// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
/**
 * @type {AlertState}
 *
 */
define(['fs/presenter/alerts/AlertsPanelPresenter',
        'hp/core/Localizer',
        'lib/jquery.ThreeDots',
        'lib/jquery.dateFormat',
        'hp/lib/date'], function(AlertsPanelPresenter,Localizer) { //"use strict";

    var AlertState = (function () {
        /**
         * @constructor
         */
        function AlertState() {

            var ALERT_PREFIX = 'alertId',
            ALERTS_TABLE = '#cic-switch-show-alerts-table',
            ALERTS_TABLE_ROW_TEMPLATE = '#tour-overview-alert-template',
            ALERT_COUNT_CRITICAL = '#alertCountCritical',
            ALERT_COUNT_WARNING = '#alertCountWarning',
            ALERT_COUNT_CRITICAL_ICON = '#alertIconCritical',
            ALERT_COUNT_WARNING_ICON = '#alertIconWarning',
            ALERT_COUNT_OK_ICON = '#alertIconOk',
            ALERT_COUNT_OK = '#alertCountOk',
            ALERT_NOTIFY_BOX = '#cic-alert-panel-notify';

            var alertsPanelPresenter = new AlertsPanelPresenter();

            // declared here so it can be referenced by functions above it
            var updateAlertStats = function () {};

            function decodeAlertStatus(severity) {
                var status = "unknown";

                if (severity) {
                    switch(severity) {
                        case "CRITICAL":
                            status =  "error";
                            break;
                        case "MAJOR":
                            status = "warning";
                            break;
                        case "OK":
                            status = "ok";
                            break;
                        case "UNKNOWN":
                            status =  "unknown";
                            break;
                    }
                }
                return status;
            }

            function clearAlertTable(){
                $('[id^="' + ALERT_PREFIX + '"]').remove();
                $(ALERT_NOTIFY_BOX).hide();
            }

            /* TODO: This function will be removed after platform updates Iso8601Util.msToBasicIso8601MsUtc*/
            function convertDate(isoUTCDateString)
            {
              return isoUTCDateString.substr(0, 4) + "-" + isoUTCDateString.substr(4, 2) + "-" +
                     isoUTCDateString.substr(6, 5) + ":" + isoUTCDateString.substr(11, 2) + ":" +
                     isoUTCDateString.substring(13);
            }

            function updateAlertCount(idCount, idIcon, count){
                if (count === 0){
                    // No alerts
                    $(idCount).text(count);
                    $(idIcon).addClass('hp-unset');
                }
                else if (count === -1){
                    // Alerts not yet obtained
                    $(idCount).html('&mdash;');
                    $(idIcon).addClass('hp-unset');
                }
                else {
                    // 1 or more alerts
                    $(idCount).text(count);
                    $(idIcon).removeClass('hp-unset');
                }
            }

            function setUri(uri){
                alertsPanelPresenter.setUri(uri);
            }

            function init(){
                alertsPanelPresenter.init();
                alertsPanelPresenter.on("alertChange", updateAlertStats);
            }

            function resume(){
                alertsPanelPresenter.on("alertChange", updateAlertStats);
            }

            function pause(){
                alertsPanelPresenter.off("alertChange", updateAlertStats);
            }

            updateAlertStats = function(){
                var alertObj = alertsPanelPresenter.getAlertData();
                if (alertObj){
                    updateAlertCount(ALERT_COUNT_CRITICAL, ALERT_COUNT_CRITICAL_ICON, alertObj.critCount);
                    updateAlertCount(ALERT_COUNT_WARNING, ALERT_COUNT_WARNING_ICON, alertObj.majorCount);
                    updateAlertCount(ALERT_COUNT_OK, ALERT_COUNT_OK_ICON, alertObj.okCount);

                    var alertRow;
                    clearAlertTable();
                    if (alertObj.alerts){
                        if (alertObj.alerts.length > 0){
                            // Build a new table via cloning
                            $.each(alertObj.alerts, function (idx, singleAlert) {
                                alertRow = $(ALERTS_TABLE_ROW_TEMPLATE).clone();
                                alertRow.attr('id', ALERT_PREFIX + idx);
                                $('.hp-status', alertRow).addClass('hp-status-' + decodeAlertStatus(singleAlert.severity));
                                $('.hp-alert-description .ellipsis_text', alertRow).text(singleAlert.description);
                                $('.hp-alert-date', alertRow)
                                    .text($.format.date(Date.parseISOString(convertDate(singleAlert.alertDate)), 'M/dd/yy') + " " +
                                        $.format.date(Date.parseISOString(convertDate(singleAlert.alertDate)), 'h:mm a'));
                                alertRow.show();
                                $(ALERTS_TABLE).append(alertRow);
                                $('.hp-alert-description', alertRow).ThreeDots({max_rows: 1});
                            });
                        }
                        else{
                            $(ALERT_NOTIFY_BOX).show();
                        }
                    }
                }
                else {
                    clearAlertTable();
                    updateAlertCount(ALERT_COUNT_CRITICAL, ALERT_COUNT_CRITICAL_ICON, -1);
                    updateAlertCount(ALERT_COUNT_WARNING, ALERT_COUNT_WARNING_ICON, -1);
                    updateAlertCount(ALERT_COUNT_OK, ALERT_COUNT_OK_ICON, -1);
                }
            };

            this.updateAlertStats = updateAlertStats;
            this.init = init;
            this.pause = pause;
            this.resume = resume;
            this.setUri = setUri;
        }

        return new AlertState();
    }());

    return AlertState;

});
