// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
/**
 * @type {AlertRoutes}
 */
define(['hp/core/Router', 'hp/core/UrlFragment', 'hp/core/Localizer'],
function (router, urlFragment, localizer) { "use strict";

    var AlertRoutes = ( function() {

        var ROOT_CONTAINER = '#hp-page-container';
        var AUTH_CATEGORY = 'alerts';

        function AlertRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) {
                    return;
                }
                registered = true;

                router.map('alert',
                    '/alert' + urlFragment.pagePatternTerminal, {
                    menu: {
                        section: '',
                        label: localizer.getString('fs.alerts.menu'),
                        location: '/alert',
                        indexCategory: 'alerts',
                        authCategory: AUTH_CATEGORY
                    },
                    container: ROOT_CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/alerts/index.html',
                            'fs/view/alerts/GlobalAlertsView'],
                        function (page, view) {
                            result.loadIfViewable(page, view, AUTH_CATEGORY);
                        });
                    }
                });
            };
        }

        return new AlertRoutes();
    }());

    return AlertRoutes;
});
