// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
define(['fs/presenter/settings/NetworkSetupPresenter',
        'fs/presenter/settings/AppliancePresenter',
        'hp/core/Localizer',
        'hp/core/Router',
        'fs/presenter/settings/DateTimeSetupPresenter',
        'fs/view/settings/backup/BackupStatusView',
        'jquery',
        'lib/jquery.dateFormat',
        'hp/lib/jquery.hpStackedPanels',
        'hp/lib/jquery.hpTimestamp'],
function(networkPresenter, appliancePresenter, localizer, router, dateTimeSetupPresenter, backupStatusView) { "use strict";

    var ApplianceMoreView = (function() {

        var CLASS_PREFIX = '.fs-settings-appliance',
            CLASS_VALUE = CLASS_PREFIX + '-value',
            CLASS_1NODE = CLASS_PREFIX + '-1node',
            CLASS_2NODE = CLASS_PREFIX + '-2node',
            CLASS_IPV6 = CLASS_PREFIX + '-IPv6',
            CLASS_HARDWARE = CLASS_PREFIX + '-hardware',
            CLASS_IPV4_DHCP = CLASS_PREFIX + '-IPv4-DHCP',
            CLASS_DNS_DHCP = CLASS_PREFIX + '-DNS-DHCP',
            CLASS_IPV6_DHCP = CLASS_PREFIX + '-IPv6-DHCP',
            CLASS_SECOND_IPv4_IP = CLASS_PREFIX + '-Ipv4-secondIP',
            CLASS_SECOND_IPv6_IP = CLASS_PREFIX + '-Ipv6-secondIP';

        var ID_PREFIX = CLASS_PREFIX.replace('.', '#'),
            GENERAL_PREFIX = ID_PREFIX + '-general',
            HOSTNAME = GENERAL_PREFIX + '-hostname',
            MODEL = GENERAL_PREFIX + '-model',
            SERIAL = GENERAL_PREFIX + '-serial',
            VERSION = GENERAL_PREFIX + '-version',
            DATE = GENERAL_PREFIX + '-date';

        var IPV4_PREFIX = ID_PREFIX + '-IPv4',
            IPV6_PREFIX = ID_PREFIX + '-IPv6',
            ADDR_1NODE = '-address-1node',
            ADDR_2NODE = '-address-2node',
            ADDRTYPE = '-addrtype',
            NODE1 = '-node1',
            NODE2 = '-node2',
            SUBNET = '-subnet',
            GATEWAY = '-gateway';

        var DNS_PREFIX = ID_PREFIX + '-DNS',
            PREFERRED = DNS_PREFIX + '-preferred',
            ALTERNATE = DNS_PREFIX + '-alternate';

        var FROM_DHCP = '-from-DHCP',
            PANELS = ID_PREFIX + '-panels',
            PANEL_SELECTOR = '#hp-settings-panel-selector',
            ROUTE_PREFIX = '/settings/show/appliance/(general|IPv4|DNS|IPv6|timeandplace|backup)',
            UNSET = 'hp-unset',
            ADD_NOTIFICATION = 'addNotification';

        var CLASS_IPV6_DISABLE = '.fs-settings-ipv6-remove';

        var //TIME_DATE_PREFIX = ID_PREFIX + '-timeandplace',
            CURRENT_DATE_TIME = '#fs-settings-appliance-timeandplace-currentdatetime',
            TIMEZONE = '#fs-settings-appliance-timeandplace-timezone',
            NTP_SERVER = '#fs-settings-appliance-timeandplace-ntpserver',
            LOCALE = '#fs-settings-appliance-timeandplace-locale';

        var SECOND_IPV4_ADDR = '#fs-settings-appliance-IPv4-address-2-1node',
            SECOND_IPV6_ADDR = '#fs-settings-appliance-IPv6-address-2-1node',
            secondIPUsed = false;
            
        /**
         * Constructor
         */
        function ApplianceMoreView() {

            // Displays an error in the Notifications view.  This is done by posting
            // a jQuery event that bubbles up the element stack to the SettingsView,
            // which owns the notifications area.
            function showError(error) {
                $(PANELS).trigger(ADD_NOTIFICATION, {
                    summary: error.errorMessage,
                    details: error.resolution,
                    status: 'error'
                }, true);
            }

            // Show the contents of a field, with handling of "not set".
            function setField(field, value) {
                if (value) {
                    $(field).text(value).removeClass(UNSET);
                } else {
                    $(field).text(localizer.getString('core.common.notset'));
                    $(field + FROM_DHCP).hide();
                }
            }

            // Display the network data (called when it is received from the server).
            function showNetworkData(networkObject) {
                // Set the field visibilities based on the configuration.
                if (networkObject.ipv4Type == 'DHCP') {
                    $(CLASS_IPV4_DHCP).show();
                }
                secondIPUsed = networkPresenter.isSecondIPUsed();  
                $(CLASS_SECOND_IPv4_IP).toggle(Boolean(secondIPUsed));
                 
                if (secondIPUsed) { // the IP has to be configured
                    $(CLASS_SECOND_IPv4_IP).show();
                }
                $(CLASS_DNS_DHCP).toggle(Boolean(networkObject.dnsFromDHCP));
                if (networkObject.ipv6Type == 'DHCP') {
                    $(CLASS_IPV6_DHCP).show();
                }
                if (networkObject.ipv6Type != 'UNCONFIGURE') {
                    $(CLASS_IPV6).show();
                    if (secondIPUsed) { // the IP has to be configured
                        $(CLASS_SECOND_IPv6_IP).show();
                    }
                }
                if (!networkObject.confOneNode) {
                    $(CLASS_2NODE).show();
                    $(CLASS_1NODE).hide();
                } else {
                    $(CLASS_2NODE).hide(); // some 2 node fields may have been shown by CLASS_IPV6 above.
                }

                // Set the field contents.
                setField(HOSTNAME, networkObject.hostname);
                var addr = 'node' + networkObject.localNodeID;
                setField(IPV4_PREFIX + ADDR_1NODE, networkObject.addrs[addr].ipv4);
                setField(IPV6_PREFIX + ADDR_1NODE, networkObject.addrs[addr].ipv6);
                if (secondIPUsed) {
                    setField(SECOND_IPV4_ADDR, networkObject.addrs[addr].ipv4_2);
                    setField(SECOND_IPV6_ADDR, networkObject.addrs[addr].ipv6_2);

                }
                if (networkObject.addrs.cluster) {
                    setField(IPV4_PREFIX + ADDR_2NODE, networkObject.addrs.cluster.ipv4);
                    setField(IPV6_PREFIX + ADDR_2NODE, networkObject.addrs.cluster.ipv6);
                }
                if (networkObject.addrs.node1) {
                    setField(IPV4_PREFIX + NODE1, networkObject.addrs.node1.ipv4);
                    setField(IPV6_PREFIX + NODE1, networkObject.addrs.node1.ipv6);
                }
                if (networkObject.addrs.node2) {
                    setField(IPV4_PREFIX + NODE2, networkObject.addrs.node2.ipv4);
                    setField(IPV6_PREFIX + NODE2, networkObject.addrs.node2.ipv6);
                }
                setField(IPV4_PREFIX + SUBNET, networkObject.ipv4Subnet);
                setField(IPV6_PREFIX + SUBNET, networkObject.ipv6Subnet);
                setField(IPV4_PREFIX + GATEWAY, networkObject.ipv4Gateway);
                setField(IPV6_PREFIX + GATEWAY, networkObject.ipv6Gateway);
                setField(IPV4_PREFIX + ADDRTYPE, localizer.getString('fs.settings.appliance.addrType.' + networkObject.ipv4Type));
                setField(IPV6_PREFIX + ADDRTYPE, localizer.getString('fs.settings.appliance.addrType.' + networkObject.ipv6Type));
                setField(PREFERRED, networkObject.priDns);
                setField(ALTERNATE, networkObject.altDns);
            }

            // Display the appliance version data (called when it is received from the server).
            function showApplianceVersion(data) {
                // Show the model number.
                // REVISIT: the back end is not currently generating a modelNumber field; it generates
                // hardwareModel.  But VMs will have model numbers too, so this will change.
                if (data.modelNumber) {
                    $(MODEL).text(data.modelNumber).removeClass(UNSET);
                } else if (data.platformType == 'vm') {
                    $(MODEL).text(localizer.getString('fs.settings.appliance.platform.vm')).removeClass(UNSET);
                } else if (data.hardwareModel) {
                    $(MODEL).text(data.hardwareModel).removeClass(UNSET);
                }

                // Show the serial number.
                // REVISIT: the back end is not generating a serialNumber field right now.
                if (data.platformType == 'hardware') {
                    $(CLASS_HARDWARE).show();
                    if (data.serialNumber) {
                        $(SERIAL).text(data.serialNumber).removeClass(UNSET);
                    }
                }

                // Show version number.
                $(VERSION).text(data.softwareVersion).removeClass(UNSET);                

                // Show the version date.
                var date = Date.parseISOString(data.date);
                date = $.format.date(date, 'MMM d, yyyy');
                // REVISIT:  Need to internationalize the date format.
                $(DATE).text(date).removeClass(UNSET);
            }

            // Retrieve the hostname and IP address from the server.
            function getNetworkData() {
                networkPresenter.getNetworkConfiguration({
                    success: showNetworkData,
                    error: showError
                });
            }

            // Retrieve the appliance software version and platform type from the server.
            function getApplianceData() {
                appliancePresenter.getVersion({
                    success: showApplianceVersion,
                    error: showError
                });
            }

            function changeLocation(location) {
                $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
            }
            function showDateTime(data) {
                var dateVal = dateTimeSetupPresenter.parseDateTime(data);
                dateVal = $.format.date(dateVal, 'MMM d, yyyy hh:mm a');
                $(CURRENT_DATE_TIME).text(dateVal).removeClass(UNSET);
            }
            function showTimezone(timezoneData) {
                $(TIMEZONE).text(timezoneData.timezoneString).removeClass(UNSET);
            }
            function showNTPservers(ntpData) {
                if(ntpData.ntpServers.length > 0){
                   $(NTP_SERVER).html(ntpData.ntpServers.join('<br>')).removeClass(UNSET);
                }
                else{
                    $(NTP_SERVER).text(localizer.getString('fs.settings.appliance.timeandplace.ntpnotconfigured'));
                }
            }
            function showLocale(localeData) {
                $(LOCALE).text(localeData.displayName).removeClass(UNSET);
            }

            function registerEvents() {
                dateTimeSetupPresenter.on("dateAndTimeChange", showDateTime);
                dateTimeSetupPresenter.on("timezoneChange", showTimezone);
                dateTimeSetupPresenter.on("ntpServersChange", showNTPservers);
                dateTimeSetupPresenter.on("localeChange", showLocale);
            }

            function getDateTime() {
                dateTimeSetupPresenter.getDateTime();
            }
            function getTimezone() {
                dateTimeSetupPresenter.getTimezone();
            }
            function getNTPservers() {
                dateTimeSetupPresenter.getNTPservers();
            }
            function getLocale() {
                dateTimeSetupPresenter.getLocale();
            }
               
            this.init = function() {
                $(PANELS).hpStackedPanels({
                    panelSelector : PANEL_SELECTOR
                });
                router.watch('settings show appliance section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});
                registerEvents();
                getDateTime();
                getTimezone();
                getNTPservers();
                getLocale();
                backupStatusView.init();
                this.resume();
            };

            this.resume = function() {
                if (networkPresenter.iPv6Disabled()) {
                   $(CLASS_IPV6_DISABLE).remove();
                }
  
                $(CLASS_VALUE).html('&mdash;').addClass(UNSET);
                $(CLASS_1NODE).show();
                $(CLASS_HARDWARE).hide();
                $(CLASS_2NODE).hide();
                $(CLASS_IPV6).hide();
                $(CLASS_IPV4_DHCP).hide();
                $(CLASS_IPV6_DHCP).hide();                
                getNetworkData();
                getApplianceData();
                getDateTime();
                getTimezone();
                getNTPservers();
                getLocale();
                backupStatusView.resume();
            };

        }
        return new ApplianceMoreView();
    }());

    return ApplianceMoreView;
});
