// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
define(['hp/core/Localizer', 'hp/presenter/EulaPresenter',
    'hp/core/Router',
    'hp/view/FormStateView', 'jquery', 'hp/lib/jquery.hpToggle',
    'lib/jquery.validate'],

function(localizer, presenter, router, FormStateView)
    { "use strict";

    var SupportEditView = (function() {

        var FORM = '#hp-supportaccess-form';
        var OK_BUTTON = "#hp-supportaccess-ok-button",
            CANCEL_BUTTON = "#hp-supportaccess-cancel-button",
            EULA_SERVICE_TOGGLE = "#hp-eula-service-access-toggle-button",
            ERROR_MSG = "#errMsg",
            EULA_CONTENT_BODY = "#hp-form-contents-body";
      
        var SUPPORT_ACCESS_MANUAL = '#hp-eula-supportaccess-manual';

        function SupportEditView() {

            var formStateView = new FormStateView();
            
            function onLoadSupportSuccess(data, status, xhr) {
                
                var suppportAccessHtml = $(data).filter('#hp-eula-supportaccess-content');
                localizer.localizeDom(suppportAccessHtml);
                $(EULA_CONTENT_BODY).empty();
                $(EULA_CONTENT_BODY).append(suppportAccessHtml);
                $(EULA_SERVICE_TOGGLE).hpToggle({
                    checked: localizer.getString('fs.settings.eula.config.enabled'),
                    unchecked: localizer.getString('fs.settings.eula.config.disabled')
                });
                formStateView.reset();
                presenter.checkIsSupportEnabled();
            }
            
            function onLoadSupportError(jqXHR, textStats, errorThrown) {
            }

            function loadSupportAccessHtml(){
               $.ajax({
                   url: '/ui-js/pages/fs/license/support_access_and_written_offer.html',
                   type: 'GET',
                   async: true,
                   dataType: "html",
                   success: onLoadSupportSuccess,
                   error: onLoadSupportError
               });
            }
            
            function onOkButtonClick() {
                var isSupportEnabled = false;
                if ($(EULA_SERVICE_TOGGLE).is(':checked')) {
                    isSupportEnabled = true;
                }
                presenter.updateServiceAccess(isSupportEnabled);
            }

            function onCancelButtonClick() {
                formStateView.reset();
                router.go('/settings/show/supportaccess', 'on Edit Service Access cancel');
            }

            function isSupportEnabledSuccess(isSupportEnabled) {
                if (isSupportEnabled) {
                    $(EULA_SERVICE_TOGGLE).attr("checked", "checked");
                } else {
                    $(EULA_SERVICE_TOGGLE).removeAttr("checked");
                }
                $(EULA_SERVICE_TOGGLE).trigger('change');
                formStateView.reset();
            }

            function isSupportEnabledFailure(isSupportEnabled) {
                $(EULA_SERVICE_TOGGLE).removeAttr("checked");
                $(EULA_SERVICE_TOGGLE).trigger('change');
            }

            function enableServiceSuccess(data) {
                router.go('/settings/show/supportaccess', 'on Edit Service Access ok');
                presenter.checkIsSupportEnabled();
            }

            function enableServiceFailure(errorMessage){
                var msg = JSON.stringify(errorMessage.message);
                msg = msg.replace(/["']{1}/gi,"");
                msg = msg.replace("Authorization error:", "");
                $(ERROR_MSG).html(msg);
            }

            function registerEvents() {
                presenter.on("isSupportEnabledSucess", isSupportEnabledSuccess);
                presenter.on("isSupportEnabledFailure", isSupportEnabledFailure);
                presenter.on("enableServiceSucess", enableServiceSuccess);
                presenter.on("enableServiceFailure", enableServiceFailure);
            }

            this.resume = function(){
                loadSupportAccessHtml();
            };

            this.init = function() {
                loadSupportAccessHtml();
                $(SUPPORT_ACCESS_MANUAL).hide();
                registerEvents();
                $(OK_BUTTON).click(onOkButtonClick);
                $(CANCEL_BUTTON).click(function(ev) {
                    onCancelButtonClick();
                    ev.preventDefault();
                });
                formStateView.init({form: FORM,autoTrack: true});
            };
        }

        return new SupportEditView();

    }());

    return SupportEditView;
});