// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
/**
 * @type {StatusPager}
 *
 * Use StatusPager.js to wrap Pager.js so that pages and views for hidden status
 * states can be loaded and unloaded without exposing anything more than the
 * .status URI to the user.
 * 
 * This code SHOULD NOT be taken as a template for a general purpose solution to
 * how the problem of displaying multiple pages under one root URI.
 */
define(['hp/core/Pager',
        'hp/model/DevelopmentSettings',
        'hp/services/Log',
        'hp/core/Localizer',
        'jquery'],
function (pager, developmentSettings, Log, Localizer) { "use strict";

    var StatusPager = (function () {
        
        var lastKeyLoaded = null;

        function StatusPager() {

            var pageViewMaps = {};     // Maps to pages and views as they are registered.

            function Map(containerId, key, enterFunction)
            {
               this.enter = enterFunction;

               // Wrap the unloadElement method in Pager.js
               function unloadElement () {
                   pager.unloadElement(containerId, key);
               }

               // Wrap the loadElement method in Pager.js
               function loadElement (page, view) {
                   pager.loadElement(containerId, key, page, view);
               }

               this.load = function(page, view)
               {
                   loadElement(page, view);
               };

               this.unload = function()
               {
                   unloadElement();
               };
            }

            /**
             * Add page / view information.
             * @param key: something unique and human readable for debugging
             * @param args: {container: <CSS selector for jQuery>,
             *               enter: <immediateCallbackFunction>
             *                  require([<resources>],
             *                  <callbackFunctionToLoadPage>}
             */
            this.mapPageView = function (key, args) {
                pageViewMaps[key] = new Map (args.container, key, args.enter);
            };
            
            this.unload = function (key) {
                var pvm;
                if (key) {
                    pvm = pageViewMaps[key];
                    if (pvm) {
                        lastKeyLoaded = null;
                        pvm.unload();
                    } else {
                        Log.error('cannot unload unrecognized page name ' + key);
                    }
                } else {
                    if (lastKeyLoaded) {
                        pvm = pageViewMaps[lastKeyLoaded];
                        pvm.unload();
                    }
                }
            };
            
            this.load = function (key) {
                if (key !== lastKeyLoaded) {
                    if (lastKeyLoaded) {
                        this.unload(lastKeyLoaded);
                    }
                    var pvm = pageViewMaps[key];
                    if (pvm) {
                        pvm.enter(pvm);
                        lastKeyLoaded = key;
                    } else {
                        Log.error('cannot load unrecognized page name ' + key);
                    }
                }
            };
            
        }
        
        return new StatusPager();
    }());

    return StatusPager;
});
