// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
/**
 * @type {Application}
 */
define(['hp/view/LocationView', 'hp/core/Banner',
    'hp/core/Environment', 'hp/core/Localizer',
    'hp/view/login/LoginView', 
    'hp/core/UrlFragment', 'hp/core/Router', 'hp/core/Validator',
    'hp/presenter/settings/DevelopmentPresenter',
    'text!hpPages/core/body_contents.html',
    'jquery'],
function (locationView, banner, environment, localizer, loginView, 
    urlFragment, router, validator, developmentPresenter, bodyContentsHtml) { "use strict";

    var Application = (function () {

        var BODY = 'body';
        var DEFAULT_OPTIONS = {
            title: 'Title',
            subTitle: null,
            banner: {
                search: true,
                notifications: 'sidebar'
            }
        }

        function Application() {
          
            function onResize() {
                $(BODY).toggleClass('hp-narrow', $(window).width() < 600);
            }

            this.init = function (optionsArg) {
                var options;
                
                if (typeof optionsArg === 'string') {
                    optionsArg = {title: optionsArg};
                }
                
                options = $.extend(true, {}, DEFAULT_OPTIONS, optionsArg);

                // allow tests to insert something around the application
                if ($('#hp-body').length > 0) {
                    BODY = '#hp-body';
                }
                $(BODY).empty();
                $(BODY).append($(bodyContentsHtml));
                if (options.layout) {
                    $(BODY).addClass('hp-' + options.layout + '-layout');
                }

                if (! environment.supportedBrowser()) {
                    $('#hp-unsupported-browser').show();
                    $('#hp-page-spinner').hide();
                    return;
                }

                // check for kiosk mode
                var params = urlFragment.getParameters(window.location.href);
                if (params.kiosk === 'true') {
                    environment.setKioskMode(true);
                }
                
                localizer.init();
                locationView.init();
                banner.init(options.title, options.subTitle, options.banner);
                validator.init();
                loginView.setTitle(options.title, options.subTitle);

                localizer.localizeDom();
                
                $(BODY).addClass('hp-active');
                $(window).resize(onResize);
                onResize();
                
                if (developmentPresenter.isExperimentalFeatures()) {
                    $('html').addClass('experimental');
                } else {
                    $('html').removeClass('experimental');
                }
                
                if (developmentPresenter.getHighContrast()) {
                    $('html').addClass('hp-high-contrast');
                } else {
                    $('html').removeClass('hp-high-contrast');
                }
            };

            this.start = function () {
                router.start();
            };
        }

        return new Application();
    }());

    return Application;
});
