﻿// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
define(['./upload-cn', './settings-cn', './help-cn', './notify-cn'],
function (upload, settings, help, notify) {
"use strict";
    return {
        upload : upload,
        settings : settings,
        help : help,
        notify : notify,

        loading : "正在加载...",
        // TODO: remove styling and use CSS
        rest_error_fmt : "<b>{0}</b><BR>{1}<BR><b>解决办法:</b>{2}",

        //TODO consider moving the CIC specific stuff out of core.

        login : {
            "user" : "用户",
            "password" : "密码",
            "loginButton" : "登录",
            "domain" : "域",
            "title" : "设备"
        },
        menu : {
            settings : "设置",
            search : "搜索",
            map : "映射",
            activity : "活动"
        },
        shell : {
            banner : {
                title : "浏览",
                session : {
                    control : {
                        tooltip : "会话"
                    },
                    duration : "已登录",
                    logout : "退出"
                },
                local : "本地"
            },
            unsupportedBrowser : "不支持您正在使用的 Web 浏览器。请考虑使用最新(稳定)版本的 Chrome、Safari、Firefox、Opera 或 Internet Explorer 版本 8 或更高版本。"
        },
        dataTables : {
            oLanguage : {
                sProcessing : "正在处理...",
                sLengthMenu : "显示 _MENU_ 项",
                sZeroRecords : "未找到任何匹配的记录",
                sEmptyTable : "没有任何项",
                sLoadingRecords : "正在加载...",
                sInfo : "正在显示第 _START_ 至 _END_ 项，共 _TOTAL_ 项",
                sInfoEmpty : "正在显示第 0 至 0 项，共 0 项",
                sInfoFiltered : "(从总计 _MAX_ 项中筛选而得)",
                sInfoPostFix : "",
                sSearch : "搜索:",
                sUrl : "",
                oPaginate : {
                    sFirst : "第一个",
                    sPrevious : "上一个",
                    sNext : "下一个",
                    sLast : "最后一个"
                },
                fnInfoCallback : null
            }
        },
        master : {
            header : {
                all : "全部",
                referenced : "引用",
                searched : "搜索",
                filtered : "筛选"
            },
            filters : {
                title : "筛选器",
                filter : "过滤器",
                noFilters : "无筛选器",
                error : "错误",
                warning : "警告",
                recentlyAdded : "最近添加",
                recentlyChanged : "最近更改",
                resetAll : "重置"
            },
            loadingItems : '正在加载 {0} ...',
            noItems : '无 {0}',
            noMatches : '没有匹配项',
            showMore : '显示更多'
        },
        details : {
            view : "查看",
            actions : "操作",
            edit : "编辑",
            close : "关闭",
            cancel : "取消",
            reset : "重置",
            add : "添加",
            addAgain : "添加 +",
            create : "创建",
            createAgain : "创建 +",
            save : "保存",
            update : "更新",
            "delete" : "删除",
            ok : "确定",
            apply : "应用",
            more : "更多",
            enable: "启用",
            disable: "禁用",
            addAll : "全部添加",
            addSelected : "添加所选项",
            removeAll : "全部删除",
            removedSelected : "删除所选项",
            overview : "概述",
            backToOverview : "返回概述"

        },
        deleteConfirm : {
            title : "删除 {0}",
            dependencyHeader : "{0} 项依赖于 {1}",
            prompt : "是否继续删除?",
            ok : "是，删除"
        },
        "delete" : {
            title : "警告:当前正在使用 {0} {1}。",
            accordian_button : "{0} 个服务器配置文件正在使用 {1}",
            accordian_button_singular : "1 个服务器配置文件正在使用 {0}",
            message : "删除 {0} {1}?",
            name : "名称",
            description : "说明",
            delete_button : "是，删除",
            cancel_button : "取消"
        },
        formState : {
            changed : "已更改:{0} 至 \"{1}\"",
            unchanged : "重置:{0}",
            checked : "已选中:{0}",
            unchecked : "已取消选中:{0}",
            checkedValue: "已选中",
            uncheckedValue: "取消选中",
            navigateAway : {
                warning : "警告:您的更改将丢失。",
                prompt : "是否前往新页面?",
                proceed : "是，前往",
                cancel : "取消"
            }
        },
        associationAdd : {
            selected : "已选择 {0} 项",
            added : "添加了 {0}"
        },
        common : {
            close: "关闭",
            yes : "是",
            no : "否",
            notset : "未设置",
            none : "无",
            cancel : "取消"
        },
        validator : {
            messages : {
                required : "此字段为必填字段。",
                number : "请输入有效数字。",
                digits : "输入整数(仅数字)。",
                range : "请输入在 {0} 与 {1} 之间的值。",
                max : "请输入小于或等于 {0} 的值。",
                min : "请输入大于或等于 {0} 的值。",
                name : "名称只能包含可打印字符，并且不能包括前导空白。"
            }
        },
        noDetails : {
            header : "找不到所请求的项。",
            detail : "所请求的项不存在。" +
                "可能其他用户已删除此项。" +
                "请刷新此页或选择其它项。",
            specificErrorDetails : "详细信息"               
        },
        noItems : {
            header : "无法检索 {0}。",
            detail : "获取项列表时有问题。" +
                "请尝试刷新此页。"
        },
        noPage : {
            header : "找不到所请求的页。",
            detail : "所请求的页或引用项不存在或输入的 URL 不正确。" +
                "如果通过单击上一页中的链接访问此页，则返回上一页，刷新它并重试。" +
                "如果手动输入 URL 或使用书签，则检查其是否准确和有效。"
        },
        notAuthorized : {
            header : "未授权。",
            detail_user : "未授权 {0} 查看此页。",
            detail : "未授权您查看此页。"
        },
        noRoles : {
            header : "无角色。",
            detail : "您在此系统上没有任何管理角色。请与安全管理员联系了解您的角色。"
        },
        noSession : {
            header : "登录的会话已丢失。"
        },

        measurements : {
            "millimeters" : "{0} mm",
            "meters" : "{0} m",
            "celsius" : "{0} \u00B0C",
            "fahrenheit" : "{0} \u00B0F",
            "usMeasurement" : "{0}' {1}\"",
            "dimensions" : "{0}  x {1}",
            units : {
                "meter" : "m",
                "millimeter" : "mm",
                "feet" : "ft",
                "inches" : "in"
            }
        },
        units : {
            "meter" : "m",
            "millimeter" : "mm",
            "feet" : "ft",
            "inches" : "in",
            "bytes" : "B",
            "kilobytes" : "KB",
            "megabytes" : "MB",
            "gigabytes" : "GB",
            "terrabytes" : "TB",
            "petabytes" : "PB"
        },
        date : {
            today : "今天 {0}",
            yesterday : "昨天 {0}",
            todayFormat : "h:mm a",
            yesterdayFormat : "h:mm a",
            thisYearFormat : "MMM d h:mm a",
            priorYearFormat : "M/d/yy h:mm a"
        },
        duration : {
            dhms: "{0}天{1}小时", //"{0}d{1}h{2}m{3}s",
            hms: "{0}小时{1}分", //"{0}h{1}m{2}s",
            ms: "{0}分{1}秒",
            s: "{0}秒"
        },
        timeago : {
            prefixAgo: null,
            prefixFromNow: null,
            suffixAgo: "以前",
            suffixFromNow: "从现在起",
            seconds: "1 分钟内",
            minute: "1 分钟",
            minutes: "%d 分钟",
            hour: "1 小时",
            hours: "%d 小时",
            day: "1 天",
            days: "%d 天",
            month: "1 个月",
            months: "%d 个月",
            year: "1 年",
            years: "%d 年",
            numbers: []
        },
        sort : {
            ascending : "升序",
            descending : "降序"
        },
        map: {
            title: "映射"
        },
        related: {
            title: "相关"
        },
        file: {
            upload: {
                control: {
                    tooltip: '上传',
                    doNotExitBrowser: '正在上传文件时请勿关闭窗口、注销或重新加载浏览器。'
                },
                flyout: {
                    upload: "上传",
                    elapsed: "已用 {0}",
                    remaining: "剩余 {0}"
                },
                cancel: {
                    confirmTitle: "停止上传",
                    confirmQuestion: "是否停止上传文件 {0}?",
                    confirmNote: "注意:将丢弃迄今为止传输的任何数据。",
                    yesButton: "是，停止上传",
                    canceled: "上传已取消"
                },
                error : {
                    emptyResponse : "响应为空",
                    accessDenied : "上传失败，但无法获得响应详细信息:{0}.",
                    noDrop: "此浏览器不支持拖放文件。"
                }
            },
            chooser : {
                label: "文件",
                dragAndDrop: "拖放文件或选择文件进行上传。",
                browse_only: "选择要上传的文件。",
                dragOverText: "将文件拖至此处",
                oneFileOnly: "一次选择一个文件进行上传。",
                dropOneFileOnly: "仅拖动一个文件。",
                invalidSelection: "必须选择文件。",
                noDragDrop: "此浏览器不支持拖放。",
                browse: "浏览",
                disabled: "在控制台上运行时禁止上传文件。"
            }
        },
        connectionError : "{0} 遇到了通信问题。重试。"
    };
});
