// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
// From: http://webreflection.blogspot.com/2009/07/ecmascript-iso-date-for-every-browser.html
define([], function() {"use strict";
    function t(i){return i<10?"0"+i:i;}
    function h(i){return i.length<2?"00"+i:i.length<3?"0"+i:3<i.length?Math.round(i/Math.pow(10,i.length-3)):i;}
    
    if(!('toISOString' in Date.prototype)) {
        
        Date.prototype.toISOString = function () {
            return "".concat(
                this.getUTCFullYear(), "-",
                t(this.getUTCMonth() + 1), "-",
                t(this.getUTCDate()), "T",
                t(this.getUTCHours()), ":",
                t(this.getUTCMinutes()), ":",
                t(this.getUTCSeconds()), ".",
                h("" + this.getUTCMilliseconds()), "Z"
            );
        };
    }
    
    if(!('isToday' in Date.prototype)) {
        
        Date.prototype.isToday = function () {
            var now = new Date();
            return (this.getFullYear() === now.getFullYear() &&
                this.getMonth() === now.getMonth() &&
                this.getDate() === now.getDate());
        };
    }
    
    if(!('parseISOString' in Date)) {
        
        Date.parseISOString = function (str) {
            // ISO 8601 allows many variations on the timestamp format.
            // This parser supports two:
            //     2011-12-20T08:48:22.888Z
            //     2011-12-20T08:48:22Z
            var ms = (str.length > 20) ? parseFloat(str.slice(19,23)) * 1000 : 0;
            return new Date(Date.UTC(
                parseInt(str.slice(0,4), 10),
                parseInt(str.slice(5,7), 10) - 1,
                parseInt(str.slice(8,10), 10),
                parseInt(str.slice(11,13), 10),
                parseInt(str.slice(14,16), 10),
                parseInt(str.slice(17,19), 10),
                ms));
        };
    }
    
    if(!('now' in Date)) {
        
        Date.now = function (str) {
            return (new Date()).getTime();
        };
    }
});
