define([], function() {"use strict";
window.Interval = function(arg) {
    if (arg) {
        this.years = arg.years;
        this.months = arg.months;
        this.days = arg.days;
        this.hours = arg.hours;
        this.minutes = arg.minutes;
        this.seconds = arg.seconds;
    }
};

window.Interval.between = function (startAt, endAt) {
    var delta, arg = {};
    // ellapsed milliseconds
    delta = endAt.getTime() - startAt.getTime();
    // calculate ellapsed years
    arg.years = Math.floor(delta / (1000 * 60 * 60 * 24 * 365));
    // reduce delta to remaining
    delta = (delta - (arg.years * 1000 * 60 * 60 * 24 * 365));
    // calculate ellapsed days
    arg.days = Math.floor(delta / (1000 * 60 * 60 * 24));
    // reduce delta to remaining
    delta = (delta - (arg.days * 1000 * 60 * 60 * 24));
    // calculate ellapsed hours
    arg.hours = Math.floor(delta / (1000 * 60 * 60));
    // reduce delta to remaining
    delta = (delta - (arg.hours * 1000 * 60 * 60));
    // calculate remaining minutes
    arg.minutes =  Math.floor(delta / (1000 * 60));
    // reduce delta to remaining
    delta = (delta - (arg.minutes * 1000 * 60));
    arg.seconds = Math.floor(delta / 1000);
    return new Interval(arg);
};

window.Interval.parseISODurationUnit = function(string, unit) {
    var parts = string.split(unit);
    if (parts.length > 0) {
        return parseInt(parts[0].split(/[A-Z]/).slice(-1)[0], 10);
    } else {
        return 0;
    }
};

window.Interval.parseISODuration = function (string) {
    // PnYnMnDTnHnMnS
    var parts = string.split('T');
    var arg = {};
    arg.years = Interval.parseISODurationUnit(parts[0], 'Y');
    arg.months = Interval.parseISODurationUnit(parts[0], 'M');
    arg.days = Interval.parseISODurationUnit(parts[0], 'D');
    if (parts.length > 1) {
        arg.hours = Interval.parseISODurationUnit(parts[1], 'H');
        arg.minutes = Interval.parseISODurationUnit(parts[1], 'M');
        arg.seconds = Interval.parseISODurationUnit(parts[1], 'S');
    }
    return new Interval(arg);
};

window.Interval.prototype = {
  
    years: function () { return this.years; },
    months: function () { return this.months; },
    days: function () { return this.days; },
    hours: function () { return this.hours; },
    minutes: function () { return this.minutes; },
    seconds: function () { return this.seconds; },
    
    toISODuration: function () {
        var result = 'P';
        if (this.years) {
            result += this.years + 'Y';
        }
        if (this.months) {
            result += this.months + 'M';
        }
        if (this.days) {
            result += this.days + 'D';
        }
        if (this.hours || this.minutes || this.seconds) {
            result += 'T';
        }
        if (this.hours) {
            result += this.hours + 'H';
        }
        if (this.minutes) {
            result += this.minutes + 'M';
        }
        if (this.seconds) {
            result += this.seconds + 'S';
        }
        return result;
    },
    
    greaterThan: function (interval) {
        if (this.years && this.years > interval.years) {
            return true;
        } else if (interval.years && interval.years > this.years) {
            return false;
        }
        if (this.months && this.months > interval.months) {
            return true;
        } else if (interval.months && interval.months > this.months) {
            return false;
        }
        if (this.days && this.days > interval.days) {
            return true;
        } else if (interval.days && interval.days > this.days) {
            return false;
        }
        if (this.hours && this.hours > interval.hours) {
            return true;
        } else if (interval.hours && interval.hours > this.hours) {
            return false;
        }
        if (this.minutes && this.minutes > interval.minutes) {
            return true;
        } else if (interval.minutes && interval.minutes > this.minutes) {
            return false;
        }
        if (this.seconds && this.seconds > interval.seconds) {
            return true;
        } else if (interval.seconds && interval.seconds > this.seconds) {
            return false;
        }
        return false;
    }
};
});
