// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.

define(['hp/core/Router','hp/core/Localizer', 'jquery', 'hp/lib/jquery.hpSelect'],
function(router,localizer) {
    (function($) {
        // jQuery plugin definition
        $.fn.hpStackedPanels = function(options) {
          
            var instance;

            function hpStackedPanels(elem) {
              
                // Changes can come from three places:
                // Scrolling
                //    find panel first visible panel, if changed
                //    update title, replace route location
                //
                // Route location changing
                //    find panel with the matching anchor, if changed
                //    start scrolling to it -> see Scrolling above
                //
                // Caller focuses on an input element
                //    find panel with the matching anchor, if changed
                //    start scrolling to it -> see Scrolling above
                
                var panels;
                var panelSelector;
                var updateSelector = false;
                var focusPanel; // the first panel with any visible region
                var scrollToPanel; // where we're scrolling to if route changed

                function setHeight(elem) {
                    var fullHeight = Math.max(200, $(elem).parent().height());
                    
                    // Adjust the height of the last element so we can scroll
                    // it to the top.
                    $('> li', elem).last().height(fullHeight);
                }
                
                function pinPanelHeader(panel) {
                    var label = $('> label:first', panel)[0];
                    $(label).addClass('hp-active');
                    $(panel).css({
                        paddingTop: $(label).outerHeight(true)
                    });
                }
                
                function unpinPanelHeader(panel) {
                    var label = $('> label:first', panel)[0];
                    $(label).removeClass('hp-active');
                    $(panel).css({paddingTop: ''});
                }
                
                function setRouteAndTitleForAnchor(anchor) {
                    if (anchor) {
                        if (updateSelector) {
                            // align panel selector with route location
                            $(panelSelector).hpSelect('set', $(anchor).text());
                            // align route location with anchor
                            router.replaceWith($(anchor).attr('href').substr(1), 'stacked panel');
                        } else {
                            $('li', panelSelector).removeClass('hp-selected');
                            $(anchor).parent('li').addClass('hp-selected');
                        }
                    }
                }
                
                function getPanelForAnchor(anchor) {
                    var panel = $('#' + $(anchor).data('panel-id'), panels);
                    return (panel.length === 1 ? panel[0] : null);
                }
                
                function getAnchorForPanel(panel) {
                    var anchor =
                        $('a[data-panel-id="'+$(panel).attr('id')+'"]', panelSelector);
                    return (anchor.length === 1 ? anchor[0] : null);
                }
                
                function getAnchorForLocation(location) {
                    var anchor = $('a[href^="' + (location.split('?')[0]) + '"]', panelSelector);
                    return (anchor.length === 1 ? anchor[0] : null);
                }
                
                function focusOnPanel(panel) {
                    // no-op if we're already focusing on this panel
                    if (focusPanel !== panel) {
                        unpinPanelHeader(focusPanel);
                        focusPanel = panel;
                        // if we aren't scrolling due to a location change or
                        // we are but this is the panel we are going to.
                        if (! scrollToPanel || scrollToPanel === focusPanel) {
                            var anchor = getAnchorForPanel(focusPanel);
                            setRouteAndTitleForAnchor(anchor);
                        }
                        pinPanelHeader(focusPanel);
                    }
                }
                
                function onScroll() {
                    var targetPanel = null;
                    var topOffset = 10;
                    
                    // We potentially have to unpin all panels, in case we
                    // jump from the last to the first
                    $('> li', elem).each(function(index, panel) {
                      
                        if (! targetPanel) {
                            targetPanel = panel;
                        }
                        
                        // We focus on the panel immediately before the one
                        // who's top is passed the top of the container.
                        // We vary topOffset to avoid jumpiness at the transition
                        // points.
                        if ($(panel).position().top > topOffset) {
                            focusOnPanel(targetPanel);
                            return false;
                        }
                        
                        targetPanel = panel;
                        if (targetPanel === focusPanel) {
                            topOffset = 0;
                        }
                    });
                    
                    if (targetPanel) {
                        // If we have only one panel, we'll be here
                        focusOnPanel(targetPanel);
                        return false;
                    }
                }
                
                function scrollToAnchor(anchor) {
                    var panel, scrollTo;
                    
                    // scroll to location and focus
                    panel = getPanelForAnchor(anchor);
                    if (panel && panel !== focusPanel) {
                        scrollTo = $(panels).scrollTop() + $(panel).position().top;
                        if ($(panels).scrollTop() === scrollTo) {
                            onScroll(); // in case we're resuming and need to reset
                        } else {
                            scrollToPanel = panel;
                            $(panels).animate({scrollTop: scrollTo}, 300,
                                function () {scrollToPanel = null;});
                        }
                    }
                    
                    return panel;
                }
                
                function onFocus() {
                    var panel = $(this).closest('.hp-stacked-panel');
                    var anchor = getAnchorForPanel(panel);
                    scrollToAnchor(anchor);
                }
                
                function changeToAnchor(anchor) {
                    if (anchor) {
                        var panel = scrollToAnchor(anchor);
                  
                        if (panel) {
                            // focus on first input/select in panel
                            $('input, select, textarea', panel).first().focus();
                        }
                    }
                }
                
                function onResize() {
                    setHeight(elem);
                }
                
                this.pause = function() {
                    $(window).off('resize.hpStackedPanels');
                };
                
                this.resume = function() {
                    $(window).on('resize.hpStackedPanels', onResize);
                };

                this.initialize = function(elem) {
                    panels = elem;
                    
                    if (options && options.panelSelector) {
                        panelSelector = $(options.panelSelector);
                        
                        if (panelSelector.hasClass('hp-select')) {
                            $(panelSelector).hpSelect();
                            // make sure selector has a view label
                            if (! $('> label', panelSelector).text()) {
                                $('> label', panelSelector).
                                    text(localizer.getString('core.details.view'));
                            }
                            
                            updateSelector = true;
                        }
                    }
                    
                    $(elem).scroll(onScroll);
                    
                    $('input, select, textarea', elem).focus(onFocus);

                    setTimeout(function () {setHeight(elem);}, 100);
                };
                
                this.setPanelByLocation = function (location) {
                    var anchor = getAnchorForLocation(location);
                    changeToAnchor(anchor);
                };
                
                this.setFirstPanel = function () {
                    var anchor = $('a[href]:first', panelSelector);
                    changeToAnchor(anchor);
                };
            }
            
            if ( typeof options === 'string' ) { 
                // call method
                var args = Array.prototype.slice.call( arguments, 1 );

                this.each(function() {
                    instance = $.data( this, 'hpStackedPanels' );
                    if ( !instance ) {
                        if (window.console) {
                            window.console.error(
                                "cannot call methods on hpStackedPanels prior to initialization; " +
                                "attempted to call method '" + options + "'" );
                        }
                        return;
                    }
                    if ( !$.isFunction( instance[options] ) || options.charAt(0) === "_" ) {
                        if (window.console) {
                            window.console.error(
                                "no such method '" + options + "' for hpStackedPanels instance" );
                        }
                        return;
                    }
                    // apply method
                    instance[ options ].apply( instance, args );
                });  
            } else {
                // pluginify
                var ret;
                this.each(function() {
                    var $elem = $(this);
                    instance = new hpStackedPanels($elem[0]);
                    $.data(this, 'hpStackedPanels', instance);
                    instance.initialize($elem[0]);
                    ret = ret ? ret.add($elem) : $elem;
                });
                return ret;
            }
        };
    }(jQuery));
});
