// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.
/**
 * @type {MapNode}
 */
define(['hp/model/map/MapLink', 'hp/core/Localizer'],
function (MapLink, localizer) { "use strict";

    var MapNode = ( function() {

        function MapNode() {

            var self = this;
            var resource;
            var row;
            var selected = false;
            var selectionRelated = false;
            var highlighted = false;
            var summary;
            var links = [];
            
            this.id = function () {
                if (resource) {
                    return resource.uri;
                } else {
                    return summary.category;
                }
            };
            
            this.resource = function () {
                return resource;
            };
            
            this.row = function () {
                return row;
            };
            
            this.linkedTo = function (node) {
                var length, i;
                length = links.length;
                for (i=0; i<length; i++) {
                    if (links[i].hasNodeById(node.id())) {
                        return true;
                    }
                }
                return false;
            };
            
            this.links = function () {
                return links;
            };
            
            this.addLink = function (link) {
                links.push(link);
            };
            
            this.removeLink = function (link) {
                var index = links.indexOf(link);
                if (index != -1) {
                    links.splice(index, 1);
                }
            };
            
            this.relinkAs = function (node) {
                var length, i;
                // copy links since we might remove
                var originalLinks = links.slice(0);
                length = originalLinks.length;
                for (i=0; i<length; i++) {
                    originalLinks[i].relinkNode(self, node);
                }
            };
            
            this.isSelected = function () {
                return selected;
            };
            
            this.setSelected = function (selectedArg) {
                var length, i;
                selected = selectedArg;
                length = links.length;
                for (i=0; i<length; i++) {
                    links[i].setSelectionRelated(selectedArg);
                }
            };
            
            this.isSelectionRelated = function () {
                return selectionRelated;
            };
            
            this.setSelectionRelated = function (selectionRelatedArg) {
                selectionRelated = selectionRelatedArg;
            };
            
            this.isHighlighted = function () {
                return highlighted;
            };
            
            this.setHighlighted = function (highlightedArg) {
                highlighted = highlightedArg;
            };
            
            this.summary = function () {
                return summary;
            };
            
            this.hasUri = function (uri) {
                if (resource) {
                    return (resource.uri === uri);
                } else {
                    return (summary.uriIndex[uri]);
                }
            };
            
            this.toString = function () {
                if (resource) {
                    return resource.uri;
                } else {
                    return summary.associationParams[0];
                }
            };
            
            this.init = function(resourceArg, rowArg, summaryArg) {
                resource = resourceArg;
                row = rowArg;
                summary = summaryArg;
            };
            
            this.destroy = function() {
                resource = null;
                row = null;
            };
        }

        return MapNode;
    }());

    return MapNode;
});
