// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
/**
 * @type {DashboardIndicatorPresenter}
 */
define(['hp/services/IndexService',
    'hp/services/IndexFilter',
    'hp/core/EventDispatcher'], 
function(indexService, IndexFilter, EventDispatcher) {"use strict";

    var DashboardIndicatorPresenter = ( function() {
      
        /**
         * @constructor
         */
        function DashboardIndicatorPresenter() {
          
            var dispatcher = new EventDispatcher();
            var configuration;
            
            function getSummary() {
                var filter;
                var summary = {label: configuration.label,
                    query: configuration.query};
                filter = new IndexFilter();
                filter.setUserQuery(configuration.query);
                indexService.searchIndexResources(filter, 0, 0,
                    {success: function (indexResults) {
                        summary.total = indexResults.total;
                        dispatcher.fire('summaryChange', summary);
                     },
                    error: function (error) {
                        //console.log(error); ///
                     }}
                );
            }
            
            /**
             * @public
             */
            this.init = function (configurationArg) {
                configuration = configurationArg;
            };
            
            this.resume = function () {
                getSummary();
            };
            
            this.pause = function () {
            };
            
            /**
             * Add a listener for a specified event.
             * @public
             * @param {string} eventName The name of the event.
             * @param {function(...)}
             */
            this.on = function(eventName, callback) {
                dispatcher.on(eventName, callback);
            };
            
            this.off = function(eventName, callback) {
                dispatcher.off(eventName, callback);
            };
        }

        return DashboardIndicatorPresenter;
    }());

    return DashboardIndicatorPresenter;
});
