// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['hp/presenter/dashboard/DashboardCategoryPresenter',
    'hp/core/LinkTargetBuilder',
    'hp/core/Style',
    'hp/model/Session',
    'hp/core/Localizer',
    'jquery',
    'hp/lib/jquery.hpTimestamp',
    'hp/lib/jquery.hpPlot',
    'lib/jquery.flot.pie'],
function(DashboardCategoryPresenter, linkTargetBuilder, style, session, localizer) { "use strict";

    var DashboardCategoryView = (function() {
      
        var DEFAULT_STATUSES = [
                        {status:'error', value:'CRITICAL'},
                        {status:'warning', value: 'MAJOR'},
                        {status:'ok', value: 'OK'}
                    ];
        
        /**
         * Constructor
         */
        function DashboardCategoryView() {
          
            var presenter;
            var container;
            var configuration;
          
            function checkCanAdd(total) {
                if (configuration.addLinkLabel) {
                    if (configuration.canAdd) {
                        configuration.canAdd(total, function (canAdd) {
                            $('.hp-primary', container).parent().toggle(canAdd);
                        });
                    }
                    else if (session.canPerformAction(configuration.category, 'Create')) {
                        var haveItems = (total > 0);
                        $('.hp-primary', container).parent().toggle(!haveItems);
                    }
                }
            }
            
            function onSummaryChange(summary) {
                var link = linkTargetBuilder.makeLink(null, null, null, summary.category,
                        null, null, ['freset=true']);
                var haveItems = (summary.total > 0);
                
                $('.hp-summary-status', container).toggle(haveItems);
                $('.hp-utilization-summary', container).toggle(haveItems);
                $('.hp-dashboard-value', container).toggle(!haveItems);
                checkCanAdd(summary.total);
                
                // TODO: use MainMenu to get label
                $('header .hp-name', container).
                    text(linkTargetBuilder.categoryLabel(summary.category));
                $('header .hp-count', container).text(summary.total);
                if (link) {
                    $('header h2 a', container).
                        attr('href', $(link).attr('href')).
                        removeClass('hp-inactive');
                } else {
                    $('header h2 a', container).addClass('hp-inactive');
                }
                $.each(configuration.statuses, function(index, status) {
                    var anchor =
                        $('.hp-summary-status a.hp-summary-' + status.status, container);
                    var icon = $('> .hp-status', anchor);
                    var link;
                    
                    $('.hp-count', anchor).text(summary[status.status]);
                    if (! summary[status.status]) {
                        icon.addClass('hp-unset');
                        anchor.removeAttr('href').addClass('hp-inactive');
                    } else {
                        icon.removeClass('hp-unset');
                        link = linkTargetBuilder.makeLink(
                            null, null, null,
                            summary.category, null, null,
                            ['fp_status=' + status.value]);
                        if (link) {
                            anchor.attr('href', $(link).attr('href')).
                                removeClass('hp-inactive');
                        } else {
                            anchor.removeAttr('href').addClass('hp-inactive');
                        }
                    }
                });
            }
            
            function onUtilizationChange(utilization) {
                var data = [],
                    index = utilization.index;
                $.each(utilization.segments, function (index, segment) {
                    var color;
                    if (segment.color) {
                        color = segment.color;
                    } else if (utilization.type === 'status') {
                        color = style.statusColor(segment.status);
                    } else if (index === (utilization.segments.length - 1)) {
                        color = style.summaryBaseColor();
                    } else {
                        color = style.summaryColor(index);
                    }
                    data.push({label: segment.label,
                        data: segment.total,
                        color: color});
                });
                $.plot($('.hp-pie:eq('+index+')', container), data, {
                        series: {
                          pie: {
                            innerRadius: 0.6,
                            show: true,
                            label: {
                              show: false
                            },
                            stroke: {
                              width: 3
                            }
                          }
                        },
                        legend: {
                          show: false
                        }
                    }
                );
                $('.hp-pie-summary:eq('+index+')', container).
                    text(utilization.label);
            }
          
            /**
             * @public
             */
            this.pause = function () {
                presenter.pause();
                presenter.off('summaryChange', onSummaryChange);
                presenter.off('utilizationChange', onUtilizationChange);
            };
            
            this.resume = function () {
                presenter.on('summaryChange', onSummaryChange);
                presenter.on('utilizationChange', onUtilizationChange);
                presenter.resume();
            };
            
            this.init = function (configurationArg, containerArg) {
                var pieTemplate = $('#hp-dashboard-category-pie-template', container).
                        remove().attr('id', '').removeClass('hp-template');
                container = containerArg;
                configuration = $.extend({statuses: DEFAULT_STATUSES}, configurationArg);
                presenter = new DashboardCategoryPresenter();
                presenter.init(configuration);
                
                if (! configuration.utilization) {
                    $('.hp-utilization-summary', container).hide();
                }
                else {
                    var numUtil = $.isArray(configuration.utilization) ? configuration.utilization.length : 1;
                    for (var i = 0; i < numUtil; i++) {
                        $('.hp-utilization-summary', container).append(pieTemplate.clone());
                    }
                }
                
                $('.hp-summary-status', container).hide();
                $('.hp-utilization-summary', container).hide();
                $('.hp-dashboard-value', container).hide()
                    .text(localizer.getString('core.master.noItems',
                            [linkTargetBuilder.categoryLabel(configuration.category).toLowerCase()]));
                $('.hp-primary', container).parent().hide();
                if (configuration.addLinkLabel) {
                    var addHref = $(linkTargetBuilder.makeLink(null, null, 'add', configuration.category)).attr('href');
                    $('.hp-primary', container).attr('href', addHref)
                        .text(configuration.addLinkLabel);
                }
            };
        }

        return DashboardCategoryView;
    }());
    
    return DashboardCategoryView;
});
