// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
define(['hp/presenter/settings/DevelopmentPresenter',
        'hp/view/FormStateView',
        'hp/core/Notifications',
        'hp/core/Localizer',
        'jquery'],
function(presenter, FormStateView, notifications, localizer) {"use strict";

    var DevelopmentEditView = (function() {

        var FORM = '#hp-settings-development-form',
            OK = '#hp-settings-edit-ok',
            CANCEL = '#hp-settings-edit-cancel',
            REFRESH_INTERVAL = '#hp-settings-edit-refresh-interval',
            MAX_INDEX_ITEMS = '#hp-settings-edit-max-index-items',
            EXPERIMENTAL_FEATURES = '#hp-settings-edit-experimental-features',
            ROUTING_LOG_LEVEL = '#hp-settings-edit-routing-log-level',
            AUDIO = '#hp-settings-edit-audio',
            DISABLE_IPV6 = '#hp-settings-edit-ipv6-disable',
            DISABLE_FACTORY_RESET ="#hp-settings-edit-factory-reset-disable",
            HIGH_CONTRAST = '#hp-settings-edit-high-contrast',
            TRACK_TIMING = '#hp-settings-edit-track-timing';

        /**
         * @class View script for the Development Settings panel of the Edit view of the Settings page.
         */
        function DevelopmentEditView() {
          
            var formStateView = new FormStateView();

            function fillForm() {
                $(REFRESH_INTERVAL).val(presenter.getRefreshInterval());
                $(MAX_INDEX_ITEMS).val(presenter.getMaxIndexItems());
                if (presenter.isExperimentalFeatures()) {
                    $(EXPERIMENTAL_FEATURES).attr('checked','checked');
                } else {
                    $(EXPERIMENTAL_FEATURES).removeAttr('checked');
                }
                $(ROUTING_LOG_LEVEL).val(presenter.getRoutingLogLevel());
                if (presenter.getDisableAudio()) {
                    $(AUDIO).removeAttr('checked');
                } else {
                    $(AUDIO).attr('checked','checked');
                }
                if (presenter.getDisableIPv6()) {
                   $(DISABLE_IPV6).attr('checked','checked'); 
                } else {                   
                   $(DISABLE_IPV6).removeAttr('checked');
                }
               if (presenter.getDisableFactoryReset()) {
                   $(DISABLE_FACTORY_RESET).attr('checked','checked'); 
                } else {                   
                   $(DISABLE_FACTORY_RESET).removeAttr('checked');
                }
                if (presenter.getHighContrast()) {
                    $(HIGH_CONTRAST).attr('checked','checked');
                } else {
                    $(HIGH_CONTRAST).removeAttr('checked');
                }
                if (presenter.getTrackTiming()) {
                    $(TRACK_TIMING).attr('checked','checked');
                } else {
                    $(TRACK_TIMING).removeAttr('checked');
                }
                formStateView.reset();
            }

            function apply() {
                presenter.save({
                    refreshInterval : $(REFRESH_INTERVAL).val(),
                    maxIndexItems : $(MAX_INDEX_ITEMS).val(),
                    experimentalFeatures : $(EXPERIMENTAL_FEATURES).is(':checked'),
                    routingLogLevel : $(ROUTING_LOG_LEVEL).val(),
                    disableAudio : (! $(AUDIO).is(':checked')),
                    disableIPv6 : ($(DISABLE_IPV6).is(':checked')),   
                    disableFactoryReset : ($(DISABLE_FACTORY_RESET).is(':checked')),                                       
                    highContrast : ($(HIGH_CONTRAST).is(':checked')),
                    trackTiming : ($(TRACK_TIMING).is(':checked'))
                });
                if (presenter.isExperimentalFeatures()) {
                    $('html').addClass('experimental');
                } else {
                    $('html').removeClass('experimental');
                }
                if (presenter.getHighContrast()) {
                    $('html').addClass('hp-high-contrast');
                } else {
                    $('html').removeClass('hp-high-contrast');
                }
                var alertMsg = localizer.getString('core.settings.development.edit.success');
                notifications.show(alertMsg);
            }

            this.init = function (validator) {
                formStateView.init({form: FORM, autoTrack: true});
                    
                // Handlers for the buttons.
                $(OK).click(function(ev) {
                    apply();
                    ev.preventDefault();
                    formStateView.reset();
                    $(CANCEL).trigger('click');
                });
                
                fillForm();
            };

            this.pause = function() {
                formStateView.reset();
            };

            this.resume = function () {
                fillForm();
            };
        }

        return new DevelopmentEditView();
    }());

    return DevelopmentEditView;
});
