// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
/**
 * @type {EnclosureShowRoutes}
 */
define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var EnclosureShowRoutes = ( function() {

        var CONTAINER = '#hpsum-enclosure-page .hp-details-show-view';

        function EnclosureShowRoutes() {

            var registered = false;
            var activityView = null;

            this.register = function () {

                if (registered) return;
                registered = true;

                router.map('enclosure show overview',
                    '/enclosure/show/overview' +
                    urlFragment.viewSinglePatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/enclosure/overview.html',
                            'hpsum/view/enclosure/EnclosureShowOverviewView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                
                router.map('enclosure show oa overview',
                    '/enclosure/show/oa/overview' +
                    urlFragment.viewSinglePatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/enclosure/overview.html',
                            'hpsum/view/enclosure/EnclosureShowOverviewView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                
                router.map('enclosure show sd2 overview',
                    '/enclosure/show/sd2/overview' +
                    urlFragment.viewSinglePatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/sd2oa/sd2oaOverview.html',
                            'hpsum/view/sd2oa/SD2oaOverview'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                router.map(' enclosure show overview multi',
                   '/enclosure/show/(unknown|host|windows|linux|vmware|hpux|ilo|ilo2|ilo3|ilo4| \
                     integrityilo2|integrityilo3|ipdu|switch|fc_switch|sas_switch|oa|sd2|virtual_connect|moonshot|ilo_federation)/overview' +
                    urlFragment.viewMultiPatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/overview_multi.html',
                            	'hpsum/view/node/NodeShowOverviewMultiView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                        }
                    });
                
                router.map('enclosure show activity',
                    '/enclosure/show/activity' + urlFragment.viewPatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/activity/resource.html',
                            'hpsum/view/activity/ActivityResourceView'],
                        function (page, View) {
                            if (! activityView) {
                                activityView = new View();
                            }
                            result.load(page, activityView);
                        });
                    }
                });
                
                router.map('enclosure show related',
                    '/enclosure/show/related' + urlFragment.viewPatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/map/related.html',
                            'hp/view/map/RelatedView'],
                        function (page, view) {
                            view.route = '/enclosure/show/related';
                            result.load(page, view);
                        });
                    }
                });
                
                router.map('enclosure show more',
                    '/enclosure/show/(general|bandwidth|usage)' +
                        urlFragment.viewPatternTerminal, {
                    root: '/enclosure/show/(general|bandwidth|usage)',
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/enclosure/more.html',
                              'hpsum/view/enclosure/EnclosureShowMoreView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                router.filter('enclosure show default redirector',
                    '/enclosure/show' + urlFragment.viewPatternTerminal, {
                    check: function (location, result) {
                        result.replaceWith(
                            urlFragment.replaceView(location, 'show/overview'));
                    }
                });

                router.map('enclosure show no route', '/enclosure/show/.*', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/no_details.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            }
        }

        return new EnclosureShowRoutes();
    }());

    return EnclosureShowRoutes;
});
