// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
/* This is a Resource object for Group resource.
 */
define(['hp/model/Resource',
'hp/services/IndexService',
'hp/services/REST',
'hp/model/Session'
],
function(Resource, indexService, restService, session) {"use strict";

	var GroupResource = ( function() {

			/**
			 * @constructor
			 */
			function GroupResource() {
				var category = 'group';
				Resource.call(this, category);

				/**
				 * @public
				 * Add a new group
				 */
				this.addGroup = function(item, handlers) {
					var object = {
						hapi : {
							group_name : item.name,
							group_description : item.description,
							group_nodes : {
								group_node : item.nodes
							},
							group_baselines : {
								group_baseline : item.baselines
							}
						}
					};

					var options = {
						encodeResults : false,
						encodeErrors : false
					};

					var sessionurl = '/session/' + session.getToken();
					restService.postObject(sessionurl + '/node/group/add', object, {
						success : function(data) {
							if (data.hapi.hcode == 0 || data.hapi.hcode == 5032) {
								handlers.success(data);
							} else {
								handlers.error(data);
							}
						},
						error : function(data) {
							handlers.error(data)
						}
					}, options);
				};

				/**
				 * @public
				 * Intialize the group resource.
				 */
				this.init = function(count) {
				};

			}

			return new GroupResource();
		}());
	return GroupResource;

});
