// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
/**
 * @type {EnclosureShowRoutes}
 */
define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var iloShowRoutes = ( function() {

        var CONTAINER = '#hpsum-ilo-page .hp-details-show-view';

        function iloShowRoutes() {

            var registered = false;
            var activityView = null;

            this.register = function () {

                if (registered) return;
                registered = true;

                router.map('ilo show overview',
                    '/ilo/show/overview' +
                    urlFragment.viewSinglePatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/ilo/iloOverview.html',
                            'hpsum/view/ilo/IloOverviewView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                
				router.map('ilo ilo overview', '/ilo/show/(ilo|ilo2|ilo3|ilo4)/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/ilo/iloOverview.html',
						'hpsum/view/ilo/IloOverviewView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
				

                router.map(' ilo show overview multi',
                   '/ilo/show/overview' +
                    urlFragment.viewMultiPatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/overview_multi.html',
                            'hpsum/view/node/NodeShowOverviewMultiView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                        }
                    });
                
				router.map('ilo integritylo overview', '/ilo/show/(integrityilo2|integrityilo3)/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/integrityilo/integrityiloOverview.html',
						'hpsum/view/integrityilo/IntegrityIloOverview'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
                

                router.filter('ilo show default redirector',
                    '/ilo/show' + urlFragment.viewPatternTerminal, {
                    check: function (location, result) {
                        result.replaceWith(
                            urlFragment.replaceView(location, 'show/overview'));
                    }
                });

                router.map('ilo show no route', '/ilo/show/.*', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/no_details.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            }
        }

        return new iloShowRoutes();
    }());

    return iloShowRoutes;
});
