// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
/**
 * @type {iloFederationShowRoutes}
 * This is used to provide route map for each ilo federation action.
 * This also provides default redirector and shows default error page if no matching URI identified.
 */

define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { 
	"use strict";
	// Constructor
	var iloFederationShowRoutes = ( function() {
		var CONTAINER = '#hpsum-ilofederation-page .hp-details-show-view';
		var CHANGE_CONTAINER = '#hp-change-page-container';
		function iloFederationShowRoutes(){
			
			var registered = false;
			this.register = function() {
				if(registered) return;
				registered =true;
				 
			router.map('ilofederation show overview', '/ilofederation/show/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/ilofederation/iloFederationOverview.html',
						'hpsum/view/ilofederation/iloFederationOverviewView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
				

			router.map('ilofederation show overview multi',
                   '/ilofederation/show/(unknown|host|windows|linux|vmware|hpux|ilo|ilo2|ilo3|ilo4| \
                     integrityilo2|integrityilo3|moonshot|switch|fc_switch|sas_switch|oa|sd2|virtual_connect|ilo_federation)/overview' +
                    urlFragment.viewMultiPatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/overview_multi.html',
                            'hpsum/view/node/NodeShowOverviewMultiView'],
                        function (page, view) {
                            result.load(page, view);
                        });
						}
					});

				router.map('node ilofederation overview', '/node/show/ilo_federation/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/ilofederation/iloFederationOverview.html',
						'hpsum/view/ilofederation/iloFederationOverviewView'],
						function (page,view){
							result.load(page,view);
						});
					}				
					
				});
				
				router.filter ('ilofederation show default redirector',
					'/ilofederation/show' + urlFragment.viewPatternTerminal, {
					 check: function (location, result) {
					 	result.replaceWith(urlFragment.replaceView(location, 'show/overview'));
					 }
				});	

				router.map('ilofederation show no route', '/ilofederation/show/.+',
				{
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpPages/core/no_details.html'],
						function (page){
							result.load(page);
						});
					}
					
				});
			}
		}
		
		return new iloFederationShowRoutes();
		
	}());
	
	return iloFederationShowRoutes;

});