// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
/**
 * @type {pduRoutes}
 */
define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var ipduRoutes = ( function() {

        var CONTAINER = '#hpsum-ipdu-page .hp-details-pane';
        var CHANGE_CONTAINER = '#hp-change-page-container';
        var CONFIRM_CONTAINER = '#hp-dialog-container';

        function ipduRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) return;
                registered = true;

                router.map('ipdu show',
                    '/ipdu/show' + urlFragment.pagePatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/show.html',
                            'hpsum/view/node/NodeShowView',
                            'hpsum/model/ipdu/ipduShowRoutes'],
                        function (page, view, routes) {
                            routes.register();
                            result.load(page, view);
                        });
                    }
                });
                                router.map('ipdu add',
                    '/ipdu/add' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        /*
                        require(['text!hpsumpages/node/add.html',
                            'hpsum/view/node/NodeAddView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                        */
                       result.replaceWith('/node/add');
                    }
                });

                router.map('ipdu edit',
                    '/ipdu/edit' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        /*
                        require(['text!hpsumpages/node/edit.html',
                            'hpsum/view/node/NodeEditView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                        */
                       result.replaceWith('/node/edit');
                    }
                });
                
             router.map('ipdu inventoryd', '/ipdu/inventoryd' +
				urlFragment.viewSinglePatternTerminal, {
					container: CHANGE_CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/node/doinventory.html',
						'hpsum/view/node/NodeInventoryDView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
                
             
				router.map('ipdu deploy',
                    '/ipdu/deploy' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/deploy.html',
                            'hpsum/view/node/NodeDeployView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                                
               router.map('ipdu reports', '/ipdu/reports' +
				urlFragment.pagePatternTerminal, {
					container: CHANGE_CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/node/reports.html',
						'hpsum/view/node/NodeReportsView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});


                router.map('ipdu deploy-results', '/ipdu/deploy-results' +
                urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function(location, result) {
                        require(['text!hpsumpages/node/install_results.html',
                        'hpsum/view/node/NodeDeployResults'],
                        function (page,view){
                            result.load(page,view);
                        });
                    }
                });
 
                router.filter('ipdu default redirector',
                    '/ipdu' + urlFragment.viewPatternTerminal, {
                    check: function (location, result) {
                        result.replaceWith(
                            urlFragment.replaceView(location, 'show'));
                    }
                });

                router.map('ipdu no route', '/ipdu/.+', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/core/no_details.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            }
        }

        return new ipduRoutes();
    }());

    return ipduRoutes;
});
