// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
/**
 * @type {NodeShowRoutes}
 * This is used to provide route map for each NodesShow action.
 * This also provides default redirector and shows default error page if no matching URI identified.
 */

define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { 
	"use strict";
	// Constructor
	var NodeShowRoutes = ( function() {
		var CONTAINER = '#hpsum-nodes-page .hp-details-show-view';
		var CHANGE_CONTAINER = '#hp-change-page-container';
		function NodeShowRoutes(){
			
			var registered = false;
			this.register = function() {
				if(registered) return;
				registered =true;
				 
			router.map('node show overview', '/node/show/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/node/overview.html',
						'hpsum/view/node/NodeShowOverviewView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
				router.map('node show overview multi',
                   '/node/show/overview' +
                    urlFragment.viewMultiPatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/overview_multi.html',
                            'hpsum/view/node/NodeShowOverviewMultiView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

				router.map(' node show type overview multi',
                   '/node/show/(unknown|host|windows|linux|vmware|hpux|ilo|ilo2|ilo3|ilo4| \
                     integrityilo2|integrityilo3|ipdu|switch|fc_switch|sas_switch|oa|sd2|virtual_connect|moonshot|ilo_federation)/overview' +
                    urlFragment.viewMultiPatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/overview_multi.html',
                            'hpsum/view/node/NodeShowOverviewMultiView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
				
				router.map('node unknown overview', '/node/show/(unknown|host)/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/node/overview.html',
						'hpsum/view/node/NodeShowOverviewView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
				
				router.map('node server overview', '/node/show/(windows|linux|vmware|hpux)/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/server/overview.html',
						'hpsum/view/server/ServerShowOverviewView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
				
				router.map('node ilo overview', '/node/show/(ilo|ilo2|ilo3|ilo4)/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/ilo/iloOverview.html',
						'hpsum/view/ilo/IloOverviewView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});

				router.map('node ilo_federation overview', '/node/show/ilo_federation/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/ilofederation/iloFederationOverview.html',
						'hpsum/view/ilofederation/iloFederationOverviewView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
				
				router.map('node integritylo overview', '/node/show/(integrityilo2|integrityilo3)/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/integrityilo/integrityiloOverview.html',
						'hpsum/view/integrityilo/IntegrityIloOverView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
				
                router.map('node moonshot overview', '/node/show/moonshot/overview' +
                    urlFragment.viewSinglePatternTerminal, {
                    container: CONTAINER,
                    enter: function(location, result) {
                        require(['text!hpsumpages/moonshot/moonshotOverview.html',
                        'hpsum/view/moonshot/moonshotOverviewView'],
                        function (page,view){
                            result.load(page,view);
                        });
                    }
                });
                
				router.map('node ipdu overview', '/node/show/ipdu/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/ipdu/ipduOverview.html',
						'hpsum/view/ipdu/IpduOverviewView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
				
				router.map('node enclosure overview', '/node/show/oa/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/enclosure/overview.html',
						'hpsum/view/enclosure/EnclosureShowOverviewView'],
						function (page,view){
							result.load(page,view);
						});
					}				
					
				});

				router.map('node sd2 overview', '/node/show/sd2/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/sd2oa/sd2oaOverview.html',
						'hpsum/view/sd2oa/SD2oaOverview'],
						function (page,view){
							result.load(page,view);
						});
					}				
					
				});
				
				router.map('node vc overview', '/node/show/virtual_connect/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/vc/vcOverview.html',
						'hpsum/view/vc/VcOverviewView'],
						function (page,view){
							result.load(page,view);
						});
					}				
					
				});
				
				router.map('node switch overview', '/node/show/(switch|fc_switch|sas_switch)/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/switch/overview.html',
						'hpsum/view/switch/SwitchOverviewView'],
						function (page,view){
							result.load(page,view);
						});
					}				
					
				});
				
				router.map('node show more', '/node/show/more' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						var resourcetype = router.location().split('/');
                		resourcetype = resourcetype[5];
                		if(resourcetype == "fc_switch")
                			resourcetype = "switch";
                		var location = router.location().replace("node", resourcetype);
                		location = location.replace("/more/","/");
                		router.go(location);
                	}
					});
				/*
				router.map('node show reports', '/node/show/reports' +
				urlFragment.viewSinglePatternTerminal, {
					container: CHANGE_CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/node/reports.html',
						'hpsum/view/node/NodeShowReports'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
				
				router.map('node show schedule', '/node/show/schedule' +
				urlFragment.viewSinglePatternTerminal, {
					container: CHANGE_CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/node/schedule.html',
						'hpsum/view/node/NodeShowSchedule'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
				*/
				
				router.filter ('node show default redirector',
					'/node/show' + urlFragment.viewPatternTerminal, {
					 check: function (location, result) {
					 	result.replaceWith(urlFragment.replaceView(location, 'show/overview'));
					 }
				});	

				router.map('node show no route', '/node/show/.+',
				{
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpPages/core/no_details.html'],
						function (page){
							result.load(page);
						});
					}
					
				});
			}
		}
		
		return new NodeShowRoutes();
		
	}());
	
	return NodeShowRoutes;

});