// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
/**
 * @type {SwitchRoutes}
 */
define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var SwitchRoutes = ( function() {

        var CONTAINER = '#hpsum-switch-page .hp-details-pane';
        var CHANGE_CONTAINER = '#hp-change-page-container';
        var SHOW_CONTAINER = '#hpsum-switch-page .hp-details-show-view';

        function SwitchRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) return;
                registered = true;

                router.map('switch show',
                    '/switch/show' + urlFragment.pagePatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/show.html',
                            'hpsum/view/node/NodeShowView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                
                router.map('switch show overview',
                    '/switch/show/overview' +
                    urlFragment.viewSinglePatternTerminal, {
                    container: SHOW_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/switch/overview.html',
                            'hpsum/view/switch/SwitchOverviewView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                

                router.map(' switch show overview multi',
                   '/switch/show/(unknown|host|windows|linux|vmware|hpux|ilo|ilo2|ilo3|ilo4| \
                     integrityilo2|integrityilo3|ipdu|switch|fc_switch|sas_switch|oa|sd2|virtual_connect|moonshot|ilo_federation)/overview' +
                    urlFragment.viewMultiPatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/overview_multi.html',
                            'hpsum/view/node/NodeShowOverviewMultiView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                        }
                    });
                
                router.map('switch show each overview',
                    '/switch/show/(sas_switch|fc_switch|switch_cisco|switch_brocade|switch_qlogic)/overview' +
                    urlFragment.viewSinglePatternTerminal, {
                    container: SHOW_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/switch/overview.html',
                            'hpsum/view/switch/SwitchOverviewView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                
                router.map('switch show overview multi',
                    '/switch/show/overview' +
                    urlFragment.viewMultiPatternTerminal, {
                    container: SHOW_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/switch/overview_multi.html',
                            'hpsum/view/switch/SwitchOverviewMultiView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                router.map('switch deploy-results', '/switch/deploy-results' +
                urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function(location, result) {
                        require(['text!hpsumpages/node/install_results.html',
                        'hpsum/view/node/NodeDeployResults'],
                        function (page,view){
                            result.load(page,view);
                        });
                    }
                });
                
                                router.map('switch add',
                    '/switch/add' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        /*
                        require(['text!hpsumpages/node/add.html',
                            'hpsum/view/node/NodeAddView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                        */
                       result.replaceWith('/node/add');
                    }
                });

                router.map('switch edit',
                    '/switch/edit' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        /*
                        require(['text!hpsumpages/node/edit.html',
                            'hpsum/view/node/NodeEditView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                        */
                       result.replaceWith('/node/edit');
                    }
                });
                
             router.map('switch inventoryd', '/switch/inventoryd' +
				urlFragment.viewSinglePatternTerminal, {
					container: CHANGE_CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/node/doinventory.html',
						'hpsum/view/node/NodeInventoryDView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
                
             
				router.map('switch deploy',
                    '/switch/deploy' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/deploy.html',
                            'hpsum/view/node/NodeDeployView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                                
               router.map('switch reports', '/switch/reports' +
				urlFragment.pagePatternTerminal, {
					container: CHANGE_CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/node/reports.html',
						'hpsum/view/node/NodeReportsView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});

                
                router.filter('switch show default redirector',
                    '/switch/show' + urlFragment.viewPatternTerminal, {
                    check: function (location, result) {
                        result.replaceWith(
                            urlFragment.replaceView(location, 'show/overview'));
                    }
                });


                router.filter('switch default redirector',
                    '/switch' + urlFragment.viewPatternTerminal, {
                    check: function (location, result) {
                        result.replaceWith(
                            urlFragment.replaceView(location, 'show/overview'));
                    }
                });

                router.map('switch no route', '/switch/.+', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/no_details.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            }
        }

        return new SwitchRoutes();
    }());

    return SwitchRoutes;
});
