// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
/**
 * This provides login and logout functions with dummy session details.
 * Set and retrieval functions for GlobalSettings provided here.
 */
define(['hp/model/Session', 'hp/view/DialogView', 'hp/core/Localizer','hp/services/Log', 'text!hpsumpages/common/logoff_shutdown.html', 'jquery'], function(session, DialogView, localizer, Log, logoffhtml) {

	function logOffSession(handlers) {

		var value = $('input[name=hpsum-logoff-value]:checked').val();
		var closeHandlers = { 
				success:function()
						{
							session.eraseAll();
							if (handlers && handlers.success) {
								handlers.success({});
							}
							window.location.hash = '#/login';
							window.location.reload(true);
							if(value =='shutdown'){
								window.document.write("HPSUM Engine is Shutdown. Please restart the engine to Login.");
							}
								
						},
			    error:function(){
			         Log.error("Error shutting down the engine");
			      }
		};
		
		if (value == 'logoff') {
			//close hpsum session
			session.closeSession(closeHandlers);
		} else {
			var data = { hapi: {
						force: 'false'
						}};
			session.shutDown(data,closeHandlers);
			Log.info("initiated shutdown");
		}
		
		
	}

	//TODO convert to module pattern
	return {
		login : function(username, password, provider, handlers) {

			session.createSession(username, password, handlers);
		},
        logout : function (authToken, handlers) {
        	
			var logoffdialogcontents = $(logoffhtml);
			localizer.localizeDom(logoffdialogcontents);
			new DialogView({
				contents : logoffdialogcontents,
				ok : function() {
					logOffSession(handlers);
				},
				cancel : function() {
					return;
				}
			});
        },
		getGlobalSettings : function (handlers) {
            setTimeout(function() {
                handlers.success({"allowLocalLogin":true,"defaultLoginDomain":{"name":"LOCAL","uri":"","loginDomain":"0"},"configuredLoginDomains":[]});
            }, 10)
        },
        setGlobalSettings : function (allowLocalLogin, defaultProviderId, handlers) {
            //REST.putObject('/authn/rest/authentication/globalsettings',
            //        {"allowLocalLogin": allowLocalLogin, "defaultProvider":{"providerId": defaultProviderId}},
            //        null, handlers);
            handlers.error({errorMessage: "authn.setGlobalSettings() not Implemented"})
        }
    };
});
