 // (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
/**
 * @type {HpsumPageRoutes}
 * Provides page routes for all the main menus such as dashboard, baseline, nodes etc.
 */
define(['hp/core/Router', 'hp/core/UrlFragment', 'hp/model/SessionRoutes',
  'hp/model/SearchRoutes', 'hp/model/MapRoutes',
  'hp/model/settings/SettingsRoutes', 'hp/model/settings/DevelopmentRoutes', 
  'hpsum/HpsumGenerator', 'hp/core/Localizer'],
function (router, urlFragment, sessionRoutes, searchRoutes, mapRoutes, 
	
	settingsRoutes, developmentRoutes, generator, localizer) { "use strict";

    var MainPageRoutes = ( function() {

        var CONTAINER = '#hp-page-container';
        var CHANGE_CONTAINER = '#hp-change-page-container';
        var DASHBOARD_CONFIG = {
            primaries: [
                {category: 'server',
                 utilization: {
                   segments: [
                      {label: 'old', query: 'firmware:2012-01-01'},
                      {label: 'new', query: 'firmware:2012-02-01'}
                   ],
                   //label: 'Server firmware distribution'
                   label: localizer.getString('hpsum.shell.serverFirmwareDistribution')
                 }
                },
                {category: 'volume',
                 utilization: {
                   segments: [
                     // use status to simulate in HPSUM
                     {label: 'old', query: 'status:ok'}
                   ],
                   //label: 'Terrabytes in use'
                   label: localizer.getString('hpsum.shell.terrabytesInUse')
                 }},
                {category: ['switch', 'fc_switch'],
                  utilization: {
                    segments: [
                      // use category to simulate in HPSUM
                      {label: 'old', query: 'category:fc_switch'}
                    ],
                    //label: 'Switch ports in use'
                    label: localizer.getString('hpsum.shell.switchPortsInUse')
                  }}
                ],
            secondaries: [
                {category: 'enclosure'},
                {category: 'rack'},
                {resourceUri: '/server/item1'},
                {resourceUri: '/server/item5'}
                ],
            indicators: [
                {query: 'model:sM-8001',
                  label: 'Old servers'},
                {query: 'firmware:2012-02-01',
                  label: 'Devices with old firmware'},
                {query: 'category:fc_switch',
                  label: 'Fibre channel switches'}
                ]
        };

        function MainPageRoutes() {

            var loaded = false;

            this.load = function () {

                if (loaded) return;
                loaded = true;

                
			router.map('status', '^/status', {
                    menu: {
                        simpleBanner: true
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/status/index.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });	
                		
			// This adds login
			sessionRoutes.register();		

	    	router.map('default', '^$|^/$', {
                    menu: {
                        label: localizer.getString('hpsum.common.browse'),
                        location: '/'
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/welcome/index.html',
                        		'hpsum/view/welcome/WelcomeView'
                            	],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
	 
                router.map('welcome', '^/welcome', {
                    menu: {
                        section: localizer.getString('hpsum.common.general'),
                        label: localizer.getString('hpsum.menu.welcome'),
                        location: '/welcome'
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/welcome/index.html',
                              'hpsum/view/welcome/WelcomeView'
                ],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                
                router.map('activity', '^/activity', {
                    menu: {
                        section: localizer.getString('hpsum.common.general'),
                        label: localizer.getString('hpsum.common.tasks'),
                        location: '/activity',
                        indexCategory: ['alert', 'task'],
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/activity/index.html',
                            'hpsum/view/activity/ActivityView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
  			
			/* FIXME This feature will be added in the next release
	    	router.map('dashboard', '^/dashboard', {
                    menu: {
                        section: localizer.getString('hpsum.common.general'),
                        label: localizer.getString('hpsum.common.dashboard'),
                        location: '/dashboard'
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/dashboard/index.html',
                            'hp/view/dashboard/DashboardView'],
                        function (page, view) {
                            view.configure(DASHBOARD_CONFIG);
                            result.load(page, view);
                        });
                    }
                });
		  */
	    	router.map('one-touch-update', '^/guided-update' + urlFragment.pagePatternTerminal, {
                    menu: {
                      section: localizer.getString('hpsum.menu.sources'),
                      label: localizer.getString('hpsum.common.oneTouchUpdate'),
                      location: '/guided-update',
                      resourceUriPattern: '^/guided-update/.+',
                      indexCategory: 'one-touch-update',
                      authCategory: 'BASELINE'
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/one-touch-update/index.html',
                            'hpsum/view/one-touch-update/OneTouchUpdateView',
                            'hpsum/model/one-touch-update/OneTouchUpdateRoutes'],
                        function (page, view, routes) {
                        	routes.register();
							result.noAction();
							//commented the following line to avoid loading same page multiple times
                            //result.load(page, view);
                        });
                    }
                });
     router.map('baseline', '^/baseline' + urlFragment.pagePatternTerminal, {
                    menu: {
                        section: localizer.getString('hpsum.menu.sources'),
                        label: localizer.getString('hpsum.common.baselines'),
                        location: '/baseline',
                        resourceUriPattern: '^/baseline/.+',
                        indexCategory: 'baseline',
                        authCategory: 'BASELINE'
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/baseline/index.html',
                            'hpsum/view/baseline/BaselineView',
                            'hpsum/model/baseline/BaselineRoutes'],
                        function (page, view, routes) {
                            routes.register();
                            result.load(page, view);
                        });
                    }
                });
                
                router.map('node', '^/node(/.*|$)', {
                    menu: {
                        section: localizer.getString('hpsum.menu.sources'),
                        label: localizer.getString('hpsum.common.nodes'),
                        location: '/node',
                        resourceUriPattern: '^/node/.+',
                        indexCategory: 'node'
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/index.html',
                            'hpsum/view/node/NodeView',
                            'hpsum/model/node/NodeRoutes'],
                        function (page, view, routes) {
                            routes.register();
                            result.load(page, view);
                        });
                    }
                });
                
			    router.map('group', '^/group(/.*|$)', {
					menu : {
							section : localizer.getString('hpsum.menu.sources'),
							label : localizer.getString('hpsum.group.groups'),
							location : '/group',
							resourceUriPattern : '^/group/.+',
							indexCategory : 'group'
						},
						container : CONTAINER,
						enter : function(location, result) {
							require(['text!hpsumpages/group/index.html',
							'hpsum/view/group/GroupView',
							'hpsum/model/group/GroupRoutes'],
							function(page, view, routes) {
								routes.register();
								result.load(page, view);
							});
					}
			    }); 

                router.map('enclosure', '^/enclosure' + urlFragment.pagePatternTerminal, {
                    menu: {
                      section: localizer.getString('hpsum.menu.deploymentTypes'),
                      label: localizer.getString('hpsum.menu.enclosures'),
                      location: '/enclosure',
                      resourceUriPattern: '^/enclosure/.+',
                      indexCategory: 'enclosure',
                      authCategory: 'ENCLOSURE'
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/enclosure/index.html',
                            'hpsum/view/enclosure/EnclosureView',
                            'hpsum/model/enclosure/EnclosureRoutes'],
                        function (page, view, routes) {
                            routes.register();
                            result.load(page, view);
                        });
                    }
                });
                
                router.map('server', '^/server' + urlFragment.pagePatternTerminal, {
                    menu: {
                      section: localizer.getString('hpsum.menu.deploymentTypes'),
                      label: localizer.getString('hpsum.common.servers'),
                      location: '/server',
                      resourceUriPattern: '^/server/.+',
                      indexCategory: 'server',
                      authCategory: 'SERVER'
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/server/index.html',
                            'hpsum/view/server/ServerView',
                            'hpsum/model/server/ServerRoutes'],
                        function (page, view, routes) {
                            routes.register();
                            result.load(page, view);
                        });
                    }
                });

                router.map('switch', '^/switch' + urlFragment.pagePatternTerminal, {
                    menu: {
                        section: localizer.getString('hpsum.menu.deploymentTypes'),
                        label: localizer.getString('hpsum.common.switches'),
                        resourceUriPattern: '^/switch/.+',
                        indexCategory: ['switch', 'fc_switch'],
                        location: '/switch'
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/switch/index.html',
                            'hpsum/view/switch/SwitchView',
                            'hpsum/model/switch/SwitchRoutes'],
                        function (page, view, routes) {
                            routes.register();
                            result.load(page, view);
                        });
                    }
                });
				
               
	    	router.map('vmware', '^/vmware' + urlFragment.pagePatternTerminal, {
                    menu: {
                        section: localizer.getString('hpsum.menu.deploymentTypes'),
                        label: localizer.getString('hpsum.menu.vmHosts'),
                        resourceUriPattern: '^/vmware/.+',
                        indexCategory: 'vmware',
                        location: '/vmware'
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/server/vmwareindex.html',
                            'hpsum/view/server/VmwareView',
                            'hpsum/model/vmware/VmwareRoutes'],
                        function (page, view, routes) {
                            routes.register();
                            result.load(page, view);
                        });
                    }
                });
                /*FIXME: Removed from 6.3.0
                router.map('moonshot', '^/moonshot' + urlFragment.pagePatternTerminal, {
                    menu: {
                        section: localizer.getString('hpsum.menu.deploymentTypes'),
                        label: localizer.getString('hpsum.node.moonshot'),
                        resourceUriPattern: '^/moonshot/.+',
                        indexCategory: 'moonshot',
                        location: '/moonshot'
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/moonshot/index.html',
                            'hpsum/view/moonshot/moonshotView',
                            'hpsum/model/moonshot/moonshotRoutes'],
                        function (page, view, routes) {
                            routes.register();
                            result.load(page, view);
                        });
                    }
                });
                */

               router.map('ilo', '^/ilo' + urlFragment.pagePatternTerminal, {
                    menu: {
                        section: localizer.getString('hpsum.menu.deploymentTypes'),
                        label: localizer.getString('hpsum.menu.ilo'),
                        resourceUriPattern: '^/ilo/.+',
                        indexCategory: 'ilo',
                        location: '/ilo'
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/ilo/index.html',
                            'hpsum/view/ilo/iloView',
                            'hpsum/model/ilo/iloRoutes'],
                        function (page, view, routes) {
                            routes.register();
                            result.load(page, view);
                        });
                    }
                });
                
                router.map('ipdu', '^/ipdu' + urlFragment.pagePatternTerminal, {
                    menu: {
                        section: localizer.getString('hpsum.menu.deploymentTypes'),
                        label: localizer.getString('hpsum.menu.ipdu'),
                        resourceUriPattern: '^/ipdu/.+',
                        indexCategory: 'ipdu',
                        location: '/ipdu'
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/ipdu/index.html',
                            'hpsum/view/ipdu/ipduView',
                            'hpsum/model/ipdu/ipduRoutes'],
                        function (page, view, routes) {
                            routes.register();
                            result.load(page, view);
                        });
                    }
                });
                
                router.map('vc', '^/vc' + urlFragment.pagePatternTerminal, {
                    menu: {
                        section: localizer.getString('hpsum.menu.deploymentTypes'),
                        label: localizer.getString('hpsum.menu.vc'),
                        resourceUriPattern: '^/vc/.+',
                        indexCategory: 'vc',
                        location: '/vc'
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/vc/index.html',
                            'hpsum/view/vc/VcView',
                            'hpsum/model/vc/vcRoutes'],
                        function (page, view, routes) {
                            routes.register();
                            result.load(page, view);
                        });
                    }
                });
                
                router.map('ilofederation', '^/ilofederation' + urlFragment.pagePatternTerminal, {
                    menu: {
                        section: localizer.getString('hpsum.menu.deploymentTypes'),
                        label: localizer.getString('hpsum.menu.ilofederation'),
                        resourceUriPattern: '^/ilofederation/.+',
                        indexCategory: 'ilofederation',
                        location: '/ilofederation'
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/ilofederation/index.html',
                            'hpsum/view/ilofederation/iloFederationView',
                            'hpsum/model/ilofederation/iloFederationRoutes'],
                        function (page, view, routes) {
                            routes.register();
                            result.load(page, view);
                        });
                    }
                });                
                
                generator.registerRoutes();
                searchRoutes.register();

                mapRoutes.register();

                /* FIXME All of this settings will be added in the future
                  settingsRoutes.register([
                                     
                  {
                      registerRoutes: function () {
                          router.map('hpsum settings', '/settings/edit/hpsum(/$|$)', {
                              container: CHANGE_CONTAINER,
                              enter: function (location, result) {
                                  require(['text!hpsumpages/settings/edit.html',
                                      'hpsum/view/settings/HpsumSettingsEditView'],
                                  function (page, view) {
                                      result.load(page, view);
                                  });
                              }
                          });
                      },
                      authCategory: 'APPLIANCE',
                      registerOverview: function(result) {
                          require(['text!hpsumpages/settings/overview.html',
                                   'hpsum/view/settings/HpsumSettingsShowOverviewView',
                                   'hp/view/settings/SettingsOverviewView'],
                          function (panel, view, overview) {
                              overview.register(panel, view, {priority : 10});
                          });
                      }
                  }
                ]);
              */
                
		router.map('not auth', '^/noauth', {
                    menu: {},
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/core/not_authorized.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
				
                router.map('no route', '^.*', {
                    menu: {},
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/core/no_page.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            }
        }

        return new MainPageRoutes();
    }());

    return MainPageRoutes;
});
