// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.

define(['hpsum/model/activity/ActivityResource',
    'hpsum/presenter/activity/ActivityPresenter',
    'hp/view/MasterPaneView',
    'hp/core/LinkTargetBuilder',
    'hp/core/Localizer',
    'jquery',
    'lib/jquery.dataTables',
    'hp/lib/jquery.hpStatus',
    'hp/lib/jquery.hpTimestamp',
    'lib/jquery.dateFormat',
    'hp/lib/date',
    'hp/lib/jquery.hpDropMenu',
    'hp/lib/jquery.hpSelect',
    'hp/view/DialogView',
    'hp/lib/jquery.hpCollapsible',	
    'hp/lib/jquery.hpProgressBar'],
function(resource, Presenter, MasterPaneView, linkTargetBuilder, localizer) { "use strict";

    var ActivityView = (function() {
      
        var TYPE = 'task';
        var PAGE = '#tour-activity-page';
        var FILTERBAR_CONTROL = PAGE + ' .hp-filterbar-control';
        var CATEGORY_FILTER = '#hp-activity-category-filter';
        var STATE_FILTER = '#hp-activity-state-filter';
        var DATE_FILTER = '#hp-activity-date-filter';
        var DATE_MENU = '#hp-activity-date-menu';
        var DETAILS_TEMPLATE = '#tour-activity-details-template';
        
        var USERS = ['no one', 'Sam', 'Wilma', 'Fred'];
      
        /**
         * Constructor
         */
        function ActivityView() {
          
            var presenter = new Presenter();
            var masterPaneView = new MasterPaneView();
            var detailsTemplate = null;
            
            function appendNote(details, activityNote) {
                var note = $('.hp-comment.hp-template', details).clone();
                note.removeClass('hp-template');
				var date = Date.parseISOString(activityNote.date);
				var formattedDate;
				if (date.isToday()) {
					formattedDate = localizer.getString('hpsum.task.today');
				} else if (date.getFullYear() === (new Date()).getFullYear()) {
					formattedDate = $.format.date(date, 'MMM d');
				} else {
					formattedDate = $.format.date(date, 'M/d/280\ ');
				}
               if(activityNote.text === 'Schedule created') 
			   {
					
				$('.hp-comment-text', note).html('<table><td width=300><div class="hp-collapsible" id="message-collapsible"><label>'+linkTargetBuilder.makeLink(activityNote.text,activityNote.textDetails)+'('+formattedDate + ' ' + $.format.date(Date.parseISOString(activityNote.date),'h:mma') +')</label></div></td><td><label>'+formattedDate+ $.format.date(Date.parseISOString(activityNote.date),'h:mma') +'</label></td></table>');			   
			   
			   }
			   else
			   {
			   $('.hp-comment-text', note).html('<table><td width=300><div class="hp-collapsible" id="message-collapsible"><label>'+activityNote.text + '</label></div></td><td><label>'+formattedDate+ $.format.date(Date.parseISOString(activityNote.date),'h:mma') +'</label></td></table><div class="",id=""><textarea size="80x10" >'+activityNote.textDetails+'</textarea></div>');			   
			   }
			   $('#hp-collapsible').hpCollapsible();
			   note.show();
			   
                $('.hp-comments', details).append(note);                
                $('.hp-comment-delete', note).click(function () {
                    alert("TBD");
                });
            }
            
            function addNote(details, alertUri) {
                var alertNote = {user: 'Sam',
                    text: $('.hp-comment-form-text', details).val(),
                    date: new Date().toISOString()};
                presenter.addNote(alertUri, alertNote);
                appendNote(details, alertNote);
                $('.hp-comment-form-text', details).val('')
            }
            
            function renderDetails(indexResult) {
                var details = detailsTemplate.clone();
                
                if (indexResult.hasOwnProperty('notes')) {
                    $.each(indexResult.notes, function (index, activityNote) {
                        appendNote(details, activityNote);
                    });
                }
                
                $('.hp-comment-form-text', details).focus(function () {
                    $('.hp-comment-add', details).fadeIn();
                }).blur(function () {
                    $('.hp-comment-add', details).fadeOut();
                });
                
                $('.hp-comment-form-text', details).bind('keydown', function (ev) {
                    if (13 === ev.keyCode) {
                        addNote(details, indexResult.uri);
                        ev.preventDefault();
                    }
                });
                
                $('.hp-comment-add', details).bind('click', function () {
                    addNote(details, indexResult.uri);
                });
                
                return details;
            }
            
            function onSelectionChange(selection) {
                $('.hp-header-selection').
                    html((selection.uris ? selection.uris.length : 0) + ' selected');
            }
            
            function onIndexResultsChange(indexResults) {
            }
            
            function selectAll() {
                presenter.selectAll();
            }
            
            function onFilterChange(filter) {
                $(STATE_FILTER).hpSelect('set', presenter.getStateFilter(true));
                $(STATE_FILTER + ' .hp-value').
                    text(presenter.getStateFilterSummary(true));
            }
            
            function onStateFilterChange(ev, values) {
                presenter.setStateFilter(values, true);
            }
            
            function onDateFilterChange(ev, values) {
            }
            
            function initFilters() {
              
                $(STATE_FILTER).hpSelect({multiSelect: true}).
                    change(onStateFilterChange);
                
                $('#hp-activity-filter-default').bind('click', function (ev) {
                    presenter.setDefaultFilters(true);
                });
                
                $(DATE_FILTER).hpSelect().change(onDateFilterChange);
                                              
                $('#hp-activity-date-range-from').datepicker();
                $('#hp-activity-date-range-to').datepicker();
            }
            
            function initActions() {
                $('#tour-activity-actions').hpDropMenu();
                
                $('.hp-header-select-all').click(selectAll);
                
                $('#tour-activity-dismiss').click(function () {
                    presenter.dismissSelected();
                });
                
                $('#tour-activity-delete').click(function () {
                    presenter.deleteSelectedItems({});
                });
            }
            
            function initTable() {
                detailsTemplate = $('#tour-activity-details-template').
                    remove().attr('id', '');
                    
                masterPaneView.init({
                    routePrefix: '^/' + TYPE,
                    resource: resource,
                    page: $(PAGE),
                    multiSelect: true,
                    dataTableOptions:  {
                        aoColumns : [
                            /* expand/collapse
                             {fnRender: function (oObj) {
                                return '<div class="hp-collapser"></div>';
                              },
                              sWidth: 10, sClass: "hp-icon", mDataProp: 'collapse'}, */
                            // status
                            {fnRender: function (oObj) {
                            	if(oObj.aData.status === 0 )
                                    return '<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div></div>';
                                if(oObj.aData.status === 1 )
                                	return '<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>';
                                if(oObj.aData.status === 2 )
                                	return '<div class="hp-status"><div class="hp-status-value hp-status-warning"><span class="hp-value">warning</span></div></div>';
                                if(oObj.aData.status === 3 )
                                	return '<div class="hp-status"><div class="hp-status-value hp-status-unknown"><span class="hp-value">unknown</span></div></div>';
                              },
                              sWidth: 10, sClass: "hp-icon", mDataProp: 'status'},
							 // source
                            {fnRender: function (oObj) {
                                return linkTargetBuilder.makeLink(
                                    oObj.aData.Resource);
                            }, sWidth: 60,mDataProp: 'Resource'}, 
                           // message
                            {fnRender: function (oObj) {								
                                if (oObj.aData.category === 'alert') {
                                    return oObj.aData.Message;
                                } else if (oObj.aData.category === 'task') {
                                    return oObj.aData.Message;
							    } 
                            }, sWidth: 60, mDataProp: 'Message'},
                           // State
                            {fnRender: function (oObj) {								
                                if (oObj.aData.category === 'alert') {
                                    return oObj.aData.state;
                                } else if (oObj.aData.category === 'task') {
                                    return oObj.aData.state;
							    } 
                            }, sWidth: 60, mDataProp: 'state'},  
                            // progress
                            /*{fnRender: function (oObj) {
                                if (oObj.aData.category === 'task' &&
                                    'finished' !== oObj.aData.state) {
                                    var progress = oObj.aData.progress;
                                    if (! progress) {
                                        progress = 0;
                                    }
                                    return '<span data-percent="' + progress +
                                        '" class="hp-progress hp-condensed">' +
                                    '</span>' + progress + '%';
                                } else {
                                    return '';
                                }
                              },
                              sWidth: 90, mDataProp: 'progress'},*/
                            // date/time
                           {fnRender: function (oObj) {
                                // 2011-12-20T08:48:22.888Z
                                /*var date = Date.parseISOString(oObj.aData.LastUpdate);
                                var formattedDate;
                                if (date.isToday()) {
                                    formattedDate = localizer.getString('hpsum.task.today');
                                } else if (date.getFullYear() === (new Date()).getFullYear()) {
                                    formattedDate = $.format.date(date, 'MMM d');
                                } else {
                                    formattedDate = $.format.date(date, 'M/d/280\
                                    ');
                                }
                                return '<div class="hp-timestamp">' +
                                    formattedDate + ' ' + $.format.date(
                                        Date.parseISOString(oObj.aData.LastUpdate), 'h:mma') +
                                    '</div>';*/
                                   return oObj.aData.LastUpdate;
                              },
                              sWidth: 90, mDataProp: 'LastUpdate'} 
                          ],
                         
                        aaSorting: [[ 4, "desc" ]],
                        fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(1) > div.hp-status', nRow).hpStatus();
                            if (aData.category === 'task' &&
                                'finished' !== aData.state) {
                                $('td:eq(3) span', nRow).hpProgressBar();
                            }
                            return nRow;
                        } 
                    },
					
                    detailsRenderer: renderDetails
                });
            }
            
            /**
             * @public
             */
            this.pause = function () {
                presenter.off('indexResultsChange', onIndexResultsChange);
                presenter.off('selectionChange', onSelectionChange);
                presenter.off('filterChange', onFilterChange);
                presenter.pause();
                masterPaneView.pause();
            };
            
            this.resume = function () {
                document.title = 'Activity';
                presenter.on('indexResultsChange', onIndexResultsChange);
                presenter.on('selectionChange', onSelectionChange);
                presenter.on('filterChange', onFilterChange);
                presenter.resume(true);
                masterPaneView.resume();
            };
            
            this.init = function() {
                
                initFilters();
                initActions();
                initTable();
                
                $('#tour-activity-clear').click(function () {
                    presenter.clearSelectedItems();
                });
                $('#tour-activity-delete').click(function () {
                    presenter.deleteSelectedItems();
                });

                presenter.init();
                
                this.resume();
            };
        }

        return new ActivityView();
    }());
    
    return ActivityView;
});
