// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
/**
 * @type (BaselineAddView)
 * This is a view class for Baseline Add menu option.
 */
define(['hpsum/presenter/baseline/BaselinePresenter',
    'hp/core/Notifications',
    'hp/view/DialogView',
    'hp/model/Session',
    'hp/core/Localizer',
    'hp/core/Router',
    'text!hpPages/core/header_help.html',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'lib/jquery.selectBox',
    'lib/jquery.dataTables',
    'lib/jquery-ui-timepicker-addon',
    'lib/jquery.dateFormat',
    'hp/lib/jquery.hpCollapsible',
    'hp/lib/jquery.hpToggle',
    'lib/jquery.cookie',
    'lib/jquery.jstree'],
function(presenter, notifications, DialogView, session, localizer, router, headerHelpHtml) { "use strict";

    var BaselineAddView = (function() {
      
        var ADD = '#hpsum-baselines-add',
            CANCEL = '#hpsum-baselines-add-close',
            RESET = "#hpsum-baselines-reset",
            NAME = '#hpsum-baselines-name',
	    PATH_DETAILS = '#hpsum-path-details',
            PATH = '#hpsum-location-path',
            LOCATION_TYPE = '#hpsum-baseline-location-type',
            URI_PATH = '#hpsum-baseline-uri-path',
            USER_NAME = '#hpsum-baseline-add-username',
            PASSWORD = '#hpsum-baseline-add-password',
	    BROWSE_LOCATION_ERROR = '#hpsum-invalid-location-error',
            BROWSE_BUTTON = '#hpsum-browse-location',
            WEB_BUNDLES_LIST = '#hpsum-pfw-bundles',
            WEB_BUNDLES_PANEL ='#hpsum-baseline-bundles-list',
            RETRIEVELIST_BUTTON = '#hpsum-baselines-getList',
            BROWSE_TREE = '#browse',
            BROWSE_DIALOG = '#hpsum-browse-dialog',
            INFO_DIALOG = '#hpsum-info-dialog',
            ROUTE_PREFIX = '/baseline/add',
            PANEL_SELECTOR = "#hpsum-baseline-add-panel-selector",
            PANELS = '#hpsum-baseline-add-panels',
            URI_DETAILS = '#hpsum-uri-details',
            BASELINE_LABEL = '#hpsum-baseline-location-lable-path',
            PROXY_SETTINGS = '#hpsum-baseline-proxy-settings',
	    SCHEDULE_DETAILS = '#hpsum-baseline-schedule-information',
	    FORM = '#hpsum-baselines-add-form',
	    BROWSE_OK='#hp-baseline-add-ok',
            PROXY_USE_HP = '#hpsum-baseline-proxy-hp',
            SPLASH_DIALOG = '#hpsum-add-wait-dialog',
			SPLASH_SPINNER = '#hpsum-add-spinner';
            
        /**
         * Constructor
         */
        function BaselineAddView() {
          
            var addInProgress = false;
            var browseDialogContents;
            var infoDialog;
            var proxyOptionValue;
            var locationType = 'local';
            var whichProxySettings,
                addWaitDialog,
                timer;
          
           	function onPathEdit() {
				$(BROWSE_LOCATION_ERROR).hide();
				$(PATH).removeClass("hp-error");
				$(PATH).unbind('keyup', onPathEdit);
			}

			function handleInvalidPath(hapi) {
				if (hapi.hcode == 5) {
					$(BROWSE_LOCATION_ERROR).text(localizer.getString('hpsum.baseline.add.inValidLocation'));
					$(PATH).addClass("hp-error");
					$(BROWSE_LOCATION_ERROR).show();
					$(PATH).keyup(onPathEdit);
					$('#browse-dialog-cancel').trigger('click');
				    	$(ADD).attr("disabled", true);
				} else {
				    $(BROWSE_LOCATION_ERROR).hide();
				    $(PATH).removeClass("hp-error");
				    $(PATH).unbind('keyup', onPathEdit);
				}
			}

            function reset() {
                $(NAME).val("");
                $(LOCATION_TYPE).selectBox('value','local');
                $(NAME).focus();
                $(PATH).val("");
                var firstOption = $('#hpsum-baseline-location-type option:first');
				firstOption.attr('selected', true);
				$(PATH_DETAILS).show();
                $(URI_DETAILS).hide();
                $(PROXY_SETTINGS).hide();
                $(RETRIEVELIST_BUTTON).css( "display", "none" );
                addInProgress = false;
                $(ADD).attr("disabled", true);
                $('#hpsum-baseline-proxy-hp').val("");
                $('#hpsum-baseline-proxy-url').val("");
                $('#hpsum-baseline-proxy-port').val("");
                $('#hpsum-baseline-proxy-username').val("");
                $('#hpsum-baseline-proxy-password').val("");
                $('#hpsum-baseline-proxy-username').val("");
                $('#hpsum-baseline-proxy-password').val("");
		onProxyOptionsChange("No");
		$('#hpsum-proxy-options').selectBox('value', 'No');
                 $(WEB_BUNDLES_PANEL).hide();
                 $(".hpsum-proxy").attr("disabled", false);
		 $('#hpsum-proxy-options').selectBox('enable');
                 $(BROWSE_BUTTON).attr("disabled", false);
            	$(PATH).attr("disabled", false);
            	$('#hpsum-baseline-bundles-list-error').hide();
            }
            
            function resetCancel() {
                reset();
            }
            
         
			function onItemAddSuccess(item) {
					resetCancel();
					addInProgress = false;
					closeAddWait();
					$(CANCEL).trigger('click');					
			}

            /**
             * @private
             */
            function onItemAddError(errorMessage) {
                if(errorMessage.indexOf("#") != -1) {
                    var error = errorMessage.split("#");
                    var notif = {
                        summary:error[0],
                        sourceName: error[1],
                        status: 'error'
                        };
                    notifications.add(notif, true);
                } else
                    notifications.show(errorMessage, 'error');
                addInProgress = false;
                resetCancel();
                closeAddWait();
                $(CANCEL).trigger('click');
            }


				function showAddWait(msg) {
					
					
					if (!addWaitDialog) {
						addWaitDialog = $(SPLASH_DIALOG);
						addWaitDialog.dialog({
							modal : true,
							dialogClass : 'hp-simple-dialog',
							position : "center",
							draggable : false,
							resizable : false,
							width : 260,
							height : 180
						});
					}
					if(msg == undefined)
						msg = localizer.getString('hpsum.baseline.add.addInProgress');
					$('#hpsum-bs-wait-message', addWaitDialog).html(msg);
					$(SPLASH_SPINNER).show();
					msg='';
					addWaitDialog.dialog('open');
				}

				function closeAddWait() {
					$(SPLASH_SPINNER).hide();
					if (addWaitDialog) {
						addWaitDialog.dialog('close');
					}
				}
			

				
            /**
             * @private
             * Call presenter's addItem() to add a new baseline item into Indexservice
             */
            function onAddItem() {
            	
            	showAddWait();
            	var uriPath;
            	
                if(! addInProgress) {
                    addInProgress = true;
                    if($(LOCATION_TYPE).val() == 'FTP'){
                       var selectedRow = $('#hpsum-pfw-bundles-table tbody tr.hp-selected');
            			var data = $('#hpsum-pfw-bundles-table').dataTable().fnGetData(selectedRow[0]._DT_RowIndex);
						var index = data.url.search(/ftp:\/\//i);
						var length = data.url.length;
						if(index != -1)
							uriPath = data.url.substr(index+6, length );
						else
							uriPath = data.url;
            			}
            		else{
            			uriPath = $(URI_PATH).val();
            		}                 
                    presenter.addItem({
                    	category: 'baseline',
                    	name: 'Service Pack for Proliant ' + (new Date()).getTime(), //adds a dummy baseline name for now
                        locationType: $(LOCATION_TYPE).val(),
						location: $(PATH).val(),
                        uripath: uriPath,
                        username : $(USER_NAME).val(),
                        password : $(PASSWORD).val(),
                        proxy_settings: getProxyJsonObject(),
                        uri: '/baseline/item-' + (new Date()).getTime(), 
                        status: 'ok',
                        attributes: {version:'2012.10.31', size:'1.5 GB'}}, {
                        success : onItemAddSuccess,
                        error : onItemAddError
                    });
                    
                    //$(CANCEL).trigger('click');
                }

                //return false;
            }
            
            /**
             * * Show information dialog to user such as selecting a valid baseline before proceed.
             */
            function showInfoDialog()
            {
            	if (!infoDialog) {
                    infoDialog =  $(INFO_DIALOG);
                    infoDialog.dialog({
                        modal : true,
                        dialogClass: 'hp-simple-dialog',
                        position : "center",
                        draggable : false,
                        resizable : false
                    });
                    $('button', infoDialog).on('click', function () {
                        infoDialog.dialog('close');
                    });
                }
                infoDialog.dialog('open');
            }
            
            /**
             * * Initialize and display browse dialog.
             * * User can navigate to any folder and choose a valid baseline location 
             */
            function initBrowseDialog(){
            	new DialogView({contents: browseDialogContents,
                	position : "center",
                    ok: function (elem) {
                    	
                    	var node = $(BROWSE_TREE).jstree('get_selected');
                    	if(node[0] == null || (node[0] && node[0].attributes["rel"].value != "package"))
                    	{
                    		var loc_type = $(LOCATION_TYPE).val();
                    		if(loc_type == 'local')
                    		{
                    		//alert("Please select a valid folder!");
	                    		showInfoDialog();
	                    		return false;
                    		}
                    	}
                    	$(PATH).val(node[0].id);
                    	var path = $(PATH).val();
                    	path = path.replace("_C_", ":");
                    	$(PATH).val(path);
                    	$(PATH).trigger('change');
                    	if($(LOCATION_TYPE).val() == 'local')
                    		$(ADD).attr("disabled", false);
                    },
                    cancel: function () {
                    	$(PATH).val('');
                    	$(PATH).trigger('change');
                    }
                });
            }
            
            /**
             * * Create a JsTree inside the browse dialog.
             * * This includes operations such as JSON data load through AJAX call, configuration of tree etc.
             */
            function createTree(){
            	
            	var uri = "Session/" + session.getToken()  + "/Baseline/browse";
				var initial_folder = $(PATH).val();
				
				$(BROWSE_TREE).empty();
                $(BROWSE_TREE).jstree({
                        "json_data" : {
                        		   "ajax" : {
						           		"url" : function (node) {
	                                        var url;
	                                        if (node == -1) {
	                                            url = "Session/" + session.getToken()  + "/Baseline/browse";
	                                        } else {
	                                            url = null;
	                                        }
	                                        return url;
	                                    },
										"type" : "POST",
					                    "dataType" : "json",
					                    "data" : function (n) {
					                    	var uri = $(PATH).val().length > 0 ? $(PATH).val() : "..";
					                    	uri = uri.replace("_C_", ":"); 
												var object = {
														"hapi": {
    														"uri": uri
														}
													}; 
												
												return JSON.stringify(object); 
										},
										"success" : function (output) {
											
											var data = [], children = [], index, node, bAddParent = false;
											
											//This will handle if user has given an invalid location to browse.
											handleInvalidPath(output.hapi);
											
											//hcode has string value in the response payload. This need to be changed later when it is 
											//changed to integer value
											if(output.hapi.hcode != "0")
											{
												//add a node to navigate to parent directory 
												node = {
											        		"data" : "..",
											        		"attr" : { "id" : "..", "rel" : "parent"},
											                "state" : "open",
											               }
											               
											    data.push( node );
												return data;
											}
											
											//iterate through folders and create child nodes
											for(var i=0; i < output.hapi.folders.folder.length; i++ ){
												var folder = output.hapi.folders.folder[i];
												var child, rel;
												
												if(i === 0) 
												{
													var str = $(PATH).val();
													if(str === '/')
													{
														bAddParent = false;
													}
													else if(i == 0) // && (str.length > 0 && str.indexOf('/') === -1)) 
													{
														bAddParent = true;
														continue;
													}
												}	
												
												//if it is root folder and drive, add the first item as a sibling node instead of parent node
												//change icon if folder is a valid package
												if(folder.possible_package)
													rel = "package";
												else
													rel = "folder";
												
												//take only last folder name from complete path
												//var str = folder.folder_name.substring(folder.folder_name.lastIndexOf('/')+1);
												var strfolder, idfolder;
												if(str === '/' && folder.folder_name.indexOf('/') != 0) {
													strfolder = folder.folder_name.substring(0, folder.folder_name.indexOf('/')-1);
													idfolder = folder.folder_name.substring(0, folder.folder_name.indexOf('/'));
												}
												else {
												strfolder = folder.folder_name.substring(folder.folder_name.lastIndexOf('/')+1);
												idfolder = folder.folder_name;
												}
												idfolder = idfolder.replace(":", "_C_");
												//create children nodes
												if(strfolder.length > 0 && idfolder.length > 0) {
    									        	child = {
    									        		"data" : strfolder,
    									        		 "attr" : {"id" : idfolder, "rel" : rel}
    									        		}
    										        children.push( child );
    										    }
										    }
											
											//add a node to navigate to parent directory 
											node = {
										        		"data" : "..",
										        		"attr" : { "id" : "..", "rel" : "parent"},
										                "state" : "open",
										               }
										               
										    data.push( node );
										    
										    if(bAddParent) {
										    	var rel, val;
										    	if(output.hapi.folders.folder[0].possible_package)
													rel = "package";
												else
													rel = "folder";
													
												if($(PATH).val() === '')
													val = output.hapi.folders.folder[0].folder_name
												else
													val = $(PATH).val();
												
												var valId = val; 
												valId = valId.replace(":", "_C_");
												val = val.replace("_C_", ":");
												
											    //add parent folder to folder list
												node = {
											        		"data" : val,//output.hapi.folders.folder[0].folder_name,
											        		"attr" : { "id" : valId, "rel" : rel}, //{ "id" : output.hapi.folders.folder[0].folder_name, "rel" : rel},
											                "metadata" :  output.hapi.folders.folder[0],
											                "state" : "open",
											                "children" : children
											               }
											               
											    data.push( node );
											}
											else
											{
												data.push(children);
											}
											
										                
											return data;
										}
						           }
						},
                        "themes" : {
                                "theme" : "default",
                                "url" : "/css/style.css",
                                "dots" : true,
                                "icons" : true
                        },
                        "plugins" : [ "themes", "json_data", "ui" , "crrm", "types" ],
                        "types" : {
                                "max_depth" : -2,
                                "max_children" : -2,
                                "valid_children" : [ "drive" ],
                                "types" : {
                                        "default" : {
                                                "valid_children" : "none",
                                                "icon" : {
                                                        "image" : "/img/hp-piano/collapse-closed.png"
                                                }
                                        },
                                        "folder" : {
                                                "valid_children" : [ "default", "folder", "package" ],
                                                "icon" : {
                                                        "image" : "/img/hp-piano/collapse-closed.png"
                                                }
                                        },
                                        "package" : {
                                                "valid_children" : [ "default", "folder" ],
                                                "icon" : {
                                                        "image" : "/img/hp-piano/status-ok.png"
                                                }
                                        },
                                        "drive" : {
                                                "valid_children" : [ "default", "folder" ],
                                                "icon" : {
                                                        "image" : "/img/hp-piano/down-arrow.png"
                                                },
                                                "start_drag" : false,
                                                "move_node" : false,
                                                "delete_node" : false,
                                                "remove" : false
                                        },
                                        "parent" : {
                                                "valid_children" : [ "default", "folder", "drive", "package" ],
                                                "icon" : {
                                                        "image" : "/img/hp-piano/grid-collapse.png"
                                                },
                                                "start_drag" : false,
                                                "move_node" : false,
                                                "delete_node" : false,
                                                "remove" : false
                                        }
                                        
                                }
                        }
                })
                .bind("dblclick.jstree", function (event, data) {
                		var node = $(BROWSE_TREE).jstree('get_selected');
                		if(node[0].id === "..")
                		{
                			if(node[0].nextSibling)
                			{
                				var str = $(PATH).val(); 
                				if(str === '')
                				{
                					$(PATH).val(node[0].nextSibling.id.substring(0, node[0].nextSibling.id.lastIndexOf("/")));
                					$(PATH).trigger('change');
                				}
                				else if(str === '/')
                				{
                					
                				}
                				else
                				{
	                				if(str.indexOf('/') != -1){
	                					$(PATH).val(node[0].nextSibling.id.substring(0, node[0].nextSibling.id.lastIndexOf("/")));
	                					$(PATH).trigger('change');
	                				}
	                				else{
	                					$(PATH).val("/");
	                					$(PATH).trigger('change');
	                				}
	                			}
                			}
                			else
                			{
                				$(PATH).val("/");
                				$(PATH).trigger('change');
                			}
                		}
                		else 
                		{	
                    		$(PATH).val(node[0].id);
                    		$(PATH).trigger('change');
                    	}
                		
                		$(BROWSE_TREE).jstree("refresh");
                })
                .bind("select_node.jstree", function (event, data) { 
                    var node = $(BROWSE_TREE).jstree('get_selected');
                    var loc_type = $(LOCATION_TYPE).val();
                    if (loc_type != 'FTP'){
                        if(node[0] && node[0].attributes["rel"].value != "package")
                            $(BROWSE_OK).attr("disabled","disabled");
                        else
                            $(BROWSE_OK).removeAttr("disabled");
                        }
                    else
                        $(BROWSE_OK).removeAttr("disabled");
                        });
                }
            
       
            function onProxyOptionsChange(msg) 
            {
            	 var value = $('#hpsum-proxy-options').val();
		 $(WEB_BUNDLES_LIST).html('');
		 $(WEB_BUNDLES_PANEL).hide();
		 $('#hpsum-baseline-bundles-list-error').hide();
            	 if(value == "No" || msg == "No"){
            	 	 $('#hpsum-proxy-usehp-item').hide();
               		 $('#hpsum-proxy-usescript-item').hide();
               		 proxyOptionValue = "No";
            	 }
            	 else if(value == "Server"){
            	 	 $('#hpsum-proxy-usehp-item').show();
                	 $('#hpsum-proxy-usescript-item').hide();
                	 proxyOptionValue = "Server";
            	 }
            	 else if (value == "Script"){
            	 	$('#hpsum-proxy-usehp-item').hide();
                	$('#hpsum-proxy-usescript-item').show();
                	proxyOptionValue = "Script";
            	 }
            }
            
            function changeLocation(location) {
                	
              if (location.length > ROUTE_PREFIX.length) {
                   $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
               	} else {
                   $(PANELS).hpStackedPanels('setFirstPanel');
                }
            }
            
           	function initBundlesTable(tableid){
				return $(tableid).dataTable({
				  		oLanguage: {
				  		    sEmptyTable: localizer.getString('hpsum.node.noItemsFound'),
				  		    sSearch: localizer.getString('hpsum.common.search')
							   },
				    bPaginate : false,
				    bProcessing : true,
				    bFilter : false,
				    bSort : true,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : false,
				    bDestroy : true,
				    	aoColumns : [
				        	{mDataProp: 'name'},
				        	{mDataProp: 'version'},
				        	{mDataProp : 'url',
							"bVisible" : false
							}
				        ],
				    aaSorting: [[ 0, "asc" ]],
				    });
			}
			
            
            function showBundlesTable(data){
            	closeAddWait();
            	$(WEB_BUNDLES_LIST).empty();
            	$('#hpsum-baseline-bundles-list-error').hide();
            	if(typeof data === 'string')
            	{
            		$(WEB_BUNDLES_PANEL).hide();
            		$('#hpsum-baseline-bundles-list-error').show();
            		$('#hpsum-bundle-list-err-msg').text(': ' + data);
            		$(ADD).attr("disabled", true);
 
            		return;
            		
            	}
            	if(data.length < 1){
            		$(WEB_BUNDLES_LIST).append('No bundles available');
            		$(ADD).attr("disabled", true);
            		return;
            	}
            		
            	$(WEB_BUNDLES_LIST).append('<table class="hp-selectable" id="hpsum-pfw-bundles-table"><thead><tr><td><b>' + 
								localizer.getString("hpsum.common.name") + '</b></td><td><b>' + 
								localizer.getString("hpsum.common.version") + '</b></td><td></td></tr></thead></table>');
				
							
				var bundleTable = initBundlesTable('#hpsum-pfw-bundles-table');
				for( var i=0; i<data.length; i++){
					var compItem = [{
								'name' : data[i].name.name_en,
								'version' : data[i].version,
								'url':  data[i].url.url__value
							}];
					bundleTable.fnAddData(compItem);
				}
				$("#hpsum-pfw-bundles-table tbody tr").click(function(e) {
						var srcElem;
									//Check if firefox or (chrome and IE)
						if (e.srcElement) {
										srcElem = e.srcElement;
											//Chrome and IE
									} else {
										srcElem = e.target;
										//Firefox
									
									}
						$(".hp-selected").each(function(){
						$(this).removeClass("hp-selected");});
						$(this).addClass("hp-selected");
						
				});
            	$('#hpsum-pfw-bundles-table tbody tr').first().addClass('hp-selected');	
            	$(ADD).attr("disabled", false);
            	$(RETRIEVELIST_BUTTON).attr("disabled", true);
            	$(RETRIEVELIST_BUTTON).off('click',retrieveListofBundles);
            }
            

            function getProxyJsonObject(){
            	var proxy_settings;
            	if((proxyOptionValue == "No") || (proxyOptionValue == undefined))
            		proxy_settings ='';
            	else if(proxyOptionValue == "Server"){
            		proxy_settings = {
            			proxy_username: $('#hpsum-baseline-proxy-username').val(),
            			proxy_password: $('#hpsum-baseline-proxy-password').val(),
            			proxy_ftp_port: $('#hpsum-baseline-proxy-port').val(),
            			proxy_url: $('#hpsum-baseline-proxy-url').val(),
            			use_proxy_script:false
            		};
            	}
            	else if(proxyOptionValue == "Script"){
            		proxy_settings = {
            			proxy_username: $('#hpsum-baseline-proxyscript-username').val(),
            			proxy_password: $('#hpsum-baseline-proxyscript-password').val(),
            			use_proxy_script: true,
            			proxy_script: $('#hpsum-baseline-proxy-script').val()
            		};
            	}
            	return proxy_settings;
            }
                      
            function retrieveListofBundles() {
            	
				
            	var input = {
            		hapi: {
            			working_location :$(PATH).val(),
            			proxy_settings: getProxyJsonObject()
            		}
            		
            	};
            	
            	presenter.getListofPFWBundles(input, {success:function(data){
            		$(WEB_BUNDLES_PANEL).show();
            		showBundlesTable(data);
            		$(BROWSE_BUTTON).attr("disabled", true);
            		$(PATH).attr("disabled", true);
            		$(".hpsum-proxy").attr("disabled", true);
			$('#hpsum-proxy-options').selectBox('disable');
            	},error:function(message) {
            		closeAddWait();
            		$(WEB_BUNDLES_PANEL).show();
            		showBundlesTable(message);
            	}});
            	showAddWait(localizer.getString('hpsum.baseline.add.retrieveInProgress'));
            	
            }
            function setRetrieveButtonState(){
            	if($(LOCATION_TYPE).val() == 'FTP'){
                       if($(PATH).val()== '')
                     	   			$(RETRIEVELIST_BUTTON).attr("disabled", true);
                      		 	else
                       				$(RETRIEVELIST_BUTTON).attr("disabled", false);
                      }
            	
            }
            function setLocationType(){
            	 $('#hpsum-baseline-bundles-list-error').hide();
            	 $('#hpsum-baseline-add-browse-text').text(localizer.getString('hpsum.baseline.add.browseText'));
            	 locationType = $(LOCATION_TYPE).val();
                    if (locationType == 'local') {
                        $(BASELINE_LABEL).html('<b>' + localizer.getString('hpsum.baseline.add.enterDirectory') + '</b>');
                        $(PATH_DETAILS).show();
                        $(URI_DETAILS).hide();
                        $(RETRIEVELIST_BUTTON).css( "display", "none" );
                        $(RETRIEVELIST_BUTTON).off('click',retrieveListofBundles);
                        $(WEB_BUNDLES_PANEL).hide();
                        $(RETRIEVELIST_BUTTON).hide();
                        $(BROWSE_BUTTON).attr("disabled", false);
                        $(PATH).val('');
            			$(PATH).attr("disabled", false);
                        $(PROXY_SETTINGS).hide();
                        $(ADD).attr("disabled", true);

                    } else if (locationType == 'UNC') {
                        $(PATH_DETAILS).hide();
                        $(URI_DETAILS).show();
                        $(PROXY_SETTINGS).hide();
                        $(WEB_BUNDLES_PANEL).hide();
                        $(RETRIEVELIST_BUTTON).css( "display", "none" );
                        $(RETRIEVELIST_BUTTON).off('click',retrieveListofBundles);
                        $(ADD).attr("disabled", false);
                    } else {
                    	$('#hpsum-baseline-add-browse-text').text(localizer.getString('hpsum.baseline.add.browsePFWText'));
                        $(BASELINE_LABEL).html('<b>' + localizer.getString('hpsum.baseline.add.enterWorkingDirectory') + '</b>');
                        $(PATH_DETAILS).show();
                        $(URI_DETAILS).hide();
                        $(PROXY_SETTINGS).show();
                        $(RETRIEVELIST_BUTTON).show();
                        $(".hpsum-proxy").attr("disabled", false);
			$('#hpsum-proxy-options').selectBox('enable');
                        $(RETRIEVELIST_BUTTON).on('click',retrieveListofBundles);
						if($(PATH).val()== '')
                     	   			$(RETRIEVELIST_BUTTON).attr("disabled", true);
						$(PATH).on('change',setRetrieveButtonState);
                    	$(PATH).on('input',setRetrieveButtonState);
                    	
                        $(ADD).attr("disabled", true);
                        $(WEB_BUNDLES_LIST).html('');
                       
		       $('#hpsum-proxy-options').selectBox({autoWidth: false});
		       $('#hpsum-proxy-options').change(onProxyOptionsChange);
			$(".hpsum-proxy").on('input', function() {
				$(WEB_BUNDLES_LIST).html('');
				$(WEB_BUNDLES_PANEL).hide();
			});
						
                    }
                }

            
            /**
	         * @public
	         */
            this.resume = function () {
            	router.watch('baseline add section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});
                $(WEB_BUNDLES_PANEL).hide();
                $(LOCATION_TYPE).selectBox('value','local');
                $(RETRIEVELIST_BUTTON).attr("disabled", false);
                $(RETRIEVELIST_BUTTON).css( "display", "none" );
				$(PATH).attr("disabled", false);
            	reset();
            };
            
            this.pause = function () {
            };
            
            /**
             * @public
             * Initialization funtion for the object
             * All the controls actions are initialized in this function.
             */
            this.init = function() {

                reset();
				
		$(CANCEL).live('click', function() {											
			router.go('/baseline/show/');						
		});

                $(PANELS).hpStackedPanels({
                    panelSelector : PANEL_SELECTOR
                });
                
                $(LOCATION_TYPE).selectBox({autoWidth: false});
                $(RETRIEVELIST_BUTTON).css( "display", "none" );

                var listItem = $('.hp-details-header-controls', $(FORM).parent());

                // put help in header
                if ($('.hp-details-header-controls', $(FORM).parent()).length === 0) {
                    var headerHelp = $(headerHelpHtml);
                    localizer.localizeDom(headerHelp);
                    $('.hp-details-header', $(FORM).parent()).append(headerHelp);
                }
				$(ADD).live('click', function(ev) {
                   	onAddItem.call(this);
                   	ev.preventDefault();
               	});

                $(RESET).live('click', function() {
                    reset.call();
                });

                browseDialogContents = $(BROWSE_DIALOG).detach().show();

                $(BROWSE_BUTTON).on('click', function() {

                initBrowseDialog();

                $(BROWSE_OK).attr("disabled", "disabled");
                    createTree();
                });

                $(LOCATION_TYPE).change(setLocationType);

                $('#hpsum-proxy-usehp-item').hide();
                $('#hpsum-proxy-usescript-item').hide();
                //$('input:radio[name=hpsum-baseline-proxy-opt]').click(onProxyOptionChange);

                this.resume();
            };
        }

        return BaselineAddView;
    }());
    
    return new BaselineAddView();
});
