// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
/**
 * @type (GroupDeployView)
 * This is a view class for Group Deploy View.
 */
define(['hpsum/presenter/group/GroupPresenter',
    'hpsum/presenter/node/NodePresenter',
	'hp/core/Router',
    'hp/core/Notifications',
	'hp/core/HelpMenu',
	'hp/view/DialogView',
	'hp/core/Localizer',
    'jquery',
    'hpsum/view/node/jquery.hpsumInstallables',	
    'hp/lib/jquery.hpStackedPanels',
    'lib/jquery.selectBox',
    'lib/jquery.dataTables',
    'lib/jquery.dataTables.rowReordering',
    'hp/lib/jquery.hpCollapsible',
    'hp/lib/jquery.hpToggle',	
	'hp/lib/jquery.hpSearchCombo'
	],

function(presenter, nodePresenter, router, notifications, helpMenu, DialogView, localizer) {"use strict";

	var GroupDeployView = ( function() {

			//Consts can go here
			var DEPLOY = '#hpsum-group-deploy-ok',
			    ANALYSIS = '#hpsum-group-analysis',
			    RESET = '#hpsum-group-reset',
			    CANCEL = '#hpsum-group-deploy-close',
			    DEPLOY_CONTENTS = '#hpsum-group-deploy',
			    GROUP_NODE_DEPLOY_CONTENT = '#hpsum-group-node-deploy-data',
			    PANEL_SELECTOR = '#hpsum-deploy-panel-selector',
			    FIRST_ANCHOR = PANEL_SELECTOR + ' a[href]:first',
			    PANELS = '#hpsum-group-deploy-panels',
			    NAME = '#hpsum-group-deploy-name',
			    REBOOTOPTION = '#hpsum-deploy-reboot-option',
			    DELAYSEC = '#hpsum-group-deploy-delay-seconds',
			    MESSAGE = '#hpsum-group-deploy-reboot-message',
			    ROUTE_PREFIX = '/group/deploy',
			    NONECHECKBOX = '.nonecheckbox',
			    USESNMPCHECKBOX = '.useSNMPcheckbox',
			    USEAGENTLESSCHECKBOX = '.useAgentlesscheckbox',
			    USEWEBEMCHECKBOX = '.useWEBEMcheckbox',
			    DOWNGRADECHKBOXCOMP = '.downgradechkbox',
			    REWRITECHKBOXCOMP = '.rewritechkbox',
			    FIRMWARECHKBOXCOMP = '.firmwarechkbox',
			    SOFTWARECHKBOXCOMP = '.softwarechkbox',
			    SPLASH_DIALOG = '#hpsum-group-analysis-dialog',
			    SPLASH_SPINNER = '#hpsum-group-analysis-spinner',
			    THROBBER = '#hpsum-group-deploy-throbber';

			/**
			 * Constructor
			 */
			function GroupDeployView() {

				var groupItem = null,
				setAttributesOnGroup = false,
				analysisWaitDialog = null, 
				defaultOptiondetails = {
					hapi : {
						os_management_options : {
							none : false,
							usesnmp : false,
							useagentless : false,
							usewebem : false
						},

						installation_option : {
							downgrade : false,
							rewrite : false,
							force : false
						},

						reboot_options : {
							action : 'No',
							delay : '3600',
							message : 'Reboot at user request after deploy'
						}
					}
				},
				optiondetails = defaultOptiondetails,
				nodeChanges = [],
				nodeTPMMap = [],
				analysisNeededNodes = 0;

				function onItemChange(item) {
					groupItem = item.hapi;

					if (groupItem) {
						$(NAME).text(groupItem.group_name);
						$(ANALYSIS).attr("disabled", true);
						$(DEPLOY).attr("disabled", false);
						populateDeployData();
					} else {
						$(CANCEL).trigger('click');
					}
				}

				function setoptiondetails() {
					var optionSelected = false,
					    atleastOneOptionSelected = false;
					
					optionSelected = $(NONECHECKBOX).is(':checked');
					optiondetails.hapi.os_management_options.none = optionSelected;
					if (!atleastOneOptionSelected) {
						atleastOneOptionSelected = optionSelected;
					}
					optionSelected = $(USESNMPCHECKBOX).is(':checked');
					optiondetails.hapi.os_management_options.usesnmp = optionSelected;
					if (!atleastOneOptionSelected) {
						atleastOneOptionSelected = optionSelected;
					}
					optionSelected = $(USEAGENTLESSCHECKBOX).is(':checked');
					optiondetails.hapi.os_management_options.useagentless = optionSelected;
					if (!atleastOneOptionSelected) {
						atleastOneOptionSelected = optionSelected;
					}
					optionSelected = $(USEWEBEMCHECKBOX).is(':checked');
					optiondetails.hapi.os_management_options.usewebem = optionSelected;
					if (!atleastOneOptionSelected) {
						atleastOneOptionSelected = optionSelected;
					}

					if (!atleastOneOptionSelected) {
						optiondetails.hapi.os_management_options = {};
					}else {
						setAttributesOnGroup = true;
					}
					atleastOneOptionSelected = false;

					optionSelected = $(DOWNGRADECHKBOXCOMP).is(':checked');
					optiondetails.hapi.installation_option.downgrade = optionSelected;
					if (!atleastOneOptionSelected) {
						atleastOneOptionSelected = optionSelected;
					}
					optionSelected = $(REWRITECHKBOXCOMP).is(':checked');
					optiondetails.hapi.installation_option.rewrite = optionSelected;
					if (!atleastOneOptionSelected) {
						atleastOneOptionSelected = optionSelected;
					}
					if (!atleastOneOptionSelected) {
						optiondetails.hapi.installation_option = {force : false};
					}
					
					if ($(SOFTWARECHKBOXCOMP).is(':checked') || $(FIRMWARECHKBOXCOMP).is(':checked')) {
						optiondetails.hapi.installation_option.force = true;
						if (!atleastOneOptionSelected) {
							atleastOneOptionSelected = true;
						}
					}
					
					if (!atleastOneOptionSelected) {
						optiondetails.hapi.installation_option = {};
					} else {
						setAttributesOnGroup = true;
					} 
					atleastOneOptionSelected = false;

					if (($(REBOOTOPTION).val() == "If needed") || ($(REBOOTOPTION).val() == "Always")) {
						atleastOneOptionSelected = true;
					}
					optiondetails.hapi.reboot_options.action = $(REBOOTOPTION).val();
					
					if ($(DELAYSEC).val() != '') {
						optiondetails.hapi.reboot_options.delay = $(DELAYSEC).val();
					}
					
					if ($(MESSAGE).val() != '') {
						optiondetails.hapi.reboot_options.message = $(MESSAGE).val();
					}
					
					if (!atleastOneOptionSelected) {
						optiondetails.hapi.reboot_options = {};
					} else {
						setAttributesOnGroup = true;
					}
					atleastOneOptionSelected = false;
				}

				function onSetattributeSuccess(item) {

				}

				function onSetattributeError(errorMessage) {
					notifications.show(errorMessage, 'error');
					$(DEPLOY).attr("disabled", true);
					$(CANCEL).trigger('click');
				}

				function onDeploy() {				
					$(DEPLOY).attr('disabled', true);
					$(THROBBER).show();
					for (var idx = 0; idx < nodeChanges.length; idx++) {
						if (nodeTPMMap[nodeChanges[idx].node_id] == true) {
							nodePresenter.setattribute({
								node_id: nodeChanges[idx].node_id
							},{
								hapi : {
									tpm_bypass : 'true',
									node_id : nodeChanges[idx].node_id
								}
							}, {
								success : function(data) {
									if (data.hapi.hcode == 0) {
										
									} else {
										notifications.show(data.hapi.hmessage);
										$(CANCEL).trigger('click');
									}
								},
								error : function(data) {
								}
							});
						}
					}
										
					presenter.deploy(groupItem, {
						success : onDeploySuccess,
						error : onDeployError
					});
				}


				function onDeploySuccess(item) {
					$(THROBBER).hide();
					notifications.show(groupItem.group_name + ' Group ' + localizer.getString("hpsum.group.deployStarted"), 'ok');
					$(CANCEL).trigger('click');
				}

				function onDeployError(errorMessage) {
					$(THROBBER).hide();
					notifications.show(errorMessage, 'error');
					$(CANCEL).trigger('click');
				}

				function changeLocation(location) {
					if (location.length > ROUTE_PREFIX.length) {
						$(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
					} else {
						$(PANELS).hpStackedPanels('setFirstPanel');
					}
				}

				function populateOptions() {
					optiondetails = defaultOptiondetails;
					$(NONECHECKBOX).attr('checked', false);
					$(USESNMPCHECKBOX).attr('checked', false);
					$(USEAGENTLESSCHECKBOX).attr('checked', false);
					$(USEWEBEMCHECKBOX).attr('checked', false);

					$(DOWNGRADECHKBOXCOMP).attr('checked', false);
					$(REWRITECHKBOXCOMP).attr('checked', false);

					$(FIRMWARECHKBOXCOMP).attr('checked', false);
					$(SOFTWARECHKBOXCOMP).attr('checked', false);

					$(REBOOTOPTION).selectBox('value', 'No');
					$(DELAYSEC).val('3600');
					$('textarea' + MESSAGE).attr('value', 'Reboot at user request after deploy');
				}

				function populateDeployData() {
					var groupNodes = [],
					    groupNodeData,
					    id,
					    contentid,
					    name,
					    htmlContents = '';
					
					groupNodes = groupItem.group_nodes.group_node;
					
					for (var idx = 0; idx < groupNodes.length; idx++) {
						id = 'hpsum-group-node-collapse-' + groupNodes[idx];
						contentid = 'hpsum-group-node-ccontent-' + groupNodes[idx];
						name  = 'hpsum-group-node-cname-' + groupNodes[idx];
						htmlContents += '<div class ="my-collapsible" id ="' + id +
						'" data="' + groupNodes[idx] + '"><label id ="'+ name +'" style="clear: both">' + groupNodes[idx] + '</label>' +
						'<div class="hp-notify hp-notify-warning hp-hide" style="" id="hpsum-group-tpm-warning-' + groupNodes[idx] + '">"' +
						localizer.getString("hpsum.oneTouchUpdate.tpmWarning") + '</div>' +
						'<div id ="' + contentid + '"><label>Collapse Content</label></div></div>';
						
						nodePresenter.getNodeData({node_id: groupNodes[idx]}, {
							success: function(data) {
								$('#hpsum-group-node-cname-' + data.hapi.node_id).html(data.hapi.name);
								nodeChanges = nodeChanges.concat({
									node_id: data.hapi.node_id,
									selectionChanged: false,
									node_name: data.hapi.name,
									component_length : 0,
									failed_dependency_cnt : 0
									});
								if (data.hapi.tpm_state == true) {
									$('#hpsum-group-tpm-warning-' + data.hapi.node_id, DEPLOY_CONTENTS).show();
								}
								nodeTPMMap[data.hapi.node_id] = data.hapi.tpm_state;
							},
							error: function() {
							}
						});
					}
					
					$(GROUP_NODE_DEPLOY_CONTENT, DEPLOY_CONTENTS).html(htmlContents);
					$('.my-collapsible', DEPLOY_CONTENTS).hpCollapsible();
					
					for (var idx = 0; idx < groupNodes.length; idx++) {
						$('#hpsum-group-node-ccontent-' + groupNodes[idx], DEPLOY_CONTENTS).hpsumInstallables({
								command: 'init',
								nodeItem: {node_id: groupNodes[idx], type: ''},
								onSelectionChanged: onSelectionChanged
							});
						$('#hpsum-group-tpm-warning-' + groupNodes[idx], DEPLOY_CONTENTS).hide();	
					}
					
				}
				
				function onSelectionChanged(id, value, componentList) {		
					if (value == true) {
						$(DEPLOY).attr("disabled", true);
						$(ANALYSIS).attr("disabled", false);
					} else {
						  if (componentList.failed_dependency > 0) {
							$(DEPLOY).attr("disabled", true);
							$(ANALYSIS).attr("disabled", true);
						}
					}
					
					var nodeName = '';
					for (var idx = 0; idx < nodeChanges.length; idx++) {
						if (nodeChanges[idx].node_id == id){
							nodeChanges[idx].selectionChanged = value;
							nodeName = nodeChanges[idx].node_name;
							nodeChanges[idx].component_length = componentList.component.length;
							nodeChanges[idx].failed_dependency_cnt = componentList.failed_dependency;
						}
					}
					
					var name  = '#hpsum-group-node-cname-' + id;
					if(componentList.failed_dependency != 0){
						$(name).html('&nbsp&nbsp<p><img src="/img/hp-piano/status-error-small-select.png">&nbsp&nbsp' + nodeName + '<br/>' +
						'&nbsp&nbsp' + localizer.getString("hpsum.node.compFailedDep", [componentList.component.length]));
					}
					else{
						if(componentList.component.length == 0){
							$(name).html('&nbsp&nbsp<p><img src="/img/hp-piano/status-warning-small-select.png">&nbsp&nbsp' + nodeName + '<br/>' +
							'&nbsp&nbsp' + localizer.getString("hpsum.node.compSelectZero", [componentList.component.length]));
						}
						else{
							$(name).html('&nbsp&nbsp<p><img src="/img/hp-piano/status-ok-small-select.png">&nbsp&nbsp' + nodeName + '<br/>' +
							'&nbsp&nbsp' + localizer.getString("hpsum.node.compSelect", [componentList.component.length]));
						}	
					}
				}
				

				function onAnalysis() {
					var analysisStartedNodes = 0,
					    cContentId,
					    instalables,
					    componentsList;
					    
					showAnalysisWaitDialog();
					
					setoptiondetails();
					if (setAttributesOnGroup) {
						presenter.setAttributes(groupItem, optiondetails, {
							success : onSetattributeSuccess,
							error : onSetattributeError
						});
						setAttributesOnGroup = false;
					}
					
					for (var idx = 0; idx < nodeChanges.length; idx++) {
						if (nodeChanges[idx].selectionChanged == true) {
							cContentId = '#hpsum-group-node-ccontent-' + nodeChanges[idx].node_id;
							instalables = $(cContentId).data('plugin_hpsumInstallables');
							componentsList = instalables.getComponents();

							nodePresenter.analysis({
								node_id : nodeChanges[idx].node_id
							}, 
							componentsList, {
								node_id : nodeChanges[idx].node_id,
								success : function(data) {
								},
								error : function(errorInfo) {
								}
							});
							analysisStartedNodes++;
						}
					}
					
					var timer = setInterval(function() {
						presenter.getGroupStatus({group_id: groupItem.group_id}, {
							success : function(data) {
								if (data.hapi.hcode == 0) {
									if (data.hapi.group_status.match(/Ready to start deploy/)) {
										clearInterval(timer);			
										var enableDeployCnt = 0;
										for (var idx = 0; idx < nodeChanges.length; idx++) {
											nodeChanges[idx].selectionChanged = false;
											if (nodeChanges[idx].failed_dependency_cnt > 0) {
												enableDeployCnt++;	
											}
											$('#hpsum-group-node-ccontent-' + nodeChanges[idx].node_id).hpsumInstallables({
												command : 'init',
												nodeItem : {
													node_id : nodeChanges[idx].node_id,
													type : ''
												},
												onSelectionChanged : onSelectionChanged
											}); 
										}
										
										if (0 == enableDeployCnt) { 
											$(DEPLOY).attr("disabled", false);
											$(ANALYSIS).attr("disabled", true);
										}
										else {
											$(DEPLOY).attr("disabled", true);
											$(ANALYSIS).attr("disabled", true);
										}
										
										closeAnalysisWaitDialog();
									}
								}
							},
							error : function(data) {
								clearInterval(timer);
								closeAnalysisWaitDialog();
							}
						});
					}, 3000); 

				}

				function showAnalysisWaitDialog() {
						analysisWaitDialog = $(SPLASH_DIALOG);
						analysisWaitDialog.dialog({
							modal : true,
							dialogClass : 'hp-simple-dialog',
							position : "center",
							draggable : false,
							resizable : false,
							width : 280,
							height : 180
						});
					$(SPLASH_SPINNER).show();
					analysisWaitDialog.dialog('open');
				}

				function closeAnalysisWaitDialog() {
					$(SPLASH_SPINNER).hide();
					analysisWaitDialog.dialog('destroy');
				}		
				
				
				function reset() {
					populateOptions();
				}

				/**
				 * @public
				 * Initialize Group Deploy View
				 */
				this.init = function() {

					$(DEPLOY).live('click', function(ev) {
						onDeploy.call(this);
						ev.preventDefault();
					});
					
					$('#hpsum-group-deploy-panels').live('click', function(ev) {
						var value = ev;
						if (ev.hasOwnProperty("srcElement")) {
							if (ev.srcElement.type != undefined) {
								if (ev.srcElement.type.match(/checkbox|select-one|number|textarea/i)) {
									$(ANALYSIS).attr("disabled", false);
									$(DEPLOY).attr("disabled", true);
								}
							}
						}
					}); 
					
					$(ANALYSIS).live('click', function(ev) {
						onAnalysis.call(this);
						ev.preventDefault();
					});

					$(PANELS).hpStackedPanels({
						panelSelector : PANEL_SELECTOR
					});

					$(".hp-collapsible").hpCollapsible();

					$(DEPLOY).attr("disabled", false);

					$(RESET).live('click', function() {
						reset.call();
					});

					$(CANCEL).live('click', function() {
						$('.hpsumInstallables').hpsumInstallables('destroy');
					});
					
					router.watch('Group Deploy section', ROUTE_PREFIX + '.*', {
						parent : ROUTE_PREFIX,
						change : changeLocation
					});
					
					this.resume();
				};

				/**
				 * @public
				 * Resume Group Deploy View
				 */
				this.resume = function() {
					$(THROBBER).hide();
					presenter.on("itemChange", onItemChange);
					$(PANELS).hpStackedPanels('resume');
					reset();
					$('#hpsum-group-deploy').hpCollapsible('expand');
				};

				/**
				 * @public
				 * Pause Group Deploy View
				 */
				this.pause = function() {
					presenter.off("itemChange", onItemChange);
					$(PANELS).hpStackedPanels('pause');
				};
			}

			return GroupDeployView;
		}());

	return new GroupDeployView();
});
