// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
/**
 * @type (GroupEditView)
 * This is a view class for Editing Group.
 */

define(['hpsum/presenter/group/GroupPresenter',
	'hpsum/presenter/node/NodePresenter',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/core/Validator',
    'hp/view/FormStateView',
    'hp/core/HelpMenu',
    'hp/core/Localizer',
    'hp/core/Notifications',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'lib/jquery.selectBox',
    'lib/jquery.dataTables',
    'hp/lib/jquery.hpCollapsible',
    'hp/lib/jquery.hpSearchCombo',
    'hp/lib/jquery.hpToggle'],
function(presenter, nodePresenter, router, urlFragment, validator, FormStateView, helpMenu, localizer, notifications) { "use strict";
 
	var EditGroupView = ( function() {
			// consts can go here
			var ADD = '#hpsum-group-edit',
			    CANCEL = '#hpsum-group-edit-close',
			    RESET = "#hpsum-group-reset", 
			    PANEL_SELECTOR = '#hpsum-group-edit-panel-selector',
			    PANELS = '#hpsum-group-edit-panels',
			    TITLE = '#hpsum-group-title',
			    NAME = '#hpsum-group-name',
			    NAMEERR = '#hpsum-group-name-error',
			    DESC = '#hpsum-group-description',
			    ADD_GROUP_NODES_TABLE = '#hpsum-group-add-group-nodes-table',
			    REMOVE_NODES_TABLE = '#hpsum-remove-group-nodes-table',
			    USERNAME = '#hpsum-group-user-name',
			    USERNAMEERR = '#hpsum-group-user-name-error',
			    PASSWORD = '#hpsum-group-password',
			    PASSWORDERR = '#hpsum-group-password-error',
			    ROUTE_PREFIX = '/group/edit',
			    BASELINES = '#hpsum-group-edit-baselines-search',
			    ASSOCBASELINE = '#hpsum-group-edit-baseline',
			    HOTFIX = '#hpsum-group-edit-addpackage-search',
			    ASSOCHOTFIX = '#hpsum-group-edit-addpackage',
			    REMOVEBASELINE = '#hpsum-group-edit-baseline-remove',
        		REMOVEHOTFIX = '#hpsum-group-edit-addpackage-remove',
        		ADDSELECT = '#hpsum-group-edit-add-select-all-nodes',
        		ADDDESELECT = '#hpsum-group-edit-add-deselect-all-nodes',
        		REMOVESELECT = '#hpsum-group-edit-remove-select-all-nodes',
        		REMOVEDESELECT = '#hpsum-group-edit-remove-deselect-all-nodes',
        		THROBBER = '#hpsum-group-edit-throbber',
        		BASELINE_WRANING = '#hpsum-group-edit-baseline-warning';
      
			/**
			 * @constructor
			 */
			function EditGroupView() {
				var formStateView = new FormStateView(),
				    nodes = [],
				    groupCurrentNodes = [],
				    groupItem = null,
				    tableAddNodes = [],
				    tableRemoveNodes = [],
				    selectedAddNodes = [],
				    selectedRemoveNodes = [],
				    selectedBaselines = [],
				    editInProgress = false,
				    closeEditWindow = false,
				    editGroupSuccess = false,
				    baselines = '',
				    hotfixes = '',
				    assocBaseline = '',
				    newBaseline = null,
				    newHotFix = null,
				    assocHotFix = '',
				    searchResults = [],
				    attributes = {
				    	hapi: {
				    		username: "",
				    		password: ""
				    	}
				    },
				    groupExistingBaselines = [],
				    currentBaseline = null,
				    currentHotFix = null;
				
				function onItemChange(item) {
					reset();
					groupItem = item.hapi;

					if (groupItem && groupItem.hasOwnProperty("group_id")) {
						getGroupDataSuccess(item);
						$(TITLE).text(groupItem.group_name);
						$(NAME).attr('placeholder', groupItem.group_name);
						$(DESC).attr('placeholder', groupItem.group_description);
						$(ASSOCBASELINE).text('');
						$(ASSOCHOTFIX).text('');
						$(REMOVEBASELINE).hide();
                    	$(REMOVEHOTFIX).hide();
                    	if (groupItem.group_id.match(/g1$/i)) {
							$(NAME).attr('disabled', true);
							$(DESC).attr('disabled', true);
							$('#hpsum-group-add-group').hide();
							$('#hpsum-group-add-group-nodes').hide();
							$('#hpsum-group-remove-group-nodes').hide();
						}
						newBaseline = newHotFix = currentBaseline = currentHotFix = null;
						groupExistingBaselines = [];
						if (groupItem.group_baselines) {
							groupExistingBaselines = groupItem.group_baselines;
							for (var i = 0; i < groupItem.group_baselines.length; i++) {
								var baseline = presenter.getBaselineDetailsforId(groupItem.group_baselines[i]);
								if (baseline) {
									if (baseline.name.match(/^Additional Package/i)) {
										$(ASSOCHOTFIX).text(baseline.name);
										$(REMOVEHOTFIX).show();
										$(HOTFIX).hpSearchCombo('set', {id: baseline.id, name: baseline.name});
										assocHotFix = baseline;
										currentHotFix = baseline;
									} else {
										$(ASSOCBASELINE).text(baseline.name);
										$(REMOVEBASELINE).show();
										$(BASELINES).hpSearchCombo('set', {id: baseline.id, name: baseline.name});
										assocBaseline = baseline;
										currentBaseline = baseline;
									}
								}
							}
						}
					} else {
						$(CANCEL).trigger('click');
					}
				}
				
				function changeLocation(location) {
					if (location.length > ROUTE_PREFIX.length) {
						$(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
					} else {
						$(PANELS).hpStackedPanels('setFirstPanel');
					}
				}

				function onNameEdit() {
					$(NAMEERR).hide();
					$(NAME).removeClass("hp-error");
					$(NAME).unbind('keyup', onNameEdit);
				}

				function onUserNameEdit() {
					$(USERNAMEERR).hide();
					$(USERNAME).removeClass("hp-error");
					$(USERNAME).unbind('keyup', onUserNameEdit);
				}
				
				function onPasswordEdit() {
					$(PASSWORDERR).hide();
					$(PASSWORD).removeClass("hp-error");
					$(PASSWORD).unbind('keyup', onPasswordEdit);
				}

				function onGroupEditSuccess(data) {
					$(ADD).attr('disabled', false);
					$(THROBBER).hide();
					if (data.hapi.hcode == 5030) {
						$(NAMEERR).text(localizer.getString('hpsum.group.groupAlreadyExists'));
						$(NAME).addClass("hp-error");
						$(NAMEERR).show();
						$(NAME).keyup(onNameEdit);
						editGroupSuccess = false;
						closeEditWindow = false;
					}
					else {
					reset();
					editGroupSuccess = true;
					closeEditWindow = true;
					$(CANCEL).trigger('click');
					}
				}

				function onGroupEditError(msg) {
					$(ADD).attr('disabled', false);
					$(THROBBER).hide();
					editInProgress = false;
					$(NAMEERR).text(msg);
					$(NAME).addClass("hp-error");
					$(NAMEERR).show();
				}

				function reset() {
					formStateView.reset();
					editInProgress = false;
					$(NAMEERR).hide();
					$(NAME).removeClass("hp-error");
					$(ADD).attr('disabled', false);
				}


				function getSelectedBaselines() {
					var fail = false;
					var finalBaseline;
					var finalHotFix;
					var baselineJson = [];
					if ((newBaseline == null) && (assocBaseline == null))
						finalBaseline = null;
					else if (newBaseline == null)
						finalBaseline = assocBaseline;
					else
						finalBaseline = newBaseline;
					if ((newHotFix == null) && (assocHotFix == null))
						finalHotFix = null;
					else if (newHotFix == null)
						finalHotFix = assocHotFix;
					else
						finalHotFix = newHotFix;

					if ((finalHotFix == null) && (finalBaseline == null))
						fail = true;
					else if (finalHotFix == null) {
						baselineJson.push(finalBaseline.id);
						newBaseline = finalBaseline;
					}
					else if (finalBaseline == null) {
						baselineJson.push(finalHotFix.id);
						newHotFix = finalHotFix;
					}
					else {
						baselineJson.push(finalBaseline.id);
						newBaseline = finalBaseline;
						baselineJson.push(finalHotFix.id);
						newHotFix = finalHotFix;
					}
					if (fail == false) {
						selectedBaselines = baselineJson;
						for (var idx = 0; idx < selectedBaselines.length; idx++) {
							if (selectedBaselines[idx] == null) {
								selectedBaselines.splice(idx, 1);
							}
						}
						
						var validateBaselines = [],
							foundExistingBaselines = 0;
						
						validateBaselines = selectedBaselines;
						for (var idx = 0; idx < validateBaselines.length; idx++) {
							if (-1 != $.inArray(validateBaselines[idx], groupExistingBaselines)) {
								foundExistingBaselines++;
							}
						}
						if (foundExistingBaselines == selectedBaselines.length) {
							selectedBaselines = [];
						}	
					}
				}
				
				function validate() {
					
					if (!validateCredentialsValues) {
						return false;			
					}
					
					return validateName() || validateDescription() || validateSelectedNodes() || validateCredentials() || validateBaselines();
				}

				function validateName() {
					var success = true;
					var trimmedGroupName = $.trim($(NAME).val());
					if ((!trimmedGroupName.match(new RegExp(/^[a-z][a-z-0-9 ]*$/i))) ||
						(groupItem.group_name == trimmedGroupName) ||
						(trimmedGroupName == '')) {
						success = false;
					}

					return success;
				}

				function validateDescription() {
					var success = true;
					if ($(DESC).val() == '') {
						success = false;
					}
					return success;
				}

				function validateSelectedNodes() {
					return getSelectedAddNodes().length > 0 || getSelectedRemoveNodes().length > 0;
				}

				function validateCredentialsValues() {
					var success = true;
					if ($(USERNAME).val() == '' && $(PASSWORD).val() != '') {
						$(USERNAMEERR).text(localizer.getString('hpsum.group.requiredUserName'));
						$(USERNAME).addClass("hp-error");
						$(USERNAMEERR).show();
						$(USERNAME).keyup(onUserNameEdit);
						success = false;
					}
					else if ($(USERNAME).val() != '' && $(PASSWORD).val() == '') {
						$(PASSWORDERR).text(localizer.getString('hpsum.group.requiredPassword'));
						$(PASSWORD).addClass("hp-error");
						$(PASSWORDERR).show();
						$(PASSWORD).keyup(onPasswordEdit);
						success = false;
					}
					
					return success;
				}
				
				function validateCredentials() {
					var success = true;
					if ($(USERNAME).val() == '' && $(PASSWORD).val() == ''){
						success = false;
					}
					return success;
				}
				
				function validateBaselines() {
					getSelectedBaselines();
					var latestBaseline = "",
					    latestHotFix = "",
					    currBaseline = "",
					    currHotFix = "";
					if (newBaseline) {
						latestBaseline = newBaseline.id;
					}
					if (currentBaseline) {
						currBaseline = currentBaseline.id;
					}
					if (newHotFix) {
						latestHotFix = newHotFix.id;
					}
					if (currentHotFix) {
						currHotFix = currentHotFix.id;
					}
					
					return latestBaseline != currBaseline || latestHotFix != currHotFix;
				}
				
				function getSelectedAddNodes() {
					return selectedAddNodes;
				}

				function getSelectedRemoveNodes() {
					return selectedRemoveNodes;
				}

				function onEditGroup() {
					if (validate()) {
					 if (groupItem && groupItem.hasOwnProperty("group_id")) {
					 	$(ADD).attr('disabled', true);
						$(THROBBER).show();
						if (!editInProgress) {
							editInProgress = true;

							if (validateCredentials()) {
								attributes.hapi.username = $(USERNAME).val();
								attributes.hapi.password = $(PASSWORD).val();

								presenter.setAttributes(groupItem, attributes, {
									success : function(data) {
										editGroupSuccess = true;
									},
									error : function(errorMessage) {
										notifications.show(errorMessage, 'error');
									}
								});
								closeEditWindow = true;
							}	
													
							if (getSelectedRemoveNodes().length > 0) {
								var selectedRemoveNodes = getSelectedRemoveNodes();
								presenter.removeNodes(groupItem, {
									nodes : selectedRemoveNodes
								}, {
									success : function(data) {
										editGroupSuccess = true;
									},
									error : function(errorMessage) {
										notifications.show(errorMessage, 'error');
									}
								});
								closeEditWindow = true;
							}

							if (validateName() || validateDescription() || getSelectedAddNodes().length > 0) {
								var selectedAddNodes = getSelectedAddNodes();
								presenter.editItem(groupItem, {
									name : $(NAME).val(),
									description : $(DESC).val(),
									nodes : selectedAddNodes
								}, {
									success : onGroupEditSuccess,
									error : function(errorMessage) {
										notifications.show(errorMessage, 'error');
										closeEditWindow = true;
									}
								});
							}
							
							//if (selectedBaselines.length > 0) {
							if (validateBaselines()) {
									presenter.setAttributes(groupItem, {
										hapi : {
											baselines : {
												remove_existing_baselines:'true',
												baseline : selectedBaselines
											}
										}
									}, {
										success : function(data) {
											editGroupSuccess = true;
										},
										error : function(errorMessage) {
											notifications.show(errorMessage, 'error');
										}
									});
									closeEditWindow = true;
							}
							
							editInProgress = false;
							
							if (closeEditWindow) {
								$(ADD).attr('disabled', false);
								$(THROBBER).hide();
								if (editGroupSuccess) {
									notifications.show(localizer.getString("hpsum.group.editedGroup") + ' ' + groupItem.group_name, 'ok');
								}
								reset();
								$(CANCEL).trigger('click');
							} 
							
						}
					  } else {
					  	$(CANCEL).trigger('click');
					  }
					} else {
						$(CANCEL).trigger('click');
					}
				}

				function getAllNodesSuccess(results) {
					$(ADD_GROUP_NODES_TABLE).dataTable().fnClearTable(true);
					$(REMOVE_NODES_TABLE).dataTable().fnClearTable(true);
					nodes = results.hapi.output_data.nodes.node;
					tableAddNodes = [];
					tableRemoveNodes = [];
					selectedAddNodes = [];
					selectedRemoveNodes = [];
					var haveAddNodes = false,
						haveGroupNodes =  false;

					for (var idx = 0; idx < nodes.length; ++idx) {
						
						nodePresenter.getNodeData({
							node_id : nodes[idx].node_id
						}, {
							success : function(data) {
								var nodeData = data.hapi,
								    status = 'unknown',
								    change = false,
								    nodeStatus = nodeData.node_status,
								    rebootRequired = "",
								    nodeBaseline = localizer.getString('hpsum.group.noBaseline'),
								    adtPackage = localizer.getString('hpsum.group.noAdtPackage');

								if (nodeData.node_state.match(/inventory|analysis|install$/i) || nodeData.node_phase.match(/initialize/i)) {
									status = 'unknown';
									change = true;
								} else if (nodeData.node_state.match(/error/i) || nodeData.node_phase.match(/initialize|InActive/i)) {
									status = 'error';
								} else if (nodeData.node_state.match(/uan/i)) {
									if (nodeData.node_status.match(/No applicable/i)) {
										status = 'ok';
									} else {
										status = 'warning';
									}
								} else if (nodeData.node_state.match(/installdone/i)) {
									if (nodeData.return_code == -2 || nodeData.return_code == -3) {
										status = 'error';
										nodeStatus = localizer.getString('hpsum.node.installDoneWithErrors');
									} else {
										status = 'ok';
									}

									if (nodeData.return_code == 1) {
										rebootRequired = localizer.getString('hpsum.node.rebootRequired')
									}
								} else if (nodeData.node_state.match(/idle/i)) {
									if (nodeData.node_phase.match(/unknown/i)) {
										status = 'error';
									} else {
										status = 'warning';
									}
								}

								if (nodeData.baselines) {
									for (var i = 0; i < nodeData.baselines.length; i++) {
										var baseline = presenter.getBaselineDetailsforId(nodeData.baselines[i]);
										if (baseline) {
											if (baseline.name.match(/^Additional Package/i)) {
												adtPackage = baseline.name;
											} else {
												nodeBaseline = baseline.name;
											}
										}
									}
								}
								
								if ($.inArray(nodeData.node_id, groupCurrentNodes) != -1) {
									$(REMOVE_NODES_TABLE).dataTable().fnAddData({
										status : status,
										change : change,
										node_id : nodeData.node_id,
										name : nodeData.name,
										type : nodeData.type,
										node_status : nodeStatus,
										uri : nodeData.uri,
										state : nodeData.node_state,
										return_code : nodeData.return_code,
										reboot : rebootRequired,
										baseline : nodeBaseline,
										adtPackage : adtPackage
									});
									
									$(REMOVESELECT).attr('disabled', false);
									tableRemoveNodes.push(nodeData.node_id);
									
								} else {
									$(ADD_GROUP_NODES_TABLE).dataTable().fnAddData({
										status : status,
										change : change,
										node_id : nodeData.node_id,
										name : nodeData.name,
										type : nodeData.type,
										node_status : nodeStatus,
										uri : nodeData.uri,
										state : nodeData.node_state,
										return_code : nodeData.return_code,
										reboot : rebootRequired,
										baseline : nodeBaseline,
										adtPackage : adtPackage
									});
									
									$(ADDSELECT).attr('disabled', false);
									tableAddNodes.push(nodeData.node_id);
								}
							},
							error : function(errorMsg) {
							}
						}); 
					}
				}
					
				function onAddTableRow(e) {
					var aData = $(ADD_GROUP_NODES_TABLE).dataTable().fnGetData(this),
							selectdNodesLenght = selectedAddNodes.length,
						    idx;
						if ($(this).hasClass('hp-selected')) {
							$(this).removeClass('hp-selected');
							for (idx = 0; idx < selectdNodesLenght; idx += 1) {
								if (selectedAddNodes[idx] === aData.node_id) {
									selectedAddNodes.splice(idx, 1);
									break;
								}
							}
							if (0 == selectedAddNodes.length) {
								$(ADDDESELECT).attr('disabled', true);
							}
							else if (selectedAddNodes.length < tableAddNodes.length) {
								$(ADDSELECT).attr('disabled', false);
							}
						} else {
							$(this).addClass('hp-selected');
							selectedAddNodes = selectedAddNodes.concat(aData.node_id)
							$(ADDDESELECT).attr('disabled', false);
							if (selectedAddNodes.length == tableAddNodes.length) {
								$(ADDSELECT).attr('disabled', true);
							}
							else if (selectedAddNodes.length < tableAddNodes.length) {
								$(ADDSELECT).attr('disabled', false);
							}
						}
				}
				
				function onRemoveTableRow(e) {
					var aData = $(REMOVE_NODES_TABLE).dataTable().fnGetData(this),
							selectdNodesLenght = selectedRemoveNodes.length,
						    idx;
						if ($(this).hasClass('hp-selected')) {
							$(this).removeClass('hp-selected');
							for (idx = 0; idx < selectdNodesLenght; idx += 1) {
								if (selectedRemoveNodes[idx] === aData.node_id) {
									selectedRemoveNodes.splice(idx, 1);
									break;
								}
							}
							if (0 == selectedRemoveNodes.length) {
								$(REMOVEDESELECT).attr('disabled', true);
							}
							else if (selectedRemoveNodes.length < tableRemoveNodes.length) {
								$(REMOVESELECT).attr('disabled', false);
							}
						} else {
							$(this).addClass('hp-selected');
							selectedRemoveNodes = selectedRemoveNodes.concat(aData.node_id)
							$(REMOVEDESELECT).attr('disabled', false);
							if (selectedRemoveNodes.length == tableRemoveNodes.length) {
								$(REMOVESELECT).attr('disabled', true);
							}
							else if (selectedRemoveNodes.length < tableRemoveNodes.length) {
								$(REMOVESELECT).attr('disabled', false);
							}
						}
				}
				
				function getAllNodesError(data) {
				}

				function getGroupDataSuccess(groupData) {
					groupCurrentNodes = groupData.hapi.group_nodes.group_node;
					
					nodePresenter.getAllNodes({
						success : getAllNodesSuccess,
						error : getAllNodesError
					});
				}

				function getBaseline(string, handlers) {
					var results = [];
					if (string && string.length > 0) {
						results = $.grep(baselines, function(option, index) {
							return (option.name.match(new RegExp(string, 'i')));
						});
					}
					handlers.success({
						count : results.length,
						members : results
					});
				}

				function getHotfixes(string, handlers) {
					var results = [];
					if (string && string.length > 0) {
						results = $.grep(hotfixes, function(option, index) {
							return (option.name.match(new RegExp(string, 'i')));
						});
					}
					handlers.success({
						count : results.length,
						members : results
					});
				}

				function getBaselinesSuccess(searchResults) {
					baselines = $.grep(searchResults, function(option, index) {
						return !(option.name.match(new RegExp('^Additional', 'i')));
					});
					hotfixes = $.grep(searchResults, function(option, index) {
						return (option.name.match(new RegExp('^Additional', 'i')));
					});

				}

				function getBaselinesError(msg) {

				}
          
          		function onAddSelectAll() {
					$(ADD_GROUP_NODES_TABLE + ' tbody tr').addClass('hp-selected');
					$(ADDSELECT).attr('disabled', true);
					$(ADDDESELECT).attr('disabled', false);
					selectedAddNodes = [];
					for (var idx = 0; idx < tableAddNodes.length; ++idx) {
						selectedAddNodes = selectedAddNodes.concat(tableAddNodes[idx]);
					}
				}
				
				function onAddDeselectAll() {
					$(ADD_GROUP_NODES_TABLE + ' tbody tr').removeClass('hp-selected');
					$(ADDSELECT).attr('disabled', false);			
					$(ADDDESELECT).attr('disabled', true);
					selectedAddNodes = [];
				}
				
				function onRemoveSelectAll() {
					$(REMOVE_NODES_TABLE + ' tbody tr').addClass('hp-selected');
					$(REMOVESELECT).attr('disabled', true);
					$(REMOVEDESELECT).attr('disabled', false);
					selectedRemoveNodes = [];
					for (var idx = 0; idx < tableRemoveNodes.length; ++idx) {
						selectedRemoveNodes = selectedRemoveNodes.concat(tableRemoveNodes[idx]);
					}
				}
				
				function onRemoveDeselectAll() {
					$(REMOVE_NODES_TABLE + ' tbody tr').removeClass('hp-selected');
					$(REMOVEDESELECT).attr('disabled', true);			
					$(REMOVESELECT).attr('disabled', false);
					selectedRemoveNodes = [];
				}
				
				/**
				 * @public
				 * Intialize the group edit view.
				 */
				this.init = function() {

					$(PANELS).hpStackedPanels({
						panelSelector : PANEL_SELECTOR
					});

					$(CANCEL).click(function() {
						router.go(urlFragment.replaceView(router.location(), 'show'));
					});

					var dummyRemoveNodesData = [];
					$(REMOVE_NODES_TABLE).dataTable({
						oLanguage : { sEmptyTable :
							localizer.getString("hpsum.group.noNodesInGroup"),
						    sSearch: localizer.getString('hpsum.common.search')
						},
						bPaginate : false,
						sScrollY: "450px",
						bProcessing : true,
						bFilter : true,
						bInfo : false,
						bAutoWidth : false,
						bRetrieve : true,
						bDestroy : true,
						aaData : dummyRemoveNodesData,
						aoColumns : [
						{mDataProp: 'status',
							fnRender: function (oObj) {
								var statusCode;
								if (oObj.aData.change == true )
									statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-changing"></div></div>';
								else if(oObj.aData.status == "ok")
                                    statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>';
                                else if(oObj.aData.status == "error")
                                	statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>';
                                else if(oObj.aData.status == "warning")
                                	statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-warning"><span class="hp-value">warning</span></div></div>';
                                else if(oObj.aData.status == "unknown")
                                	statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-unknown"><span class="hp-value">unknown</span></div></div>';
                                
                                return statusCode;
                                
								/*return '<div class="hp-switch"> <ol class="hp-up-ports">' +
								'<li class="hp-up-port">' + ' <div class="hp-condensed">' + statusCode +
								' </div>' + 
								'<div class="hp-full">' +
								statusCode + 
								'<div class="hp-form-contents"> ' +
								'<fieldset>' + '<ol> ' + ' <li> ' +
								'<div><a href="#/node' + '/show/r' + oObj.aData.uri + '/getData">' + oObj.aData.name + '</a><div></li>' +
								' <li> ' + '<div>' + oObj.aData.type + '</div>' + ' </li> ' +
								' <li> ' + '<div>' + oObj.aData.state + '</div>' + ' </li> ' +
								' <li> ' + '<div>' + oObj.aData.node_status + '</div>' + ' </li> ' +
								' <li> ' + '<div>' + oObj.aData.reboot + '</div>' + ' </li> ' +
								'</ol></fieldset></div></li></ol></div>';
								*/
							},
							sWidth: '10px', sClass: "hp-icon"
						}, {
							mDataProp : 'name'
						}, {
							mDataProp : 'type'
						}, {
							mDataProp : 'node_status'
						}, {
							mDataProp : 'baseline'
						}, {
							mDataProp : 'adtPackage'
						}],
						aaSorting : [[1, "asc"]],
						bScrollCollapse : true
					});
					
					var dummyAddNodesData = [];
					$(ADD_GROUP_NODES_TABLE).dataTable({
						oLanguage : { sEmptyTable :
							localizer.getString("hpsum.group.noMoreNodesAvailable"),
						    sSearch: localizer.getString('hpsum.common.search')
						},
						bPaginate : false,
						sScrollY: "450px",
						bProcessing : true,
						bFilter : true,
						bInfo : false,
						bAutoWidth : false,
						bRetrieve : true,
						bDestroy : true,
						aaData : dummyRemoveNodesData,
						aoColumns : [
						{mDataProp: 'status',
							fnRender: function (oObj) {
								var statusCode;
								if (oObj.aData.change == true )
									statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-changing"></div></div>';
								else if(oObj.aData.status == "ok")
                                    statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>';
                                else if(oObj.aData.status == "error")
                                	statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>';
                                else if(oObj.aData.status == "warning")
                                	statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-warning"><span class="hp-value">warning</span></div></div>';
                                else if(oObj.aData.status == "unknown")
                                	statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-unknown"><span class="hp-value">unknown</span></div></div>';
                                
                                return statusCode;
                                
                                /*
								return '<div class="hp-switch"> <ol class="hp-up-ports">' +
								'<li class="hp-up-port">' + ' <div class="hp-condensed">' + statusCode +
								' </div>' + 
								'<div class="hp-full">' +
								statusCode + 
								'<div class="hp-form-contents"> ' +
								'<fieldset>' + '<ol> ' + ' <li> ' +
								'<div><a href="#/node' + '/show/r' + oObj.aData.uri + '/getData">' + oObj.aData.name + '</a><div></li>' +
								' <li> ' + '<div>' + oObj.aData.type + '</div>' + ' </li> ' +
								' <li> ' + '<div>' + oObj.aData.state + '</div>' + ' </li> ' +
								' <li> ' + '<div>' + oObj.aData.node_status + '</div>' + ' </li> ' +
								' <li> ' + '<div>' + oObj.aData.reboot + '</div>' + ' </li> ' +
								'</ol></fieldset></div></li></ol></div>';
								*/
							},
							sWidth: '10px', sClass: "hp-icon"
						}, {
							mDataProp : 'name'
						}, {
							mDataProp : 'type'
						}, {
							mDataProp : 'node_status'
						}, {
							mDataProp : 'baseline'
						}, {
							mDataProp : 'adtPackage'
						}],
						aaSorting : [[1, "asc"]],
						bScrollCollapse : true
					});
						
				  $(NAME).change(function(ev, value) {
					var trimmedGroupName = $.trim($(NAME).val());
					var success = false;
					if (!trimmedGroupName.match(new RegExp(/^[a-z][a-z-0-9 ]*$/i))) {
						$(NAMEERR).text(localizer.getString('hpsum.group.inValidGroupName'));
						$(NAME).addClass("hp-error");
						$(NAMEERR).show();
						$(NAME).keyup(onNameEdit);
						success = true;
					}
					 
					$(ADD).attr("disabled", success);
				  }); 
                
					$(CANCEL).live('click', function(ev) {
						$(ADD_GROUP_NODES_TABLE + " tbody").off('click','tr', onAddTableRow);
						$(REMOVE_NODES_TABLE + " tbody").off('click','tr', onRemoveTableRow);
						ev.preventDefault();
					});
					
					$(ADDSELECT).live('click', function(ev) {
						onAddSelectAll.call(this);
						ev.preventDefault();
					});
					
					$(ADDDESELECT).live('click', function(ev) {
						onAddDeselectAll.call(this);
						ev.preventDefault();
					});
					
					$(REMOVESELECT).live('click', function(ev) {
						onRemoveSelectAll.call(this);
						ev.preventDefault();
					});
					
					$(REMOVEDESELECT).live('click', function(ev) {
						onRemoveDeselectAll.call(this);
						ev.preventDefault();
					});
					
					$(ADD).live('click', function(ev) {
						onEditGroup.call(this);
						ev.preventDefault();
					});

					$(RESET).live('click', function() {
						reset.call();
					});

					$(BASELINES).hpSearchCombo({
						getResults : getBaseline
					});
					
					$(HOTFIX).hpSearchCombo({
						getResults : getHotfixes
					});
					
					$(BASELINES).change(function(ev, value) {
						var item = presenter.getBaselineDetailsforId(value);
						if (item) {
							$(ASSOCBASELINE).text(item.name);
							$(REMOVEBASELINE).show();
							newBaseline = item;
						} else {
							if(assocBaseline != null){
								$(ASSOCBASELINE).text(assocBaseline.name);
								$(REMOVEBASELINE).show(); 
							}
							newBaseline = null;
						}
						
						if (value == "" && $(HOTFIX).val() == "") {
							$(BASELINE_WRANING).hide();
						} else {
							$(BASELINE_WRANING).show();
						}
						
						if (value == "") {
							$(ASSOCBASELINE).text('');
							$(REMOVEBASELINE).hide();
						}
					});
					
					$(HOTFIX).change(function(ev, value) {
					
						var item = presenter.getBaselineDetailsforId(value);
						if (item) {
							$(ASSOCHOTFIX).text(item.name);
							$(REMOVEHOTFIX).show();
							newHotFix = item;
						} else {
							if (assocHotFix != null) {
								$(ASSOCHOTFIX).text(assocHotFix.name);
								$(REMOVEHOTFIX).show();
							}
							newHotFix = null;
						}
						
						if (value == "" && $(BASELINES).val() == "") {
							$(BASELINE_WRANING).hide();
						} else {
							$(BASELINE_WRANING).show();
						}
						
						if (value == "") {
							$(ASSOCHOTFIX).text('');
							$(REMOVEHOTFIX).hide();
						}
					});

					$(REMOVEBASELINE).on('click', function(ev) {
						assocBaseline = null;
						$(BASELINES).hpSearchCombo('set', {
							id : '',
							name : ''
						});
						$(ASSOCBASELINE).text('');
						$(REMOVEBASELINE).hide();
					});
					
					$(REMOVEHOTFIX).on('click', function(ev) {
						assocHotFix = null;
						$(HOTFIX).hpSearchCombo('set', {
							id : '',
							name : ''
						});
						$(ASSOCHOTFIX).text('');
						$(REMOVEHOTFIX).hide();
					}); 
					
					router.watch('group edit section', ROUTE_PREFIX + '.*', {
						parent : ROUTE_PREFIX,
						change : changeLocation
					});

					this.resume();
				};

				/**
				 * @public
				 * Resume the group edit view.
				 */
				this.resume = function() {
					$('#hpsum-group-add-group').show();
					$('#hpsum-group-add-group-nodes').show();
					$('#hpsum-group-remove-group-nodes').show();
					$(ADD_GROUP_NODES_TABLE).dataTable().fnClearTable(true);
					$(REMOVE_NODES_TABLE).dataTable().fnClearTable(true);
					$(ADD_GROUP_NODES_TABLE + " tbody").on('click','tr', onAddTableRow);
					$(REMOVE_NODES_TABLE + " tbody").on('click','tr', onRemoveTableRow);
					$(THROBBER).hide();
					$(BASELINE_WRANING).hide();
					$(NAME).attr('disabled', false);
					$(DESC).attr('disabled', false);
					$(ADDSELECT).attr('disabled', true);
					$(ADDDESELECT).attr('disabled', true);
					$(REMOVESELECT).attr('disabled', true);
					$(REMOVEDESELECT).attr('disabled', true);
					$(ASSOCHOTFIX).text('');
					$(ASSOCBASELINE).text('');
					$(RESET).trigger('click');
					$(NAMEERR).hide();
					$(NAME).removeClass("hp-error");
					$(REMOVEBASELINE).hide();
                    $(REMOVEHOTFIX).hide();
					
					$(BASELINES).hpSearchCombo('set', {
						id : '',
						name : ''
					});
					
					$(HOTFIX).hpSearchCombo('set', {
						id : '',
						name : ''
					});
					
					presenter.on("itemChange", onItemChange);
					
					presenter.getAllBaselines({
						success : getBaselinesSuccess,
						error : getBaselinesError
					});
				};

			
				/**
				 * @public
				 * Pause the group edit view.
				 */
				this.pause = function() {
					presenter.off("itemChange", onItemChange);
				};

			}

			return EditGroupView;
		}());

	return new EditGroupView();

    		
});

