// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/group/GroupPresenter',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/core/Notifications',
    'hp/view/FormStateView',
    'hp/core/Localizer',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'hp/lib/jquery.hpSearchCombo',
    'lib/jquery.selectBox'],

function(presenter,router, urlFragment, notifications, FormStateView, localizer) {"use strict";

	var GroupInventoryView = ( function() {

			//Consts can go here
			var OK = '#hpsum-group-inventory-ok',
			    CANCEL = '#hpsum-group-inventory-close',
			    PANEL_SELECTOR = '#hpsum-group-inventory-panel-selector',
			    PANELS = '#hpsum-group-inventory-panels',
			    FORM = '#hpsum-group-inventory-form',
			    FAILEDMSG = '#hpsum-group-inventory-failed-details',
			    FAILEDPANEL = '#hpsum-group-inventory-failed',
			    BASELINES = '#hpsum-group-baselines-search',
			    ASSOCBASELINE = '#hpsum-group-baseline',
			    HOTFIX = '#hpsum-group-addpackage-search',
			    ASSOCHOTFIX = '#hpsum-group-addpackage',
			    NAME = '#hpsum-group-inventory-name',
			    ROUTE_PREFIX = '/group/inventory',
			    REMOVEBASELINE = '#hpsum-group-baseline-remove',
        		REMOVEHOTFIX = '#hpsum-group-addpackage-remove',
        		THROBBER = '#hpsum-group-inventory-throbber',
        		BASELINE_WARNING = '#hpsum-group-inventory-baseline-warning',
        		NOBASELINE_WARNING = '#hpsum-group-inventory-no-baseline-warning',
        		NOBASELINE_NODES_TABLE = '#hpsum-group-inventory-view-nodes',
        		NOBASELINE_DETAILS = '#hpsum-group-inventory-nobaseline-nodes';

			/**
			 * Constructor
			 */
			function GroupInventoryView() {

				var formStateView = new FormStateView();
				var inventoryInProgress = false,
				    groupItem = null,
				    baselines = '',
				    hotfixes = '',
				    assocBaseline = '',
				    newBaseline = null,
				    newHotFix = null,
				    assocHotFix = '',
				    searchResults = [];

				function onItemChange(item) {
					item = item.hapi;

					if (item) {
						$(NAME).text(item.group_name);
						$(ASSOCBASELINE).text('');
						$(ASSOCHOTFIX).text('');
						$(REMOVEBASELINE).hide();
                    	$(REMOVEHOTFIX).hide();
						groupItem = item;
						newBaseline = null;
						newHotFix = null;
						if (item.group_baselines) {
							for (var i = 0; i < item.group_baselines.length; i++) {
								var baseline = presenter.getBaselineDetailsforId(item.group_baselines[i]);
								if (baseline) {
									if (baseline.name.match(/^Additional Package/i)) {
										$(ASSOCHOTFIX).text(baseline.name);
										$(REMOVEHOTFIX).show();
										$(HOTFIX).hpSearchCombo('set', {id: baseline.id, name: baseline.name});
										$(NOBASELINE_WARNING).hide();
										assocHotFix = baseline;
									} else {
										$(ASSOCBASELINE).text(baseline.name);
										$(REMOVEBASELINE).show();
										$(BASELINES).hpSearchCombo('set', {id: baseline.id, name: baseline.name});
										$(NOBASELINE_WARNING).hide();
										assocBaseline = baseline;
									}
								}
							}
						}
					} else {
						$(CANCEL).trigger('click');
					}
					formStateView.reset();
				}

				function onInventoryError(errorMessage) {
					$(OK).attr('disabled', false);
					$(THROBBER).hide();
					$(FAILEDPANEL).show();
					$(FAILEDMSG).text(errorMessage);
					inventoryInProgress = false;
				}

				function onInventorySuccess(item) {
					$(OK).attr('disabled', false);
					$(THROBBER).hide();
					inventoryInProgress = false;
					formStateView.reset();
					$(CANCEL).trigger('click');
				}
				
				function performInventory() {
					inventoryInProgress = true;
					presenter.startInventory(groupItem, {
						success : onInventorySuccess,
						error : onInventoryError
					});
				}
				
				function onInventory() {
					var fail = false;
					var finalBaseline;
					var finalHotFix;
					var baselineJson = [];
					if (!inventoryInProgress) {
						$(OK).attr('disabled', true);
						$(THROBBER).show();
						if ((newBaseline == null) && (assocBaseline == null))
							finalBaseline = null;
						else if (newBaseline == null)
							finalBaseline = assocBaseline;
						else
							finalBaseline = newBaseline;
						if ((newHotFix == null) && (assocHotFix == null))
							finalHotFix = null;
						else if (newHotFix == null)
							finalHotFix = assocHotFix;
						else
							finalHotFix = newHotFix;

						if ((finalHotFix == null) && (finalBaseline == null))
							fail = true;
						else if (finalHotFix == null)
							baselineJson.push(finalBaseline.id);
						else if (finalBaseline == null)
							baselineJson.push(finalHotFix.id);
						else {
							baselineJson.push(finalBaseline.id);
							baselineJson.push(finalHotFix.id);
						}
						if (fail == true) {
							//$(FAILEDPANEL).show();
							//$(FAILEDMSG).text(localizer.getString('hpsum.group.errorPleaseSelectBaseline'));
						} else {
							if (baselineJson[0] == null) {
								baselineJson.splice(0, 1);
							}
							groupItem.baselines = baselineJson;
						}
							
						if (baselineJson.length == 0) {
							presenter.getNodesData(groupItem, {
								success : function(data) {
									var NoBaselinesNodes = [],
									    allNodesDetials = [],
									    CanPerformInventory = true;
									    
									if (data.hasOwnProperty('hapi')) {
										allNodesDetials = data.hapi.output_data.nodes.node;
									}
									
									$(NOBASELINE_NODES_TABLE).dataTable().fnClearTable();
									
									for (var idx = 0; idx < allNodesDetials.length; idx++) {
										if (allNodesDetials[idx].baselines.length == 0) {
											CanPerformInventory = false;
											$(NOBASELINE_DETAILS).show();
											
											var nodeData = allNodesDetials[idx],
											    status = 'unknown',
											    change = false,
											    nodeStatus = nodeData.node_status,
											    rebootRequired = "",
											    nodeBaseline = localizer.getString('hpsum.group.noBaseline'),
											    adtPackage = localizer.getString('hpsum.group.noAdtPackage'),
											    name = "";

											if (nodeData.node_state.match(/inventory|analysis|install$/i) || nodeData.node_phase.match(/initialize/i)) {
												status = 'unknown';
												change = true;
											} else if (nodeData.node_state.match(/error/i) || nodeData.node_phase.match(/initialize|InActive/i)) {
												status = 'error';
											} else if (nodeData.node_state.match(/uan/i)) {
												if (nodeData.node_status.match(/No applicable/i)) {
													status = 'ok';
												} else {
													status = 'warning';
												}
											} else if (nodeData.node_state.match(/installdone/i)) {
												if (nodeData.return_code == -2 || nodeData.return_code == -3) {
													status = 'error';
													nodeStatus = localizer.getString('hpsum.node.installDoneWithErrors');
												} else {
													status = 'ok';
												}

												if (nodeData.return_code == 1) {
													rebootRequired = localizer.getString('hpsum.node.rebootRequired');
												}

											} else if (nodeData.node_state.match(/idle/i)) {
												if (nodeData.node_phase.match(/unknown/i)) {
													status = 'error';
												} else {
													status = 'warning';
												}
											}

											if (nodeData.baselines) {
												for (var i = 0; i < nodeData.baselines.length; i++) {
													var baseline = presenter.getBaselineDetailsforId(nodeData.baselines[i]);
													if (baseline) {
														if (baseline.name.match(/^Additional Package/i)) {
															adtPackage = baseline.name;
														} else {
															nodeBaseline = baseline.name;
														}
													}
												}
											}
											
											name = '<a href="#/node' + '/show/r' + nodeData.node_uri + '/getdata">' + nodeData.name + '</a>';
											
											$(NOBASELINE_NODES_TABLE).dataTable().fnAddData({
												status : status,
												change : change,
												uri : nodeData.uri,
												name : name,
												type : nodeData.type,
												node_status : nodeStatus,
												baseline : nodeBaseline,
												adtPackage : adtPackage
											});
										}
									}

									if (!CanPerformInventory) {
										onInventoryError(localizer.getString('hpsum.group.noBaselineNodes'));	
									}
									else {
										performInventory();
									}

								},
								error : function(data) {

								}
							});
						} else {
							performInventory();
						}
					}
				}

				function changeLocation(location) {
					if (location.length > ROUTE_PREFIX.length) {
						$(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
					} else {
						$(PANELS).hpStackedPanels('setFirstPanel');
					}
				}

				this.resume = function() {
					$(THROBBER).hide();
					$(NOBASELINE_WARNING).show();
					$(BASELINE_WARNING).hide();
					$(NOBASELINE_NODES_TABLE).dataTable().fnClearTable();
					$(NOBASELINE_DETAILS).hide();
					assocBaseline = null;
					assocHotFix = null;
					$(BASELINES).hpSearchCombo('set', {
						id : '',
						name : ''
					});
					$(HOTFIX).hpSearchCombo('set', {
						id : '',
						name : ''
					});
					presenter.on('itemChange', onItemChange);
					presenter.getAllBaselines({
						success : getBaselinesSuccess,
						error : getBaselinesError
					});
					$(PANELS).hpStackedPanels('resume');
					$(FAILEDPANEL).hide();
				};

				this.pause = function() {
					presenter.off('itemChange', onItemChange);
					$(PANELS).hpStackedPanels('pause');
				};

				function baselinesAvailable(data) {
				}

				function getBaseline(string, handlers) {
					var results = [];
					if (string && string.length > 0) {
						results = $.grep(baselines, function(option, index) {
							return (option.name.match(new RegExp(string, 'i')));
						});
					}
					handlers.success({
						count : results.length,
						members : results
					});
				}

				function getHotfixes(string, handlers) {
					var results = [];
					if (string && string.length > 0) {
						results = $.grep(hotfixes, function(option, index) {
							return (option.name.match(new RegExp(string, 'i')));
						});
					}
					handlers.success({
						count : results.length,
						members : results
					});
				}

				function getBaselinesSuccess(searchResults) {
					baselines = $.grep(searchResults, function(option, index) {
						return !(option.name.match(new RegExp('^Additional', 'i')));
					});
					hotfixes = $.grep(searchResults, function(option, index) {
						return (option.name.match(new RegExp('^Additional', 'i')));
					});

				}

				function getBaselinesError(msg) {

				}

				/**
				 * @public
				 */
				this.init = function() {

					$(CANCEL).click(function() {
						router.go(urlFragment.replaceView(router.location(), 'show'));
					});
					$(FAILEDPANEL).hide();
					$(PANELS).hpStackedPanels({
						panelSelector : PANEL_SELECTOR
					});

					formStateView.init({
						form : FORM,
						routePattern : ROUTE_PREFIX + '.*',
						autoTrack : true
					});

					presenter.getAllBaselines({
						success : getBaselinesSuccess,
						error : getBaselinesError
					});

					$(BASELINES).hpSearchCombo({
						getResults : getBaseline
					});
					$(HOTFIX).hpSearchCombo({
						getResults : getHotfixes
					});
					$(BASELINES).change(function(ev, value) {
						var item = presenter.getBaselineDetailsforId(value);
						if (item) {
							$(ASSOCBASELINE).text(item.name);
							$(REMOVEBASELINE).show();
							newBaseline = item;
						} else {
							if(assocBaseline != null){
								$(ASSOCBASELINE).text(assocBaseline.name);
								$(REMOVEBASELINE).show(); 
							}
							newBaseline = null;
						}
						$(FAILEDPANEL).hide();
						
						if (value != "") {
							$(NOBASELINE_WARNING).hide();
						}
						
						if (value == "" && $(HOTFIX).val() == "") {
							$(BASELINE_WARNING).hide();
							$(NOBASELINE_WARNING).show();
						} else {
							$(BASELINE_WARNING).show();
						}
						
						/*if (value != "") {
							$(NOBASELINE_WARNING).hide();
						} else {
							$(NOBASELINE_WARNING).show();
						}*/
						
						if (value == "") {
							$(ASSOCBASELINE).text('');
							$(REMOVEBASELINE).hide();
							assocBaseline = null;
						}
						
					});
					$(HOTFIX).change(function(ev, value) {
						var item = presenter.getBaselineDetailsforId(value);
						if (item) {
							$(ASSOCHOTFIX).text(item.name);
							$(REMOVEHOTFIX).show();
							newHotFix = item;
						} else {
							if (assocHotFix != null) {
								$(ASSOCHOTFIX).text(assocHotFix.name);
								$(REMOVEHOTFIX).show();
							}
							newHotFix = null;
						}

						$(FAILEDPANEL).hide();
						
						if (value != "") {
							$(NOBASELINE_WARNING).hide();
						}
						
						if (value == "" && $(BASELINES).val() == "") {
							$(BASELINE_WARNING).hide();
							$(NOBASELINE_WARNING).show();
						} else {
							$(BASELINE_WARNING).show();	
						}
						
						/*if (value != "") {
							$(NOBASELINE_WARNING).hide();
						} else {
							$(NOBASELINE_WARNING).show();
						}*/
						
						if (value == "") {
							$(ASSOCHOTFIX).text('');
							$(REMOVEHOTFIX).hide();
							assocHotFix = null;
						}
					});

					$(OK).on('click', function(ev) {
						onInventory();
						ev.preventDefault();
					});

					$(REMOVEBASELINE).on('click', function(ev) {
						assocBaseline = null;
						$(BASELINES).hpSearchCombo('set', {
							id : '',
							name : ''
						});
						$(ASSOCBASELINE).text('');
						$(REMOVEBASELINE).hide();
					});
					
					$(REMOVEHOTFIX).on('click', function(ev) {
						assocHotFix = null;
						$(HOTFIX).hpSearchCombo('set', {
							id : '',
							name : ''
						});
						$(ASSOCHOTFIX).text('');
						$(REMOVEHOTFIX).hide();
					}); 

					router.watch('group inventory section', ROUTE_PREFIX + '.*', {
						parent : ROUTE_PREFIX,
						change : changeLocation
					});

					var dummyNodeData = [];

					$(NOBASELINE_NODES_TABLE).dataTable({
						oLanguage : {
						    sEmptyTable: localizer.getString("hpsum.group.noMoreNodesAvailable"),
						    sSearch: localizer.getString('hpsum.common.search')
						},
						bPaginate : false,
						sScrollY: "450px",
						bFilter : false,
						bInfo : false,
						bAutoWidth : false,
						bRetrieve : true,
						aaData : dummyNodeData,
						aoColumns : [
						{mDataProp: 'status',
							fnRender: function (oObj) {
								var statusCode;
								if (oObj.aData.change == true )
									statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-changing"></div></div>';
								else if(oObj.aData.status == "ok")
                                    statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>';
                                else if(oObj.aData.status == "error")
                                	statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>';
                                else if(oObj.aData.status == "warning")
                                	statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-warning"><span class="hp-value">warning</span></div></div>';
                                else if(oObj.aData.status == "unknown")
                                	statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-unknown"><span class="hp-value">unknown</span></div></div>';
                                return statusCode;
							},
							sWidth: '10px', sClass: "hp-icon"
						},{
							mDataProp : 'name'
						}/*,{
							mDataProp : 'type'
						}, {
							mDataProp : 'node_status'
						},{
							mDataProp : 'baseline'
						}, {
							mDataProp : 'adtPackage'
						}*/],
						aaSorting : [[1, "asc"]],
						bScrollCollapse : true
					});
					
					this.resume();
				};
			}

			return new GroupInventoryView();
		}());

	return GroupInventoryView;
});

