// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
/**
 * @type (GroupReportsView)
 * This is a view class for Group Reports menu option.
 */

define(['hpsum/presenter/group/GroupPresenter',
	'hpsum/presenter/node/NodePresenter',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/view/FormStateView',
    'hp/core/HelpMenu',
	'hp/core/Localizer',
	'hp/core/Notifications',
	'hp/view/DialogView',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'lib/jquery.selectBox',
    'hp/lib/jquery.hpToggle'],
function(groupPresenter, presenter, router,urlFragment, FormStateView, helpMenu, localizer, notifications, DialogView) {"use strict";

	var GroupReportsShowView = ( function() {
			var FORM = '#hpsum-groups-reports-form',
			    RESET = '#hpsum-groups-reset',
			    CANCEL = '#hpsum-groups-reports-close',
			    GENERATE = '#hpsum-groups-reports-generate',
			    PANEL_SELECTOR = '#hpsum-group-reports-panel-selector',
			    PANELS = '#hpsum-group-reports-panels',
			    TYPE = '#hpsum-group-reports-type',
			    ROUTE_PREFIX = '/group/reports',
			    FIRMWARECHECKBOX = '#hpsum-group-reports-firmware',
			    INSTALLABLECHECKBOX = '#hpsum-group-reports-installable',
			    FAILEDDEPCHECKBOX = '#hpsum-group-reports-faileddep',
			    INSTALLEDCHECKBOX = '#hpsum-group-reports-installed',
			    COMBINEDCHECKBOX = '#hpsum-group-reports-combined',
			    REPORTFORMATHTML = '#hpsum-group-reports-html',
			    REPORTFORMATXML = '#hpsum-group-reports-xml',
			    REPORTFORMATCSV = '#hpsum-group-reports-csv',
			    RUNBACKCHECKBOX = '#chkbox-runbackReport',
			    TITLE = '#hpsum-group-reports-title',
			    SPLASH_DIALOG = '#hpsum-report-wait-dialog',
			    SPLASH_SPINNER = '#hpsum-report-spinner',
			    REPORTS_TABLE = '#hpsum-reports-table';

			function GroupReportsShowView() {
				var groupItem = null,
				    timer = null,
				    inProgressTimer = null,
				    inProgressReportId = null,
				    reportWaitDialog,
				    allReportsDialog,
				    deleteInfoDialog,
				    deleteReportId,
				    generateInProgress = false;
				    
				function reset() {
					$(FIRMWARECHECKBOX).attr('checked', true);
					$(FIRMWARECHECKBOX).attr('disabled', false);
					$(FIRMWARECHECKBOX).trigger('change');
					
					$(INSTALLABLECHECKBOX).attr('checked', true);
					$(INSTALLABLECHECKBOX).attr('disabled', false);
					$(INSTALLABLECHECKBOX).trigger('change');
					
					$(FAILEDDEPCHECKBOX).attr('checked', true);
					$(FAILEDDEPCHECKBOX).attr('disabled', false);
					$(FAILEDDEPCHECKBOX).trigger('change');
					
					$(COMBINEDCHECKBOX).attr('checked', true);
                    $(COMBINEDCHECKBOX).attr('disabled', false);
                    $(COMBINEDCHECKBOX).trigger('change');
					
					if (groupItem && groupItem.hasOwnProperty("group_state")) {
						if (groupItem.group_state != "INSTALLDONE") {
							$(INSTALLEDCHECKBOX).attr('checked', false);
							$(INSTALLEDCHECKBOX).attr('disabled', true);
							$(INSTALLEDCHECKBOX).trigger('change');
						} else {
							$(INSTALLEDCHECKBOX).attr('checked', true);
							$(INSTALLEDCHECKBOX).attr('disabled', false);
							$(INSTALLEDCHECKBOX).trigger('change');
						}
					}
					
					$(RUNBACKCHECKBOX).attr('checked', false);
					$(RUNBACKCHECKBOX).attr('disabled', false);
					$(RUNBACKCHECKBOX).trigger('change');
				}

				function onItemChange(item) {
					if (timer) {
						clearInterval(timer);
						timer = null;
					}
					groupItem = item.hapi;
					if (groupItem && groupItem.hasOwnProperty("group_id")) {
						$(TITLE).text(groupItem.group_name);	
						if(groupItem.group_state != "INSTALLDONE"){
						    $(INSTALLEDCHECKBOX).attr('checked', false);
						    $(INSTALLEDCHECKBOX).attr('disabled', true);
						    $(INSTALLEDCHECKBOX).trigger('change');
						} else {
							$(INSTALLEDCHECKBOX).attr('checked', true);
						    $(INSTALLEDCHECKBOX).attr('disabled', false);
						    $(INSTALLEDCHECKBOX).trigger('change');
						}
					} else {
						$(CANCEL).trigger('click');
					}
				}

				function showReportGenerationWait() {
					var reportButtons = {};
					reportButtons[localizer.getString('hpsum.node.runbackReport')] = function() {
						notifications.show(localizer.getString("hpsum.node.runningReportInBack") + groupItem.group_name + 
										   '. ' + localizer.getString("hpsum.node.referForReportStatus"), 'ok');
						closesReportGenerationWait();
					};
	
					reportWaitDialog = $(SPLASH_DIALOG);
					reportWaitDialog.dialog({
						modal : true,
						dialogClass : 'hp-simple-dialog',
						position : "center",
						draggable : false,
						resizable : false,
						buttons : reportButtons,
						width : 260,
						height : 180
					}); 
					
					$(SPLASH_SPINNER).show();
					reportWaitDialog.dialog('open');
				}

				function closesReportGenerationWait() {
					$(SPLASH_SPINNER).hide();
					if (reportWaitDialog) {
					   reportWaitDialog.dialog('close');
					}
				}

				function populateReportsTable(isItemOnChange) {	
					var reports = [],
					    firmware_report,
					    update_applied_report,
					    installed_report,
					    dependency_report,
					    combined_report,
					    nodes = [];

					presenter.getAllReports({
						success : function(data) {
							reports = data.hapi.reports.report;
							var tableReports = [],
							    reportTypes = [],
							    reportStatus,
							    inProgress = false;
							    							    
							for (var idx = 0; idx < reports.length; ++idx) {
								    reportStatus = reports[idx].report_state;
								    
								if (reportStatus == "report_generation_completed") {
									reportStatus = localizer.getString("hpsum.node.completed");
								} else if (reportStatus == "in_progress" || reportStatus == "not_started" || reportStatus == "partially_generated") {
									reportStatus = localizer.getString("hpsum.node.inProgress");
									inProgress = true;
									if (isItemOnChange) {
										inProgressReportId = reports[idx].report_id;

										$(GENERATE).attr("disabled", true);
										inProgressTimer = setInterval(function() {
											presenter.getReportStatus(inProgressReportId, {
												success : function(data) {
													if (data.hapi.report_state.match(/in_progress|not_started|partially_generated/i)) {
													} else if (data.hapi.report_state.match(/report_generation_completed/i)) {

														clearInterval(inProgressTimer);

														$(GENERATE).attr("disabled", false);
														populateReportsTable(false);
														generateInProgress = false;

													} else {

														clearInterval(inProgressTimer);

													}
												},
												error : function(errorInfo) {

													clearInterval(inProgressTimer);
												}
											});

										}, 3000);
									}
								} else {
									reportStatus = localizer.getString("hpsum.node.failed");
								}

								    
								    reportTypes = reports[idx].report_type;
								    firmware_report = update_applied_report = 	installed_report = dependency_report = combined_report = "";					    
								    for (var i=0; i < reportTypes.length; i++) {
								    	
								    	if (reportTypes[i] == "firmware_report") {
								    		reportTypes[i] = "Firmware";
								    		if (inProgress) {
												firmware_report = '<img src="/img/hp-piano/throbber-small.png" class="hpsum-status-change-med">';
											} else { 	
								    		    firmware_report =  '<a href="' + reports[idx].report_id + '/' + reportTypes[i] + '.rpt"' + 'target ="_blank">' + 
								    		                   '<img src="/img/hp-piano/status-ok.png" ></br>' +
								    		                   localizer.getString("hpsum.node.viewDetails") + '</a>';
								    		}
								    	}
								    	else if (reportTypes[i] == "update_applied_report") {
								    		reportTypes[i] = "update_applied";
								    		if (inProgress) {
												update_applied_report = '<img src="/img/hp-piano/throbber-small.png" class="hpsum-status-change-med">';
											} else { 
								    		    update_applied_report =  '<a href="' + reports[idx].report_id + '/' + reportTypes[i] + '.rpt"' + 'target ="_blank">' +
								    		                      '<img src="/img/hp-piano/status-ok.png" ></br>' +
								    		                      localizer.getString("hpsum.node.viewDetails") + '</a>';
								    		}
								    	}
								    	else if (reportTypes[i] == "installed_report") {
								    		reportTypes[i] = "Installed";
								    		if (inProgress) {
												installed_report = '<img src="/img/hp-piano/throbber-small.png" class="hpsum-status-change-med">';
											} else { 
								    		    installed_report =  '<a href="' + reports[idx].report_id + '/' + reportTypes[i] + '.rpt"' + 'target ="_blank">' +
								    		                    '<img src="/img/hp-piano/status-ok.png" ></br>' +
								    		                     localizer.getString("hpsum.node.viewDetails") + '</a>';
								    		}
								    	}
								    	else if (reportTypes[i] == "dependency_report") {
								    		reportTypes[i] = "FailedDependency";
								    		if (inProgress) {
												dependency_report = '<img src="/img/hp-piano/throbber-small.png" class="hpsum-status-change-med">';
											} else { 
								    		    dependency_report =  '<a href="' + reports[idx].report_id + '/' + reportTypes[i] + '.rpt"' + 'target ="_blank">' +
								    		                     '<img src="/img/hp-piano/status-ok.png" ></br>' +
								    		                   localizer.getString("hpsum.node.viewDetails") + '</a>';
								    		}
								    	}
								    	else if (reportTypes[i] == "combined_report") {
                                            reportTypes[i] = "Combined";
                                            if (inProgress) {
                                                combined_report = '<img src="/img/hp-piano/throbber-small.png" class="hpsum-status-change-med">';
                                            } else { 
                                                combined_report =  '<a href="' + reports[idx].report_id + '/' + reportTypes[i] + '.rpt"' + 'target ="_blank">' +
                                                                 '<img src="/img/hp-piano/status-ok.png" ></br>' +
                                                               localizer.getString("hpsum.node.viewDetails") + '</a>';
                                            }
                                        }
								    }
								    
								    inProgress = false;
								
								var deleteReport = '<a id="hpsum-delete-report" data-custom-value="' + reports[idx].report_id + '">' +
								'<img src="/img/hp-piano/close.png" >' + '</a>';
								
								tableReports.push({
									time_stamp : reports[idx].date_and_time,
									report_format : reports[idx].report_format,
									firmware_type : firmware_report,
									update_applied_type : update_applied_report,
									installed_type : installed_report,
									dependency_type : dependency_report,
									combined_report : combined_report,
									report_status : reportStatus,
									node_name : reports[idx].node_id,
									delete_report : deleteReport
								});
							}
									    
							$(REPORTS_TABLE).dataTable().fnClearTable();
							$(REPORTS_TABLE).dataTable().fnAddData(tableReports);
						},
						error : function(data) {
							notifications.show(data.hapi.hmessage, 'error');
							$(CANCEL).trigger('click');
						}
					});
				};

					
				function onGenerate() {	
					generateInProgress = true;
					$(GENERATE).attr("disabled", true);
					if (!$(RUNBACKCHECKBOX).is(':checked')) {
						showReportGenerationWait();
					}

					var request,
					    firmwaretype = "false",
					    update_appliedtype = "false",
					    faileddeptype = "false",
					    installedtype = "false",
					    combinedtype = "false",
					    reportformat = "false";

					if ($(REPORTFORMATHTML).is(':checked')) {
						reportformat = $(REPORTFORMATHTML).val();
					} else if ($(REPORTFORMATXML).is(':checked')) {
						reportformat = $(REPORTFORMATXML).val();
					} else if ($(REPORTFORMATCSV).is(':checked')) {
						reportformat = $(REPORTFORMATCSV).val();
					}

					if ($(FIRMWARECHECKBOX).is(':checked')) {
						firmwaretype = "true";
					}
					if ($(INSTALLABLECHECKBOX).is(':checked')) {
						update_appliedtype = "true";
					}
					if ($(FAILEDDEPCHECKBOX).is(':checked')) {
						faileddeptype = "true";
					}
					if ($(INSTALLEDCHECKBOX).is(':checked')) {
						installedtype = "true";
					}
					if ($(COMBINEDCHECKBOX).is(':checked')) {
                        combinedtype = "true";
                    }
					
					var requestNodeArray = [],
						reportNodes = groupItem.group_nodes.group_node;
						
					for (var i=0; i<reportNodes.length; i++){
						requestNodeArray.push({
									node_id : reportNodes[i],
									firmware_report : firmwaretype,
									update_applied_report : update_appliedtype,
									dependency_report : faileddeptype,
									installed_report : installedtype,
									combined_report : combinedtype
						});
					}
                    
					var request = {
						hapi : {
							report_format : reportformat,
							baseline_report: "false",
							nodes : {
								node : requestNodeArray
							}
						}
					};

					presenter.createReport(request, {
						success : function(data) {
							onSuccessReportCreation(data.hapi.report_id);
						},
						error : function(errorInfo) {
							notifications.show(errorInfo, 'error');
							closesReportGenerationWait();
							$(CANCEL).trigger('click');
						}
					});

				}

				function getReportStatus(reportId) {
					if (timer) {
						clearInterval(timer);
						timer = null;
					}
					timer = setInterval(function() {
						presenter.getReportStatus(reportId, {
							success : function(data) {
								if (data.hapi.report_state.match(/in_progress|not_started/i)) {
								} else if (data.hapi.report_state.match(/report_generation_completed/i)) {
									closesReportGenerationWait();
									if (timer) {
										clearInterval(timer);
										timer = null;
									}
									$(GENERATE).attr("disabled", false);
									populateReportsTable(false);
									generateInProgress = false;
								} else if (data.hapi.report_state.match(/partially_generated/i)) {
									
								} else {
									notifications.show(data.hapi.hmessage, 'error');
									closesReportGenerationWait();
									
									if (timer) {
										clearInterval(timer);
										timer = null;
									}

									$(CANCEL).trigger('click');
								}
							},
							error : function(errorInfo) {
								notifications.show(errorInfo, 'error');
								closesReportGenerationWait();
								
								if (timer) {
									clearInterval(timer);
									timer = null;
								}

								$(CANCEL).trigger('click');
							}
						});

					}, 3000);
				}

				function onSuccessReportCreation(reportId) {
					populateReportsTable(false);
					presenter.generateReport(reportId, {
						success : function(data) {
							if (!$(RUNBACKCHECKBOX).is(':checked')) {
								populateReportsTable(false);
								getReportStatus(reportId);
							} else {
								notifications.show(localizer.getString("hpsum.node.runningReportInBack") + groupItem.group_name +
												   '. ' + localizer.getString("hpsum.node.referForReportStatus"), 'ok');
							    populateReportsTable(false);
								getReportStatus(reportId);
							}
						},
						error : function(errorInfo) {
							notifications.show(errorInfo, 'error');
							closesReportGenerationWait();
							$(CANCEL).trigger('click');
						}
					});
				}

				function onDeleteReport() {
					var deleteConfirmButtons = {};

					deleteConfirmButtons[localizer.getString('core.delete.delete_button')] = function() {
						presenter.deleteReport({report_id : deleteReportId},
							{
							success : function(data) {
								notifications.show(data.hapi.hmessage, 'ok');
								populateReportsTable(false);
							},
							error : function(message) {
								notifications.show(message, 'error');
							}
						});
						deleteInfoDialog.dialog('close');
					};

					deleteConfirmButtons[localizer.getString('core.delete.cancel_button')] = function() {
						deleteInfoDialog.dialog('close');
					};
					
					if (!deleteInfoDialog) {
						deleteInfoDialog = $('#hpsum-delete-report-dialog');
						deleteInfoDialog.dialog({
							modal : true,
							dialogClass : 'hp-simple-dialog',
							position : "center",
							draggable : false,
							resizable : false,
							buttons : deleteConfirmButtons
						});
					}
					
					deleteInfoDialog.dialog('open');	
				}
				
				function changeLocation(location) {
					if (location.length > ROUTE_PREFIX.length) {
						$(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
					} else {
						$(PANELS).hpStackedPanels('setFirstPanel');
					}
				}


				this.init = function() {
					var resource = router.location().split('/');
                	resource = resource[1];
              	$('a[data-panel-id]').each(function(index) {
                		var currentLink = $(this).attr('href');
                		if(currentLink  == undefined)
                			return;
                		var current = currentLink.split('/');
                		current[1] = resource;
                		currentLink =current.join('/');
                		$(this).attr('href',currentLink);
  					});
  					ROUTE_PREFIX = '/'+ resource +'/reports';

					$(PANELS).hpStackedPanels({
						panelSelector : PANEL_SELECTOR
					});

					$(RESET).live('click', function() {
						reset.call();
					});

					$(GENERATE).live('click', function(ev) {
						if (!generateInProgress) {
						 onGenerate.call();
						}
						ev.preventDefault();
					});
					
					$('#hpsum-delete-report').live('click', function(ev) {
						deleteReportId = $(this).data("custom-value");
						onDeleteReport.call();
						ev.preventDefault();
					});
					
					var yesString = localizer.getString("hpsum.common.yes"),
						noString = localizer.getString("hpsum.common.no");
						
					$(FIRMWARECHECKBOX).hpToggle({checked: yesString, unchecked: noString});
					$(INSTALLABLECHECKBOX).hpToggle({checked: yesString, unchecked: noString});
					$(FAILEDDEPCHECKBOX).hpToggle({checked: yesString, unchecked: noString});
					$(INSTALLEDCHECKBOX).hpToggle({checked: yesString, unchecked: noString});
					$(COMBINEDCHECKBOX).hpToggle({checked: yesString, unchecked: noString});
					$(RUNBACKCHECKBOX).hpToggle({checked: yesString, unchecked: noString});
					
					$(CANCEL).click(function () {
					if (timer) {
						clearInterval(timer);
						timer = null;
					}
					if (inProgressTimer) {
						clearInterval(inProgressTimer);
						inProgressTimer = null;
					}
					
                    router.go(urlFragment.replaceView(router.location(), 'show'));
                });
					router.watch('node report section', ROUTE_PREFIX + '.*', {
						parent : ROUTE_PREFIX,
						change : changeLocation
					});
					
					this.resume();
				};

				this.resume = function() {
					
					var dummyReportsData = [];
					$(REPORTS_TABLE).dataTable({
						oLanguage : {
						    sEmptyTable: localizer.getString("hpsum.node.noReports"),
						    sSearch: localizer.getString('hpsum.common.search')
						},
						bPaginate : false,
						bFilter : false,
						bInfo : false,
						bAutoWidth : false,
						bRetrieve : true,
						bDestroy : true,
						aaData : dummyReportsData,
						aoColumns : [{
							mDataProp : 'time_stamp'
						},{
							sWidth: 75, mDataProp : 'firmware_type'
						},{
							sWidth: 75, mDataProp : 'update_applied_type'
						},{
							sWidth: 75, mDataProp : 'dependency_type'
						},{
							sWidth: 75, mDataProp : 'installed_type'
						},{
                            sWidth: 75, mDataProp : 'combined_report'
                        },{
							mDataProp : 'report_format'
						},{
							mDataProp : 'report_status'
						},{
							mDataProp : 'delete_report'
						}],
						aaSorting: [[ 0, "desc" ]]
					});
					
					generateInProgress = false;
					if (timer) {
						clearInterval(timer);
						timer = null;
					}
					if (inProgressTimer) {
						clearInterval(inProgressTimer);
						inProgressTimer = null;
					}
					$(RESET).trigger('click');	    
					groupPresenter.on("itemChange", onItemChange);
					$(PANELS).hpStackedPanels('resume');
					$(GENERATE).attr("disabled", false);
					populateReportsTable(true);
				};

				this.pause = function() {
					
					if (timer) {
						clearInterval(timer);
						timer = null;
					}
					groupPresenter.off("itemChange", onItemChange);
					$(PANELS).hpStackedPanels('pause');
				};

			}

			return GroupReportsShowView;
		}());

	return new GroupReportsShowView();

});



