// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
/**
 * @type {GroupShowOverviewView}
 * Provides functions to show overview/details pane for a group
 */

define(['hpsum/presenter/group/GroupPresenter',
	'hpsum/presenter/node/NodePresenter',
    'hp/core/UrlFragment',
    'hp/core/Router',
    'text!hpPages/core/no_details.html',
    'hp/core/Localizer',
    'jquery',
    'hp/lib/jquery.hpGridPanels',
    'hp/lib/jquery.hpEllipsis',
    'lib/jquery.ThreeDots',
    'lib/jquery.columnizer',
    'lib/jquery.dateFormat',
    'hp/lib/date',
    'hp/lib/jquery.hpTooltip'],

function(groupPresenter, nodePresenter, urlFragment, router, noneHtml, localizer) {"use strict";

	var GroupShowOverviewView = ( function() {

			//Consts can go here
			var ROOT = '#hpsum-group-show-overview',
			    SPINNER = '#hpsum-group-add-spinner',
			    NAME = '#hpsum-over-group-name',
			    DESCRIPTION = '#hpsum-over-group-description',
			    GROUP_HOTFIX = '#hpsum-over-group-hotfix',
			 	GROUP_BASELINE = '#hpsum-over-group-baseline',
			    NODES_TABLE = '#hpsum-group-nodes-table',
			    OK_NODES = '#hpsum-group-ok-nodes',
			    ERROR_NODES = '#hpsum-group-error-nodes',
			    WARNING_NODES = '#hpsum-group-warning-nodes',
			    INPROGRESS_NODES = '#hpsum-group-inprogress-nodes',
			   	UNKNOWN_NODES = '#hpsum-group-unknown-nodes';

			function GroupShowOverviewView() {

				var noItem,
				groupItem,
				updateTimer = null;

				function onSelectionChange(selection) {
					$(NODES_TABLE).dataTable().fnClearTable();
					urlFragment.replaceHrefUris(ROOT, selection.uris);
				}

				function populateNodesTable(groupNodes) {
					$(NODES_TABLE).dataTable().fnClearTable();
					var nodes = groupNodes,
						ok = 0,
						warning = 0,
						error = 0,
						inprogress = 0,
						unknown = 0;
					$(OK_NODES).text(ok);
					$(ERROR_NODES).text(error);
					$(WARNING_NODES).text(warning);
					$(INPROGRESS_NODES).text(inprogress);
					$(UNKNOWN_NODES).text(unknown); 
								
					for (var idx = 0; idx < nodes.length; ++idx) {
						nodePresenter.getNodeData({
							node_id : nodes[idx]
						}, {
							success : function(data) {
								var nodeData = data.hapi,
									status = 'unknown',
									change = false,
									nodeStatus = nodeData.node_status,
									rebootRequired = "",
									nodeBaseline = localizer.getString('hpsum.group.noBaseline'),
									adtPackage = localizer.getString('hpsum.group.noAdtPackage'),
									removeNode = "",
									viewLog = "",
									uri = "",
									tableData = [],
									addData = true;
									
								tableData = $(NODES_TABLE).dataTable().fnGetData();
								for (var idx = 0; idx < tableData.length; idx++) {
									if (nodeData.node_id == tableData[idx].node_id) {
										addData = false;
										break;	
									}
								}
											
							  if (addData) {
								if (nodeData.node_state.match(/inventory|analysis|install$/i) ||
									nodeData.node_phase.match(/initialize/i)) {
									status = 'unknown';
									change = true;
									inprogress++;
								} else if (nodeData.node_state.match(/error/i) ||
										   nodeData.node_phase.match(/initialize|InActive/i)) {
									status = 'error';
									error++;
								} else if (nodeData.node_state.match(/uan/i)) {
									if (nodeData.node_status.match(/No applicable/i)) {
										status = 'ok';
										ok++;
									} else {
										status = 'warning';
										warning++;
									}
								} else if (nodeData.node_state.match(/installdone/i)) {
									if (nodeData.return_code == -2 || nodeData.return_code == -3) {
										status = 'error';
										nodeStatus = localizer.getString('hpsum.node.installDoneWithErrors');
										error++;
									} else {
										status = 'ok';
										ok++;
									}

									if (nodeData.return_code == 1) {
										rebootRequired = localizer.getString('hpsum.node.rebootRequired')
									}

								} else if (nodeData.node_state.match(/idle/i)) {
									if (nodeData.node_phase.match(/unknown/i)) {
										status = 'error';
										error++;
									} else {
										status = 'warning';
										warning++;
									}
								} else {
									unknown++;
								}
								
								if (nodeData.baselines) {
									for (var i = 0; i < nodeData.baselines.length; i++) {
										var baseline = groupPresenter.getBaselineDetailsforId(nodeData.baselines[i]);
										if (baseline) {
											if (baseline.name.match(/^Additional Package/i)) {
												adtPackage = '<a href="#/baseline/show/r' + baseline.uri + '/getBaselineData">' +
															 baseline.name + '</a>';
											} else {
												nodeBaseline = '<a href="#/baseline/show/r' + baseline.uri + '/getBaselineData">' +
															 baseline.name + '</a>';
											}
										}
									}
								}
								
								if (!groupItem.group_id.match(/g1$/i)) {
									removeNode = '<a id="hpsum-group-remove-node" data-custom-value="' + nodeData.node_id + '">' +
											 '<img src="/img/hp-piano/close.png" >' + '</a>';
								}
								
								uri = '/Session/' + nodeData.node_session + '/Node/' + nodeData.node_id;
								
								if (nodeData.node_state.match(/INSTALLDONE/i)) {
									viewLog = '<a href="#/node/deploy-results/r' + uri + '/getdata">' + localizer.getString('hpsum.oneTouchUpdate.viewLog') + '</a>';
								}
								
								$(NODES_TABLE).dataTable().fnAddData({
									status : status,
									change : change,
									uri : uri,
									node_id : nodeData.node_id,
									name : nodeData.name,
									type : nodeData.type,
									node_status : nodeStatus,
									state : nodeData.node_state,
									return_code : nodeData.return_code,
									reboot : rebootRequired,
									baseline : nodeBaseline,
									adtPackage : adtPackage,
									view_log : viewLog,
									remove_node : removeNode
								});
										
								$(OK_NODES).text(ok);
								$(ERROR_NODES).text(error);
								$(WARNING_NODES).text(warning);
								$(INPROGRESS_NODES).text(inprogress);
								$(UNKNOWN_NODES).text(unknown);
							 } 
					   
							}
							,
							error : function(errorMsg) {
							}
						}); 
					}
					
					$(OK_NODES + '-img').attr('tooltip', localizer.getString('hpsum.group.okGroupNodes')).hpTooltip();
					$(ERROR_NODES + '-img').attr('tooltip', localizer.getString('hpsum.group.errorGroupNodes')).hpTooltip();
					$(WARNING_NODES + '-img').attr('tooltip', localizer.getString('hpsum.group.warningGroupNodes')).hpTooltip();
					$(INPROGRESS_NODES + '-img').attr('tooltip', localizer.getString('hpsum.group.inProgressGroupNodes')).hpTooltip();
					$(UNKNOWN_NODES + '-img').attr('tooltip', localizer.getString('hpsum.group.unKnownGroupNodes')).hpTooltip();
				}

				function onItemChange(item) {
					$(NODES_TABLE).dataTable().fnClearTable();
					$(GROUP_BASELINE).html(localizer.getString('hpsum.group.noBaseline'));
					$(GROUP_HOTFIX).html(localizer.getString('hpsum.group.noAdtPackage'));
					noItem.remove();
					groupItem = item.hapi;

					$(SPINNER).hide();
					$(NAME).text(groupItem.group_name);
					$(DESCRIPTION).text(groupItem.group_description);
					if (groupItem.group_baselines) {
						for (var i = 0; i < groupItem.group_baselines.length; i++) {
							var baseline = groupPresenter.getBaselineDetailsforId(groupItem.group_baselines[i]);
							if (baseline) {
								if (baseline.name.match(/^Additional Package/i)) {
									$(GROUP_HOTFIX).html('<a href="#/baseline/show/r' + baseline.uri
														+ '/getBaselineData">' + baseline.name + '</a>');
								} else {
									$(GROUP_BASELINE).html('<a href="#/baseline/show/r' + baseline.uri
														+ '/getBaselineData">' + baseline.name + '</a>');
								}
							}
						}
					}
					populateNodesTable(groupItem.group_nodes.group_node);
					if (updateTimer) {
						clearInterval(updateTimer);
						updateTimer = null;
					}
					if (groupItem.group_state.match(/INVENTORY|SELFINVENTORY|ANALYSIS|INSTALL$/i) ||
					   (groupItem.group_state.match(/IDLE/i) && item.group_phase.match(/Initialize/i))) {
						    updateTimer = setInterval(function() {
						    	var routerLocation = router.location();
						    	if (routerLocation.match(/group/i) &&
						    		routerLocation.match(/show/i) &&
						    		routerLocation.match(/overview/i)) {
						    		populateNodesTable(groupItem.group_nodes.group_node);
						    	}
						    	else {
						    		if (updateTimer) {
						    		clearInterval(updateTimer);
						    		updateTimer = null;
						    		}
						    	}
						    }, 15000);
					} else if (!groupItem.group_state.match(/INVENTORY|SELFINVENTORY|ANALYSIS|INSTALL$/) &&
							   !(groupItem.group_state.match(/IDLE/i) && groupItem.group_phase.match(/Initialize/i))) {
							   	if (updateTimer) {
						    		clearInterval(updateTimer);
						    		updateTimer = null;
						    	}
					}

					router.go((urlFragment.replaceView(router.location(), 'show/overview')));
				}

				function onItemError(error) {
					$(ROOT).append(noItem);
				}

				function getItemUrl(oObj) {
					return '<a href="#/node' + '/show/r' + oObj.aData.uri + '/getdata">' + oObj.aData.name + '</a>';
				}

				/*
				 *  Public Functions
				 */

				this.init = function() {
					noItem = $(noneHtml);
					$(DESCRIPTION).ThreeDots({
						max_rows : 3,
						alt_text_t : true
					});

					var dummyNodeData = [];
					$(NODES_TABLE).dataTable({
						oLanguage : {
						    sEmptyTable: localizer.getString("hpsum.group.noNodesInGroup"),
						    sSearch: localizer.getString('hpsum.common.search')
						},
						bPaginate : false,
						sScrollY: "450px",
						bFilter : true,
						bInfo : false,
						bAutoWidth : false,
						bRetrieve : true,
						aaData : dummyNodeData,
						aoColumns : [
						{mDataProp: 'status',
							fnRender: function (oObj) {
								var statusCode;
								if (oObj.aData.change == true )
									statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-changing"></div></div>';
								else if(oObj.aData.status == "ok")
                                    statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>';
                                else if(oObj.aData.status == "error")
                                	statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>';
                                else if(oObj.aData.status == "warning")
                                	statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-warning"><span class="hp-value">warning</span></div></div>';
                                else if(oObj.aData.status == "unknown")
                                	statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-unknown"><span class="hp-value">unknown</span></div></div>';
                           	
                           		return statusCode;
                           		
								/* Disable for now
								 * 
								 return '<div class="hp-switch"> <ol class="hp-up-ports">' +
								'<li class="hp-up-port">' + ' <div class="hp-condensed">' + statusCode +
								' </div>' + 
								'<div class="hp-full">' +
								statusCode + 
								'<div class="hp-form-contents"> ' +
								'<fieldset>' + '<ol> ' + ' <li> ' +
								'<div><a href="#/node' + '/show/r' + oObj.aData.uri + '/getData">' + oObj.aData.name + '</a><div></li>' +
								' <li> ' + '<div>' + oObj.aData.type + '</div>' + ' </li> ' +
								' <li> ' + '<div>' + oObj.aData.state + '</div>' + ' </li> ' +
								' <li> ' + '<div>' + oObj.aData.node_status + '</div>' + ' </li> ' +
								' <li> ' + '<div>' + oObj.aData.reboot + '</div>' + ' </li> ' +
								'</ol></fieldset></div></li></ol></div>';
								*/
							},
							sWidth: '10px', sClass: "hp-icon"
						},
						{
						fnRender : getItemUrl,
						mDataProp : 'name'
						}, {
						mDataProp : 'type'
						}, {
						mDataProp : 'node_status'
						}, {
							mDataProp : 'baseline'
							//sWidth: '70px'
						}, {
							mDataProp : 'adtPackage'
						}, {
							mDataProp : 'view_log'
						}, {
							mDataProp : 'remove_node'
						}],
						aaSorting : [[1, "asc"]],
						bScrollCollapse : true

					});
					
					$('#hpsum-group-remove-node').live('click', function(ev) {
						groupPresenter.removeNodes(groupItem, {
							nodes : $(this).data("custom-value")
						}, {
							success : function(data) {
							},
							error : function(errorMessage) {
							}
						});
						ev.preventDefault();
					}); 
           			
					this.resume();
				};

				this.resume = function() {
					$(NODES_TABLE).dataTable().fnClearTable();
					$(GROUP_BASELINE).html(localizer.getString('hpsum.group.noBaseline'));
					$(GROUP_HOTFIX).html(localizer.getString('hpsum.group.noAdtPackage'));
					groupPresenter.refreshAllBaselines();
					groupPresenter.on("selectionChange", onSelectionChange);
					groupPresenter.on("itemError", onItemError);
					groupPresenter.on("itemChange", onItemChange);
				};

				this.pause = function() {
					groupPresenter.off("selectionChange", onSelectionChange);
					groupPresenter.off("itemChange", onItemChange);
					groupPresenter.off("itemError", onItemError);
				};

			}

			return new GroupShowOverviewView();
		}());

	return GroupShowOverviewView;
});
