/* (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
*/
define(['hp/view/DetailsShowView',
    'hpsum/presenter/group/GroupPresenter',
    'hp/view/DialogView',
    'hp/core/UrlFragment',
    'hp/core/LinkTargetBuilder',
    'hp/view/NotificationsView',
    'hp/core/Localizer',
    'hp/core/HashManager',
    'hp/core/Notifications',
    'jquery',
    'hp/lib/date',
    'hp/lib/jquery.hpDropMenu',
    'hp/lib/jquery.hpStatus',
    'hp/lib/jquery.hpCollapsible'],
function(DetailsShowView, presenter, DialogView, urlFragment,
    linkTargetBuilder, NotificationsView, localizer, hashManager, notifications) { "use strict";

	var GroupShowView = ( function() {

			//Consts can go here
			var VIEW = '#hpsum-group-show',
			    SELECTOR = '#hpsum-groups-panel-selector',
			    HEADER = '#hpsum-groups-show .hp-details-header',
			    TITLE = '#hpsum-groups-details-title',
			    STATUS = '#hpsum-groups-details-status',
			    ACTIONS = '.hp-details-actions',
			    ADD_ACTION = '#hpsum-group-action-add',
			    EDIT_ACTION = '#hpsum-group-action-edit',
			    INVENTORY_ACTION = '#hpsum-group-action-inventory',
			    DEPLOY_ACTION = '#hpsum-group-action-deploy',
			    ABORT_ACTION = '#hpsum-group-action-abort',
			    ABORT_TITLE = '#hpsum-group-abort-title',
			    ABORT_INFO_DIALOG = '#hpsum-abort-info-dialog',
			    DELETE_ACTION = '#hpsum-group-action-delete',
			    DELETE_TITLE = '#hpsum-group-delete-title',
			    DELETE_INFO_DIALOG = '#hpsum-delete-info-dialog',
			    REPORTS_ACTION = '#hpsum-group-action-reports';

			/**
			 * Constructor
			 */
			function GroupShowView() {

				var detailsShowView = new DetailsShowView(),
				    notificationsView = new NotificationsView(),
				    thisgroup = null,
				    item = null,
				    notificationsCleared = false,
				    deleteInfoDialog,
				    abortInfoDialog;
				
				function clearNotifications() {
					if (!notificationsCleared) {
						notificationsCleared = true;
						notificationsView.clear();
					}
				}

				function onItemChange(groupItem) {
					clearNotifications();
					item = groupItem.hapi;
					
					if (item) {
						thisgroup = item;
						$(HEADER).removeClass('hp-show-changing');
						$(ACTIONS).removeClass('hp-disabled');
						$(TITLE).removeClass('hp-unavailable');
						$(TITLE).text(item.group_name);

					   if (thisgroup.group_id.match(/g1$/i)) {
					   		$(DELETE_ACTION).addClass('hp-disabled');
					   } else {
					   		$(DELETE_ACTION).removeClass('hp-disabled');
					   }
					   
					   if (item.group_phase.match(/Error/i)) {
							$(STATUS).hpStatus('error', false).removeClass('hp-unavailable');

							notificationsView.add({
								status : 'error',
								details : localizer.getString('hpsum.group.groupErrorSummary'),
								summary : localizer.getString('hpsum.group.groupErrorDetails'),
							});

							$(EDIT_ACTION).removeClass('hp-disabled');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}
						
						else if (item.group_phase.match(/InActive/i)) {
							$(STATUS).hpStatus('error', false).removeClass('hp-unavailable');

							notificationsView.add({
								status : 'error',
								summary : localizer.getString('hpsum.group.groupInActiveSummary'),
								details : localizer.getString('hpsum.group.groupInActiveDetails'), 
							});

							$(EDIT_ACTION).removeClass('hp-disabled');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
							
							//This will restore an In-Active group
							presenter.restore(thisgroup);
						}

					  	else if (item.group_phase.match(/Initialize/i)) {
							$(STATUS).hpStatus('running', true).removeClass('hp-unavailable');

							notificationsView.add({								
								status : 'running',
								changing : true,
								summary : localizer.getString('hpsum.group.groupScoutingSummary') 
							});

							$(EDIT_ACTION).addClass('hp-disabled');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}
						
						else if (item.group_phase.match(/NoNodes/i)) {
							$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');
							var details = '<a href="#/group/edit/addNodesToGroup">' + localizer.getString('hpsum.group.addNodesToGroup') + '</a>';

							notificationsView.add({
								status : 'warning',
								summary : localizer.getString('hpsum.group.groupNoNodesSummary'),
								details : details
							});

							$(EDIT_ACTION).removeClass('hp-disabled');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}

						else if (item.group_state.match(/IDLE/i) && item.group_phase.match(/UserActionNeeded/i)) {
							$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');
							var notif = {
								status : 'warning',
								summary : localizer.getString('hpsum.group.readyForInventory'),
								details : '<a href="#/group/inventory">' + localizer.getString('hpsum.group.startInventory') + '</a>'
							};
							notificationsView.add(notif);

							$(EDIT_ACTION).removeClass('hp-disabled');
							$(INVENTORY_ACTION).removeClass('hp-disabled');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}

						else if (item.group_state.match(/INVENTORY/i)) {
							$(STATUS).hpStatus('running', true).removeClass('hp-unavailable');
							var notif = {
								status : 'running',
								summary : localizer.getString('hpsum.group.inventoryProgress'),
								changing : true
							};
							notificationsView.add(notif);
							
							$(EDIT_ACTION).addClass('hp-disabled');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).removeClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}

						else if (item.group_state.match(/UAN/i) && item.group_phase.match(/UserActionNeeded/i)) {
							$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');
							var notif = {
								status : 'warning',
								summary : localizer.getString('hpsum.group.readyForDeploy'),
								details : '<a href="#/group/deploy">' + localizer.getString('hpsum.group.startDeploy') + '</a>',
								changing : false
							};
							notificationsView.add(notif);
							
							$(EDIT_ACTION).removeClass('hp-disabled');
							$(INVENTORY_ACTION).removeClass('hp-disabled');
							$(DEPLOY_ACTION).removeClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).removeClass('hp-disabled').attr('style', '');
						}
						
						else if (item.group_phase.match(/NoComponents/i)) {
							$(STATUS).hpStatus('ok', false).removeClass('hp-unavailable');
							var notif = {
								status : 'ok',
								summary : localizer.getString('hpsum.group.noApplicableComp'),
								details : '<a href="#/group/inventory">' + localizer.getString('hpsum.group.startInventoryAgain') + '</a>', 
								changing : false
							};
							notificationsView.add(notif);
							
							$(EDIT_ACTION).removeClass('hp-disabled');
							$(INVENTORY_ACTION).removeClass('hp-disabled');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).removeClass('hp-disabled').attr('style', '');
						}
						
						else if (item.group_state.match(/ANALYSIS/i)) {
							$(STATUS).hpStatus('running', true).removeClass('hp-unavailable');
							var notif = {
								status : 'running',
								summary : localizer.getString('hpsum.group.analysisProgress'),
								changing : true
							};
							notificationsView.add(notif);
							
							$(EDIT_ACTION).addClass('hp-disabled');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).removeClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}
						
						else if (item.group_state.match(/INSTALLDONE/i)) {
							if (item.group_return_code == -2 || item.group_return_code == -3) {
								$(STATUS).hpStatus('error', false).removeClass('hp-unavailable');
								var notif = {
									status : 'error',
									summary : localizer.getString('hpsum.node.installDoneWithErrors'),
									details : localizer.getString('hpsum.node.installDoneSeeErrors'),
									changing : false
								}; 
							} else {
								$(STATUS).hpStatus('ok', false).removeClass('hp-unavailable');
								var notif = {
									status : 'ok',
									summary : localizer.getString('hpsum.group.deployDone'),
									details : localizer.getString('hpsum.node.installDoneSee'),
									changing : false
								}; 
							}
							notificationsView.add(notif);

							$(EDIT_ACTION).removeClass('hp-disabled');
							$(INVENTORY_ACTION).removeClass('hp-disabled');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).removeClass('hp-disabled').attr('style', '');
						}
						
						else if (item.group_state.match(/INSTALL$/i)) {
							$(STATUS).hpStatus('running', true).removeClass('hp-unavailable');
							var notif = {
								status : 'running',
								summary : localizer.getString('hpsum.group.deployProgress'),
								changing : true
							};
							notificationsView.add(notif);
							
							$(EDIT_ACTION).addClass('hp-disabled');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).removeClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}

						else if (item.group_state.match(/INSTALLHOLD/i)) {
							$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');

							notificationsView.add({
								status : 'warning',
								summary : localizer.getString('hpsum.group.deployHoldSummary'),
								changing : false
							});

							$(EDIT_ACTION).removeClass('hp-disabled');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}
						
						if (item.group_state.match(/INVENTORY|SELFINVENTORY|ANALYSIS|INSTALL$/i) ||
						    (item.group_state.match(/IDLE/i) && item.group_phase.match(/Initialize/i))) {
							var timer = setInterval(function() {
								presenter.getGroupStatus({
									group_id : item.group_id
								}, {
									success : function(data) {
										if (data.hapi.hcode == 0) {
											if (!data.hapi.group_state.match(/INVENTORY|SELFINVENTORY|ANALYSIS|INSTALL$/) &&
											    !(data.hapi.group_state.match(/IDLE/i) && data.hapi.group_phase.match(/Initialize/i))) {
											    presenter.refreshIndexResults();
												clearInterval(timer);
											}
										} else {
											clearInterval(timer);
										}
									},
									error : function(data) {
										clearInterval(timer);
									}
								});
							}, 3000);
						}

					} else {
						$(TITLE).text('');
						$(STATUS).hpStatus('unknown');
						$(STATUS + ' span').text('');
					}
				}

				function onItemError(errorMessage) {
				}

				function onSelectionChange(selection) {
					notificationsCleared = false;
					clearNotifications();
					urlFragment.replaceHrefUris(HEADER, selection.uris, selection.multiSelectId);
					if ($(HEADER).hasClass('hp-show-init')) {
						$(HEADER).removeClass('hp-show-init');
					} else {
						$(HEADER).addClass('hp-show-changing');
						$(ACTIONS).addClass('hp-disabled');
					}
				}
				
				function onItemDeleteSuccess(data) {
					notifications.show(localizer.getString('hpsum.group.deletedGroup') + ' ' + thisgroup.group_name, 'ok');
            	}
            	
            	function onItemDeleteError(errorMessage) {
            		notifications.show(errorMessage, 'error');
            	}
	
				function showDeleteInfoDialog() {
					var deleteConfirmButtons = {};

					deleteConfirmButtons[localizer.getString('hpsum.baseline.show.yesDelete')] = function () {
						presenter.deleteItem(thisgroup, {
							success : function(data) {
								onItemDeleteSuccess(data)
							},
							error : function(message) {
								onItemDeleteError(message)
							}
						});
						deleteInfoDialog.dialog('close');
					};

					deleteConfirmButtons[localizer.getString('hpsum.common.cancel')] = function() {
						deleteInfoDialog.dialog('close');
					};
					
					$(DELETE_TITLE).html(thisgroup.group_name);
					
					if (!deleteInfoDialog) {
						deleteInfoDialog = $(DELETE_INFO_DIALOG);
						deleteInfoDialog.dialog({
							modal : true,
							dialogClass : 'hp-simple-dialog',
							position : "center",
							draggable : false,
							resizable : false,
							buttons : deleteConfirmButtons
						});
					}
					
					deleteInfoDialog.dialog('open');
				}

				function onDeleteItem() {
					showDeleteInfoDialog();
					hashManager.replaceHash('/group/show/overview');
				}

				function onItemAbortedSuccess(data) {
					notifications.show(localizer.getString('hpsum.group.abortedGroup') + ' ' + thisgroup.group_name, 'ok');
				}

				function onItemAbortedError(errorMessage) {
					notifications.show(errorMessage, 'error');
				}

				function showAbortInfoDialog() {
					var AbortConfirmButtons = {};

					AbortConfirmButtons[localizer.getString('hpsum.group.yesAbort')] = function() {
						presenter.abortItem(thisgroup, {
							success : function(data) {
								onItemAbortedSuccess(data)
							},
							error : function(message) {
								onItemAbortedError(message)
							}
						});
						abortInfoDialog.dialog('close');
					};

					AbortConfirmButtons[localizer.getString('hpsum.common.cancel')] = function () {
						abortInfoDialog.dialog('close');
					};

					$(ABORT_TITLE).html(thisgroup.group_name);
													                   
					if (!abortInfoDialog) {
						abortInfoDialog = $(ABORT_INFO_DIALOG);
						abortInfoDialog.dialog({
							modal : true,
							dialogClass : 'hp-simple-dialog',
							position : "center",
							draggable : false,
							resizable : false,
							buttons : AbortConfirmButtons
						});
					}
					abortInfoDialog.dialog('open');
				}

				function onAbortItem() {
					showAbortInfoDialog();
					hashManager.replaceHash('/group/show/overview');
				}

				/**
				 * @public
				 * Initialize Group Show View
				 */
				this.init = function() {
					detailsShowView.init($(SELECTOR));
					notificationsView.init($(VIEW));
					$(ACTIONS).hpDropMenu();
					$(ABORT_ACTION).bind('click', function(ev) {
						onAbortItem.call(this);
						ev.preventDefault();
					});
					$(DELETE_ACTION).bind('click', function(ev) {
						onDeleteItem.call(this);
						ev.preventDefault();
					}); 
					this.resume();
				};

				/**
				 * @public
				 * Resume Group Show View
				 */
				this.resume = function() {
					notificationsCleared = false;
					presenter.on("selectionChange", onSelectionChange);
					presenter.on("itemChange", onItemChange);
					presenter.on("itemError", onItemError);
					if (notificationsView.resume) {
						notificationsView.resume();
					}
				};

				/**
				 * @public
				 * Pause Group Show View
				 */
				this.pause = function() {
					presenter.off("selectionChange", onSelectionChange);
					presenter.off("itemChange", onItemChange);
					presenter.off("itemError", onItemError);
					if (notificationsView.pause) {
						notificationsView.pause();
					}
				};
			}

			return new GroupShowView();
		}());

	return GroupShowView;

});
