// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/node/NodePresenter', 
    'hp/core/UrlFragment',
    'hp/core/Router',
    'hp/core/LinkTargetBuilder',
    'text!hpPages/core/no_details.html',
    'hp/core/Localizer',
	'hp/model/Session',
    'jquery',
    //These two modules required to show table for contents section in details pane
    'lib/jquery.dataTables',
    'lib/jquery.dateFormat',
    'hp/lib/jquery.hpGridPanels'],
function(presenter, urlFragment,router, linkTargetBuilder, noneHtml, localizer, session) { "use strict";

    var IloFederationOverviewView = (function() {
      
        var ROOT = '#hpsum-federation-show-overview';
        var PANELS = '.hp-grid-panels',
        	DESCRIPTION = '#hpsum-ilo-federation-desc',
        	TYPE ='#hpsum-ilo-type',
        	BASELINE='#hpsum-ilo-federation-bundle',
        	LOCATION='#hpsum-ilo-location',
        	SPINNER = '#hpsum-node-add-spinner',
            INSTALL_LOGS = '#hpsum-federation-install-log',
            INSTALLED_FW_LIST_TABLE = '#ilofed-installed-fw-contents-table',
            INSTALLED_SYSTEM_TYPE_TABLE = '#ilofed-installed-system-type-table',
            A_INSTALLED_ILO = '#hpsum-installed-ilo',
            A_INSTALLED_BIOS = '#hpsum-installed-bios',
            FW_SELECTTION_TYPE = '#ilo-federation-selection-type',
            INSTALLED_TYPE_TABLE_HEADER = '#hpsum-installed-type-name',
            ILO_FED_GROUP = '#hpsum-ilo-federation-group',
            VERSION_SELECT = '#hpsum-ilofederation-version';

        /**
         * Constructor
         */
        function IloFederationOverviewView() {
          
            var noItem;
            var timer= null;
            var thisNode=null;
            var firmwareItems = null;
            var ilotimer=-1;
            var biosItems = null;
            var iloItems = null;
            var ppicItems = null;
            var cpldItems = null;
                        
            function onItemChange(item) {
            	item = item.hapi;
            	
            	if(item == null)
            		return;
            		
            	thisNode =item;
                noItem.remove();
				biosItems = null;
				iloItems = null;
                cpldItems = null;
                ppicItems = null;
                
                item.type = item.type.toLowerCase();
        		var uitype = presenter.getUINodeType(item.type);
        		$(ROOT).closest('section').show();
        		
        		if(!router.location().match(uitype)) {
        		    if(router.location().indexOf("/node") == 0)
        		    	router.go((urlFragment.replaceView(router.location(), 'show/' + item.type + '/overview')));
        		    else {
        		    	$(ROOT).closest('section').hide();
        		      	return;
        		    }
                }
                
                
                $("#ilofed-installed-fw-contents-table > tbody > tr").remove();
            	$("#ilofed-installed-fw-contents-table_filter").remove();
            	$("#ilofed-installed-fw-contents-table_processing").remove();
            	$("#ilofed-installed-system-type-table > tbody > tr").remove();
		$("#ilofed-installed-system-type-table_filter").remove();
            	$("#ilofed-installed-system-type-table_processing").remove();
            	
				$('a.hp-button' , $(INSTALL_LOGS)).attr('href', '#/' + urlFragment.getPage(router.location()) + '/deploy-results');
                $(INSTALL_LOGS).hide();
        		if(item.node_state.match(/idle/i) && item.node_phase.match(/initialize/i)){
        			$('.hp-grid-panels').css({"display":"none"});
        			 $(SPINNER).show();
                     getNodeStatus();
                }
        		else {
        			$(SPINNER).hide();
					$('.hp-grid-panels').css({"display":""});
        			$('.hp-grid-panels').hpGridPanels('reset');     			

        			$(DESCRIPTION).text(item.description);
        			$(ILO_FED_GROUP).text(item.federation_group);
        			
        			var fwBaseline = presenter.getFWBaseline(item.baselines)
        			if(fwBaseline){
        					var baseline_url = '#/baseline/show/r'+fwBaseline.uri +'/getBaselineData';
        					name = fwBaseline.name;
        					$(BASELINE).html('<a href="'+ baseline_url +'">'+name+ '</a>');
        				}
        			else
        				$(BASELINE).text(localizer.getString('hpsum.node.noBaselineDefined'));  

                    if (item.node_state.match(/uan/i)) {

                        // Populate the all the discovered server models and counts
                        if (item.server_types && item.server_types.length > 0) {
							
							var systemsTable = initSystemsTable();
							systemsTable.fnClearTable();
							// Go ahead and populate all the systems in the systems table
                            var idx;
                            for (idx = 0; idx < item.server_types.length; idx++) {
                                var system = item.server_types[idx];
                                systemsTable.fnAddData([{server_model : system.server_model, count : system.count}]);
                            }
                        }

                        if (item.bios && item.bios.devices)
                            biosItems = item.bios.devices;
                        if (item.ilo && item.ilo.devices)
                            iloItems = item.ilo.devices;
                        if (item.cpld && item.cpld.devices)
                            cpldItems = item.cpld.devices;
                        if (item.powerpic && item.powerpic.devices)
                            ppicItems = item.powerpic.devices;

                        if (iloItems) {
                            // Simulate selection of the iLO to populate the iLO details for the first time
                            $(VERSION_SELECT).selectBox('value', "iLo");
                            populateFirmwareListTable();
                        }
                    }

                    if(item.node_state.match(/installdone/i))
                        $(INSTALL_LOGS).show();

        		}
                $(PANELS).hpGridPanels('reset');
                $(ROOT).removeClass('hp-show-changing');
                $('.hp-dynamic', ROOT).removeClass('hp-unavailable');
            }
            
			
            function getNodeStatus(item)
            {

                 if(ilotimer != -1)
                 {

                    ilotimer = setInterval(function () {

                        presenter.getNodeStatus(item, {
                                success : function(data) {
                                            onIloFederationStatusSuccess(data,ilotimer);
                                         },
                                error : function(errorInfo) {
                                            onNodeStatusError(errorInfo,ilotimer);
                                        }
                        });
                        }, 3000);
                }
            }
            
            function onIloFederationStatusSuccess(data,ilotimer){
            	if(thisNode.node_id == data.hapi.node_status.node_id) {
            		if(!data.hapi.node_status.node_phase.match(/initialize/i)){
        				clearInterval(ilotimer);
        				ilotimer = -1;
        				presenter.refreshIndexResults();
        			}
        		}
            }   
            function onNodeStatusError(){
                //clearInterval(ilotimer);
            	//ilotimer =-1
                //We need to show the login page.Since we failed to communicate to the 
                //hpsum_service
            }      
            
            function onItemError(error) {
                $(ROOT).append(noItem);
            }
            
            function onSelectionChange(selection) {
                urlFragment.replaceHrefUris(ROOT, selection.uris);
                if ($(ROOT).hasClass('hp-show-init')) {
                    $(ROOT).removeClass('hp-show-init');
                } else {
                    $(ROOT).addClass('hp-show-changing');
                    $('#tour-server-bundle-item').addClass('hp-show-changing');
                }
            }
          
            /**
             * @public
             */
            this.resume = function() {
            	$(PANELS).hpGridPanels('reset');
                presenter.on("selectionChange", onSelectionChange);
                presenter.on("itemError", onItemError);
                presenter.on("itemChange", onItemChange);
                $(VERSION_SELECT).on('change',populateFirmwareListTable);
                $(VERSION_SELECT).selectBox('value', "iLo");
            };
            
            this.pause = function() {
            	presenter.off("selectionChange", onSelectionChange);
                presenter.off("itemChange", onItemChange);
                presenter.off("itemError", onItemError);
                $(VERSION_SELECT).off('change');
            };


            function populateFirmwareListTable(event) {

                var type = $(VERSION_SELECT).val();

                var idx;
                var devices = null;

                if (type == "iLo" && iloItems) {
                    $(INSTALLED_TYPE_TABLE_HEADER).text(localizer.getString('hpsum.ilofederation.ilotype'));
                    devices = iloItems;
                    $(FW_SELECTTION_TYPE).text(localizer.getString('hpsum.common.ilo'));
                } else if (type == "Bios" && biosItems) {
                    $(INSTALLED_TYPE_TABLE_HEADER).text(localizer.getString('hpsum.baseline.custom.systemrom'));
                    devices = biosItems;
                    $(FW_SELECTTION_TYPE).text(localizer.getString('hpsum.common.bios'));
                } else if(type == "Powerpic" && ppicItems)
                {
                    $(INSTALLED_TYPE_TABLE_HEADER).text(localizer.getString('hpsum.ilofederation.powerpictype'));
                    devices = ppicItems;
                    $(FW_SELECTTION_TYPE).text(localizer.getString('hpsum.common.powerpic'));
                } else if (type == "CPLD" && cpldItems)
                {
                    $(INSTALLED_TYPE_TABLE_HEADER).text(localizer.getString('hpsum.ilofederation.cpldtype'));
                    devices = cpldItems;
                    $(FW_SELECTTION_TYPE).text(localizer.getString('hpsum.common.cpld'));
                }

				var fwListTable = initFWListTable();
				fwListTable.fnClearTable();
				
                if( devices )
                {
                    for (idx = 0; idx < devices.length; idx++) {
                        var obj = devices[idx];
                        fwListTable.fnAddData([{product: obj.product, version: obj.version, count: obj.count}]);
                    }
                }

            }
             
			function initFWListTable() {
				
				if($.fn.DataTable.fnIsDataTable( $(INSTALLED_FW_LIST_TABLE)[0] ))
				{
					$(INSTALLED_FW_LIST_TABLE).dataTable().fnDestroy();	
				}
				
				return $(INSTALLED_FW_LIST_TABLE).dataTable({
                    bPaginate : false,
                    bLengthChange : false,
                    bFilter : true,
                    bSort : true,
                    bInfo : false,
                    bAutoWidth : false,
                    bRetrieve : true,
				    bDestroy : true,
				    aoColumns : [				        
                        {mDataProp: 'product'},
                        {mDataProp: 'version'},
                        {mDataProp: 'count'}
                        ],
                    aaSorting: [[ 0, "desc" ]]
                });
			}
			
			function initSystemsTable() {
				
				if($.fn.DataTable.fnIsDataTable( $(INSTALLED_SYSTEM_TYPE_TABLE)[0] ))
				{
					$(INSTALLED_SYSTEM_TYPE_TABLE).dataTable().fnDestroy();	
				}  
								
				return $(INSTALLED_SYSTEM_TYPE_TABLE).dataTable({
                    bPaginate : false,
                    bLengthChange : false,
                    bFilter : true,
                    bSort : false,
                    bInfo : false,
                    bAutoWidth : false,
                    bRetrieve : true,
				    bDestroy : true,
				    aoColumns : [				        
                        {mDataProp: 'server_model'},
                        {mDataProp: 'count'}
                        ]
                });
			}

            this.init = function() {
            	if(!presenter.initDone)
            		presenter.init();
                noItem = $(noneHtml);
                $(PANELS).hpGridPanels();
				
				$(VERSION_SELECT).selectBox({autoWidth: false});
                $(VERSION_SELECT).on('change',populateFirmwareListTable);

                this.resume();
            };
        }

        return new IloFederationOverviewView();
    }());
    
    return IloFederationOverviewView;
});
