// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
/**
 * @type (DeployDomainView)
 * This is a view class for Integrity iLO deploy domain screen.
 */
define(['hpsum/presenter/node/NodePresenter',
	'hp/core/Notifications',
	'hp/core/Localizer',
	'hp/lib/jquery.hpCollapsible',
    'jquery'],
function(presenter, notifications, localizer) { "use strict";

    var DeployDomainView = (function() { 
    	
    	var DEPLOYBUTTON = '#integrityilo-deploy-domain-ok',
    		CLOSEBUTTON = '#integrityilo-deploy-domain-close',
    		ANALYSISBUTTON = '#integrityilo-deploy-domain-analysis',
    		DOWNGRADECHKBOXCOMP ='.downgradechkbox',
			REWRITECHKBOXCOMP ='.rewritechkbox',
			DOMAININFO_TABLE = '#hpsum-deploy-domain-table',
			DOMAIN_REBOOT_TABLE = '#hpsum-domain-reboot-table',
			NOTIFICATION = '#deploy-domain-notification',
			BASELINES = '#hpsum-deploy-domain-baselines',
			INSTALL_OPTIONS = '#hpsum-deploy-domain-installation-Options',
			REBOOT_OPTIONS = '#hpsum-deploy-domain-reboot-options'; 
			 

        /**
         * Constructor
         */
        function DeployDomainView() {
        	
        	var nodeItem = null;
        	
        	var  installationoptions = {
				force:false,
				downgrade:false,
				rewrite:false												
			};
        	
        	var optiondetails = { 
				hapi: {
					activate_sfw: false,
					installation_option:{
						downgrade: false,
						rewrite:false,
						force:false
					}
            	}
            }
            
            var deploy_count = 0;
            var notification_msg = '';
           
			function onItemChange(item) {
				nodeItem = item.hapi;
				 
				if(nodeItem.domain_deploy_message) {
					notification_msg = nodeItem.domain_deploy_message;
				} else {
					notification_msg = '';
				}
				
				$(DEPLOYBUTTON).attr('disabled','disabled');
				$(ANALYSISBUTTON).attr('disabled','disabled');
				
				populateDomainInfo(nodeItem);
				
				for(var i = 0; i < nodeItem.domain_partitions.length; i++) {
					var par = nodeItem.domain_partitions[i];
					
					if(par.node_id) {
						presenter.getNodeData(par, {
						success: onGetNodeDataSuccess,
						error: onGetNodeDataError
						});
					} else {
						notification_msg = notification_msg + '<p>' + 'Partition not ready to deploy: ' + par.monarchIP + '</p>';
					}					
				}
				
				if(!notification_msg) {
					$(NOTIFICATION).html('The iLO domain is ready to deploy');
					$(BASELINES).show();
					$(INSTALL_OPTIONS).show();
					$(REBOOT_OPTIONS).show();
					
					presenter.otheroption(nodeItem, {
						success: populateOtherOptions,	
						error: onPopulateError
						});
					
					presenter.getbaseline(nodeItem,{
						success : populateBaselines,
						error : onPopulateError
	                    });
	                    
	               	$('.require-analysis').on('click', function(){
	               		$(ANALYSISBUTTON).removeAttr('disabled');
	               		$(DEPLOYBUTTON).attr('disabled','disabled');
	               	});	
	               	
	               	if($('.hp-selected').length > 0){
	               		$(DEPLOYBUTTON).removeAttr('disabled');
	               	}		
				} else {
					showDeployDomainError();
				}
			}
			
			function onGetNodeDataSuccess(item) {
				if(item.hapi.node_state != "UAN" && notification_msg.indexOf(item.hapi.ip) == -1) {
					notification_msg = notification_msg + '<p>' + 'Partition not ready to deploy: ' + item.hapi.ip + '</p>'; 
					showDeployDomainError();
				}
				
				$("input:checkbox.reboot-partition").each(function () {
					if($(this).val() == item.hapi.node_id) {
						if(item.hapi.activate_sfw) {
							$(this).attr('checked', 'checked');
						} else {
							$(this).removeAttr('checked');
						}
					}
				});
			}
			
			function onGetNodeDataError(data, item) {
				if(notification_msg.indexOf(item.monarchIP) == -1) {
					notification_msg = notification_msg + '<p>' + 'Partition not ready to deploy: ' + item.monarchIP + '</p>';
					showDeployDomainError();	
				}
			}
			
			function showDeployDomainError(){
				$(NOTIFICATION).html(notification_msg);
				$(ANALYSISBUTTON).attr('disabled','disabled');
				$(DEPLOYBUTTON).attr('disabled','disabled');
				$(BASELINES).hide();
				$(INSTALL_OPTIONS).hide();
				$(REBOOT_OPTIONS).hide();				
			}
			
			function onPopulateError(errorMessage) {
                notifications.show(errorMessage, 'error');
				$(ANALYSISBUTTON).attr("disabled", 'disabled');
				$(DEPLOYBUTTON).attr("disabled", 'disabled');
				$(CANCEL).trigger('click');
				
            }
            
            function populateDomainInfo(nodeItem) {
            	$(DOMAININFO_TABLE).html('');
            	$(DOMAIN_REBOOT_TABLE).html('');
            	
            	var reboot_count = 0;
            	for(var i = 0; i < nodeItem.domain_partitions.length; i++) {
            		var par = nodeItem.domain_partitions[i];
            		var domain_row = $('<tr></tr>').html('<td>' + par.monarchIP + '</td><td>' + par.number + '</td><td>'+ par.bays + '</td>');
            		
            		if(par.power_on && par.node_id) {
            			var reboot_row = $('<tr></tr>').html('<td><input class=\"reboot-partition require-analysis\" type=\"checkbox\" value=\"' + par.node_id +'\"></td><td>'+ par.monarchIP + '</td><td>' + par.number + '</td><td>'+ par.bays + '</td>');
            			$(DOMAIN_REBOOT_TABLE).append(reboot_row);
            			reboot_count++;	
            		} 		
            		$(DOMAININFO_TABLE).append(domain_row);
            	}
            	if(reboot_count == 0) {
            		$(DOMAIN_REBOOT_TABLE).html('<tr><td colspan=4><i>No partitions require reboot to activate</i></td></tr>');
            	}
            }
			
			//Initialize install review table to add all the components
            function initInstallTable(tableid) {			    
				var oTab = $(tableid).dataTable({
				    bPaginate : false,
				    bProcessing : true,
				    bFilter : false,
				    bSort : false,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
					bServerSide:false,
				    //aaData: data,
				    aoColumns : [
				        {mDataProp: 'name'},
				        {mDataProp: 'product_type', "bVisible": false},
				        {mDataProp: 'product_sub_type', "bVisible": false},
				        {mDataProp: 'installed_version', "bVisible": false},
				        {mDataProp: 'active_version', "bVisible": false},
				        {mDataProp: 'available_version'},						
				        {mDataProp: 'file_name', "bVisible": false},
				        {mDataProp: 'component_id', "bVisible": false}],
				    aaSorting: [[ 0, "asc" ]]
				    });			
			}
			
			function populateBaselines(data)
			{
				//update component table
				var baselineslist = data.hapi.baselines;  
			
				if(baselineslist){
					
					$('#all-baselines').empty();
					
					for(var i=0; i < baselineslist.baseline.length; i++) {
						var currbaseline = baselineslist.baseline[i];
						//Add baselines						
						$('#all-baselines').append('<div class="hp-collapsible" id="baseline'+i+'"><label>'+currbaseline.baseline_name+'</label><div>');
						$('#baseline'+ i).append('<table class="hp-selectable" id="hpsum-deploy-installables'+i+'"><thead><tr><td>' + localizer.getString('hpsum.common.name') + '</td><td>' + localizer.getString('hpsum.common.type') + '</td><td>' + localizer.getString('hpsum.node.family') + '</td><td>' + localizer.getString('hpsum.node.installedVersion') + '</td><td>' + localizer.getString('hpsum.node.activeVersion') + '</td><td>' + localizer.getString('hpsum.node.availableVersion') + '</td><td></td><td></td></tr></thead></table></div></div>');
						var  tableid= '#hpsum-deploy-installables'+i;
						initInstallTable(tableid);	
						
						if(currbaseline.hasOwnProperty("components")) {														
						   
						   var table = $(tableid).dataTable();
						   //Create a component list for the analysis and populate the component table
						  				   
						   for(var j= 0; j < currbaseline.components.component.length; j++) {
								table.fnAddData(currbaseline.components.component[j]);
								if(currbaseline.components.component[j].selected) {
									$(tableid + ' tbody tr').last().addClass('hp-selected');
								}							
						   }
						}
						$('#baseline'+ i).hpCollapsible();
					}
				}	
			}

			function populateOtherOptions(data)	{
				if(data && data.hasOwnProperty("hapi")){
				
					if(data.hapi.hasOwnProperty("installation_option") && data.hapi.installation_option){
						installationoptions.downgrade = data.hapi.installation_option.downgrade;
						installationoptions.rewrite = data.hapi.installation_option.rewrite;
						installationoptions.force = data.hapi.installation_option.force;										
					}				
				}						
				
				$(DOWNGRADECHKBOXCOMP).attr('checked', installationoptions.downgrade);							
				$(REWRITECHKBOXCOMP).attr('checked', installationoptions.rewrite);					
			}
			
			function onDeploy() {				
				for(var i = 0; i<nodeItem.domain_partitions.length; i++) {
					var par = nodeItem.domain_partitions[i];
					presenter.deploy(par, {
						success : onDeploySuccess,
                        error : onDeployError
                    });
				}
			}
			
			function onDeploySuccess(item) {
				deploy_count++;
				if(deploy_count == nodeItem.domain_partitions.length) {
					$(CLOSEBUTTON).trigger('click');	
				}
            }


            function onDeployError(errorMessage) {
            	deploy_count++;
            	if(deploy_count == nodeItem.domain_partitions.length) {
	                notifications.show(errorMessage, 'error');                        				
					$(DEPLOYBUTTON).attr("disabled", 'disabled');				
					$(CLOSEBUTTON).trigger('click');
				}
            }
			
			function onAnalysis() {				
				for(var i = 0; i<nodeItem.domain_partitions.length; i++) {
					var par = nodeItem.domain_partitions[i];
					setoptiondetails(par);
					presenter.setattribute(par,optiondetails, {
                        success : onSetAttributeSuccess,
                        error : onSetAttributeError
                    });                     
                }				
			}
			
			function onSetAttributeSuccess(){
				//Update the node data
				presenter.getNodeData(nodeItem, {success: onItemChange});			
			}
			
			function onSetAttributeError(){
				$(DEPLOYBUTTON).attr("disabled", 'disabled');	
				$(ANALYSISBUTTON).attr("disabled", 'disabled');
			}
			
			function setoptiondetails(partition) {
				
				optiondetails.hapi.installation_option.downgrade =  $(DOWNGRADECHKBOXCOMP).is(':checked');	
				optiondetails.hapi.installation_option.rewrite = $(REWRITECHKBOXCOMP).is(':checked');
				if(optiondetails.hapi.installation_option.downgrade || optiondetails.hapi.installation_option.rewrite){
					optiondetails.hapi.installation_option.force = true;
				} else {
					optiondetails.hapi.installation_option.force = false;
				}
				
				$("input:checkbox.reboot-partition").each(function () {
						if($(this).val() == partition.node_id) {
							if($(this).is(':checked')) {
								optiondetails.hapi.activate_sfw = true;	
							} else {
								optiondetails.hapi.activate_sfw = false;
							}	
						}
				});
			}
			
			
			this.resume = function () {
				presenter.on("itemChange", onItemChange);
            };
            
            this.pause = function() {
            	presenter.off("itemChange", onItemChange);
            };
          
            /**
             * @public
             * Initialization funtion for the object
             * All the controls actions are initialized in this function.
             */
            this.init = function() {
            	
            	$(DEPLOYBUTTON).live('click', function(ev) {
                    onDeploy.call(this);
                    ev.preventDefault();
                });
				 $(ANALYSISBUTTON).live('click', function(ev) {
                    onAnalysis.call(this);
                    ev.preventDefault();
                });
                
            	$(".hp-collapsible").hpCollapsible();
            	this.resume();               					
            };
        }

        return DeployDomainView;
    }());
    
    return new DeployDomainView();
});