// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/node/NodePresenter', 
    'hp/core/UrlFragment',
    'hp/core/Router', 
    'hp/core/Localizer',
    'hp/core/LinkTargetBuilder',
    'text!hpPages/core/no_details.html',
    'jquery',
    'hp/lib/jquery.hpGridPanels'],
function(presenter, urlFragment,router,localizer, linkTargetBuilder, noneHtml) { "use strict";

    var IpduOverviewView = (function() {
      
        var ROOT = '#hpsum-ipdu-show-overview';
        var PANELS = '.hp-grid-panels',
        	DESCRIPTION = '#hpsum-node-description',
        	BASELINE='#hpsum-node-bundle',
        	PAIRED = '#hpsum-ipdu-paired',
        	CORES ='#hpsum-ipdu-cores',
        	COREDETAILS = '#hpsum-ipdu-coredetails',
        	EXTBARDETAILS = '#hpsum-ipdu-extbars-details',
        	NOEXTBAR = '#hpsum-ipdu-no-extbars',
        	SPINNER = '#hpsum-node-progress-spinner',
            INSTALL_LOGS = '#hpsum-ipdu-install-log';
      
        /**
         * Constructor
         */
        function IpduOverviewView() {
          
            var noItem;
            
            function onItemChange(item) {
            	item = item.hapi;
                noItem.remove();
        		
        		item.type = item.type.toLowerCase();
        		var uitype = presenter.getUINodeType(item.type);
        		$(ROOT).closest('section').show();
        		
        		if(!router.location().match(uitype)) {
        		    if(router.location().indexOf("/node") == 0)
        		    	router.go((urlFragment.replaceView(router.location(), 'show/' + item.type + '/overview')));
        		    else {
        		    	$(ROOT).closest('section').hide();
        		      	return;
        		    }
                }
                
                $('a.hp-button' , $(INSTALL_LOGS)).attr('href', '#/' + urlFragment.getPage(router.location()) + '/deploy-results');
                $(INSTALL_LOGS).hide();

        		if(item.node_state.match(/idle/i) && item.node_phase.match(/initialize/i)){
        			$('.hp-grid-panels').css({"display":"none"});
        			 $(SPINNER).show();
        			 presenter.startNodeStatus(item);
        		}
        		else {
        			$(SPINNER).hide();
        			$('.hp-grid-panels').css({"display":""});
        			$('.hp-grid-panels').hpGridPanels('reset');
        			$(DESCRIPTION).text(item.description);
        			if(item.partner_available == undefined)
        				$(PAIRED).text('');
        			else {
        				if(item.partner_available == 'true')
        				{
        					if(item.partner_ip_address_ipv4 == '')
        						$(PAIRED).text(partner_ip_address_ipv6);
        					else
        						$(PAIRED).text(partner_ip_address_ipv4);
        				}
        				else
        					$(PAIRED).text('');
        			}
        			showCoreDetails(item);
        			showExtBarDetails(item);
        			var fwBaseline =presenter.getBaselineOrPkg(item.baselines)
        			if(fwBaseline){
        					var baseline_url = '#/baseline/show/r'+fwBaseline.uri +'/getBaselineData';
        					name = fwBaseline.name;
        					$(BASELINE).html('<a href="'+ baseline_url +'">'+name+ '</a>');
        				}
        			else
        				$(BASELINE).text(localizer.getString('hpsum.node.noBaselineDefined'));  

                    if(item.node_state.match(/installdone/i))
                        $(INSTALL_LOGS).show();

        		}
                $(PANELS).hpGridPanels('reset');
                $(ROOT).removeClass('hp-show-changing');
                $('.hp-dynamic', ROOT).removeClass('hp-unavailable');
            }
            
            function showCoreDetails(item){
            	if(item.cores == undefined)
            		return;
            	if(item.cores.length == 0)
            		return;
				$(CORES).text(item.cores.length);
            	var i,htmlContents="";
            	for(i=0; i<item.cores.length; i++){
            	    htmlContents += '<label>' + localizer.getString('hpsum.common.core') + ' + (i+1) +' +':</label>';
            	    htmlContents += '<ol><li style="margin-bottom: 5px;padding-left:10px;">' + localizer.getString('hpsum.common.model') +': <label style="padding-left:115px;">'+ item.cores[i].model_id +'</label></li>' ;
            	    htmlContents += '<li style="margin-bottom: 5px;padding-left:10px;">' + localizer.getString('hpsum.moonshot.productID') + ': <label style="padding-left:90px;">'+ item.cores[i].product_id +'</label></li>' ;
            	    htmlContents += '<li style="margin-bottom: 5px;padding-left:10px;">' + localizer.getString('hpsum.common.firmwareVersion') + ': <label style="padding-left:50px;">'+ item.cores[i].version +'</label></li>' ;
            	    htmlContents += '<li style="margin-bottom: 5px;padding-left:10px;">' + localizer.getString('hpsum.common.state') + ': <label style="padding-left:120px;">'+ item.cores[i].state +'</label></li>' ;
            		htmlContents += '</ol>';
            	}
            	$(COREDETAILS).html(htmlContents);
            	$('.hp-collapsible').hpCollapsible();
				//$('.hp-collapsible').hpCollapsible('expand');
            }
            
            function showExtBarDetails(item){
            	if(item.cores == undefined)
            		return;
            	if(item.cores.length == 0)
            		return;
            	var i,j,contents="";
            	$(NOEXTBAR).hide();
            	for(i=0; i<item.cores.length; i++){
            		var htmlContents="";
            		htmlContents += '<div class="hp-collapsible"><label>' + localizer.getString('hpsum.common.core') + (i+1) +':</label> <div>';
            		htmlContents += '<table><tr> <td> ' + localizer.getString('hpsum.moonshot.productID') +' </td> <td> ' + localizer.getString('hpsum.common.model') +'</td> <td> ' + localizer.getString('hpsum.common.version') +'</td></tr> ';
            		if(item.cores[i].extbars.length == 0){
            		    htmlContents += '<tr><td>' + localizer.getString('hpsum.ipdu.noExtBars') + '</td></tr> </table> </div>';
            			contents += htmlContents;
            			htmlContents='';
            			continue;
            		}
            		for(j=0; j<item.cores[i].extbars.length; j++){
            			htmlContents += '<tr> <td>' + item.cores[i].extbars[j].product_id + '</td> <td>'
            									+  item.cores[i].extbars[j].model_id +'</td> <td>' 
            									+ item.cores[i].extbars[j].version + '</td></tr>';	
            		}
            		htmlContents += '</table></div>';
					contents += htmlContents ;	
            	}
            	
            	$(EXTBARDETAILS).html(contents);
            	$('.hp-collapsible').hpCollapsible();
				$('.hp-collapsible').hpCollapsible('expand');
            }          
            
            function onItemError(error) {
                $(ROOT).append(noItem);
            }
            
            function onSelectionChange(selection) {
                urlFragment.replaceHrefUris(ROOT, selection.uris);
                if ($(ROOT).hasClass('hp-show-init')) {
                    $(ROOT).removeClass('hp-show-init');
                } else {
                    $(ROOT).addClass('hp-show-changing');
                    $('#hpsum-node-bundle-item').addClass('hp-show-changing');
                }
            }
          
            /**
             * @public
             */
            this.resume = function() {
                $(PANELS).hpGridPanels('reset');
                presenter.on("selectionChange", onSelectionChange);
                presenter.on("itemError", onItemError);
                presenter.on("itemChange", onItemChange);
                
            };
            
            this.pause = function() {
                presenter.off("selectionChange", onSelectionChange);
                presenter.off("itemChange", onItemChange);
                presenter.off("itemError", onItemError);
                
            };
             
            this.init = function() {
            	if(!presenter.initDone)
            		presenter.init();
                noItem = $(noneHtml);
                $(PANELS).hpGridPanels();
                this.resume();
            };
        }

        return new IpduOverviewView();
    }());
    
    return IpduOverviewView;
});
