// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/node/NodePresenter', 
    'hp/core/UrlFragment',
    'hp/core/Router',
    'hp/core/LinkTargetBuilder',
    'text!hpPages/core/no_details.html',
    'hp/core/Localizer',
	'hp/model/Session',
    'jquery',
    'hp/lib/jquery.hpGridPanels'],
function(presenter, urlFragment,router, linkTargetBuilder, noneHtml, localizer, session) { "use strict";

    var moonshotOverviewView = (function() {
      
        var ROOT = '#hpsum-moonshot-show-overview';
        var PANELS = '.hp-grid-panels',
        	DESCRIPTION = '#hpsum-moonshot-description',
        	BASELINE='#hpsum-moonshot-baseline',
        	SPINNER = '#hpsum-node-add-spinner',
            INSTALL_LOGS = '#hpsum-moonshot-install-log',
            CHASSIS_NAME = '#hpsum-moonshot-chassis-name',
            PRODUCT_NAME = '#hpsum-moonshot-product-name',
            PRODUCT_ID = '#hpsum-moonshot-product-id',
            UUID = '#hpsum-moonshot-uuid',
            SERIAL_NUMBER = '#hpsum-moonshot-serial-no',
            BUNDLE_VERSION = '#hpsum-moonshot-bundle-version',
            SWITCH_TABLE = '#hpsum-moonshot-switch-table',
            CARTRIDGE_TABLE = '#hpsum-moonshot-cartridge-table';
            
      
        /**
         * Constructor
         */
        function moonshotOverviewView() {
          
            var noItem;
            var timer= null;
            var thisNode=null;
            
            function onItemChange(item) {
            	item = item.hapi;
            	thisNode =item;
                noItem.remove();
        		
        		item.type = item.type.toLowerCase();
        		var uitype = presenter.getUINodeType(item.type);
        		$(ROOT).closest('section').show();
        		
        		if(!router.location().match(uitype)) {
        		    if(router.location().indexOf("/node") == 0)
        		      router.go((urlFragment.replaceView(router.location(), 'show/' + item.type + '/overview')));
        		    else {
        		      $(ROOT).closest('section').hide();
        		      return;
        		    }
                }
                
                $('a.hp-button' , $(INSTALL_LOGS)).attr('href', '#/' + urlFragment.getPage(router.location()) + '/deploy-results');
                $(INSTALL_LOGS).hide();
        		if(item.node_state.match(/idle/i) && item.node_phase.match(/initialize/i)){
        			$('.hp-grid-panels').css({"display":"none"});
        			 $(SPINNER).show();
        		}
        		else {
        			$(SPINNER).hide();
					$('.hp-grid-panels').css({"display":""});
        			$('.hp-grid-panels').hpGridPanels('reset');     			
        			$(DESCRIPTION).text(item.description);
        			      				
        			if(item.hasOwnProperty('bundle_version')){
        				$(BUNDLE_VERSION).text(item.bundle_version);
						showSwitches(item);	
						showCartridges(item);					
        			}
        			else{
        				$(BUNDLE_VERSION).text('');
        				$(SWITCH_TABLE).hide();
        				$(CARTRIDGE_TABLE).hide();
        			}
        			
                    if(item.hasOwnProperty('serial_number'))
                        $(SERIAL_NUMBER).text(item.serial_number);
                    else 
                        $(SERIAL_NUMBER).text('');
                        
                    if(item.hasOwnProperty('product_id'))
                        $(PRODUCT_ID).text(item.product_id);
                    else
                        $(PRODUCT_ID).text("");
                        
                    if(item.hasOwnProperty('product_name'))
                        $(PRODUCT_NAME).text(item.product_name);
                    else
                        $(PRODUCT_NAME).text("");
                        
                    if(item.hasOwnProperty('chassis_name'))
                        $(CHASSIS_NAME).text(item.chassis_name);
                    else
                        $(CHASSIS_NAME).text("");
                        
                    if(item.hasOwnProperty('uuid'))
                        $(UUID).text(item.uuid);
                    else
                        $(UUID).text("");
        			
        			var fwBaseline =presenter.getFWBaseline(item.baselines)
        			if(fwBaseline){
        					var baseline_url = '#/baseline/show/r'+fwBaseline.uri +'/getBaselineData';
        					name = fwBaseline.name;
        					$(BASELINE).html('<a href="'+ baseline_url +'">'+name+ '</a>');
        				}
        			else
        				$(BASELINE).text(localizer.getString('hpsum.node.noBaselineDefined'));  

                    if(item.node_state.match(/installdone/i))
                        $(INSTALL_LOGS).show();

        		}
                $(PANELS).hpGridPanels('reset');
                $(ROOT).removeClass('hp-show-changing');
                $('.hp-dynamic', ROOT).removeClass('hp-unavailable');
            }
            
			function showSwitches(item) {    
                if(item.switch_info_list.length > 0) {
                    $('#hpsum-moonshot-no-switches').hide();
                    $(SWITCH_TABLE).show();
                    
                    $("#hpsum-moonshot-switch-table > tbody > tr").remove();
                    $("#hpsum-moonshot-switch-table_filter").remove();
                    $("#hpsum-moonshot-switch-table_processing").remove();
                    var switchTable = initSwitchTable();
                    switchTable.fnClearTable();
                    switchTable.fnAddData(item.switch_info_list);
                } else {
                    $(SWITCH_TABLE).hide();
                    $('#hpsum-moonshot-no-switches').show();
                }	
            }
            
            function showCartridges(item) {
                if(item.cartridge_info_list.length > 0) {
                    $(CARTRIDGE_TABLE).show();
                    $('#hpsum-moonshot-no-cartridges').hide();
                    
                    $("#hpsum-moonshot-cartridge-table > tbody > tr").remove();
                    $("#hpsum-moonshot-cartridge-table_filter").remove();
                    $("#hpsum-moonshot-cartridge-table_processing").remove();
                    var cartridgeTable = initCartridgeTable();
                    cartridgeTable.fnClearTable();
                    cartridgeTable.fnAddData(item.cartridge_info_list);
                } else {
                    $(CARTRIDGE_TABLE).hide();
                    $('#hpsum-moonshot-no-cartridges').show();
                }
            }
			
            function getNodeStatus(item){
            	  var moonshottimer = setInterval(function () {
            		
            		presenter.getNodeStatus(item, {
                				success : function(data) {
                    				onmoonshotStatusSuccess(data,moonshottimer);
                    		 	},
                    			error : function(errorInfo) {
                        			onNodeStatusError(errorInfo,moonshottimer);
                    			}
                			});
                			
                }, 3000);
            }
            
            function onmoonshotStatusSuccess(data,moonshottimer){
            	if(thisNode.node_id == data.hapi.node_status.node_id) {
            		if(!data.hapi.node_status.node_phase.match(/initialize/i)){
        				clearInterval(moonshottimer);
        				moonshottimer = 0;
        				presenter.refreshIndexResults();
        			}
        		}
            }   
            function onNodeStatusError(){
            	
            }      
            
            function onItemError(error) {
                $(ROOT).append(noItem);
            }
            
            function onSelectionChange(selection) {
                urlFragment.replaceHrefUris(ROOT, selection.uris);
                if ($(ROOT).hasClass('hp-show-init')) {
                    $(ROOT).removeClass('hp-show-init');
                } else {
                    $(ROOT).addClass('hp-show-changing');
                    $('#tour-server-bundle-item').addClass('hp-show-changing');
                }
            }
            
            function initSwitchTable() {
               return $(SWITCH_TABLE).dataTable({
                    bPaginate : false,
                    bFilter : false,
                    bInfo : false,
                    bAutoWidth : false,
                    bRetrieve : false,
                    bDestroy : true,
                    aoColumns : [
                        {mDataProp: 'slot'},
                        {mDataProp: 'product_name', sWidth: 200},
                        {mDataProp: 'serial_number'},
                        {mDataProp: 'power'},
                        {mDataProp: 'status'}],
                    aaSorting: [],
                    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                        return nRow;
                    }
                });
            }
            
            function initCartridgeTable() {
               return $(CARTRIDGE_TABLE).dataTable({
                    bPaginate : false,
                    bFilter : false,
                    bInfo : false,
                    bAutoWidth : false,
                    bRetrieve : false,
                    bDestroy : true,
                    aoColumns : [
                        {mDataProp: 'slot'},
                        {mDataProp: 'id'},
                        {mDataProp: 'product_name', sWidth: 200},
                        {mDataProp: 'serial_number'},
                        {mDataProp: 'power'},
                        {mDataProp: 'status'}],
                    aaSorting: [],
                    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                        return nRow;
                    }
                });
            }
          
            /**
             * @public
             */
            this.resume = function() {
                $(PANELS).hpGridPanels('reset');
                presenter.on("selectionChange", onSelectionChange);
                presenter.on("itemError", onItemError);
                presenter.on("itemChange", onItemChange);
            };
            
            this.pause = function() {
                presenter.off("selectionChange", onSelectionChange);
                presenter.off("itemChange", onItemChange);
                presenter.off("itemError", onItemError);
            };
             
            this.init = function() {
            	if(!presenter.initDone)
            		presenter.init();
                noItem = $(noneHtml);
                $(PANELS).hpGridPanels();
                this.resume();
            };
        }

        return new moonshotOverviewView();
    }());
    
    return moonshotOverviewView;
});
