// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
/**
 * @type (moonshotView)
 * This is a view class for moonshot
 * Provides functions for showing master pane and its action.
 */
define(['hpsum/model/node/NodeResource',
	'hp/view/MasterPaneView',
	'hpsum/presenter/node/NodePresenter',
	'hp/core/Localizer',
    'jquery',
	'hp/lib/jquery.hpStatus',
    'hp/lib/jquery.hpUtilizationMeter',
    'hp/lib/jquery.hpSafeClone'],
function(resource, MasterPaneView, presenter, localizer) {"use strict";

    var moonshotView = ( function() {
		
		var TYPE = 'moonshot';
		var PAGE = '#hpsum-moonshot-page';

        /**
         * @constructor
         * @type {moonshotView}
         */
        function moonshotView() {

			var masterPaneView = new MasterPaneView();
			var template = null;
			var types = [],
				types_existing =[];
			
			function renderer(indexResult) {
               var item = template.hpSafeClone();
                $('.hp-status', item).hpStatus(indexResult.status, indexResult.changing);
                $('.hp-master-item-name', item).html(indexResult.name);
                $('.hpsum-node-type',item).html(localizer.getString('hpsum.common.type') + ':' + indexResult.type);
                $('.hpsum-node-status',item).html(localizer.getString('hpsum.common.statusStr') + ':' +indexResult.node_status);
                return item;
            }
			
			function getItemUrl(oObj){
								// add Filters
                var types = presenter.getAllNodeTypes();
               	var html = '<li id="hpsum-option-oa" data-id="moonshot" class="hp-selected">' + localizer.getString('hpsum.common.all') + '</li>';
                $('#types', PAGE).html(html);
                
                return oObj.aData.name;
                //Commented the following lines to avoid opening the node in another tab in the browser 
                /*
	    		return '<a href="#/' + TYPE + '/show/r' + oObj.aData.uri + '?f_q=type:moonshot' +
                                    '">' + oObj.aData.name +
                                    '</a>';
				*/
			}
            /**
             * @public
             */
            this.init = function() {
				presenter.init();
                
                template = $('#hpsum-node-item-template').detach().show().attr('id', '');
                
 				presenter.setFilter("type:moonshot");
                
                masterPaneView.init({
                    routePrefix: '/' + TYPE,
                    resource: presenter.resource(),
                    page: $(PAGE),
                    multiSelect: true,
                    addLink: presenter.getAddLink(),
                    dataTableOptions:  {
                        aoColumns : [
                            {fnRender: function (oObj) {
                                return '<div>' + oObj.aData.status +
                                    (oObj.aData.changing ? ' *' : '') +
                                    '</div>';
                            }, mDataProp: 'status'},
                            {fnRender: getItemUrl, mDataProp: 'name'} //,
                            //{mDataProp: 'attributes.model'}
                        ],
                        aaSorting: [[ 1, "asc" ]],
                        fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0) > div', nRow).hpStatus();
                            return nRow;
                        }
                    },
                    gridItemRenderer: renderer
                });
         	   
		 // $('#hpsum-option-oa').trigger('click');
  
            };

            /**
             * @public
             */
            this.pause = function() {
				masterPaneView.pause();
            };

            /**
             * @public
             */
            this.resume = function() {
				masterPaneView.resume();
				presenter.setFilter("type:moonshot");
            };
        }

        return new moonshotView();
    }());

    return moonshotView;
});
