// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
/**
 * @type (NodeAddView)
 * This is a view class for Node Add menu option.
 */

define(['hpsum/presenter/node/NodePresenter',
	'hpsum/presenter/group/GroupPresenter',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/core/HashManager',
    'hp/core/Validator',
    'hp/view/FormStateView',
	'hp/view/DialogView',
    'hp/core/HelpMenu',
	'hp/services/REST',
    'hp/core/Localizer',
	'hp/model/Session',
    'text!hpPages/core/header_help.html',
    'jquery',
	'hpsum/view/node/jquery.hpsumInstallables',
    'hp/lib/jquery.hpStackedPanels',
    'lib/jquery.selectBox',
    'lib/jquery.dataTables',
    'hp/lib/jquery.hpCollapsible',
    'hp/lib/jquery.hpSearchCombo',
    'hp/lib/jquery.hpToggle'],
function(presenter, groupPresenter, router,urlFragment, hashManager, validator, FormStateView, DialogView, helpMenu,rest, localizer,session, headerHelpHtml) { "use strict";
    	
    	var AddView = (function() {
    		var ADD = '#hpsum-node-add',
            	CANCEL = '#hpsum-node-add-close',
				CLOSE = '#hpsum-ipdialog-close',
             	RESET = '#hpsum-node-reset',
				PANEL_SELECTOR = '#hpsum-node-add-panel-selector',
            	FIRST_ANCHOR = PANEL_SELECTOR + ' a[href]:first',
            	PANELS = '#hpsum-node-add-panels',	
           		NAME = '#hpsum-node-name',
           		NAMEERR= '#hpsum-node-name-error',
           		DESC = '#hpsum-node-description',
           		TYPE ='#hpsum-node-type',
           		TYPEERR='#hpsum-node-type-error',
           		ENTER_CRED = '#hpsum-node-cred-details',
				ENTER_LINUX_CRED = '#hpsum-linux-node-cred-details',
           		USERNAME = '#hpsum-node-credential-username',
           		USERNAME_ERR ='#hpsum-node-username-err',
           		PASSWORD = '#hpsum-node-credential-password',
           		PASSWORD_ERR ='#hpsum-node-password-err',
				LINUX_CRED_PANEL = '#hpsum-linux-node-add-credentials',
				LINUXUSERNAME = '#hpsum-linux-node-credential-username',
				LINUXUSERNAME_ERR = '#hpsum-linux-node-username-err',
           		LINUXPASSWORD_ERR = '#hpsum-linux-node-password-err',
				LINUXPASSWORD = '#hpsum-linux-node-credential-password',
           		FORM = '#hpsum-node-add-form',
            	SEARCHER = '#hpsum-node-searcher',
            	BASELINES = '#hpsum-node-add-baselines-search',
            	HOTFIX = '#hpsum-node-add-hotfix-search',
            	COLLAPSE = '#hpsum-node-add-bandwidth',
            	PARTNER_TYPE ='#hpsum-node-add-partner',
            	PARTNER_CRED_PANEL ='#hpsum-node-add-partner-credentials',
            	PARTNER_IP_LABEL = '#hpsum-node-partner-ip',
            	PARTNER_IP_VALUE ='#hpsum-node-partner-ip-value',
            	PARTNER_ENTER_CRED = '#hpsum-node-partner-cred-details',
            	PARTNER_USERNAME = '#hpsum-node-partner-credential-username',
           		PARTNER_PASSWORD = '#hpsum-node-partner-credential-password',
            	ROUTE_PREFIX = '/node/add',
				FIND_NODES_BUTTON = '#hpsum-ip-dialog',
				SEARCH_BUTTON = '#hpsum-node-search',
				IP_DIALOG = '#hpsum-node-ip-dialog',
				IP_FORM_CONTENT = '#hpsum-all-form-content',
				IP_DIALOG_HEADER = '#hp-ip-header',
				IP_DIALOG_FOOTER = '#hp-ip-footer',
				IP_START = '#hpsum-ip-start',
				IP_END = '#hpsum-ip-end',
				NODE_COMP = '#hpsum-node-components',
				SEARCH_NODE = '#hpsum-search-node',
				SEARCH_DIALOG = '#hpsum-search-dialog',
				SEARCH_SPINNER = '#hpsum-search-spinner',
				APPLY_SETTINGS_BUTTON = '#hpsum-apply-settings',
				NODESETTINGS_DIALOG = '#hpsum-node-settings-dialog',
				NODESETTINGS_CRED = '#hpsum-node-settings-cred-details',
           		NODESETTINGS_USERNAME = '#hpsum-node-settings-credential-username',
           		NODESETTINGS_USERNAME_ERR ='#hpsum-node-settings-username-err',
           		NODESETTINGS_PASSWORD = '#hpsum-node-settings-credential-password',
           		NODESETTINGS_PASSWORD_ERR ='#hpsum-node-settings-password-err',
				NODESETTINGS_BASELINE = '#hpsum-node-settings-add-baselines-search',
				NODESETTINGS_HOTFIX = '#hpsum-node-settings-add-hotfix-search',
				NODESETTINGS_ADD = '#hpsum-node-settings-add',
				NODESETTINGS_RESET = '#hpsum-node-settings-reset',
                NODE_SELECTED = '#hpsum-node-comp-selected',
				NODESETTINGS_CANCEL = '#hpsum-node-settings-close',
				IP_ERR = '#hpsum-node-settings-err',
				NODE_ADD_THROBBER = '#hpsum-node-add-throbber',
				ADD_ASSOC_NODES = '#hpsum-node-addassocnodes',
				FEDERATION_GROUP_NAME = '#hpsum-ilo-federation-groupname',
				FEDERATION_GROUP_LABEL = '#hpsum-ilo-federation-grouplabel',
				FEDERATION_GROUP_ERROR = '#hpsum-ilo-federation-grouperror',
				FEDERATION_TYPE_WARNING = '#hpsum-ilo-federation-warning',
				NODE_ADD_TYPE = '#hpsum-node-addType',
				ADD_SINGLE_NODE = '#hpsum-node-addSingleNode',
				ADD_FIND_NODE = '#hpsum-node-findNode',
				ADD_BASELINE = '#hpsum-node-add-baseline',
				ADD_ALREADYEXISTS = '#hpsum-node-add-alreadyExist',
				ADD_CREDENTIALS = '#hpsum-node-add-credentials',
				ADD_ASSOC_NODES = '#hpsum-node-addassocnodes',
				SELECT_GROUP = '#hpsum-node-group-select',
				ADD_GROUP = '#hpsum-node-add-group';
           		
    		function AddView(){
    			
    			var formStateView = new FormStateView(),
					useCurrentCredentials = false,
    				useSudoCredentials = false,
					rootUsername='',
					rootPassword='',
    				partnerUsername='',
    				partnerPassword='',
    				baselines='',
    				hotfixes='',
    				addInProgress = false,
					checkedVal = '',
					nodeSettingsDialog= null,
					node_table,
                    node_data = [],
					nodeIpDialog= null,
					localhostType='';
					var IpdialogContents;
					var nodeSettingsDialogContents;
    			    var node_details = [];
					var selected_nodes = [];
					var added_nodes = [];
			    	var complex_id;
					var searchInProgress = false;
					var progressTimer;
					var ipRangeNodeAdd = false;
    			
    			
    		function changeLocation(location) {
                	
              if (location.length > ROUTE_PREFIX.length) {
                   $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
               	} else {
                   $(PANELS).hpStackedPanels('setFirstPanel');
                }
            }
            	
           function onItemAddSuccess(data) {
			  addInProgress = false;
			  var node_ip = $(NAME).val();
			  if(data.hapi.hcode > 0)
			  {
			  onItemAddError(localizer.getString('hpsum.node.invalidIP'));
			  }
			  else if(data.hapi.hmessage == "The specified node" + " " + node_ip + " " + "already exists.")
			  {
			  onItemAddError(localizer.getString('hpsum.node.duplicateNode'));
			  }
			  else {
			  	/*groupPresenter.editItem({group_id: 'g1'}, {
					nodes : data.hapi.node_id
					}, {
						success : function(data) {},
						error : function(errorMessage) {}
				});
				
			 var userSelectedGroup = $(SELECT_GROUP).val();
			 if (!userSelectedGroup.match(/g1$/i)) {
				groupPresenter.editItem({group_id: $(SELECT_GROUP).val()}, {
					nodes : data.hapi.node_id
					}, {
						success : function(data) {},
						error : function(errorMessage) {}
				});
			}*/ 
				$(NODE_ADD_THROBBER).hide();
				$(ADD).removeAttr("disabled");
				
			  	$(CANCEL).trigger('click');
			  }
           }
		   
		   function onItemsAddSuccess(data) {
			  addInProgress = false;
			  nodeSettingsDialog.cancel();
			  addselected();
			}
			function onAddItemsSuccess(data) {
           $(CANCEL).trigger('click');
		   }
		   function addselected()
           {
             var node_selected_id = '#hpsum-node-selected-table';
			 var node_tableid = '#hpsum-node-table';

             var node_selected_table =  $(node_selected_id).dataTable();
			 var node_table = $(node_tableid).dataTable();
			 
			 for( var j=0;j<selected_nodes.length;j++)
			 {
				added_nodes.push(selected_nodes[j]);
				node_details.pop(selected_nodes[j]);				
			 }
			 if(node_selected_table.length != 0)
				node_selected_table.fnClearTable();
             node_selected_table.fnAddData(added_nodes); 
			 				
			 selected_nodes = [];
			 
			 var nNodes = node_table.fnGetNodes( );
			 var aRow = new Array();
			 for( var i=0;i<nNodes.length;i++)
			 {
				if ( $(nNodes[i]).hasClass('hp-selected') ) 
				{					
					aRow.push($(nNodes[i]).closest('tr')[0]);
				}
			 }
			 
			 for( var j=0;j<aRow.length;j++)
			 {
				node_table.fnDeleteRow(aRow[j]);
			 }
			 nNodes = node_table.fnGetNodes( );
			 
			 $(APPLY_SETTINGS_BUTTON).attr("disabled","disabled");
            }
		   
            function NodeSelectedTable(tableid) {
              
			  var oTab = $(tableid).dataTable({
			  oLanguage: {
			      sEmptyTable: localizer.getString('hpsum.node.noAddedNodes'),
			      sSearch: localizer.getString('hpsum.common.search')
						},
				bPaginate : false,
				bProcessing : true,
				bFilter : false,
				bSort : true,
				bAutoWidth : false,
				bInfo : false,
				bRetrieve : true,
				bDestroy : true,
				//aaData: data,
				aoColumns : [
				{mDataProp: 'node_ip'},
				{mDataProp: 'node_name'}
				],
				aaSorting: [[ 0, "asc" ]],
				fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
					//$(nRow).attr('id', aData.component_file_name);
					return nRow;
            }
          
      });
      }
		   
		   function onItemsAddError(data) {			                
              reset();			  
			  addInProgress = false;			  
           }
           
           function onTypeEdit(){
           		$(TYPEERR).hide();
            	$(TYPE).removeClass("hp-error");
            	$(TYPE).unbind('mousedown', onTypeEdit);
           }
		   function showNodeAddType(){
		   if($(NODE_ADD_TYPE).val().toLowerCase().match(/addSingleNode/i))
		   {
		   $(ADD_SINGLE_NODE).show();
		   $(ADD_FIND_NODE).hide();
		   $(TYPE).selectBox('value', "selectType");
		   $(NODE_ADD_TYPE).selectBox('value', "addSingleNode");
		   $(ADD_BASELINE).show();
		   $(ADD_CREDENTIALS).show();
		   $(ADD_GROUP).show();
		   }
		   else if($(NODE_ADD_TYPE).val().toLowerCase().match(/findNode/i))
		   {
		   $(ADD_SINGLE_NODE).hide();
		   $(ADD_BASELINE).hide();
		   $(ADD_ALREADYEXISTS).hide();
		   $(ADD_CREDENTIALS).hide();
		   $(LINUX_CRED_PANEL).hide();
		   $(PARTNER_CRED_PANEL).hide();
		   $(ADD_GROUP).hide();
		   $(ADD_FIND_NODE).show();
		   }
		   }
           function showPartnerOptions() {
            	//$(TYPE).unbind('mousedown', onTypeEdit);
            	if($(TYPE).val().toLowerCase().match(/Windows/i) ||
            			$(TYPE).val().toLowerCase().match(/Linux/i) ||
            			$(TYPE).val().toLowerCase().match(/hpux/i))
            				$('#hpsum-node-add-alreadyExist').show();
            		else	
            				$('#hpsum-node-add-alreadyExist').hide();
            	
				if($(TYPE).val().toLowerCase().match(/Linux|hpux/i)){
                    if(localhostType.match(/Windows/i)) {
                        $('input[id=hpsum-node-credential-current]').attr("disabled", true);
                        $('#hpsum-node-credential-key-label').html(localizer.getString('hpsum.oneTouchUpdate.enterCredentials'));
                    }
                } else {
                    $('input[id=hpsum-node-credential-current]').attr("disabled", false);
                    $('#hpsum-node-credential-key-label').html(localizer.getString('hpsum.common.enterAdministratorCredentials'));
                }
							
				if($(TYPE).val().toLowerCase().match(/Linux|hpux/i)){
					$(LINUX_CRED_PANEL).css({"display":""});
					$(LINUXUSERNAME).removeClass("hp-error");
					$(LINUXPASSWORD).removeClass("hp-error");
					$(LINUXUSERNAME_ERR).hide();
					$(LINUXPASSWORD_ERR).hide();
					$(ENTER_LINUX_CRED).hide();
					
					var value = $("input[name='hpsum-node-credential']:checked").val();
					
					if(value == 'one'){
						$('input[name="hpsum-linux-node-credential"]').attr("disabled",true);
						$('#hpsum-linux-access-level-label').html(localizer.getString('hpsum.common.linuxcredentialsApplicable'));
					}
					else {
						$('input[name="hpsum-linux-node-credential"]').attr("disabled",false);
						$('#hpsum-linux-access-level-label').html(localizer.getString('hpsum.common.linuxcredentials'));
					}
				}
				else
					$(LINUX_CRED_PANEL).css({"display":"none"});
            		
            	if($(TYPE).val().toLowerCase().match(/sas_switch/i) || 
            		$(TYPE).val().toLowerCase().match(/vc/i) ||
            		$(TYPE).val().toLowerCase().match(/pdu/i)) {
            			if($(TYPE).val().toLowerCase().match(/pdu/i)){
            				$(PARTNER_TYPE).html(localizer.getString('hpsum.common.PartnerIpduCredentials'));
            				$(PARTNER_IP_LABEL).html(localizer.getString('hpsum.common.PartnerIpduIP'));
            			}
            			else{
            				$(PARTNER_TYPE).html(localizer.getString('hpsum.common.associatedOACredentials'));
            				$(PARTNER_IP_LABEL).html(localizer.getString('hpsum.common.associatedOAIp'));
            			}
            				
            			$(PARTNER_CRED_PANEL).css({"display":""});;
            			$('input[name="hpsum-node-partner-credential"]').click(partnerCredentialsOptions);
            			partnerCredentialsOptions("two");
            		
            		}
            	else
            		$(PARTNER_CRED_PANEL).css({"display":"none"});
				
				if($(TYPE).val().toLowerCase().match(/vc/i) ||
            			$(TYPE).val().toLowerCase().match(/sas_switch/i) ||
            			$(TYPE).val().toLowerCase().match(/enclosure/i) ||
						$(TYPE).val().toLowerCase().match(/switch/i) ||
						$(TYPE).val().toLowerCase().match(/ilo/i) &&
						!($(TYPE).val().toLowerCase().match(/ilofederation/i))) 
				{
            				$(ADD_ASSOC_NODES).show();
							$('#hpsum-node-addassoc-description').show();
				}
            	else {	
            			$(ADD_ASSOC_NODES).hide();
						$('#hpsum-node-addassoc-description').hide();
				}
            
            	if($(TYPE).val().toLowerCase().match(/ilofederation/i)) {
					$(FEDERATION_GROUP_NAME).show().focus();
					$(FEDERATION_GROUP_LABEL).show();
					$(FEDERATION_TYPE_WARNING).css('float', 'right').fadeIn();
				} 
				else {
					$(FEDERATION_GROUP_NAME).hide();
					$(FEDERATION_GROUP_LABEL).hide();
					$(FEDERATION_GROUP_ERROR).hide();
					$(FEDERATION_TYPE_WARNING).hide();
				}
           }
           
		   function linuxCredentialOptions(value){
          		if(value.target)
            		value = value.target.value;
				if(checkedVal === value)
				{
					checkedVal = '';
					useSudoCredentials =false;
					if(value ==="one")
						$('#hpsum-linux-node-sudo').attr('checked',false);
					if(value == "two"){
						$(ENTER_LINUX_CRED).hide();
						$('#hpsum-linux-node-root').attr('checked',false);
					}
				}
				else{
					checkedVal = $('input[name="hpsum-linux-node-credential"]:checked').val();
					if(value == "one"){
						$(ENTER_LINUX_CRED).hide();
						useSudoCredentials =true;
					}
					if(value == "two"){
						$(ENTER_LINUX_CRED).show();
						rootUsername = $(LINUXUSERNAME).val();
						rootPassword = $(LINUXPASSWORD).val();
						useSudoCredentials= false;
					}
				}
            }
			
           function partnerCredentialsOptions(value)
           {
           	    if(value.target)
            		value = value.target.value;
            	if(value == "one"){
            		$(PARTNER_ENTER_CRED).hide();
            		partnerUsername= $(USERNAME).val();
            		partnerPassword= $(PASSWORD).val();
            		//useCurrentCredentials =true;
            	}
            	if(value == "two"){
            		$(PARTNER_ENTER_CRED).show();
            	}
           	
           }
           
           function onNameEdit(){
           		$(NAMEERR).hide();
            	$(NAME).removeClass("hp-error");
            	$(NAME).unbind('keyup',onNameEdit);
           }
           
          function onItemAddError(msg) {	
              addInProgress = false;
              $(NAMEERR).text(msg);
              $(NAME).addClass("hp-error");
              $(NAMEERR).show();
              $(NAME).keyup(onNameEdit);
			  $(NODE_ADD_THROBBER).hide();
			  $(ADD).removeAttr("disabled");
           }

           function onFederationGroupEdit(){
           		$(FEDERATION_GROUP_ERROR).hide();
            	$(FEDERATION_GROUP_NAME).removeClass("hp-error");
            	$(FEDERATION_GROUP_NAME).unbind('keyup',onFederationGroupEdit);
           }
           
          function reset() {
				formStateView.reset();
                addInProgress = false;
				searchInProgress = false;
                $(NAMEERR).hide();
                $(PARTNER_CRED_PANEL).css({"display":"none"});;
				$(LINUX_CRED_PANEL).css({"display":"none"});
            	$(NAME).removeClass("hp-error");
				$(NODESETTINGS_USERNAME).removeClass("hp-error");
            	$(NODESETTINGS_PASSWORD).removeClass("hp-error");
            	$(NODESETTINGS_USERNAME_ERR).hide();
            	$(NODESETTINGS_PASSWORD_ERR).hide();
            	$(TYPE).selectBox('value', "selectType");
				$(NODE_ADD_TYPE).selectBox('value', "addSingleNode");
				$(ADD_SINGLE_NODE).show();
				$(ADD_FIND_NODE).hide();
				showNodeAddType();
            	credentialsOptions('two');
            	$(FEDERATION_GROUP_NAME).hide();
				$(FEDERATION_GROUP_LABEL).hide();
				$(FEDERATION_GROUP_ERROR).hide();
				$(FEDERATION_TYPE_WARNING).hide();
            }
            
            function validate()
            {
            	var returnValue;
            	
            	if($(TYPE).val().match(/Linux/i))
					returnValue = validateName($(NAME).val())  &&
            			validateType() && validateCredentials() && validateSudoCredentials();
				else
					returnValue = validateName($(NAME).val())  &&
            			validateType() && validateCredentials();
						
				if ($(TYPE).val().match(/ilofederation/i)) {
					if(!$(FEDERATION_GROUP_NAME).val()) {
						$(FEDERATION_GROUP_NAME).addClass('hp-error');
						$(FEDERATION_GROUP_ERROR).show();
						$(FEDERATION_GROUP_NAME).keyup(onFederationGroupEdit);
						returnValue = false;
					}
				}

            	return returnValue;	
            }

			function initIpdialog()
			{	
				
				nodeIpDialog = new DialogView({contents: IpdialogContents,
                	position : "center",  	
					cancel : function() {
						searchInProgress = false;
						clearInterval(progressTimer);
						$(SEARCH_BUTTON).off('click',btnSearchClicked);
						var resource = router.location().split('/');
                		resource = resource[1];
						hashManager.replaceHash('/'+ resource +'/add');
					}
                 });

				//lets set the ip table form contents max-height
				$(IP_DIALOG).css('max-height',$(window).height() - 40 );
				var maxheight = ($(window).height() - 40) - ($(IP_DIALOG_HEADER).height() + $(IP_DIALOG_FOOTER).height());

				$(IP_FORM_CONTENT).css('max-height',maxheight);

				$(IP_ERR).hide();
				$(IP_START).val('');
				$(IP_END).val('');				
				$(IP_START).removeClass("hp-error");
				$(IP_END).removeClass("hp-error");
		        $(SEARCH_BUTTON).attr("disabled",true);
				$(IP_START).change(function(){
					if(($(IP_START).val() != '') && ($(IP_END).val() != '')){
                        $(IP_ERR).hide();
                        $(IP_START).removeClass("hp-error");
                        $(SEARCH_BUTTON).removeAttr('disabled');
					}
					else
						$(SEARCH_BUTTON).attr("disabled",true);
            		});
				$(IP_END).change(function(){
					if(($(IP_START).val() != '') && ($(IP_END).val() != '')){
						$(IP_ERR).hide();
						$(IP_END).removeClass("hp-error");
						$(SEARCH_BUTTON).removeAttr('disabled');
					}
					else
						$(SEARCH_BUTTON).attr("disabled",true);
            		});
					
				var node_tableid = '#hpsum-node-table';
				initNodeTable(node_tableid);
				var node_table = $(node_tableid, IpdialogContents).dataTable();
				var node_selected_id = '#hpsum-node-selected-table';
				NodeSelectedTable(node_selected_id);
				var node_selected_table =  $(node_selected_id, IpdialogContents).dataTable();
				
				if(node_table.length != 0)
					node_table.fnClearTable();
				if(node_selected_table.length != 0)
					node_selected_table.fnClearTable();
				
				$(APPLY_SETTINGS_BUTTON, IpdialogContents).attr("disabled","true");
				
				$(CLOSE, IpdialogContents).on('click', function () {
					nodeIpDialog.cancel();
				});
				
				$(SEARCH_BUTTON, IpdialogContents).on('click', btnSearchClicked);
			}
			
			function validatefindnodesip(ip){
            	//ipv4 match
            	if(ip == '0.0.0.0' | ip == '255.255.255.255'){
					return "invalid";
            	}
            	var patt = /^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/
            	if(ip.match(patt))
            		return "ip";
            	else{
            		patt = /^((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?$/
            		if(ip.match(patt))
            			return "ipv6";
					else{
            			return "invalid";
            		}
            	}
            		
           }
            
			function validateRangeForLastOctetDiff(startIp,endIp,ipType)
			{
				var onlyLastOctetDiff = false;
				var starIpSplit;
				var endIpSplit;
				//if ip is of type ipv4, split the ip with '.' , extract last octet , compare
				if(ipType == 'ip')
				{
					starIpSplit = startIp.split('.');
					endIpSplit = endIp.split('.');
					if((starIpSplit[0] == endIpSplit[0]) && (starIpSplit[1] == endIpSplit[1]) && (starIpSplit[2] == endIpSplit[2]))
					{
						onlyLastOctetDiff = true;
					}
				}
				//if ip is of type ipv6, split the ip with ':' , extract last octet , compare
				else if(ipType == 'ipv6')
				{
					var index = startIp.lastIndexOf(':');
					var startOctet = startIp.substr(0,index);
					index = endIp.lastIndexOf(':');
					var endOctet = endIp.substr(0,index);
					if(startOctet == endOctet)
					{
						onlyLastOctetDiff = true;
					}
				}
				return onlyLastOctetDiff;
			}
			
			function btnSearchClicked(event)
			{	debugger;
				selected_nodes = [];
				added_nodes = [];
				var startIp = $(IP_START).val();
				var endIp = $(IP_END).val();
				var rangeWithOnlyLastOctetDiff = true;
				var ipstarttype = validatefindnodesip(startIp);
				var ipendtype = validatefindnodesip(endIp);
				if(ipstarttype == ipendtype)
				{
					rangeWithOnlyLastOctetDiff = validateRangeForLastOctetDiff(startIp,endIp,ipstarttype);
				}
				if((ipstarttype === ipendtype) && (!ipstarttype.match(/invalid/i)) && (!ipendtype.match(/invalid/i)) && rangeWithOnlyLastOctetDiff)
				{
					if(!searchInProgress)
					{
						searchInProgress = true;
						showSearchSplash();
						var ip_start = $(IP_START).val();
						var ip_end = $(IP_END).val();
						var max_returns = 50;
						var type = ipstarttype;
						presenter.FindNodes(ip_start,ip_end,max_returns,type, {
								 
							success : function(data) {
							onFindNodesSuccess(data); 
							},
							error : function(errorInfo) {
									onFindNodesError(errorInfo);
								}
						});
					}
				}
				else
				{	
					if(ipstarttype.match(/invalid/i))
						$(IP_START).addClass("hp-error");
					if(ipendtype.match(/invalid/i))
						$(IP_END).addClass("hp-error");

					if(ipstarttype.match(/invalid/i) || ipendtype.match(/invalid/i))
					{
						$(IP_ERR).text(localizer.getString('hpsum.node.invalid'));
					}
					else if(ipstarttype != ipendtype)
					{
						$(IP_ERR).text(localizer.getString('hpsum.node.rangeIpsNotOfSameType'));
					}
					else if(rangeWithOnlyLastOctetDiff == false)
					{
						$(IP_ERR).text(localizer.getString('hpsum.node.rangeNotWithOnlyLastOctetDifferent'));
					}
					
					$(IP_ERR).show();

					$(SEARCH_BUTTON).attr("disabled",true);
				}
                                event.preventDefault();
			}
				
			function onFindNodesSuccess(data)
			{
				var complex_id = data.hapi.complex_id;
				var node_uri = "/Session/" + session.getToken() + "/complex/" + complex_id ;
				
				var node_tableid = '#hpsum-node-table';
			    var node_table = $(node_tableid).dataTable();
				if(node_table.length != 0)
					node_table.fnClearTable();
			
				progressTimer = setInterval(function () {
				
				rest.getURI(node_uri + "/getstatus", {
				            success : function(data) {
							if(data.hapi.command_status === 1)
							{
							
							}
							else if(data.hapi.command_status === 0)
							{
								node_details = [];
                                clearInterval(progressTimer);
                                closeSearchSplash();		
								searchInProgress = false;

								for(var j=0; j<data.hapi.nodes.node.length; j++)
								{                
									var node_data = [{
									'node_name':data.hapi.nodes.node[j].node_name,
									'node_ip':data.hapi.nodes.node[j].node_address,
									}];
									node_table.fnAddData(node_data); 									
								}
								
								$(node_tableid + " tbody tr").click(function(e) 
								{
									node_details = node_table.fnGetData();
									var srcElem;
									//Check if firefox or (chrome and IE)
									if (e.srcElement) 
									{
										//Chrome and IE
										srcElem = e.srcElement;                                    
									} 
									else 
									{
										//Firefox
										srcElem = e.target;                          
									}
									var clickedCellIndex = srcElem.cellIndex
									if (clickedCellIndex === undefined) 
                                        $(APPLY_SETTINGS).attr("disabled",true);
									var bselected = false;									
									
									var nodedetails = node_table.fnGetData( this );
									if ( $(this).hasClass('hp-selected') ) {										
										bselected = false;
									}
									else {
										bselected = true;
									}
									$(this).toggleClass('hp-selected');
									if(bselected)
									{										
										selected_nodes.push(nodedetails);
									}
									else
									{										
										selected_nodes.pop(nodedetails);
									}
									if(selected_nodes.length === 0)
										$(APPLY_SETTINGS_BUTTON).attr("disabled",true);
									else
										$(APPLY_SETTINGS_BUTTON).removeAttr("disabled");
								});
							}							
							},
							error : function(errorInfo) {							
							}
						});
		          }, 3000);
			}
			
			function initNodeTable(tableid) 
			{            	
  				var oTab = $(tableid).dataTable({
					oLanguage: {
					    sEmptyTable: localizer.getString('hpsum.node.noFoundNodes'),
					    sSearch: localizer.getString('hpsum.common.search')
							},
				    bPaginate : false,
				    bProcessing : true,
				    bFilter : true,
				    bSort : true,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
				    //aaData: data,
				    aoColumns : [
						{mDataProp: 'node_ip'},
						{mDataProp: 'node_name'}
					  ],
					aaSorting: [[ 0, "asc" ]],
				    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        //$(nRow).attr('id', aData.component_file_name);
				        return nRow;
					}
					
			});
			}
			
			function showSearchSplash(){
				
				 $(SEARCH_DIALOG).dialog({
			        modal : true,
			        position : "center",
			        draggable : false,
			        resizable : false,
			        show : 'fade',
			        dialogClass : 'hp-splash-dialog',
			        width : 400
			    });
			    
			    $(SEARCH_SPINNER).show();	
			}
			
			function closeSearchSplash()
			{
			$(SEARCH_SPINNER).hide();
			$(SEARCH_DIALOG).dialog('destroy');
			}
			
			function onFindNodesError(errorInfo)
			{
			    searchInProgress = false;
			    $(IP_ERR).text(errorInfo);
			    $(IP_ERR).show();
				$(SEARCH_SPINNER).hide();
				$(SEARCH_DIALOG).dialog('destroy');
			}
			
			function initnodeSettingsDialog(selected_nodes)
			{
				$(NODESETTINGS_RESET).click();
				//reset.call();
				var useCurrentCredentials = false;
				nodeSettingsDialog =  new DialogView({contents: nodeSettingsDialogContents,
                	position : "center", 
					cancel: function () { }
                    });
					
				presenter.getAllBaselines({
           					success:getBaselinesSuccess,
           					error: getBaselinesError
           			});
                                  
				$(NODESETTINGS_ADD, nodeSettingsDialogContents).live('click', function(ev) {
						var node_tableid = '#hpsum-node-table';
						var node_table = $(node_tableid).dataTable();
						var nNodes = node_table.fnGetNodes( );
						var aRow = [];
						for( var i=0;i<nNodes.length;i++)
						{
							if ( $(nNodes[i]).hasClass('hp-selected') ) 
							{
								var nodedetails = node_table.fnGetData( nNodes[i] );
								aRow.push(nodedetails);
							}
						}
                   		onNodeSettingsAddItem.call(this,aRow);
                    	ev.preventDefault();
				});
				
				$(NODESETTINGS_CANCEL,nodeSettingsDialogContents).on('click', function () {
                    nodeSettingsDialog.cancel();
                });
				$(NODESETTINGS_BASELINE).hpSearchCombo({getResults:getBaseline});
				$(NODESETTINGS_HOTFIX).hpSearchCombo({getResults: getHotfixes});
				$(NODESETTINGS_RESET, nodeSettingsDialogContents).live('click', function() {
					reset.call();
				});
				$('input[name="hpsum-node-settings-credential"]').click(nodesettingscredentialsOptions);
            	$('#hpsum-node-add-alreadyExist').hide();
				$('#hpsum-node-settings-credential-key').attr('checked',true);
            	nodesettingscredentialsOptions('two');
				$(NODESETTINGS_USERNAME).val('');
            	$(NODESETTINGS_PASSWORD).val('');
            	$(NODESETTINGS_USERNAME).removeClass("hp-error");
            	$(NODESETTINGS_PASSWORD).removeClass("hp-error");
            	$(NODESETTINGS_USERNAME_ERR).hide();
            	$(NODESETTINGS_PASSWORD_ERR).hide();
				$('#hpsum-node-settings-close', nodeSettingsDialogContents).click(function () {
                    router.go(urlFragment.replaceView(router.location(), 'show'));
                });
				 
			}
            
            function validateType(){
            	if($(TYPE).val().match(/Select Type/i)){
            		$(TYPEERR).text(" \t !Please select a type");
            		$(TYPE).bind('mousedown', onTypeEdit);
            		$(TYPEERR).show();
            		return false;
            	}
            	return true;	
            }
            
            function validateCredentials(){
            	if($('input[name="hpsum-node-credential"]:checked').val() == "one")
            		return true;
            	var success = true;
            	if($(USERNAME).val() == ''){
            		$(USERNAME).addClass("hp-error");
            		$(USERNAME_ERR).show();
            		$(USERNAME).bind('keyup', function(){
            			$(USERNAME_ERR).hide();
            			$(USERNAME).removeClass('hp-error');
            		});
            		success= false;
            	}
            	if($(PASSWORD).val() == ''){
            		$(PASSWORD).addClass("hp-error");
            		$(PASSWORD_ERR).show();
            		$(PASSWORD).bind('keyup', function(){
            			$(PASSWORD_ERR).hide();
            			$(PASSWORD).removeClass('hp-error');
            		}); 
            		success= false;
            	}
            	return success;
            }
            
			function validateSudoCredentials(){
				var value = $('input[name="hpsum-linux-node-credential"]:checked').val();
				if((value == "one") || (value == "none") || (value == undefined))
            		return true;
            	var success = true;
            	if($(LINUXUSERNAME).val() == ''){
            		$(LINUXUSERNAME).addClass("hp-error");
            		$(LINUXUSERNAME_ERR).show();
            		$(LINUXUSERNAME).bind('keyup', function(){
            			$(LINUXUSERNAME_ERR).hide();
            			$(LINUXUSERNAME).removeClass('hp-error');
            		});
            		success = false;
            	}
            	if($(LINUXPASSWORD).val() == ''){
            		$(LINUXPASSWORD).addClass("hp-error");
            		$(LINUXPASSWORD_ERR).show();
            		$(LINUXPASSWORD).bind('keyup', function(){
            			$(LINUXPASSWORD_ERR).hide();
            			$(LINUXPASSWORD).removeClass('hp-error');
            		}); 
            		success= false;
            	}
            	return success;
			}
	    
	    	function validateNodeSettingsCredentials(){
            	if($('input[name="hpsum-node-settings-credential"]:checked').val() == "one")
            		return true;
            	var success = true;
            	if($(NODESETTINGS_USERNAME).val() == ''){
            		$(NODESETTINGS_USERNAME).addClass("hp-error");
            		$(NODESETTINGS_USERNAME_ERR).show();
            		$(NODESETTINGS_USERNAME).bind('keyup', function(){
            			$(NODESETTINGS_USERNAME_ERR).hide();
            			$(NODESETTINGS_USERNAME).removeClass('hp-error');
            		});
            		success= false;
            	}
            	if($(NODESETTINGS_PASSWORD).val() == ''){
            		$(NODESETTINGS_PASSWORD).addClass("hp-error");
            		$(NODESETTINGS_PASSWORD_ERR).show();
            		$(NODESETTINGS_PASSWORD).bind('keyup', function(){
            			$(NODESETTINGS_PASSWORD_ERR).hide();
            			$(NODESETTINGS_PASSWORD).removeClass('hp-error');
            		}); 
            		success= false;
            	}
            	return success;
            }
			
            function validateIPHiphenRange(ip, errorstr){
				var iprange = ip.split("-");
				if(iprange.length>2){
					errorstr.val = localizer.getString('hpsum.node.iprangeError1');
					return false;
				}
				var strtIP = iprange[0].substring(iprange[0].lastIndexOf(".")+1);
				var endIP = iprange[1].substring(iprange[1].lastIndexOf(".")+1);
				if(strtIP==endIP){
					errorstr.val = localizer.getString('hpsum.node.iprangeError2');
					return false;
				}
				else if(strtIP>endIP){
					errorstr.val = localizer.getString('hpsum.node.iprangeError3');
					return false;
				}
				var firstThreeSubnetStrtIP = iprange[0].substring(0, iprange[0].lastIndexOf("."));
				var firstThreeSubnetEndIP = iprange[1].substring(0, iprange[1].lastIndexOf("."));
				if(firstThreeSubnetStrtIP != firstThreeSubnetEndIP){
					errorstr.val = localizer.getString('hpsum.node.iprangeError4');
					return false;
				}
				for(var j=0;j<iprange.length;j++){
					if(!validateName(iprange[j]))
					return false;
				}
				return true;
			}
            
			function validateName(ip){			
				if(ip == ''){
					onItemAddError(localizer.getString('hpsum.node.required'));
					return false;
				}
				
				if(ip.indexOf(",")>=0 || ip.indexOf("-")>=0)//IP range has been entered
				{
					ipRangeNodeAdd = true;
					ip=ip.replace(/ /g,'');
					var ips = ip.split(",");
					for(var i=0;i<ips.length;i++){
						if(ips[i].indexOf("-")>=0){
							var errorstr={};
							if(!validateIPHiphenRange(ips[i], errorstr) && !isDNSName(ips[i])) {
								onItemAddError(errorstr.val);
								return false;
							}
						}
						else if(!validateName(ips[i])) {
							return false;
						}
					}
					
					return true;
				}
				
				
            	if(ip.toLowerCase() == 'localhost')
            		return true;
            		//ipv4 match
            	if(ip == '0.0.0.0' | ip == '255.255.255.255'){
            		onItemAddError(localizer.getString('hpsum.node.ipCannotBe') + ' ' + ip);
            		return false;
            	}
            	var patt = /^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
            	if(ip.match(patt))
            		return true;
            	else{
            		patt = /^((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))?$/;
            		if(ip.match(patt))
            			return true;
                    patt = /^[a-zA-Z0-9-_]+(\.[a-zA-Z0-9-_]+)*\.([a-zA-Z]{2,4})$/;
                    //FQDN match
                    if(ip.match(patt))
                        return true;                           
            		else{
            			//check for unqualified domain name or netbios hostname
            			var hostnamepatt = "^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\-]*[a-zA-Z0-9])\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\-]*[A-Za-z0-9])$";
            			if(ip.match(hostnamepatt))
                        	return true;
                        	
            			onItemAddError(localizer.getString('hpsum.node.notValidIpOrDns'));
            			return false;
            		}
            	}
            		
           }
           
           function isValidIP(ip) {
           		var pattern = /^((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))?$/;
           		if(ip.match(pattern))
           			return true;
           			
           		return false;	
           }
           
           function isDNSName(ip) {
           	
           		var patt = /^[a-zA-Z0-9-_]+(\.[a-zA-Z0-9-_]+)*\.([a-zA-Z]{2,4})$/;
               	//FQDN match
                if(ip.match(patt))
                    return true;                           
        		else {
        			//check for unqualified domain name or netbios hostname
        			var hostnamepatt = "^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\-]*[a-zA-Z0-9])\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\-]*[A-Za-z0-9])$";
        			if(ip.match(hostnamepatt))
                    	return true;
               }

				return false;
           }
           
           function computeIPHiphenRange(nodeIPs, ip)
			{
				var strtEndIP = ip.split("-");
				var tmp = [];
				tmp = findRange(strtEndIP);
				var length = nodeIPs.length+tmp.length;
				var k=0;
				for(var j=nodeIPs.length; j<length; j++)
				nodeIPs[j]=tmp[k++];
				return nodeIPs;
			}		   
		function onAddItem() {
        	if(validate()){
            	var nodeType, assocnodeType='';
		var nodeIPs = [];
            	var iloFederationGroupName = '';
            	switch ($(TYPE).val().toLowerCase()){
            		case "vmware":
            				nodeType = 'vmware';
            				break;
            		case "enclosure":
            				nodeType = 'oa';
            				break;
					case "sd2":
            				nodeType = 'sd2';
            				break;
					case "moonshot":
            				nodeType = 'moonshot';
            				break;
            		case "sas_switch":
            				nodeType = 'sas_switch';
            				assocnodeType = 'oa';
            				break;
            		case "switch":
            				nodeType = 'fc_switch';
            				break;
            		case "pdu":
            				nodeType = 'ipdu';
            				assocnodeType = 'ipdu';
            				break;
            		case "vc":
            				nodeType = 'virtual_connect';
            				assocnodeType  = 'oa';
            				break;
            		case "ilofederation":
            				nodeType = "ilo_federation";
            				iloFederationGroupName = $(FEDERATION_GROUP_NAME).val();
            				break;
            		default:
            			nodeType = $(TYPE).val().toLowerCase();
            			break;
            	}
            	var baselineJson = [];
            	if(($(BASELINES).val() != '' ) && ($(HOTFIX).val() != '')){
					baselineJson.push($(BASELINES).val());
            		baselineJson.push($(HOTFIX).val());
            	}else if($(BASELINES).val() == ''){
            		baselineJson.push($(HOTFIX).val());
            	}else {
            		baselineJson.push($(BASELINES).val());
            	}
            	
            	var assocTargetDetails = null;
            	var pUsername, pPassword;
				if(nodeType.match(/virtual_connect|sas_switch|ipdu/))
            	{
            		var value = $("input[name='hpsum-node-partner-credential']:checked").val(); 
            			if(value == "one"){
            				pUsername = $(USERNAME).val();
            				pPassword = $(PASSWORD).val();
            			}else {
            				pUsername = $(PARTNER_USERNAME).val();
            				pPassword = $(PARTNER_PASSWORD).val();
            			}
            			
            		assocTargetDetails = {
            				ip: $(PARTNER_IP_VALUE).val(),
            				type :assocnodeType,
            				username : pUsername,
            				password : pPassword
            		};
            	}
				
				var susername,spassword;
				if(nodeType.match(/Linux|hpux/i)){
					if(useSudoCredentials){
						susername = "";
						spassword = "";
					}
					else{
						susername = $(LINUXUSERNAME).val();
						spassword = $(LINUXPASSWORD).val()
					}
				}
				//var auto_add_associated_nodes = $("input[name='hpsum-node-autoadd']:checked").val();
				var auto_add_assoc_nodes;
				if(nodeType.match(/virtual_connect|sas_switch|oa|fc_switch|ilo/i)){
					if($(ADD_ASSOC_NODES).is(':checked'))
						auto_add_assoc_nodes = true;
					else
						auto_add_assoc_nodes = false;
				}
            	
            	var node_skip = $("input[name='hpsum-node-active']:checked").val();
            	if(node_skip == "one")
            		node_skip = true;
            	else 
            		node_skip = false;
        		var node_object = {
						hapi:{
							nodes:{
								node:[]
							}
						}
					};
			
				var ipRange = $(NAME).val().toLowerCase();
				ipRange=ipRange.replace(/ /g,'');
				var ips = ipRange.split(",");
				for(var i=0;i<ips.length;i++){
					if(ips[i].indexOf("-")>=0) {
						var nodes = [];
						nodes = computeIPHiphenRange(nodes, ips[i]);
						if(nodes.length <= 0 && isDNSName(ips[i])) {
							nodeIPs.push(ips[i]);	
						}
						else
						{
							nodeIPs.push.apply(nodeIPs, nodes);	
						}
					}		
					else
						nodeIPs.push(ips[i]);
				}
				
				var baselineinfo = {
					baseline:[]
					};
				for (var tmp = 0; tmp < baselineJson.length; tmp++) {
					if(baselineJson[tmp]){
						var baselinedetails = presenter.getBaselineDetailsforId(baselineJson[tmp]);
						var baselinedata = {
								uri:baselinedetails.location,
								bundle_name:baselinedetails.bundleid
							};
						baselineinfo.baseline.push(baselinedata);
					}
				}
				if(nodeIPs.length == 1)
				{
					$(ADD).attr("disabled", "disabled");
					$(NODE_ADD_THROBBER).show();
					presenter.addItem({
							category: nodeType,
							name: $(NAME).val().toLowerCase(),
							description: $(DESC).val(),
							status: 'Init',
                                                        ilo_federation: { group_name: iloFederationGroupName },
							username: $(USERNAME).val(),
							password: $(PASSWORD).val(),
							group: $(SELECT_GROUP).val(),
							su_username: susername,
							su_password: spassword,
							use_sudo: useSudoCredentials,
							baseline: baselineJson,
							associated_node:assocTargetDetails,
                                                        use_current_credentials : useCurrentCredentials,
							stateDetails: null,
							node_skip: node_skip,
							auto_add_assoc_nodes: auto_add_assoc_nodes,
							uri:null,
							phase: null,
							index:null,
							}, true,{
								success : onItemAddSuccess,
								error : onItemAddError
						});
				} else {
					for (var i = 0; i < nodeIPs.length; i++) {
						var node = {
							ip : nodeIPs[i],
							name:$(NAME).val().toLowerCase(),
							selected :true,
							baselines : baselineinfo,
							group: $(SELECT_GROUP).val(),
							ilo_federation: { group_name: iloFederationGroupName },
							description: $(DESC).val(),
							type: nodeType,
							category: nodeType,
							uri:null,
							phase: null,
							index:null,
							associated_node:assocTargetDetails,
							stateDetails: null,
							node_skip: node_skip,
							authentication :{
								username : $(USERNAME).val(),
								password : $(PASSWORD).val(),
								use_current_credentials : useCurrentCredentials,
								su_username: susername,
								su_password: spassword,
								use_sudo: useSudoCredentials,
								auto_add_assoc_nodes : auto_add_assoc_nodes
							}
						};  
						node_object.hapi.nodes.node.push(node);
					}
					
				  if(! addInProgress) {
						addInProgress = true;
						presenter.addItems(node_object, true, {
								success : onAddItemsSuccess,
								error : onItemsAddError
						});                        
						}
					}
				}
    		}	
    		
			function findRange(strtEndIP){
				var range = [], j=0;
				var strtIP = strtEndIP[0].substring(strtEndIP[0].lastIndexOf(".")+1);
				var endIP = strtEndIP[1].substring(strtEndIP[1].lastIndexOf(".")+1);
				var firstThreeSubnet = strtEndIP[0].substring(0, strtEndIP[0].lastIndexOf("."));
				for(var i = strtIP; i<=endIP; i++)
				{
					range[j++] = firstThreeSubnet + "." + i;
				}
				return range;
			}
			
			function onNodeSettingsAddItem(selected_nodes) {
        	if(validateNodeSettingsCredentials()){
				var node_object = {
						hapi:{
							nodes:{
								node:[]
							}
						}
					};
            	var baselineJson = [];
            	if(($(NODESETTINGS_BASELINE).val() != '' ) && ($(NODESETTINGS_HOTFIX).val() != '')){
					baselineJson.push($(NODESETTINGS_BASELINE).val());
            		baselineJson.push($(NODESETTINGS_HOTFIX).val());
            	}else if($(NODESETTINGS_BASELINE).val() == ''){
            		baselineJson.push($(NODESETTINGS_HOTFIX).val());
            	}else {
            		baselineJson.push($(BASELINES).val());
            	}

				var baselineinfo = {
						baseline:[]
						};
				for (var tmp = 0; tmp < baselineJson.length; tmp++) {
					if(baselineJson[tmp]){
						var baselinedetails = presenter.getBaselineDetailsforId(baselineJson[tmp]);
						var baselinedata = {
								uri:baselinedetails.location,
								bundle_name:baselinedetails.bundleid
							};
						baselineinfo.baseline.push(baselinedata);
					}
				}
            
				for (var i = 0; i < selected_nodes.length; i++) {
					var node = {
						ip : selected_nodes[i].node_ip,
						selected :true,
						baselines : baselineinfo,
						authentication :{
							username : $(NODESETTINGS_USERNAME).val(),
							password : $(NODESETTINGS_PASSWORD).val(),
							use_current_credentials : useCurrentCredentials,
							auto_add_assoc_nodes : false
						}
					};  
					node_object.hapi.nodes.node.push(node);

				}

				if(! addInProgress) {
              		addInProgress = true;
                    presenter.addItems(node_object, true, {
                        	success : onItemsAddSuccess,
                        	error : onItemsAddError
                    });
                        
                    }
				}

    		}

    		function baselinesAvailable(data){
    			//data = {count: data.count, members: data};
            //	$(BASELINES).hpSearchCombo({getResults: presenter.getResults});
            }
            
            function getBaseline(string, handlers){
            	var results=[];
            		if (string && string.length > 0) {
              			 results =
                		    $.grep(baselines, function(option, index) {
                    		    return (option.name.match(
                  	         			 new RegExp(string, 'i')));
                  		  });	
           			 }
            		handlers.success({count: results.length, members: results});
        	}
          
          	function getHotfixes(string, handlers){
          		  	var results=[];
            		if (string && string.length > 0) {
              			 results =
                		    $.grep(hotfixes, function(option, index) {
                    		    return (option.name.match(
                  	         			 new RegExp(string, 'i')));
                  		  });	
           			 }
            		handlers.success({count: results.length, members: results});
          	}
            
            function getBaselinesSuccess(searchResults)
            {
            		baselines = $.grep(searchResults, function (option, index ) {
        				return !(option.name.match(new RegExp('^Additional', 'i')));
        			});
        			hotfixes = $.grep(searchResults, function (option, index) {
        				return (option.name.match(new RegExp('^Additional', 'i')));
           			});
            }
            
            function getBaselinesError(msg)
            {
            	
            }
            
            function credentialsOptions(value){
          		if(value.target)
            		value = value.target.value;
            	if(value == "one"){
            		$(ENTER_CRED).hide();
            		useCurrentCredentials =true;
            		if($(TYPE).val().toLowerCase().match(/Linux/i))
            		{
            			$('input[name="hpsum-linux-node-credential"]').attr("disabled",true);
            			$('#hpsum-linux-access-level-label').html(localizer.getString('hpsum.common.linuxcredentialsApplicable'));
            		}
            	}
            	if(value == "two"){
            		$(ENTER_CRED).show();
            		$(USERNAME).removeClass("hp-error");
            		$(PASSWORD).removeClass("hp-error");
            		useCurrentCredentials= false;
            		if($(TYPE).val().toLowerCase().match(/Linux/i))
            		{
            			$('input[name="hpsum-linux-node-credential"]').attr("disabled",false);
            			$('#hpsum-linux-access-level-label').html(localizer.getString('hpsum.common.linuxcredentials'));
            		}
            	}
            		
            }
            
			function nodesettingscredentialsOptions(value){
          		if(value.target)
            		value = value.target.value;
            	if(value == "one"){
            		$(NODESETTINGS_CRED).hide();
            		useCurrentCredentials =true;
            	}
            	if(value == "two"){
            		$(NODESETTINGS_CRED).show();
            		$(NODESETTINGS_USERNAME).removeClass("hp-error");
            		$(NODESETTINGS_PASSWORD).removeClass("hp-error");
            		useCurrentCredentials= false;
            	}
            		
            }
            
            function getlocalhostType(data) {
                for (var i=0; i< data.hapi.output_data.nodes.node.length; i++) {
                    if(data.hapi.output_data.nodes.node[i].node_name === 'localhost')
                    {
                        localhostType = data.hapi.output_data.nodes.node[i].type;
                    }
                }
            }
            
     
            
    			this.init = function() {
    				var resource = router.location().split('/');
                	resource = resource[1];
                	if(resource === 'node')
                		$(TYPE).val("Unknown");
                	else
                		$(TYPE).val(resource);
                		
                	$(TYPE).selectBox({autoWidth: false});
					$(NODE_ADD_TYPE).selectBox({autoWidth: false});
    				
    				 $('a[data-panel-id]').each(function(index) {
                		var currentLink = $(this).attr('href');
                		if(currentLink  == undefined)
                			return;
                		var current = currentLink.split('/');
                		current[1] = resource;
                		currentLink =current.join('/');
                		$(this).attr('href',currentLink);
  					});
					IpdialogContents = $(IP_DIALOG).detach().show();
					nodeSettingsDialogContents = $(NODESETTINGS_DIALOG).detach().show();
					
					$(APPLY_SETTINGS_BUTTON, IpdialogContents).on('click', function (event) 
					{
						initnodeSettingsDialog(selected_nodes);
                                                event.preventDefault();
					});
					
					$(FIND_NODES_BUTTON).live('click', function(ev) {
                        initIpdialog.call(this);
                        ev.preventDefault();
                    });
					
					$("input").bind("keydown", function(event) {
                    var keycode = (event.keyCode ? event.keyCode : (event.which ? event.which : event.charCode));
                    if (keycode == 13) { // keycode for enter key
                        $(ADD).trigger('click');
                        event.preventDefault();
                      }
                    });

                	$(PANELS).hpStackedPanels({
                    	panelSelector : PANEL_SELECTOR
                	});
                	$('input[name="hpsum-node-credential"]').click(credentialsOptions);
             		$('input[name="hpsum-linux-node-credential"]').click(linuxCredentialOptions);
              		$(CANCEL).live('click', function() {
						var resource = router.location().split('/');
                		resource = resource[1];
						hashManager.replaceHash('/'+ resource +'/show');
                	});
                	ROUTE_PREFIX = '/'+ resource +'/add';
                	formStateView.init({form: FORM,
                    	routePattern: ROUTE_PREFIX + '.*',
                    	autoTrack: false});


		// put help in header
                if ($('.hp-details-header-controls', $(FORM).parent()).length === 0) {
                    var headerHelp = $(headerHelpHtml);
                    localizer.localizeDom(headerHelp);
                    $('.hp-details-header', $(FORM).parent()).append(headerHelp);
                }
                
                    presenter.getAllNodes({
                        success: function(data) {
                                    getlocalhostType(data);
                                },
                        error : function(errorInfo) {
                                }
                    });

           			presenter.getAllBaselines({
           					success:getBaselinesSuccess,
           					error: getBaselinesError
           			});
                                  
                	$(ADD).live('click', function(ev) {
                   		onAddItem.call(this);
                    	ev.preventDefault();
                	});
                	$(BASELINES).hpSearchCombo({getResults:getBaseline});
                	$(HOTFIX).hpSearchCombo({getResults: getHotfixes});
                	$(RESET).live('click', function() {
                    	reset.call();
                	});
                
                $(FEDERATION_GROUP_NAME).hide();
					$(FEDERATION_GROUP_LABEL).hide();
					$(FEDERATION_GROUP_ERROR).hide();
					$(FEDERATION_TYPE_WARNING).hide();

                this.resume();
            };
            
            this.resume = function () {
				reset();
				$(NODE_ADD_THROBBER).hide();
				groupPresenter.getGroupIndex({
					success: function(data){
						var groups = []; 
						groups = data.hapi.output_data.groups.group;
						if (groups.length > 0) {
							$(SELECT_GROUP).html('');
							$.each(groups, function(i, data) {
								$(SELECT_GROUP).append('<option value="' + data.group_id + '">' + data.group_name + '</option>');
							});
							$(SELECT_GROUP).selectBox({autoWidth: false});
							$(SELECT_GROUP).selectBox('reset'); 
						} 
					},
					error: function(erroData){		
					}
				});
            	var resource = router.location().split('/');
                	resource = resource[1];
                	if(resource)
					{
                    }	
					else
					{
					$(TITLE).text('');
                    }
            		$('a[data-panel-id]').each(function(index) {
                		var currentLink = $(this).attr('href');
                		if(currentLink  == undefined)
                			return;
                		var current = currentLink.split('/');
                		current[1] = resource;
                		currentLink =current.join('/');
                		$(this).attr('href',currentLink);
  					});
  					ROUTE_PREFIX = '/'+ resource +'/add';
  				router.watch('node add section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});
            	 $(RESET).trigger('click');
            	 $(NAMEERR).hide();
            	 $('input[name="hpsum-node-credential"]').click(credentialsOptions);
            	 $('#hpsum-node-add-alreadyExist').hide();
            	 credentialsOptions('two');
            	 $(NAME).removeClass("hp-error");
            	 $(USERNAME).removeClass("hp-error");
            	 $(PASSWORD).removeClass("hp-error");
            	 $(TYPEERR).hide();
            	 $(USERNAME_ERR).hide();
            	 $(PASSWORD_ERR).hide();
				 $(ADD_ASSOC_NODES).hide();
				 $('#hpsum-node-addassoc-description').hide();
				 $(LINUX_CRED_PANEL).css({"display":"none"});
            	 $(PARTNER_CRED_PANEL).css({"display":"none"});
            	 $(TYPE).bind('change', showPartnerOptions);
				 $(NODE_ADD_TYPE).bind('change', showNodeAddType);
            	 $(TYPE).removeClass("hp-error");
            	  	presenter.getAllBaselines({
           					success:getBaselinesSuccess,
           					error: getBaselinesError
           			});
           			if(resource)
					{
						if (resource == 'node') {
							//$(TYPE).selectBox('value', 'unknown');
						} else if (resource == 'server') {
							$(TYPE).selectBox('value', 'windows');
						}else {
							$(TYPE).selectBox('value', resource.toLowerCase());
						}
						showPartnerOptions();
                    }	
            };
      
      		$(FEDERATION_GROUP_NAME).hide();
			$(FEDERATION_GROUP_LABEL).hide();
			$(FEDERATION_GROUP_ERROR).hide();
			$(FEDERATION_TYPE_WARNING).hide();      
      
            this.pause = function () {
             //   formStateView.reset();
             $(BASELINES).hpSearchCombo('set', {id:'', name: ''});
             $(HOTFIX).hpSearchCombo('set', {id:'', name: ''});
            };
    		
    	}	
    	return AddView;
    }());
    	
    return new AddView();	
    		
    });

