// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/node/NodePresenter',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/core/Notifications',
    'hp/view/FormStateView',
    'hp/core/Localizer',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'hp/lib/jquery.hpSearchCombo',
    'lib/jquery.selectBox'],
function(presenter,router, urlFragment, notifications, FormStateView, localizer) { "use strict";

    var NodeInventoryDView = (function() {
      
        var OK = '#hpsum-node-inventory-ok';
        var CANCEL ='#hpsum-node-inventory-close';
        var PANEL_SELECTOR = '#hpsum-node-inventory-panel-selector';
        var PANELS = '#hpsum-node-inventory-panels';
        var FORM = '#hpsum-node-inventory-form';
        var TITLE = '#hpsum-node-details-title';
        var TYPE ='#hpsum-node-type';
        var NAME = '#hpsum-node-name',
        	FAILEDMSG ='#hpsum-node-inventory-failed-details',
        	FAILEDPANEL ='#hpsum-node-inventory-failed',
        	BASELINES = '#hpsum-node-baselines-search',
        	ASSOCBASELINE = '#hpsum-node-baseline',
        	REMOVEBASELINE='#hpsum-node-baseline-remove',
        	REMOVEHOTFIX='#hpsum-node-addpackage-remove',
        	HOTFIX ='#hpsum-node-addpackage-search',
        	ASSOCHOTFIX ='#hpsum-node-addpackage';
        var ROUTE_PREFIX = '/node/inventoryd';
        
        /**
         * Constructor
         */
        function NodeInventoryDView() {
          
            var formStateView = new FormStateView();
            var inventoryInProgress = false;
            var nodeItem=null;
            var baselines='',
    			hotfixes='',
    			assocBaseline=null,
    			newBaseline = null,
    			newHotFix  = null,
    			assocHotFix = null;
            var searchResults = [];
                
            function onItemChange(item) {
            	item = item.hapi;
				if(item.node_state.match(/inventory/i)) {
					$(CANCEL).trigger('click');
				}
                if (item) {
                    $(TITLE).text(item.name);
                    $(NAME).text(item.name);
                    $(ASSOCBASELINE).text('');
                    $(REMOVEBASELINE).hide();
                    $(ASSOCHOTFIX).text('');
                    $(REMOVEHOTFIX).hide();
                    nodeItem= item;
                    newBaseline = null;
    				newHotFix  = null;
                    if(item.baselines){
                    	for (var i=0; i<item.baselines.length; i++ ){
                    		var baseline = presenter.getBaselineDetailsforId(item.baselines[i]);
                    		if(baseline){
                    			if(baseline.name.match(/^Additional Package/i)){
                    				$(ASSOCHOTFIX).text(baseline.name);
                    				$(REMOVEHOTFIX).show();
                    				assocHotFix = baseline; 
                    			}else{
                    				$(ASSOCBASELINE).text(baseline.name );
                    				$(REMOVEBASELINE).show();
                    				assocBaseline = baseline;
                    			}
                    		}
                    	}
 					 }
                } else {
                    $(TITLE).text('');
                }
                formStateView.reset();
            }
            
            function onInventoryError(errorMessage) {
                $(FAILEDPANEL).show();
                $(FAILEDMSG).text(errorMessage);
                $(OK).attr("disabled", "disabled");
                inventoryInProgress = false;
            }

            function onInventorySuccess(item) {
                inventoryInProgress = false;
                $(CANCEL).trigger('click');
            }

            
            function onInventory() {
            	var fail=false;
            	var finalBaseline;
            	var finalHotFix;
            	var baselineJson=[];
                if (! inventoryInProgress) {
                	if((newBaseline == null) && (assocBaseline == null))
                		finalBaseline = null;
                	else if (newBaseline == null)
                		finalBaseline = assocBaseline;
                	else
                		finalBaseline = newBaseline;
                	if((newHotFix == null) && (assocHotFix == null))
                		finalHotFix = null;
                	else if (newHotFix == null)
                		finalHotFix = assocHotFix;
                	else
                		finalHotFix = newHotFix;
                		
                	if((finalHotFix == null) &&  (finalBaseline == null))
                		fail = true;
                	else if(finalHotFix == null)
                		baselineJson.push(finalBaseline.id);
                	else if (finalBaseline == null)
                		baselineJson.push(finalHotFix.id);
                	else{
                		if(finalBaseline)
                			baselineJson.push(finalBaseline.id);
                		if(finalHotFix)
                			baselineJson.push(finalHotFix.id);
                	}
                	if(fail == true){
                		$(FAILEDPANEL).show();
                		$(FAILEDMSG).text(localizer.getString('hpsum.node.errorPleaseSelectBaseline'));
                	}
                	else {
                		nodeItem.baselines = baselineJson;
                    inventoryInProgress = true;
                    presenter.startInventory(nodeItem, {
                        success : onInventorySuccess,
                        error : onInventoryError
                    });
                   }
                }
            }
            
            
            function changeLocation(location) {
                if (location.length > ROUTE_PREFIX.length) {
                    $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
                } else {
                    $(PANELS).hpStackedPanels('setFirstPanel');
                }
            }
            
            this.resume = function () {
            	presenter.on('itemChange', onItemChange);
                //presenter.on('searchSuggestionChange', baselinesAvailable);
	            $(HOTFIX).hpSearchCombo('set', {id:'', name: ''});
	            baselines = hotfixes = localizer.getString('hpsum.common.loading');
                 	presenter.getAllBaselines({
           					success:getBaselinesSuccess,
           					error: getBaselinesError
           			});
                $(PANELS).hpStackedPanels('resume');
                $(OK).removeAttr("disabled");
                $(FAILEDPANEL).hide();
                $(BASELINES).hpSearchCombo('set', {id:'', name: ''});
            };
            
            this.pause = function () {
            	presenter.off('itemChange', onItemChange);
            	$(BASELINES).hpSearchCombo('set', {id:'', name: ''});
                $(HOTFIX).hpSearchCombo('set', {id:'', name: ''});
              	//presenter.off('searchSuggestionChange', baselinesAvailable);
                $(PANELS).hpStackedPanels('pause');
            };
          
          	function baselinesAvailable(data){
    			//data = {count: data.count, members: data};
            	//$(BASELINES).hpSearchCombo({getResults: presenter.getResults});
            }
            
            function getBaseline(string, handlers){
            	var results=[];
            		if (string && string.length > 0) {
              			 results =
                		    $.grep(baselines, function(option, index) {
                    		    return (option.name.match(
                  	         			 new RegExp(string, 'i')));
                  		  });	
           			 }
            		handlers.success({count: results.length, members: results});
        	}
            function getHotfixes(string, handlers){
          		  	var results=[];
            		if (string && string.length > 0) {
              			 results =
                		    $.grep(hotfixes, function(option, index) {
                    		    return (option.name.match(
                  	         			 new RegExp(string, 'i')));
                  		  });	
           			 }
            		handlers.success({count: results.length, members: results});
          	}
          
           function getBaselinesSuccess(searchResults)
            {
					baselines = $.grep(searchResults, function (option, index ) {
        				return !(option.name.match(new RegExp('^Additional', 'i')));
        			});
        			hotfixes = $.grep(searchResults, function (option, index) {
        				return (option.name.match(new RegExp('^Additional', 'i')));
           			});
            	
            }
            
            function getBaselinesError(msg)
            {
            	
            }
            /**
             * @public
             */
            this.init = function () {
              
				var resource = router.location().split('/');
                	resource = resource[1];
                	if(resource === 'node')
                		$(TYPE).val("Unknown");
                	else
                		$(TYPE).val(resource);
               		$('#hpsum-node-inventory-close').click(function () {
                    router.go(urlFragment.replaceView(router.location(), 'show'));
                });
                $(FAILEDPANEL).hide();
                   $(PANELS).hpStackedPanels({
                    	panelSelector : PANEL_SELECTOR
                	});
                
                formStateView.init({form: FORM,
                    routePattern: ROUTE_PREFIX + '.*',
                    autoTrack: true});
               
				$(REMOVEBASELINE).on('click',function(ev){
					assocBaseline=null;
					$(BASELINES).hpSearchCombo('set', {id:'', name: ''});
					$(ASSOCBASELINE).text('');
					$(REMOVEBASELINE).hide();
				});
				$(REMOVEHOTFIX).on('click',function(ev){
					assocHotFix=null;
					$(HOTFIX).hpSearchCombo('set', {id:'', name: ''});
					$(ASSOCHOTFIX).text('');
					$(REMOVEHOTFIX).hide();
				});
                $(BASELINES).hpSearchCombo({getResults:getBaseline});
                $(HOTFIX).hpSearchCombo({getResults: getHotfixes});
                $(BASELINES).change(function (ev, value) {
                	var item = presenter.getBaselineDetailsforId(value);
                	if(item){
        				$(ASSOCBASELINE).text(item.name);
        				$(REMOVEBASELINE).show();
        				newBaseline = item;
        				}
        			else {
        				if(assocBaseline != null){
        					$(ASSOCBASELINE).text(assocBaseline.name);
        					$(REMOVEBASELINE).show();
        				}
        				newBaseline = null;
        			}//nodeItem.baselines = value;
					$(OK).removeAttr("disabled");
        			$(FAILEDPANEL).hide();
    			});
                $(HOTFIX).change(function (ev, value) {
                	var item = presenter.getBaselineDetailsforId(value);
                	if(item){
        				$(ASSOCHOTFIX).text(item.name);
        				$(REMOVEHOTFIX).show();
        				newHotFix = item;
        				}
        			else {
        				if(assocHotFix != null){
        				$(ASSOCHOTFIX).text(assocHotFix.name);
        				$(REMOVEHOTFIX).show();
        				}
        				newHotFix = null;
        			}
        			//nodeItem.baselines = value;
					$(OK).removeAttr("disabled");
        			$(FAILEDPANEL).hide();
    			});
                
                $(OK).on('click', function(ev) {
                    onInventory();
                    ev.preventDefault();
                });
                

                router.watch('node inventory section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});
                
                this.resume();
            };
        }

        return new NodeInventoryDView();
    }());
    
    return NodeInventoryDView;
});
