// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
/**
 * @type {NodeShowOverviewView}
 * Provides functions to show overview/details pane for a node item
 */

define(['hpsum/presenter/node/NodePresenter',
    'hp/core/UrlFragment',
    'hp/core/Router',
    'text!hpPages/core/no_details.html',
    'hp/core/Localizer',
    'jquery',
    'hp/lib/jquery.hpGridPanels',
    'hp/lib/jquery.hpEllipsis',
    'lib/jquery.ThreeDots',
    'lib/jquery.columnizer',
    'lib/jquery.dateFormat',
    'hp/lib/date'],
function(presenter, urlFragment,router, noneHtml, localizer){
	"use strict";
	
	var NodeShowOverviewView = (function() {
		
		var ROOT = '#hpsum-node-show-overview',
			SPINNER = '#hpsum-node-add-spinner',
	  		PANELS = '.hp-grid-panels',
	  		BASELINE ='#hpsum-node-bundle',
	  		TYPE ='#hpsum-node-type',
	  		SERIAL ='#hpsum-node-serial',
            DESCRIPTION = '#hpsum-node-description';
        
        function NodeShowOverviewView(){
        	
        	var noItem;
        	
        	function onSelectionChange(selection) {
        		urlFragment.replaceHrefUris(ROOT, selection.uris);
        	}
        	
        	function onItemChange(item){
        		noItem.remove();
        		item = item.hapi;
        		if(item.type){
        			item.type = item.type.toLowerCase();
        			if(!router.location().match(item.type))
        				router.go((urlFragment.replaceView(router.location(), 'show/' + item.type + '/overview')));
        			}
        		if(item.node_state.match(/idle/i) && item.node_phase.match(/Initialize/i)){
        			$('.hp-grid-panels').css({"display":"none"});
        			 $(SPINNER).show();
        		}
        		else {
        			$(SPINNER).hide();
        			$('.hp-grid-panels').css({"display":""});
        			$('.hp-grid-panels').hpGridPanels('reset');
        			$(TYPE).text(item.model);
        			$(DESCRIPTION).text(item.description);
        			$(SERIAL).text(item.serialnumber);
        			
        		}
                $(PANELS).hpGridPanels('reset');
                $(ROOT).removeClass('hp-show-changing');
                $('.hp-dynamic', ROOT).removeClass('hp-unavailable');
            }
        	
        	function onItemError(error){
        		$(ROOT).append(noItem);
        	}
        	
        	function onAssociationsChange(tree) {
             	var bundle;
                if (tree.parents.BASELINE_TO_NODE) {
                    bundle = tree.parents.BASELINE_TO_NODE[0].resource;
                }
                if (bundle && bundle.uri) {
                    $('#hpsum-node-bundle').attr('href', '#/baseline/show/r' + bundle.uri).
                        text(bundle.name);
                } else {
                    $('#hpsum-node-bundle').text(localizer.getString('hpsum.node.noBaselineDefined'));
                }
             }
        	
        	
        	/* 
        	 *  Public Functions
        	 */
        	
        	this.init = function() {
        		noItem = $(noneHtml);
        		$(PANELS).hpGridPanels();
        		$(DESCRIPTION).ThreeDots({max_rows: 3, alt_text_t:true});
        		this.resume();
        	};
        	
        	this.resume = function() {
        		$(PANELS).hpGridPanels('reset');
        		presenter.on("selectionChange", onSelectionChange);
                presenter.on("itemError", onItemError);
                presenter.on("itemChange", onItemChange);
             
        		
        	};
        	
        	this.pause = function() {
				presenter.off("selectionChange", onSelectionChange);
                presenter.off("itemChange", onItemChange);
                presenter.off("itemError", onItemError);
               
        	};
        	
        	
        	
        	
        }
		
		return new NodeShowOverviewView();
	}());
	
	return NodeShowOverviewView;
});
