/* (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
*/
define(['hp/view/DetailsShowView',
    'hpsum/presenter/node/NodePresenter',
    'hp/core/Router',
    'hp/view/DialogView',
    'hp/core/UrlFragment',
    'hp/core/LinkTargetBuilder',
    'hp/view/NotificationsView',
    'hp/core/Localizer',
    'text!hpsumpages/node/abort_confirm.html',
    'text!hpsumpages/node/delete_confirm.html',
    'text!hpsumpages/node/failed_components.html',
    'text!hpsumpages/one-touch-update/reboot_confirm.html',
    'jquery',
    'hp/lib/date',
    'hp/lib/jquery.hpDropMenu',
    'hp/lib/jquery.hpStatus',
    'hp/lib/jquery.hpCollapsible'],
function(DetailsShowView, presenter,router, DialogView, urlFragment,
    linkTargetBuilder, NotificationsView, localizer,abortConfirmHtml, deleteConfirmHtml,failedComponentsHtml,rebootConfirmHtml) { "use strict";

    var NodeShowView = (function() {
      
        var VIEW = '#hpsum-nodes-show';
        var SELECTOR = '#hpsum-nodes-panel-selector';
        var HEADER = '#hpsum-nodes-show .hp-details-header';
        var TITLE = '#hpsum-nodes-details-title';
        var STATUS = '#hpsum-nodes-details-status';
        var ACTIONS = '.hp-details-actions';
        var _ACTION = '#hpsum-nodes--action';
        var DELETE_ACTION = '#hpsum-node-action-delete',
        	ABORT_ACTION ='#hpsum-node-action-abort',
        	INVENTORY_ACTION = '#hpsum-node-action-inventory',
        	DEPLOY_ACTION = '#hpsum-node-action-deploy',
        	REPORTS_ACTION = '#hpsum-node-action-reports',
        	SCHEDULE_ACTION ='#hpsum-node-action-schedule',
			EDIT_ACTION = '#hpsum-node-action-edit',
		REBOOT_ACTION = '#hpsum-node-action-reboot';
        var DELETE_TITLE = '#hpsum-nodes-delete-title';
        var NOTIFY_STATUSES = {error:'error', warning:'warning', unknown:'info'};
        
        var ABORT_TITLE = '#hpsum-nodes-abort-title',
       	   ABORT_ERROR = '#hpsum-abort-err';

        var F_VMWARE_DISC_GENERAL = 5052, /*! Discovery general failure */ 
            F_VMWARE_DISC_ASSOC_POWER_MGMT_ERROR = 5181, /*!  Discovery data creation error during Associate power managment*/
            F_VMWARE_DISC_COMPUTER_SYSTEM_ERROR = 5182, /*!  Discovery data creation error during System data collection*/
            F_VMWARE_DISC_COMPUTER_SYSTEM_LIST_ERROR = 5183,/*!  Discovery data creation error during System List data collection*/
            F_VMWARE_DISC_POWER_MGMT_SERVICES_ERROR = 5184, /*!  Discovery data creation error during Power Managmnet data collection*/
            F_VMWARE_DISC_SW_IDENTITY_ERROR =5185,/*!  Discovery data creation error during Software identity data collection*/
            F_VMWARE_DISC_SYS_HW_ERROR = 5186, /*!  Discovery data creation error during System Hardware data collection*/
            F_VMWARE_DISC_PCI_ERROR = 5187, /*!  Discovery data creation error during PCI data collection*/
            F_VMWARE_DISC_NIC_ERROR = 5188, /*!  Discovery data creation error during NIC data collection*/
            F_VMWARE_DISC_FCHBA_ERROR = 5189, /*!  Discovery data creation error during FCHBA data collection*/
            F_VMWARE_DISC_OS_ERROR = 5190, /*!  Discovery data creation error during OS data collection*/
            F_VMWARE_DISC_SMARTARRAY_ERROR = 5191, /*!  Discovery data creation error during SA data collection*/
            F_VMWARE_DISC_ILO_ERROR = 5192, /*!  Discovery data creation error during iLO data collection*/
            F_VMWARE_SEFL_DISC_DNL_ERROR = 5003; /*!  Self-discovery download failure*/

        var FAILED_COMPONENTS_TABLE = '#hpsum-failed-comps-table';

        /**
         * Constructor
         */
        function NodeShowView() {
          
            var detailsShowView = new DetailsShowView();
            var notificationsView = new NotificationsView();
            var deleteInProgress = false;
            var abortInProgress = false;
	    var rebootInProgress = false;
            var thisNode = null,
            	timerMap={};
            var notificationsCleared = false;
            var nodeItem = null;
                
            function clearNotifications() {
                if (! notificationsCleared) {
                    notificationsCleared = true;
                    notificationsView.clear();
                }
            }
                      
            function convertTypeStringForTitle(val) {
                if (val.match(/hpux/i)) {
                    return "HP-UX";	
                }
                return val;
            }
            
            function onItemChange(item) {
                clearNotifications();
                item = item.hapi;
                nodeItem = item;

                var resource = router.location().split('/');
                	resource = resource[1];
                var base ='#/'+resource ;
                if (item) {
                	notificationsView.clear();
                	thisNode = item;
                    $(HEADER).removeClass('hp-show-changing');
                    $('.deploy-domain').remove();
		    var deploy_url = base + '/deploy';
                    $(DEPLOY_ACTION).attr('href',deploy_url).text(localizer.getString('hpsum.node.reviewDeploy'));
                    if(!item.node_phase.match(/Initialize/i))
                    	$(ACTIONS).removeClass('hp-disabled');
                    $(TITLE).removeClass('hp-unavailable');
                    $(TITLE).text(convertTypeStringForTitle(item.type) +': ' +item.name);
                    $(STATUS).hpStatus('unknown', true).
                        removeClass('hp-unavailable');

                    if(item.node_phase.match(/InActive/i)) {
                		presenter.restore(thisNode.node_id);	
                	}

                    if (item.node_state.match(/installdone/i)) {
         				//$(HEADER).addClass('hp-show-changing');
         				$(ACTIONS).removeClass('hp-disabled');
         				$(TITLE).removeClass('hp-unavailable');
                    	$(TITLE).text(convertTypeStringForTitle(item.type) +': ' +item.name);
                    	
                    	var status,summary,details;
                    	if(item.return_code == -2 || item.return_code == -3) {
                    	    $(STATUS).hpStatus('error').removeClass('hp-unavailable');
                            status = 'error';
                            summary = localizer.getString('hpsum.node.installDoneWithErrors'); 
                            details = localizer.getString('hpsum.node.installDoneSeeErrors'); 
                    	} else {
                        	$(STATUS).hpStatus('ok').removeClass('hp-unavailable');
    						status = 'ok';
                        	summary = localizer.getString('hpsum.node.installDone');
                        	details =    localizer.getString('hpsum.node.installDoneSee');
                            if(item.type == "HPUX"){
                                details = item.node_status.replace(/\n/g, "<br/>");
                            }
                        }
						if(item.return_code == 1 && item.reboot_initiated == false)
						{
							details +=    '<p>' + item.name + ': ' + item.node_status + '.</p>' + '<a id="hpsum-node-reboot">' + localizer.getString('hpsum.node.rebootRequired') + '</a>';
						}
                    	 notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });
						
						$('#hpsum-node-reboot').unbind('click').bind('click', onReboot);
                      	
                	}
                	
                	if (item.node_state.match(/installhold/i)) {
         				//$(HEADER).addClass('hp-show-changing');
         				$(ACTIONS).addClass('hp-disabled');
         				$(TITLE).removeClass('hp-unavailable');
                    	$(TITLE).text(convertTypeStringForTitle(item.type) +': ' +item.name);
                    	$(STATUS).hpStatus('unknown', true).removeClass('hp-unavailable');
                    	var status,summary,details;
						status = 'unknown';
                    	summary = localizer.getString('hpsum.node.waitingforAssoc'); // Add in translation
                    	details =   item.node_status;
                    	 notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });
                       // showInstallProgress(item);
                      	
                	}
                	if (item.node_state.match(/install$/i)) {
         				//$(HEADER).addClass('hp-show-changing');
         				$(ACTIONS).removeClass('hp-disabled');
         				$(TITLE).removeClass('hp-unavailable');
                    	$(TITLE).text(convertTypeStringForTitle(item.type) +': ' +item.name);
                    	$(STATUS).hpStatus('unknown', true).removeClass('hp-unavailable');
                    	var status,summary,details;
						status = 'unknown';
						if(item.type.match(/moonshot/i )) {
						    summary = localizer.getString('hpsum.node.installProgressMoonshot');
						} else
                    	   summary = localizer.getString('hpsum.node.installProgress'); // Add in translation
                    	details = item.node_status;
                    	 notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            changing:true,
                            details: details
                        });
                       // showInstallProgress(item);
                      	
                	}
         			
         			if (item.node_state.match(/inventory$|analysis$/i)) {
         				//$(HEADER).addClass('hp-show-changing');
         				$(ACTIONS).removeClass('hp-disabled');
         				$(TITLE).removeClass('hp-unavailable');
                    	$(TITLE).text(convertTypeStringForTitle(item.type) +': ' +item.name);
                    	$(STATUS).hpStatus('unknown', true).removeClass('hp-unavailable');
                    	        			
        				var notif = {
        				  	status: 'info',
                            summary: localizer.getString('hpsum.node.inventoryInProgress'), // Add in translation
                           	changing: true
                            
        				};
        				notificationsView.add(notif);
                    	showInventoryProgress(item);
                	}
                    if (item.node_state.match(/error/i)) {
                    	$(HEADER).removeClass('hp-show-changing');
                    	$(STATUS).hpStatus('error', false).
                        	removeClass('hp-unavailable');
                    	var status,summary,details;
                    	
                    	status = 'error';
                    	summary = item.node_status;
                        if(!(item.type.match(/VMWARE/i)))
                        {
                        	if(item.node_status.match(/Inventory Error/i))
                        	{
                        		var details = '<p>' + localizer.getString('hpsum.common.reenterCredentials')  + '</p>' + 
                        			'<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.edit') + '</a>';
                        	}
                        	else {
    	                    	if(item.node_status.match(/Need Associated Node Details/i)){
    	                    		if(item.type.match(/virtual_connect|sas_switch/i )) {
    	                    			details = '<p>' + item.name + ' ' + localizer.getString('hpsum.node.needAssociatedOADetails') + '</p>' + 
    	                    				'<a href="'+ base+'/associated">' + localizer.getString('hpsum.node.enterAssociatedOADetails') + '</a>';
    	                    		}
    	                    		else if(item.type.match(/ipdu/i))
    	                    			details = '<p>' + item.name + ' ' + localizer.getString('hpsum.node.needAssociatediPDUDetails') + '</p>' + 
    	                    			'<a href="'+ base+'/associated">' + localizer.getString('hpsum.node.enterPartnerIpduDetails') + '</a>';
    	                    	} else if (item.node_status.match(/standby oa/i)) {
    	                    	    details = '';
    	                    	}
    	                    	else
    							{
    								details = '<p>' + item.name + ': ' + item.node_status + '.</p>';
                                    /* If details message contains a URL then convert the URL a hyperlink */
                                    var urlStartIndex;
                                    urlStartIndex = details.indexOf("http://");
                                    if (urlStartIndex == -1)
                                    {
                                        urlStartIndex = details.indexOf("https://");
                                    }
                                    if (urlStartIndex != -1)
                                    {
                                        var urlEndIndex = details.indexOf(" ", urlStartIndex);
                                        if (urlEndIndex != -1)
                                        {
                                            var url = details.substring(urlStartIndex, urlEndIndex);
                                            var hyperlink = "'<a href=\"" + url + "\">" + url + "</a>'";
                                            details = details.substring(0, urlStartIndex) + hyperlink + details.substring(urlEndIndex);
                                        }
                                    }
    							}
                        	}
                        }
                        else
                        {
                            if(item.internal_error_code == F_VMWARE_DISC_FCHBA_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_FCHBA_DISC_ERR_MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            }
                            else if(item.internal_error_code == F_VMWARE_DISC_NIC_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_NIC_DISC_ERR_MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            }
                            else if(item.internal_error_code == F_VMWARE_DISC_ILO_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_ILO_DISC_ERR_MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            }
                            else if(item.internal_error_code == F_VMWARE_DISC_OS_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_OS_DISC_ERR_MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            }
                            else if(item.internal_error_code == F_VMWARE_DISC_SYS_HW_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_SYSHW_DISC_ERR__MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            }
                            else if(item.internal_error_code == F_VMWARE_DISC_SMARTARRAY_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_SA_DISC_ERR_MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            } 
                            else if(item.internal_error_code == F_VMWARE_DISC_PCI_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_PCI_DISC_ERR_MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            } 
                            else if(item.internal_error_code == F_VMWARE_SEFL_DISC_DNL_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_SELF_DISC_DNL_ERROR_MSG')  + " " + '<a id="hpsum-failed-components-link">' + localizer.getString('hpsum.common.failedComponents') + '</a>' +'</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            }
                            else if(item.internal_error_code == F_VMWARE_DISC_GENERAL)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_GENERAL_DISC_ERR_MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            }
                            else
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.reenterCredentials')  + '</p>' + 
                                    '<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.edit') + '</a>';
                            }
                            
                        }
                    	 notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });

                         $('#hpsum-failed-components-link').unbind('click').bind('click', onFailedComponents);
                         
                    }
                    
                    if(item.node_state.match(/pending_fw_update/i)) {
                    	$(HEADER).removeClass('hp-show-changing');
                    	var status, summary,details;
                    	
                    	status = 'warning';
                    	summary = localizer.getString('hpsum.integrityilo.haspendingupdate');
                    	details = '<p>' + localizer.getString('hpsum.integrityilo.hasprevious', [item.name]) + '</p>' + 
                    			'<a href="'+ base+'/integrityilo/activatepending">' + localizer.getString('hpsum.integrityilo.activateorcancel') + '</a>';
                    	$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');
                    	var url = base+'/integrityilo/activatepending';
                    	$(DEPLOY_ACTION).attr('href',url).text(localizer.getString('hpsum.integrityilo.activatepending'));
                    	
                        notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });               	
                    }
                	

					if (item.node_state.match(/activate_pending/i)) {
						$(HEADER).addClass('hp-show-changing');
						$(ACTIONS).removeClass('hp-disabled');
						$(TITLE).removeClass('hp-unavailable');
						$(TITLE).text(convertTypeStringForTitle(item.type) + ': ' + item.name);
						$(STATUS).hpStatus('ok', true).removeClass('hp-unavailable');
						var deploy_url = base+'/deploy';
						$(DEPLOY_ACTION).attr('href',deploy_url).text(localizer.getString('hpsum.node.reviewDeploy'));

						var notif = {
							status : 'info',
							summary : item.node_status,
							changing : true

						};
						notificationsView.add(notif);
						showInventoryProgress(item);
					}
					
					if (item.node_state.match(/idle/i) && item.node_phase.match(/unknown|error/i)) {
						$(HEADER).removeClass('hp-show-changing');
                    	$(STATUS).hpStatus('error', false).
                        	removeClass('hp-unavailable');
                        	
                    	var status,summary,details;
                    	status = 'error';
                    	summary = item.node_status;
                    	
                    	if(item.node_status.match(/The specified iLo federation group was not found in the network/i)) {
                    		details = '<p>' + localizer.getString('hpsum.common.unknownNodeFederationGrpError')  + '</p>'; 
						}
						else {
							details = '<p>' + localizer.getString('hpsum.common.unknownNodeError')  + '</p>' + 
									'<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.edit') + '</a>';
						}
						if(item.node_phase.match(/error/i)) {
                            details = '<p>' + localizer.getString('hpsum.common.reenterCredentials')  + '</p>' + 
									'<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.edit') + '</a>';
                        }
						if (summary.indexOf("management software. URL:") != -1)
						{
							var httpsIndex = summary.indexOf("https://");
							if(httpsIndex!=-1)
							{
								var httpURL = summary.substring(httpsIndex);
								var urlIndex = summary.indexOf("URL:");
								if( urlIndex != -1)
								{
									var baseMessage = summary.substring(0, urlIndex);
									details = '<p>Management Software is accessible at: ' + '<a target=_blank href="'+httpURL+'">' + httpURL + '</a>'+ '</p>' + '<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.edit') + '</a>';
									summary = baseMessage;
								}
							}
						}
						
						notificationsView.add({
							status: NOTIFY_STATUSES[status],
							summary: summary, 
							details: details
						});
						
					}

					showActionMenu(item.node_state, item.node_phase, item.type);
                    
                    if (item.node_phase.match(/useractionneeded/i)) {
                    	$(HEADER).removeClass('hp-show-changing');
                    	var status, summary,details;
                    	
                    	if(item.node_state.match(/idle/i)){
                    		status = 'warning';
                    		summary = localizer.getString('hpsum.common.doActionInventory');
                    	 	details = '<p>' + item.name + ': ' + item.node_status + '.</p>' + '<a href="'+ base+'/inventoryd">' + localizer.getString('hpsum.common.doInventory') + '</a>';
                    	 	$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');
                    	}
                    	if(item.node_state.match(/uan/i)){
                    		
                    		if(item.node_status.match(/No Applicable/i)){
                                status = 'ok';
                                if(item.node_status.match(/firewall/i)){
                                    summary = localizer.getString('hpsum.node.noApplicableComponentsFound');
                                    details = localizer.getString('hpsum.node.noApplicableComponentsFound') + '. ' + localizer.getString('hpsum.node.firewallBlocking');
                                } else {
                                    summary = localizer.getString('hpsum.node.nodeUpToDate') + '. ' + localizer.getString('hpsum.node.noApplicableComponentsFound');
                                    details = localizer.getString('hpsum.node.noApplicableComponentsFound');
                                }
                                 $(STATUS).hpStatus('ok', false).removeClass('hp-unavailable');
                    		}
                    		else {
                    				status = 'warning';
                    				summary =  localizer.getString('hpsum.node.readyForDeploy'); // Add in translation
                            		if(item.type.match(/sd2/i)) {
                                		//SD2 has its own deploy options screen
                                		if(item.analysis_errors) {
                                			status = 'error';
                                			summary = localizer.getString('hpsum.node.sd2HasErrors'); // Add in translation
                                		} else if (item.analysis_warnings){
                                			status = 'warning';
                    						summary = localizer.getString('hpsum.node.sd2HasWarnings'); // Add in translation
                                		}
                                		details =    '<p>' + item.name + ': ' + item.node_status + '.</p>' + '<a href="'+ base+'/sd2/deploy">' + localizer.getString('hpsum.node.reviewAndDeploy') + '</a>';
                                		var url = base + '/sd2/deploy';
                               	 		$(DEPLOY_ACTION).attr('href',url);
                            		} else {
                              		  details =    '<p>' + item.name + ': ' + item.node_status + '.</p>' + '<a href="'+ base+'/deploy">' + localizer.getString('hpsum.node.reviewAndDeploy') + '</a>';
                              		  //show tpm message if tpm flag is true
					  if(item.tpm_state == true) {
					     summary += ". \n" + localizer.getString('hpsum.oneTouchUpdate.tpmSummary');
					     details = '<p>' + localizer.getString('hpsum.oneTouchUpdate.tpmWarning') + '</p>' + details;
					  }
                              		  if(item.hasOwnProperty('is_ilo_domain')) {
                              		  	details += '<p><a href="'+ base+'/integrityilo/deploydomain">' + localizer.getString('hpsum.integrityilo.doDeployDomain') + '</a></p>';
                              		  	if(!$('.deploy-domain').length) {
                              		  		$(DEPLOY_ACTION).closest("ol").after('<ol class=\"deploy-domain\"><li><a href="'+ base+'/integrityilo/deploydomain\">'+ localizer.getString('hpsum.integrityilo.deployDomain') +'</a></li></ol>');	
                              		  	}
                              		  }
                            		}                           		
                    	 		$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');
                    	 	}
                    	}
                        notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });
                       }
                } else {
                    $(TITLE).text('');
                    $(STATUS).hpStatus('unknown');
                    $(STATUS + ' span').text('');
                }
            }
            

            function showActionMenu(state, phase, type) {
		    if (state.match(/Idle/i)) {
                    $(EDIT_ACTION).removeClass('hp-disabled').attr('style', '').unbind('click.disable-link');
                    if (phase.match(/UnKnown/i)) {
                            $(DELETE_ACTION).removeClass('hp-disabled').attr('style', '');
                            $(ABORT_ACTION).addClass('hp-disabled');
                            $(INVENTORY_ACTION).addClass('hp-disabled');
                            $(DEPLOY_ACTION).addClass('hp-disabled');
                            $(REPORTS_ACTION).addClass('hp-disabled');
                            $(SCHEDULE_ACTION).addClass('hp-disabled');
                            $(REBOOT_ACTION).addClass('hp-disabled');
                        } else {
                            $(DELETE_ACTION).removeClass('hp-disabled').attr('style', '');
                            $(ABORT_ACTION).addClass('hp-disabled');
                            $(INVENTORY_ACTION).removeClass('hp-disabled').attr('style', '').unbind('click.disable-link');
                            $(DEPLOY_ACTION).addClass('hp-disabled');
                            $(REPORTS_ACTION).addClass('hp-disabled');
                            $(SCHEDULE_ACTION).addClass('hp-disabled');
                            $(REBOOT_ACTION).addClass('hp-disabled');
                        }
                    } else if (state.match(/inventory$/i)) {
                        $(DELETE_ACTION).addClass('hp-disabled');
                        $(ABORT_ACTION).removeClass('hp-disabled').attr('style', '');
                        $(INVENTORY_ACTION).addClass('hp-disabled');
                        $(DEPLOY_ACTION).addClass('hp-disabled');
                        $(REPORTS_ACTION).addClass('hp-disabled');
                        $(SCHEDULE_ACTION).addClass('hp-disabled');
                        $(REBOOT_ACTION).addClass('hp-disabled');
                        $(EDIT_ACTION).addClass('hp-disabled');
                    } else if (state.match(/UAN/i)) {
                        $(DELETE_ACTION).removeClass('hp-disabled').attr('style', '');
                        $(ABORT_ACTION).addClass('hp-disabled');
                        $(INVENTORY_ACTION).removeClass('hp-disabled').attr('style', '').unbind('click.disable-link');
                        $(DEPLOY_ACTION).removeClass('hp-disabled').attr('style', '').unbind('click.disable-link');
                        $(REPORTS_ACTION).removeClass('hp-disabled').attr('style', '').unbind('click.disable-link');
                        $(SCHEDULE_ACTION).removeClass('hp-disabled').attr('style', '').unbind('click.disable-link');
                        $(EDIT_ACTION).removeClass('hp-disabled').attr('style', '').unbind('click.disable-link');
                        $(REBOOT_ACTION).addClass('hp-disabled');
                    } else if (state.match(/InstallDone/i)) {
                        $(DELETE_ACTION).removeClass('hp-disabled').attr('style', '');
                        $(ABORT_ACTION).addClass('hp-disabled');
                        $(INVENTORY_ACTION).removeClass('hp-disabled').attr('style', '').unbind('click.disable-link');
                        $(DEPLOY_ACTION).addClass('hp-disabled');
                        $(REPORTS_ACTION).removeClass('hp-disabled').attr('style', '').unbind('click.disable-link');
                        $(EDIT_ACTION).removeClass('hp-disabled').attr('style', '').unbind('click.disable-link');
                        $(SCHEDULE_ACTION).addClass('hp-disabled');
                         
                        //Modify condition here to disable reboot link after install is done
                        //if the reboot action is not supported for the node type
                        if(type.match(/ilo/i))
                            $(REBOOT_ACTION).addClass('hp-disabled');
                        else
                            $(REBOOT_ACTION).removeClass('hp-disabled').attr('style', '');
                    } else if (state.match(/Install$/i)) {
                        $(DELETE_ACTION).addClass('hp-disabled');
                        $(ABORT_ACTION).removeClass('hp-disabled').attr('style', '');
                        $(INVENTORY_ACTION).addClass('hp-disabled');
                        $(DEPLOY_ACTION).addClass('hp-disabled');
                        $(REPORTS_ACTION).addClass('hp-disabled');
                        $(SCHEDULE_ACTION).addClass('hp-disabled');
                        $(EDIT_ACTION).addClass('hp-disabled');
                        $(REBOOT_ACTION).addClass('hp-disabled');
                    } else if (state.match(/activate_pending/i)) {
                        $(DELETE_ACTION).addClass('hp-disabled');
                        $(ABORT_ACTION).removeClass('hp-disabled').attr('style', '');
                        $(INVENTORY_ACTION).addClass('hp-disabled');
                        $(DEPLOY_ACTION).addClass('hp-disabled');
                        $(REPORTS_ACTION).addClass('hp-disabled');
                        $(SCHEDULE_ACTION).addClass('hp-disabled');
                        $(REBOOT_ACTION).addClass('hp-disabled');
                        $(EDIT_ACTION).addClass('hp-disabled');
                    } else if (state.match(/pending_fw_update/i)) {
                        $(DELETE_ACTION).addClass('hp-disabled');
                        $(ABORT_ACTION).addClass('hp-disabled');
                        $(INVENTORY_ACTION).addClass('hp-disabled');
                        $(DEPLOY_ACTION).removeClass('hp-disabled').attr('style', '').unbind('click.disable-link');
                        $(EDIT_ACTION).removeClass('hp-disabled').attr('style', '').unbind('click.disable-link');
                        $(REPORTS_ACTION).addClass('hp-disabled');
                        $(SCHEDULE_ACTION).addClass('hp-disabled');
                        $(REBOOT_ACTION).addClass('hp-disabled');
                    } else if (state.match(/error/i)) {
                        $(DELETE_ACTION).removeClass('hp-disabled').attr('style', '');
                        $(ABORT_ACTION).addClass('hp-disabled');
                        $(INVENTORY_ACTION).removeClass('hp-disabled').attr('style', '').unbind('click.disable-link');
                        $(DEPLOY_ACTION).addClass('hp-disabled');
                        $(REPORTS_ACTION).removeClass('hp-disabled').attr('style', '').unbind('click.disable-link');
                        $(SCHEDULE_ACTION).removeClass('hp-disabled').attr('style', '').unbind('click.disable-link');
                        $(REBOOT_ACTION).removeClass('hp-disabled').attr('style', '');
                        $(EDIT_ACTION).removeClass('hp-disabled').attr('style', '').unbind('click.disable-link');
                    }

			 if (!phase.match(/Initialize/i)) {
                    $(".hp-disabled").css("color", "grey").bind('click.disable-link', function(e) {
                        e.preventDefault();
                        return false;
                    });
             }
            }
                
            function showInventoryProgress(item){
            		if(timerMap[item.node_id])
            			return;
        		   	timerMap[item.node_id] = setInterval(function () {
            		presenter.getNodeStatus(item, {
                				success : function(data) {
                    				onNodeStatusSuccess(data);
                    		 	},
                    			error : function(errorInfo) {
                        			onNodeStatusError(errorInfo);
                    			}
                			});
                			
                }, 3000);
        	}
        	
        	function onNodeStatusSuccess(data){
        		if(thisNode.node_id == data.hapi.node_status.node_id) {
        			
        			var notif = {
        				  	status: 'info',
                            summary: data.hapi.node_status.node_status,
                           // timestamp: (new Date().toISOString()),
                            changing: true,
                            details: localizer.getString('hpsum.node.inventoryInProgress') // Add in translation
        			};
        			 
        			 
        			if(data.hapi.node_status.node_state.match(/uan|error|pending_fw_update|idle/i)){
        				notificationsView.remove(notif);
        				presenter.refreshIndexResults();
        				clearInterval(timerMap[data.hapi.node_status.node_id]);
        				delete timerMap[data.hapi.node_status.node_id];
        			}
        			else {
        				notificationsView.add(notif);	
        			}
        		}
        		else
        		{
        				clearInterval(timerMap[data.hapi.node_status.node_id]);
        				delete timerMap[data.hapi.node_status.node_id];
        		}
        	}
        	
        	function onNodeStatusError(error){
        		
        		/*if(data.hapi.node_status.node_state.match(/uan|error|pending_fw_update|idle/i)){
        				//clearInterval(inventoryTimer);
        				presenter.refreshIndexResults();
        		}*/
        	}

            function onItemError(errorMessage) {
            }
            
            function onSelectionChange(selection) {
                notificationsCleared = false;
                clearNotifications();
                urlFragment.replaceHrefUris(HEADER,
                    selection.uris, selection.multiSelectId);
                if ($(HEADER).hasClass('hp-show-init')) {
                    $(HEADER).removeClass('hp-show-init');
                } else {
                    $(HEADER).addClass('hp-show-changing');
                    $(ACTIONS).addClass('hp-disabled');
                }
            }
            
            function onAggregateChange(aggregate) {
                $(TITLE).removeClass('hp-unavailable').text(localizer.getString('hpsum.node.servers',[ aggregate.count ]));
                $(STATUS).hide();
                notificationsCleared = false;
                clearNotifications();
            }
            
            function onItemDeleteSuccess(item_name) {
                notificationsView.add({summary: localizer.getString('hpsum.switchUI.deleted')}, true); // Add in translation
                deleteInProgress = false;
            }
			
			function onItemRebootSuccess(item_name) {
                notificationsView.add({summary: localizer.getString('hpsum.node.nodeRebooted')}, true); // Add in translation
                rebootInProgress = false;
            }
			
			function onItemRebootError(errorMessage) {
                notificationsView.add({summary:errorMessage}, true);
                rebootInProgress = false;
            }

            /**
             * @private
             */
            function onItemDeleteError(errorMessage) {
                notificationsView.add({summary:errorMessage}, true);
                deleteInProgress = false;
            }
            
            function onAbort(ev){
                
                if($(ABORT_ACTION).hasClass("hp-disabled")) {
                    ev.preventDefault();
                    return;
                }
                
        		if (! abortInProgress) {
                   abortInProgress = true;
                    
                   var contents = $(abortConfirmHtml);
                   localizer.localizeDom(contents);
                    $(ABORT_TITLE, contents).text(localizer.getString('hpsum.node.abortFor', [presenter.selectionLabel()]));
                        
                    $(ABORT_ERROR, contents).hide();
                    new DialogView({contents: contents,
                        ok: function () {
                                presenter.abortAction({
                                    success : function(){
                                    	abortInProgress = false;
                                    	notificationsView.add({summary: localizer.getString('hpsum.node.abortActionSuccessful')}, true);
                                    },
                                    error : function(msg){
                                    	notificationsView.add({summary:msg}, true);
                                    	abortInProgress = false;
                                    }
                                });
                        },
                        cancel: function () {
                            abortInProgress = false;
                        }
                    });
                }
                
                ev.preventDefault();
        	}

            /**
             * @private
             */
            function onDeleteItem(ev) {
                
                if($(DELETE_ACTION).hasClass("hp-disabled")) {
                    ev.preventDefault();
                    return;
                }
                
                if ( presenter.selectionLabel() === 'localhost')
                    {
                        var contents = $(deleteConfirmHtml);
                        $('#hpsum-delete-node',contents).html(localizer.getString('hpsum.node.cannotDelete')); // Add in translation
                        $('#hpsum-node-delete-cancel',contents).hide();
                        $('#hpsum-node-delete-ok',contents).html("Ok");
                        new DialogView({contents: contents,
                                        ok: function ()
                                    {}
                                    });
                    }
                    else {
                    if (! deleteInProgress) {
                    deleteInProgress = true;
                    
                    var contents = $(deleteConfirmHtml);
                    $('#hpsum-delete-node',contents).html(localizer.getString('hpsum.common.continueWithDelete')); // Add in translation
                    $('#hpsum-node-delete-cancel',contents).show();
                    $('#hpsum-node-delete-ok', contents).html(localizer.getString('hpsum.baseline.show.yesDelete'));

                    localizer.localizeDom(contents);
                    $(DELETE_TITLE, contents).text(
                        localizer.getString('hpsum.common.deleteArg',
                            [presenter.selectionLabel()]));
                    
                    new DialogView({contents: contents,
                        ok: function () {
                                presenter.deleteItem({
                                    success : onItemDeleteSuccess,
                                    error : onItemDeleteError
                                });
                        },
                        cancel: function () {
                            deleteInProgress = false;
                        }
                    });
                }
                }
                ev.preventDefault();
            }
            
            function updateActionLinks(){
            	  	var resource = router.location().split('/');
                	resource = resource[1];
    				
    				 $('a[data-change]').each(function(index) {
                		var currentLink = $(this).attr('href');
                		if(currentLink  == undefined)
                			return;
                		var current = currentLink.split('/');
                		current[1] = resource;
                		currentLink =current.join('/');
                		$(this).attr('href',currentLink);
  					});
            }
			
			function onReboot(ev){
			    
               if($(REBOOT_ACTION).hasClass("hp-disabled")) {
                    ev.preventDefault();
                    return;
                }

			var contents = $(rebootConfirmHtml);
                localizer.localizeDom(contents);
                $('#hpsum-otu-reboot-title', contents).text(
                    localizer.getString('hpsum.RebootConfirm.title'));
				new DialogView({contents: contents,
                	ok: function () {
						if (!rebootInProgress) 
						{
							rebootInProgress = true;
							
							presenter.rebootNode(thisNode.node_id, {															
								success : onItemRebootSuccess,
								error : onItemRebootError									
								});		
						}
                    },
                    cancel: function () {
						rebootInProgress = false;
                        return;
                    }
                });				
				ev.preventDefault();
			}

            function onFailedComponents(ev) {
                var contents = $(failedComponentsHtml);
                localizer.localizeDom(contents);
                var failedDialog = new DialogView({contents: contents,
                    cancel: function () {
                        router.go('/node/show');
                    }
                }); 
                populateFailedComponentTable();             
            }
            

            function initComponentTable(tableid) {
                var oTab = $(tableid).dataTable({
                    oLanguage: {
                        sEmptyTable: localizer.getString("hpsum.node.noApplicableComponentsFound"),
                        sSearch: localizer.getString('hpsum.common.search')
                                        },
                    bPaginate : false,
                    bProcessing : true,
                    bFilter : true,
                    bSort : true,
                    bAutoWidth : false,
                    bInfo : false,
                    bRetrieve : true,
                    bDestroy : true,
                    //aaData: data,
                    aoColumns : [
                        {mDataProp: 'Component_ID'},
                        {mDataProp: 'Component_Name'},
                      ],
                    aaSorting: [],
                    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                        return nRow;
                    }
                });
            }

            //Populate failed components table
            function populateFailedComponentTable(){
                    initComponentTable(FAILED_COMPONENTS_TABLE);
                    var oTable = $(FAILED_COMPONENTS_TABLE).dataTable();
                    //oTable.fnClearTable();
                    for(var i=0; i<nodeItem.failed_component_id.length; i++)
                    {
                    var compItem = [{
                            'Component_ID': nodeItem.failed_component_id[i],
                            'Component_Name': nodeItem.failed_component_name[i]
                        }];
                    oTable.fnAddData(compItem);
                    }
                }

            this.resume = function () {
                notificationsCleared = false;
                $('#hp-page-notifications').remove();
                notificationsView.init({context: $(VIEW),
                    allLocation: '#/node/show/activity',
                    resource: presenter.resource()});
                presenter.on("selectionChange", onSelectionChange);
                presenter.on("aggregateChange", onAggregateChange);
                presenter.on("itemChange", onItemChange);
                presenter.on("itemError", onItemError);
                updateActionLinks();
                                
                $(DELETE_ACTION).bind('click', onDeleteItem);
                $(ABORT_ACTION).bind('click', onAbort);
		$(REBOOT_ACTION).bind('click', onReboot);		

                if (notificationsView.resume) {
                    notificationsView.resume();
                }
            };
            
            this.pause = function () {
                presenter.off("selectionChange", onSelectionChange);
                presenter.off("aggregateChange", onAggregateChange);
                presenter.off("itemChange", onItemChange);
                presenter.off("itemError", onItemError);
	  	$(DELETE_ACTION).unbind('click', onDeleteItem);
                $(ABORT_ACTION).unbind('click', onAbort);
		$(REBOOT_ACTION).unbind('click', onReboot);
		$('#hpsum-node-reboot').unbind('click', onReboot);
        $('#hpsum-failed-components-link').unbind('click', onFailedComponents);
                for (var key in timerMap) {
  			clearInterval(timerMap[key]);
        		delete timerMap[key];
		}
                if (notificationsView.pause) {
                    notificationsView.pause();
                }
            };
          
            /**
             * @public
             */
            this.init = function() {
                
                detailsShowView.init($(SELECTOR));
                $(ACTIONS).hpDropMenu();
                $('#hpsum-activity-actions').hide();
                this.resume();
            };
            
        }

        return new NodeShowView();
    }());
    
    return NodeShowView;
});
