// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
/**
 * @type (NodeView)
 * This is a view class for Baselines
 * Provides functions for showing master pane and its action.
 */
define(['hpsum/model/node/NodeResource',
	'hp/core/Router',
	'hp/view/MasterPaneView',
	'hpsum/presenter/node/NodePresenter',
	'hp/core/Localizer',
    'jquery',
	'hp/lib/jquery.hpStatus',
    'hp/lib/jquery.hpUtilizationMeter',
    'hp/lib/jquery.hpSafeClone'],
function(resource,router, MasterPaneView, presenter, localizer) {"use strict";

    var NodeView = ( function() {
		
		var TYPE = 'node';
		var PAGE = '#hpsum-nodes-page';

        /**
         * @constructor
         * @type {NodeView}
         */
        function NodeView() {

			var masterPaneView = new MasterPaneView();
			var template = null;
			var types = [],
				types_existing =[];
			
			function renderer(indexResult) {
               var item = template.hpSafeClone();
                $('.hp-status', item).hpStatus(indexResult.status, indexResult.changing);
                $('.hp-master-item-name', item).html(indexResult.name);
                $('.hpsum-node-type',item).html(localizer.getString('hpsum.common.type') + ':' + indexResult.type);
                $('.hpsum-node-status',item).html(localizer.getString('hpsum.common.statusStr') + ':' +indexResult.node_status);
                return item;
            }
			
			function getItemUrl(oObj){

				var resource = router.location().split('/');
                var urlHead = resource[1];
	    		
	    		return oObj.aData.name;
	    		
	    		//Commented the following lines to avoid opening the node in another tab in the browser                                    
	    		/*
	    		return '<a class="hpsum-node-class" href="#/' + urlHead + '/show/r' + oObj.aData.uri + 
                                    '">' + oObj.aData.name +
                                    '</a>';
                */
			}
			
            /**
             * @public
             */
            this.init = function() {
				presenter.init();
                
                template = $('#hpsum-node-item-template').detach().show().attr('id', '');
                
             
                presenter.setFilter("");
                masterPaneView.init({
                    routePrefix: '/' + TYPE,
                    resource: presenter.resource(),
                    page: $(PAGE),
                    multiSelect: true,
                    addLink: presenter.getAddLink(),
                    dataTableOptions:  {
                        aoColumns : [
                            {fnRender: function (oObj) {
                                return '<div>' + oObj.aData.status +
                                    (oObj.aData.changing ? ' *' : '') +
                                    '</div>';
                            }, mDataProp: 'status'},
                            {fnRender: getItemUrl, mDataProp: 'name'} //,
                            //{mDataProp: 'attributes.model'}
                        ],
                        aaSorting: [[ 1, "asc" ]],
                        fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0) > div', nRow).hpStatus();
                            return nRow;
                        },
                        fnCreatedRow :function(nRow, aData, iDisplayIndex){
			                //var types = presenter.getAllNodeTypes();
			               	var html = '<li data-id="all" class="hp-selected">' + localizer.getString('hpsum.common.all') + '</li>';
			               //	types_existing =[];
			               	var value =  aData.type;
			               	var found = false;
			              	 for(var  i=0; i<types_existing.length; i++ ){
			               		if(value.toLowerCase() == types_existing[i].toLowerCase())
			               				found = true;
			               		}
               				if(!found){
               					//html = html + '<li data-id="' + aData.type + '">' + aData.type  + '</li>';
                				types_existing.push(aData.type);
                			}
                			for(var  i=0; i<types_existing.length; i++ ){
                				html += '<li data-id="' + types_existing[i] + '">' + types_existing[i]  + '</li>';
                			}
                			$('#types', PAGE).html(html);
						}
                    },
                    gridItemRenderer: renderer
                });
  
            };

            /**
             * @public
             */
            this.pause = function() {
				masterPaneView.pause();
            };

            /**
             * @public
             */
            this.resume = function() {
				masterPaneView.resume();
				presenter.setFilter("");
            };
        }

        return new NodeView();
    }());

    return NodeView;
});
