define(['hpsum/presenter/node/NodePresenter',
		'hp/core/EventDispatcher',
		'hp/core/Localizer', 
		'lib/jquery.selectBox',
		'jquery', 
		'hp/lib/jquery.hpStatus',
		'lib/jquery.dataTables',
		'hp/lib/jquery.hpCollapsible',
		'hp/lib/jquery.hpToggle'], 
function(presenter,EventDispatcher, localizer) {"use strict";
	(function($) {
		// Create the defaults once
  		var pluginName = "hpsumAddNodeDetails",
        defaults = {
            nodeItem: null
        };
		
		var	DESCRIPTION = '#hpsum-node-description';
		var nodeDetailsPanelAdded = false;
		var credentialsPanelAdded = false;
		var rebootOptionsPanelAdded = false;
		var osManagementOptionsPanelAdded = false;
		var TYPE ='#hpsum-node-type',
			ADD_ASSOC_NODES = '#hpsum-node-addassocnodes',	
			ADD_ASSOC_NODES_DESC = '#hpsum-node-addassoc-description',
			DESCRIPTION = '#hpsum-node-description';
		var descriptionAndTypePanelAdded = false;
		var activeUpdatePanelAdded = false;
		var baselines='',
    		hotfixes='';
		var assocBaseline=null,
    		assocHotFix = null;
		
		
		// The actual plugin constructor
		function Plugin( element, options ) {
			this.element = element;

			// jQuery has an extend method which merges the contents of two or
			// more objects, storing the result in the first object. The first object
			// is generally empty as we don't want to alter the default options for
			// future instances of the plugin
			this.options = $.extend( {}, defaults, options );
			this.dispatcher = new EventDispatcher();
			this._defaults = defaults;
			this._name = pluginName;

			this.init();
		}

		Plugin.prototype = {
			init: function() {
				$(this.element).addClass('hpsumAddNodeDetails');
				if(this.options.command =='init')
					this.calculate(this.element, this.options);
			},
			recalculate: function() {
				// if(this.options.nodeItem == undefined){
					// window.console.error("recalculate before init is not allowed");
					// return;
				// }
				this.calculate(this.element,this.options);
			},
			calculate: function(el, options) {
				var plugin =this;
			},
			onPopulateError : function(el){
				el.text("GetUpdatelist failed for this node");
			},
			destroy: function(el){
					$(this.element).removeClass('hpsumAddNodeDetails');
					$.removeData(this.element, "plugin_" + pluginName);
			},
			/*
			* Method to render the credential details
			*/
			addCredentials : function()
			{
				var idPrepender = '';
				if(this.element.id != "" && this.element.id != null)
					idPrepender = this.element.id + "_";

					$(this.element).html(
					'<fieldset>'+
						'<ol>'+
							'<li><label><b>'+ localizer.getString('hpsum.common.credentials') +'</b></label></li>'+
							'<li>'+
								'<label for="hpsum-node-type" id="'+idPrepender+'hpsum-node-access-type-label">'+localizer.getString('hpsum.node.accessType')+'</label>' +
								'<span id="'+idPrepender+'span-hpsum-node-access-type">'+
									'<select id="'+idPrepender+'hpsum-node-access-type" class="hp-select" class="hp-error" class="required">' +
										'<option value = "two">'+localizer.getString('hpsum.common.enterAdministratorCredentials')+'</option>' +
										'<option value = "one">'+localizer.getString('hpsum.oneTouchUpdate.useCurrentCredentials')+'</option>' + 
									'</select>'+
								'</span>'+
								'<span id="'+idPrepender+'span-hpsum-node-linux-access-type">'+
									'<select id="'+idPrepender+'hpsum-node-linux-access-type" class="hp-select" class="hp-error" class="required">' +
									   '<option value = "root">'+localizer.getString('hpsum.node.nodeCommonPanel.rootCredentials')+'</option>' + 
									   '<option value = "sudo">'+localizer.getString('hpsum.node.nodeCommonPanel.sudoCredentials')+'</option>' +
									   '<option value = "normalAndSu">'+localizer.getString('hpsum.node.nodeCommonPanel.normalCredentials')+'</option>' +
									   '<option value = "current">'+localizer.getString('hpsum.node.nodeCommonPanel.currentCredentials')+'</option>' +
									'</select>'+
								'</span>'+
								'</br><label id="'+idPrepender+'hpsum-node-trust-relationship" style="padding-left:170px;">'+localizer.getString('hpsum.node.requiresTrustRelationship')+'</label>'+
							'</li>'+
							'<li>'+
								'<div id="'+idPrepender+'hpsum-node-admin-credentials">'+
									'<fieldset>'+
										'<ol>'+
											'<li>'+
												'<label>'+localizer.getString('hpsum.common.username')+'</label>'+
												'<input id="'+idPrepender+'hpsum-node-credential-username" type="text" maxlength="255"/>'+
												'<label id="'+idPrepender+'hpsum-node-username-err" for="hpsum-node-credential-username" class="hp-error" style="display: none;" rel="localize[hpsum.node.required]"> [Required]</label>'+
											'</li>'+
											'<li>'+
												'<label>'+localizer.getString('hpsum.common.password')+'</label>'+
												'<input id="'+idPrepender+'hpsum-node-credential-password" type="password" maxlength="255"/>'+
												'<label id="'+idPrepender+'hpsum-node-password-err"for="hpsum-node-credential-password" class="hp-error" style="display: none;" rel="localize[hpsum.node.required]"> [Required]</label>'+
											'</li>'+
										'</ol>'+
									'</fieldset>'+
								'</div>'+
								'<div id="'+idPrepender+'hpsum-node-su-credentials">'+
									'<fieldset>'+
										'<ol>'+
											'<li>'+
												'<label>'+localizer.getString('hpsum.node.nodeCommonPanel.suUsername')+'</label>'+
												'<input id="'+idPrepender+'hpsum-node-su-username" type="text" maxlength="255"/>'+
												'<label id="'+idPrepender+'hpsum-node-su-username-err" for="hpsum-node-credential-username" class="hp-error" style="display: none;" rel="localize[hpsum.node.required]"> [Required]</label>'+
											'</li>'+
											'<li>'+
												'<label>'+localizer.getString('hpsum.node.nodeCommonPanel.suPassword')+'</label>'+
												'<input id="'+idPrepender+'hpsum-node-su-password" type="password" maxlength="255"/>'+
												'<label id="'+idPrepender+'hpsum-node-su-password-err"for="hpsum-node-credential-password" class="hp-error" style="display: none;" rel="localize[hpsum.node.required]"> [Required]</label>'+
											'</li>'+
										'</ol>'+
									'</fieldset>'+
								'</div>'+
							'</li>'+
						'</ol>'+
					'</fieldset>'
				);
							
				$('#'+idPrepender+'hpsum-node-access-type').selectBox({autoWidth: false});
				$('#'+idPrepender+'hpsum-node-linux-access-type').selectBox({autoWidth: false});
				$('#'+idPrepender+'span-hpsum-node-linux-access-type').hide();
				$('#'+idPrepender+'hpsum-node-su-credentials').hide();
				$('#'+idPrepender+'hpsum-node-trust-relationship').hide();
				
				$('#'+idPrepender+'hpsum-node-access-type').bind('change',function (){
					if($('#'+idPrepender+'hpsum-node-access-type').val().toLowerCase().match(/one/i)) {
						$('#'+idPrepender+'hpsum-node-admin-credentials').hide();
						$('#'+idPrepender+'hpsum-node-trust-relationship').show();
					}
					else{	
						$('#'+idPrepender+'hpsum-node-admin-credentials').show();
						$('#'+idPrepender+'hpsum-node-trust-relationship').hide();
					}
				});
							 
				$('#'+idPrepender+'hpsum-node-linux-access-type').bind('change',function (){
					var accessType = $('#'+idPrepender+'hpsum-node-linux-access-type').val().toLowerCase();
					if(accessType.match(/normalandsu/i)) {
						$('#'+idPrepender+'hpsum-node-admin-credentials').show();
						$('#'+idPrepender+'hpsum-node-su-credentials').show();
					}
					else{	
						$('#'+idPrepender+'hpsum-node-admin-credentials').show();
						$('#'+idPrepender+'hpsum-node-su-credentials').hide();
					}
				});

				$('#hpsum-node-type').bind('change', function(){
					if($('#hpsum-node-type').val().toLowerCase().match(/linux/i))
					{
						$('#'+idPrepender+'span-hpsum-node-linux-access-type').show();
						$('#'+idPrepender+'span-hpsum-node-access-type').hide();
						$('#'+idPrepender+'hpsum-node-trust-relationship').hide();
					}
					else 
					{
						$('#'+idPrepender+'span-hpsum-node-linux-access-type').hide();
						$('#'+idPrepender+'span-hpsum-node-access-type').show();
						$('#'+idPrepender+'hpsum-node-su-credentials').hide();
						if($('#hpsum-node-type').val().toLowerCase().match(/windows/i) && $('#'+idPrepender+'hpsum-node-access-type').val().toLowerCase().match(/one/i))
						{
							$('#'+idPrepender+'hpsum-node-trust-relationship').show();
						}
					}
				});
							 
				credentialsPanelAdded = true;
			},
			/*
			* Method to render the Baseline details
			*/
			loadBaselineData : function (item)
			{
				var idPrepender = '';
				if(this.element.id != "" && this.element.id != null)
					idPrepender = this.element.id + "_";

				var baseline;	
				if(item)
				{
					if(item.baselines.length > 0)
					{
						$('#'+idPrepender+'hpsum-baseline-item').show();
						$('#'+idPrepender+'hpsum-addpackage-item').show();
						var TEMP_ASSOCHOTFIX = '#'+idPrepender+'hpsum-gu-node-addpackage';
						var TEMP_ASSOCBASELINE = '#'+idPrepender+'hpsum-gu-node-baseline';
						$(TEMP_ASSOCHOTFIX).text("");
						$(TEMP_ASSOCBASELINE).text("");
						$('#'+idPrepender+'hpsum-gu-node-addpackage-remove').hide();
						$('#'+idPrepender+'hpsum-gu-node-baseline-remove').hide();
						for (var i=0; i<item.baselines.length; i++ ){
							baseline = presenter.getBaselineDetailsforId(item.baselines[i]);
							if(baseline){
								if(baseline.name.match(/^Additional Package/i)){
									$(TEMP_ASSOCHOTFIX).text(baseline.name);
									$(TEMP_ASSOCHOTFIX).val(baseline.id);
									$('#'+idPrepender+'hpsum-gu-node-addpackage-remove').show();
								}
								else{
									$(TEMP_ASSOCBASELINE).text(baseline.name);
									$(TEMP_ASSOCBASELINE).val(baseline.id);
									$('#'+idPrepender+'hpsum-gu-node-baseline-remove').show();
								}
							}
						}
						$('#'+idPrepender+'hpsum-node-baseline-error').html("Can not change baseline as node is in '"+item.node_state+"' state.");
						if(item.node_state != "IDLE" && item.node_state != "INSTALLDONE")
						{
							$('#'+idPrepender+'hpsum-node-baseline-error').show();
							$('#'+idPrepender+'hpsum-gu-node-baselines-search').hpSearchCombo('disable');
							$('#'+idPrepender+'hpsum-gu-node-addpackage-search').hpSearchCombo('disable');
							$('#'+idPrepender+'hpsum-gu-node-baseline-remove').hide();
							$('#'+idPrepender+'hpsum-gu-node-addpackage-remove').hide();
						}
					}
					else
					{
						$('#'+idPrepender+'hpsum-node-baseline-error').hide();
						$('#'+idPrepender+'hpsum-baseline-item').hide();
						$('#'+idPrepender+'hpsum-addpackage-item').hide();
					}
				}
 			},
			
			getHotfixes : function(string, handlers){
				var results=[];
				if (string && string.length > 0) {
					results = $.grep(hotfixes, function(option, index) {
						return (option.name.match(new RegExp(string, 'i')));
					});	
				}
				handlers.success({count: results.length, members: results});
			},
			
			getBaseline : function(string, handlers){
				var results=[];
				if (string && string.length > 0) {
					results = $.grep(baselines, function(option, index) {
						return (option.name.match(new RegExp(string, 'i')));
					});	
				}
				handlers.success({count: results.length, members: results});
			},
			
			addBaseline : function(item)
			{
				
				var idPrepender = '';
				if(this.element.id != "" && this.element.id != null)
					idPrepender = this.element.id + "_";
				
				$(this.element).html(
					'<fieldset>'+
						'<h2><label style="display:inline;">'+ localizer.getString('hpsum.node.nodeCommonPanel.baselineSelection') +'</label></h2>' +
						'<br>'+
						'<p><label style="display:inline;">'+ localizer.getString('hpsum.node.addBaselineOptional') +'</label></p>'+
						'<ol>'+
						'<div id="'+idPrepender+'hpsum-node-show-assigned-baselines" style="display:none;">'+
							'<li id="'+idPrepender+'hpsum-baseline-item" class="hp-form-item">' +
								'<label for="hpsum-gu-node-baseline">'+ localizer.getString('hpsum.node.currentBaselineSelected') +'</label>' +
								'<label id="'+idPrepender+'hpsum-gu-node-baseline"></label>' +
								'<label id="'+idPrepender+'hpsum-gu-node-baseline-remove" for ="hpsum-gu-node-baseline" style="padding-left:5px"><img src="/img/hp-piano/close.png"></label>' +
							'</li>' +
							'<li id="'+idPrepender+'hpsum-addpackage-item" class="hp-form-item">' +
								'<label for="hpsum-gu-node-addpackage">'+ localizer.getString('hpsum.group.additionalPackageSelected') +'</label>' +
								'<label id="'+idPrepender+'hpsum-gu-node-addpackage"> </label>' +
								'<label id="'+idPrepender+'hpsum-gu-node-addpackage-remove" for ="hpsum-gu-node-addpackage" style="padding-left:5px"><img src="/img/hp-piano/close.png"></label>' +
							'</li>' +
						'</div>'+
							'<li id="'+idPrepender+'hpsum-node-assign-baseline-li">'+
								'<input id="'+idPrepender+'hpsum-node-assign-baseline" type="checkbox"/>' +
								'<label for="'+idPrepender+'hpsum-node-assign-baseline">'+ localizer.getString('hpsum.node.nodeCommonPanel.assignBaseline') +'</label>' +
							'</li>' +
							'<div id="'+idPrepender+'hpsum-node-assign-baseline-div">'+
								'<li class="hp-form-item">'+
									'<label style="padding-left:50px">'+ localizer.getString('hpsum.baseline.custom.baselines') +'</label>' +
									'<select id="'+idPrepender+'hpsum-gu-node-baselines-search"/>' +
								'</li>' +
								'<li class="hp-form-item">'+
									'<label style="padding-left:50px">'+ localizer.getString('hpsum.group.additionalPackage') +'</label>' +
									'<select id="'+idPrepender+'hpsum-gu-node-addpackage-search"/>' +
								'</li>' +
								'<li >' +
									'<label id="'+idPrepender+'hpsum-node-baseline-error" style="padding-left:200px;color:#FF0000;width:300px;" ></label>' +
								'</li>' +
							'</div>'+
						'</ol>' +
					'</fieldset>'
				);
				
				$('#'+idPrepender+'hpsum-node-assign-baseline').bind('change', function(){
					if($(this).is(':checked'))
					{
						$('#'+idPrepender+'hpsum-node-assign-baseline-div').show();
					}
					else
					{
						$('#'+idPrepender+'hpsum-node-assign-baseline-div').hide();
					}
					
				});
				
				if(item.enableAssignBaselineCheckbox == true)
				{
					$('#'+idPrepender+'hpsum-node-assign-baseline-div').hide();
					$('#'+idPrepender+'hpsum-node-assign-baseline-li').show();
				}
				else
				{
					$('#'+idPrepender+'hpsum-node-assign-baseline-li').hide();
				}
				
				if(item.showAssignedBaselines == true)
				{
					$('#'+idPrepender+'hpsum-node-show-assigned-baselines').show()
				}
				else
				{
					$('#'+idPrepender+'hpsum-node-show-assigned-baselines').hide()
				}
				
				$('#'+idPrepender+'hpsum-gu-node-addpackage-remove').hide();
				$('#'+idPrepender+'hpsum-gu-node-baseline-remove').hide();
				$('#'+idPrepender+'hpsum-node-baseline-error').hide();
					
				$('#'+idPrepender+'hpsum-gu-node-baseline-remove').click( function( e ) {
					$('#'+idPrepender+'hpsum-gu-node-baseline').text("");
					$('#'+idPrepender+'hpsum-gu-node-baseline-remove').hide();
					$('#'+idPrepender+'hpsum-gu-node-baselines-search').hpSearchCombo('set', {id:'', name: ''});
				});

				$('#'+idPrepender+'hpsum-gu-node-addpackage-remove').click( function( e ) {
					$('#'+idPrepender+'hpsum-gu-node-addpackage').text("");
					$('#'+idPrepender+'hpsum-gu-node-addpackage-remove').hide();
					$('#'+idPrepender+'hpsum-gu-node-addpackage-search').hpSearchCombo('set', {id:'', name: ''});
				});

				$('#'+idPrepender+'hpsum-gu-node-baselines-search').change(function (ev, value) {
					var name = '';
					var baselineId = '';
					if(value != "" && value != null)
					{
						var item = presenter.getBaselineDetailsforId(value);
						if(item){
							name = item.name;
							baselineId = item.id;
							$('#'+idPrepender+'hpsum-gu-node-baseline-remove').show();
						}
					}
					else
					{
						$('#'+idPrepender+'hpsum-gu-node-baseline-remove').hide();
					}
					$('#'+idPrepender+'hpsum-gu-node-baseline').text(name);
					$('#'+idPrepender+'hpsum-gu-node-baseline').val(baselineId);
				});

				$('#'+idPrepender+'hpsum-gu-node-addpackage-search').change(function (ev, value) {
					var name = '';
					var baselineId = '';
					if(value != "" && value != null)
					{
						var item = presenter.getBaselineDetailsforId(value);
						if(item){
							name = item.name;
							baselineId = item.id;
							$('#'+idPrepender+'hpsum-gu-node-addpackage-remove').show();
						}
					}
					else
					{
						$('#'+idPrepender+'hpsum-gu-node-addpackage-remove').hide();
					}
					$('#'+idPrepender+'hpsum-gu-node-addpackage').text(name);
					$('#'+idPrepender+'hpsum-gu-node-addpackage').val(baselineId);
				});
				
				$('#'+idPrepender+'hpsum-gu-node-addpackage-search').hpSearchCombo({getResults: this.getHotfixes});
				$('#'+idPrepender+'hpsum-gu-node-baselines-search').hpSearchCombo({getResults:this.getBaseline});
				
				presenter.getAllBaselines({
					success: function(searchResults){
							baselines = $.grep(searchResults, function (option, index ) {
								return !(option.name.match(new RegExp('^Additional', 'i')));
							});
							hotfixes = $.grep(searchResults, function (option, index) {
								return (option.name.match(new RegExp('^Additional', 'i')));
							});
					},
					error: function(msg){
					}
				});
			},
			/*
			* Method to display node description, node type, and option to add associated nodes and currently running HPSUM instance
			*/
			addNodeDetails : function(item)
			{
				var idPrepender = '';
				if(this.element.id != "" && this.element.id != null)
					idPrepender = this.element.id + "_";
				
				$(this.element).html(
					'<fieldset>'+
						'<ol id="'+idPrepender+'hpsum-node-active-update">'+
							'<li class="hp-form-item"><label for="'+idPrepender+'hpsum-node-description" id="hpsum-node-description-label">description</label><input id="'+idPrepender+'hpsum-node-description" maxlength="255" /></li>'+
							'<li class="hp-form-item">' +
								'<label for="hpsum-node-type" id="hpsum-node-type-label"></label>' +
								'<select id="hpsum-node-type" class="hp-select" class="hp-error" class="required">' +
									'<option value = "selecttype">'+localizer.getString('hpsum.node.selectType')+'</option>' + 
									'<option value = "windows">'+localizer.getString('hpsum.common.windows')+'</option>' +
									'<option value = "linux">'+localizer.getString('hpsum.common.linux')+'</option>' +
									'<option value = "hpux">'+localizer.getString('hpsum.common.hpux')+'</option>' +
									'<option value = "vmware">'+localizer.getString('hpsum.node.vmWareHost')+'</option>' +
									'<option value = "enclosure">'+localizer.getString('hpsum.node.onboardAdministrator')+'</option>' +
									'<option value = "sd2">'+localizer.getString('hpsum.node.superdome2onboardAdministrator')+'</option>' +
									'<option value = "sas_switch">'+localizer.getString('hpsum.node.hpSasBlInterconnectSwitch')+'</option>' +
									'<option value = "switch">'+localizer.getString('hpsum.node.fibreChannelSwitch')+'</option>' +
									'<option value = "ilo">'+localizer.getString('hpsum.common.ilo')+'</option>' +
									'<option value = "ipdu">'+localizer.getString('hpsum.node.intelligentPowerDistributionUnit')+'</option>' +
									'<option value = "vc">'+localizer.getString('hpsum.node.virtualConnect')+'</option>' +
									'<option value = "unknown">'+localizer.getString('hpsum.common.unknown')+'</option>'+
								'</select>' +
								'<label style="padding-left:10px;" class="hp-error" id ="hpsum-node-type-error"></label>' +
							'</li>'+
							'<li class="hp-form-item" id="'+idPrepender+'hpsum-node-enable-addassocnodes">' +
								'<div>'+
									'<input id="'+idPrepender+'hpsum-node-addassocnodes" type="checkbox"/>' +
									'<label for="hpsum-node-addassocnodes" id="'+idPrepender+'hpsum-node-addassoc-description""></label>' +
								'</div>'+
							'</li>'+
							'<div id="'+idPrepender+'hpsum-node-active-hpsum-process">'+
							'<li class="hp-form-item">'+
								'<div>'+
									'<label id ="'+idPrepender+'hpsum-node-active-update-label" rel="localize[hpsum.node.activeProcess]">[If active update process is detected on the remote node, HPSUM should]</label>'+
								'</div>'+
							'</li>'+
							'<li>'+
								'<div>'+
									'<input id="'+idPrepender+'hpsum-node-leave-active"  type="radio" name="hpsum-node-active" value="one" checked/>'+
									'<label for="'+idPrepender+'hpsum-node-leave-active" id ="'+idPrepender+'hpsum-node-keep-active-update" style="margin-top: 10px; max-width: 500px" rel="localize[hpsum.node.leaveAlone]">[Leave the update running and bypass the node]</label>'+
								'</div>'+
							'</li>'+
							'<li>'+
								'<div>'+
									'<input id="'+idPrepender+'hpsum-node-replace" type="radio" name="hpsum-node-active" value="two" checked style="vertical-align: top;"/>'+
									'<label for="'+idPrepender+'hpsum-node-replace" style="max-width: 500px;" id ="'+idPrepender+'hpsum-node-stop-active-update" rel="localize[hpsum.node.replaceSession]">[Stop any currently running update process on the node and replace it with updates from this session]</label>'+
								'</div>'+
							'</li>'+
							'</div>'+
						'</ol>'+
					'</fieldset>'
				);
				$('#'+idPrepender+'hpsum-node-addassocnodes').hide();
				$('#'+idPrepender+'hpsum-node-addassoc-description').hide();
				if(item.enableAssociateNodes == false)
				{
					$('#'+idPrepender+'hpsum-node-enable-addassocnodes').hide();
				}				
				$('#'+idPrepender+'hpsum-node-description-label').html(localizer.getString('hpsum.common.description'));
				$('#hpsum-node-type-label').html(localizer.getString('hpsum.common.type'));
				$('#'+idPrepender+'hpsum-node-active-update-label').html(localizer.getString('hpsum.node.activeProcess'));
				$('#'+idPrepender+'hpsum-node-keep-active-update').html(localizer.getString('hpsum.node.leaveAlone'));
				$('#'+idPrepender+'hpsum-node-stop-active-update').html(localizer.getString('hpsum.node.replaceSession'));
				$('#'+idPrepender+'hpsum-node-addassoc-description').html(localizer.getString('hpsum.node.nodeCommonPanel.autoAddAssoNodes'));
								
				$('#hpsum-node-type').selectBox({autowidth: false});
				$('#'+idPrepender+'hpsum-node-active-hpsum-process').hide();
				
				$('#hpsum-node-type').bind('change', function(){
					if($('#hpsum-node-type').val().toLowerCase().match(/vc/i) ||
						$('#hpsum-node-type').val().toLowerCase().match(/sas_switch/i) ||
						$('#hpsum-node-type').val().toLowerCase().match(/enclosure/i) ||
						$('#hpsum-node-type').val().toLowerCase().match(/switch/i) ||
						$('#hpsum-node-type').val().toLowerCase().match(/ilo/i)) 
					{
							$('#'+idPrepender+'hpsum-node-addassocnodes').show();
							$('#'+idPrepender+'hpsum-node-addassoc-description').show();
					}
					else{	
						$('#'+idPrepender+'hpsum-node-addassocnodes').hide();
						$('#'+idPrepender+'hpsum-node-addassoc-description').hide();
					}
					if($('#hpsum-node-type').val().toLowerCase().match(/windows/i) ||
						$('#hpsum-node-type').val().toLowerCase().match(/linux/i) ||
						$('#hpsum-node-type').val().toLowerCase().match(/hpux/i)) 
					{
							$('#'+idPrepender+'hpsum-node-active-hpsum-process').show();
					}
					else{	
						$('#'+idPrepender+'hpsum-node-active-hpsum-process').hide();
					}
					
				});
				nodeDetailsPanelAdded = true;
			},
			/*
			* Helper method to load node description and node type.
			*/
			loadNodeDetails : function(item)
			{
				
				var idPrepender = '';
				if(this.element.id != "" && this.element.id != null)
					idPrepender = this.element.id + "_";
				if(item)
				{
					$('#hpsum-node-type').selectBox('value', item.type);
					$('#'+idPrepender+'hpsum-node-description').val(item.description);
				}
			},
			/*
			* Helper method to get node details
			*/
			getNodeDetails : function()
			{
				var idPrepender = '';
				if(this.element.id != "" && this.element.id != null)
					idPrepender = this.element.id + "_";
				
				var nodeDetails ={
					nodeDescription : "",
					nodeType : "",
					isAddAssociatedNodes : false,
					nodeSkip : false
				};

				if($('#'+idPrepender+'hpsum-node-addassocnodes').is(':checked'))
					nodeDetails.isAddAssociatedNodes = true;
				else
					nodeDetails.isAddAssociatedNodes = false;
				
				nodeDetails.nodeType = $('#hpsum-node-type').val();
				nodeDetails.nodeDescription = $('#'+idPrepender+'hpsum-node-description').val();
				
				var node_skip = $("input[name='"+idPrepender+"hpsum-node-active']:checked").val();
				if(node_skip == "one")
					nodeDetails.nodeSkip = true;
				else 
					nodeDetails.nodeSkip = false;
				return nodeDetails;
			},
			/*
			* Helper method to validate the credentials entered. This method can be used on parent javascript page to validate the credential inputs 
			*/
			validateCredentials : function()
			{
				var idPrepender = '';
				if(this.element.id != "" && this.element.id != null)
					idPrepender = this.element.id + "_";
				
				var valid = true;
				if($('#hpsum-node-type').val().toLowerCase().match(/linux/i))
				{
					if($('#'+idPrepender+'hpsum-node-credential-username').val() == '')
					{
						$('#'+idPrepender+'hpsum-node-credential-username').addClass("hp-error");
						$('#'+idPrepender+'hpsum-node-username-err').show();
						$('#'+idPrepender+'hpsum-node-credential-username').bind('keyup', function(){
							$('#'+idPrepender+'hpsum-node-username-err').hide();
							$('#'+idPrepender+'hpsum-node-credential-username').removeClass('hp-error');
						});
						valid = false;
					}
					if($('#'+idPrepender+'hpsum-node-credential-password').val() == '')
					{
						$('#'+idPrepender+'hpsum-node-credential-password').addClass("hp-error");
						$('#'+idPrepender+'hpsum-node-password-err').show();
						$('#'+idPrepender+'hpsum-node-credential-password').bind('keyup', function(){
							$('#'+idPrepender+'hpsum-node-password-err').hide();
							$('#'+idPrepender+'hpsum-node-credential-password').removeClass('hp-error');
						});
						valid = false;
					}
				
					if($('#'+idPrepender+'hpsum-node-linux-access-type').val().toLowerCase().match(/normalAndSu/i))
					{
						if($('#'+idPrepender+'hpsum-node-su-username').val() == '')
						{
							$('#'+idPrepender+'hpsum-node-su-username').addClass("hp-error");
							$('#'+idPrepender+'hpsum-node-su-username-err').show();
							$('#'+idPrepender+'hpsum-node-su-username').bind('keyup', function(){
								$('#'+idPrepender+'hpsum-node-su-username-err').hide();
								$('#'+idPrepender+'hpsum-node-su-username').removeClass('hp-error');
							});
							valid = false;
						}
						if($('#'+idPrepender+'hpsum-node-su-password').val() == '')
						{
							$('#'+idPrepender+'hpsum-node-su-password').addClass("hp-error");
							$('#'+idPrepender+'hpsum-node-su-password-err').show();
							$('#'+idPrepender+'hpsum-node-su-password').bind('keyup', function(){
								$('#'+idPrepender+'hpsum-node-su-password-err').hide();
								$('#'+idPrepender+'hpsum-node-su-password').removeClass('hp-error');
							});
							valid = false;
						}
					}
				}
				else
				{
					if($('#'+idPrepender+'hpsum-node-access-type').val().toLowerCase().match(/two/i))
					{
						if($('#'+idPrepender+'hpsum-node-credential-username').val() == '')
						{
							$('#'+idPrepender+'hpsum-node-credential-username').addClass("hp-error");
							$('#'+idPrepender+'hpsum-node-username-err').show();
							$('#'+idPrepender+'hpsum-node-credential-username').bind('keyup', function(){
								$('#'+idPrepender+'hpsum-node-username-err').hide();
								$('#'+idPrepender+'hpsum-node-credential-username').removeClass('hp-error');
							});
							valid = false;
						}
						if($('#'+idPrepender+'hpsum-node-credential-password').val() == '')
						{
							$('#'+idPrepender+'hpsum-node-credential-password').addClass("hp-error");
							$('#'+idPrepender+'hpsum-node-password-err').show();
							$('#'+idPrepender+'hpsum-node-credential-password').bind('keyup', function(){
								$('#'+idPrepender+'hpsum-node-password-err').hide();
								$('#'+idPrepender+'hpsum-node-credential-password').removeClass('hp-error');
							});
							valid = false;
						}
					}
				}
				return valid;
			},
			/*
			* Helper method to get credential details
			*/
			getCredentialDetails : function()
			{
				var idPrepender = '';
				if(this.element.id != "" && this.element.id != null)
					idPrepender = this.element.id + "_";
			
				var credentials ={
					useCurrentCredentials : false,
					useSudoCredentials : false,
					useRootCredentials : false,
					useNormalAndSuUserCredentials : false,
					linuxSuUser : "",
					linuxSuPwd : "",
					adminUser : "",
					adminPwd : "",
					nodeType : ""
					
				};
				//credentials.useCurrentCredentials = false;
				credentials.nodeType = $('#hpsum-node-type').val().toLowerCase();
				if($('#hpsum-node-type').val().toLowerCase().match(/linux/i))
				{
					if($('#'+idPrepender+'hpsum-node-linux-access-type').val().toLowerCase().match(/current/i))
					{
						credentials.useCurrentCredentials = true;
					}
					else 
					{	
						credentials.adminUser = $('#'+idPrepender+'hpsum-node-credential-username').val();
						credentials.adminPwd = $('#'+idPrepender+'hpsum-node-credential-password').val();
						if($('#'+idPrepender+'hpsum-node-linux-access-type').val().toLowerCase().match(/sudo/i))
							credentials.useSudoCredentials = true;
							
						else if($('#'+idPrepender+'hpsum-node-linux-access-type').val().toLowerCase().match(/root/i))
							credentials.useRootCredentials = true;
						else if($('#'+idPrepender+'hpsum-node-linux-access-type').val().toLowerCase().match(/normalAndSu/i))
						{
							credentials.linuxSuUser = $('#'+idPrepender+'hpsum-node-su-username').val();
							credentials.linuxSuPwd = $('#'+idPrepender+'hpsum-node-su-password').val();
							credentials.useNormalAndSuUserCredentials = true;
						}
					}
				}
				else
				{
					if($('#'+idPrepender+'hpsum-node-access-type').val().toLowerCase().match(/two/i))
					{
						credentials.adminUser = $('#'+idPrepender+'hpsum-node-credential-username').val();
						credentials.adminPwd = $('#'+idPrepender+'hpsum-node-credential-password').val();
					}
					else
						credentials.useCurrentCredentials = true;
				}
				return credentials;
			},
			
			/*
			* Method to display Reboot and Installation options
			*/
			
			addRebootOptions : function()
			{
				var idPrepender = '';
				if(this.element.id != "" && this.element.id != null)
					idPrepender = this.element.id + "_";
				
				$(this.element).html(
					'<fieldset>' +
						'<ol>' +
						'<div id="'+idPrepender+'hpsum-reboot-options">' +
							'<label><b>'+ localizer.getString('hpsum.node.rebootOptions') +'</b></label>' +
							'<ol id="'+idPrepender+'hpsum-common-reboot-options">'+
									'<li class="hp-form-item">'+
									'<select id="'+idPrepender+'hpsum-reboot-option" class="hp-select" >'+
										'<option value="Never">'+ localizer.getString('hpsum.node.nodeCommonPanel.noreboot') +'</option>'+
										'<option value="If Needed">'+ localizer.getString('hpsum.node.nodeCommonPanel.ifNeeded') +'</option>'+
										'<option value = "Always">'+ localizer.getString('hpsum.node.nodeCommonPanel.always') +'</option>'+        
									'</select>'+
								'</li>'+
								'<li id="'+idPrepender+'hpsum-reboot-delay" class="hp-form-item">'+
									'<label for="hpsum-node-delay-seconds" style="width:inherit;">'+ localizer.getString('hpsum.node.rebootDelay') +'</label>'+
									'<input id="'+idPrepender+'hpsum-node-delay-seconds" placeholder=3600 type="number" min="15" max="3600" >'+
								'</li>'+
								'<li id="'+idPrepender+'hpsum-reboot-message" class="hp-form-item">'+
									'<label for="hpsum-node-reboot-message" style="vertical-align:top; width:inherit;">'+ localizer.getString('hpsum.node.enterRebootMessage') +'</label>'+
									'<textarea id="'+idPrepender+'hpsum-node-reboot-message" size="40x2" style="resize: none; width: 300px; height: 100px;" maxlength="255">'+ localizer.getString('hpsum.node.rebootMessage') +' </textarea>'+
								'</li>'+
							'</ol>'+
							'<ol id="'+idPrepender+'hpsum-reboot-to-activate-options">'+
								'<li class="hp-form-item">'+
									'<label for="hpsum-activate-selection" style="width:inherit">'+ localizer.getString('hpsum.integrityilo.rebootToActivate') +'</label>'+
									'<select id="'+idPrepender+'hpsum-activate-selection" class="require-analysis">'+
										'<option value = "NO">'+ localizer.getString('hpsum.common.no') +'</option>'+
										'<option value = "YES">'+ localizer.getString('hpsum.common.yes') +' </option>'+
									'</select>'+
								'</li>'+
								'<li class="hp-form-item">'+
									'<label id="'+idPrepender+'hpsum-no-reboot-required"><i>'+ localizer.getString('hpsum.integrityilo.rebootNotNeeded') +'</i></label>'+
								'</li>'+
							'</ol>'+
						'</div>'+
					'</ol>'+
					'<ol>'+
						'<div id="'+idPrepender+'hpsum-installation-options">'+
								'<label><b>'+ localizer.getString('hpsum.node.nodeCommonPanel.installationforceOptions') +'</b></label>'+
								'<ol>'+
									'<li class="hp-form-item">'+
										'<input id="'+idPrepender+'downgradechkbox" class="require-analysis" type="checkbox" />'+
										'<label>'+ localizer.getString('hpsum.node.installationOptionDowngrade') +'</label>'+
									'</li>'+
									'<li class="hp-form-item">'+
										'<input id="'+idPrepender+'rewritechkbox" class="require-analysis" type="checkbox" />'+
										'<label>'+ localizer.getString('hpsum.node.installationOptionRewrite') +'</label>'+
									'</li>'+
								'</ol>'+
							'</div>'+
						'<div id="'+idPrepender+'hpsum-force-options">'+
							'<ol>'+
								'<li class="hp-form-item">'+
									'<label style="text-align:left; min-width:inherit;width:inherit;">'+ localizer.getString('hpsum.node.nodeCommonPanel.applyTo') +'</label>'+
									'<select id="'+idPrepender+'hpsum-force-option" class="hp-select" >'+
										'<option value="All">'+ localizer.getString('hpsum.node.nodeCommonPanel.forceOptionAll') +'</option>'+
										'<option value="Firmware">'+ localizer.getString('hpsum.node.nodeCommonPanel.forceOptionFirmware') +'</option>'+
										'<option value = "Software">'+ localizer.getString('hpsum.node.nodeCommonPanel.forceOptionSoftware') +'</option>'+        
									'</select>'+
								'</li>'+
								'</ol>'+
							'</div>'+
						'</ol>'+
					'</fieldset>'
				);
				$('#'+idPrepender+'hpsum-reboot-option').selectBox({autoWidth: false});
				$('#'+idPrepender+'hpsum-force-option').selectBox({autoWidth: false});
				$('#'+idPrepender+'hpsum-reboot-to-activate-options').hide();
				$('#'+idPrepender+'hpsum-reboot-option').change(function()
				{
					var rebootvalue = $(''+idPrepender+'#hpsum-reboot-option').val();
					if(rebootvalue === "Never"){
						$('#'+idPrepender+'hpsum-reboot-delay').hide();
						$('#'+idPrepender+'hpsum-reboot-message').hide();
					}
					else{
						$('#'+idPrepender+'hpsum-reboot-delay').show();
						$('#'+idPrepender+'hpsum-reboot-message').show();
					}
				});
			},
			
			/*
			* Method to load Reboot and Installation options from getattributes during page load
			*/
			loadRebootOptions : function(data)
			{
				var idPrepender = '';
				if(this.element.id != "" && this.element.id != null)
					idPrepender = this.element.id + "_";
				
				if(data){
					if(data.hasOwnProperty("reboot_options") && data.reboot_options){
						$('#'+idPrepender+'hpsum-reboot-option option').filter(function() {
							if(new RegExp(this.value, 'ig').test( data.reboot_options.action))
								$(this).attr('selected', true);
						});
						if( -1 < data.reboot_options.delay){
							$('#'+idPrepender+'hpsum-node-delay-seconds').val(data.reboot_options.delay);				
						}
						else{
							$('#'+idPrepender+'hpsum-node-delay-seconds').val('3600');				
						}
						$('#'+idPrepender+'hpsum-node-reboot-message').attr('value', data.reboot_options.message);	

						if(data.reboot_options.action === "Never"){
							$('#'+idPrepender+'hpsum-reboot-delay').hide();
							$('#'+idPrepender+'hpsum-reboot-message').hide();
						}			
					}
					if(data.hasOwnProperty("installation_option") && data.installation_option){
						$('#'+idPrepender+'downgradechkbox').attr('checked', data.installation_option.downgrade);							
						$('#'+idPrepender+'rewritechkbox').attr('checked', data.installation_option.rewrite);
						var firmware = data.installation_option.firmware;
						var software = data.installation_option.software;
						var forceOption;
						
						if(!firmware && !software)
							forceOption = "All";
						else if(firmware)
							forceOption = "Firmware";
						else
							forceOption = "Software";
							
						$('#'+idPrepender+'hpsum-force-option option').filter(function() {
							if(new RegExp(this.value, 'ig').test(forceOption))
								$(this).attr('selected', true);
						});
					}
				}
			},
			
			/*
			* Method to read the values of Reboot and Installation options
			*/
			getRebootOptions : function()
			{
				var idPrepender = '';
				if(this.element.id != "" && this.element.id != null)
					idPrepender = this.element.id + "_";
				
				var options = {
					installation_options:{
						firmware :false,
						software :false,
						downgrade: false,
						rewrite:false,
						force:false							
					},
					reboot_options: {
						action:'Never',
						delay :'',
						message :''												
					},
				};
			
				options.reboot_options.action = $('#'+idPrepender+'hpsum-reboot-option').val();
				options.reboot_options.delay = $('#'+idPrepender+'hpsum-node-delay-seconds').val();
				options.reboot_options.message = $('#'+idPrepender+'hpsum-node-reboot-message').val();
				
				var forceOption = $('#'+idPrepender+'hpsum-force-option').val();
				if(forceOption === "Firmware")
					options.installation_options.firmware = true;
				if(forceOption === "Software")
					options.installation_options.software = true;
				options.installation_options.rewrite = $('#'+idPrepender+'rewritechkbox').is(':checked');	
				options.installation_options.downgrade = $('#'+idPrepender+'downgradechkbox').is(':checked');	
				
				return options;
			},
			/*
			 *	Method to load the OS Management Options
			 */
			loadOSManagementOptions : function(data)
			{
				var idPrepender = '';
				if(this.element.id != "" && this.element.id != null)
					idPrepender = this.element.id + "_";
				
				if(data)
				{
					if(data.hasOwnProperty("os_management_options") && data.os_management_options)
					{
						$('#'+idPrepender+'hpsum-snmp-management-option').attr('checked', false);							
						$('#'+idPrepender+'hpsum-agentless-management-option').attr('checked', false);							
						$('#'+idPrepender+'hpsum-webem-management-option').attr('checked', false);
						if( data.os_management_options.length > 0)
						{
							if(data.os_management_options[0].match(/NONE/i))
								$(NONECHECKBOX).attr('checked', true);
							else{
								if (data.os_management_options[0].match(/AMS/i))
									$('#'+idPrepender+'hpsum-agentless-management-option').attr('checked', true);
								if (data.os_management_options[0].match(/SNMP/i))
									$('#'+idPrepender+'hpsum-snmp-management-option').attr('checked', true);
								if (data.os_management_options[0].match(/WBEM/i))
									$('#'+idPrepender+'hpsum-webem-management-option').attr('checked', true);
							}
						}
					}
				}
			},
			/*
			 *	Method to return the OS Management Options
			 */
			getOSManagementOptions : function()
			{	
				var idPrepender = '';
				if(this.element.id != "" && this.element.id != null)
					idPrepender = this.element.id + "_";
				
				var os_management_options = '';
		
				if($('#'+idPrepender+'hpsum-snmp-management-option').attr('checked'))
					os_management_options += "SNMP|";						
				if($('#'+idPrepender+'hpsum-agentless-management-option').attr('checked'))
					os_management_options += "AMS|";													
				if($('#'+idPrepender+'hpsum-webem-management-option').attr('checked'))
					os_management_options += "WBEM|";
			 
				return os_management_options;	
			},
			/*
			 *	Method to provide the OS Management Options
			 */
			addOSManagementOptions : function()
			{
				var idPrepender = '';
				if(this.element.id != "" && this.element.id != null)
					idPrepender = this.element.id + "_";

				/* Add OS Management Options */	
				$(this.element).html(
					'<fieldset>'+
						'<ol id="hpsum-node-os-management">'+
							'<li><label><b>'+ localizer.getString('hpsum.node.osManagementOptions') +'</b></label></li>'+
								'<fieldset>' +
									'<ol>' +
										'<div class="hp-collapsible" id="'+idPrepender+'"hpsum-osmanagement-options-collapsible"><label>'+ localizer.getString('hpsum.node.osManagementOptions') +'</label>' +
											'<fieldset>' +
												'<ol>' +
													'<div>' +
														'<select id="'+idPrepender+'"hpsum-os-management-drop-down" class="hp-select selectbox" class="hp-error" class="required">' +
															'<option value = "type">'+ localizer.getString('hpsum.node.nodeCommonPanel.selectManagementOptions') +'</option>' +
															'<option value = "none">'+ localizer.getString('hpsum.node.nodeCommonPanel.noManagementOptions') +'</option>' +
														'</select>' +
													'</div>' +
												'</ol>' +
											'</fieldset>' +
											'<div id="'+idPrepender+'"osmanagement-tbody">' +
												'<table>' +
													'<tbody>' +
														'<tr>' +
															'<td><input class="useSNMPcheckbox require-analysis" id="'+idPrepender+'"hpsum-snmp-management-option" type="checkbox"/></td>' +
															'<td>'+ localizer.getString('hpsum.node.useSnmp') +'</td>' +														
														'</tr>' +
														'<tr>' +
															'<td><input class="useAgentlesscheckbox require-analysis" id="'+idPrepender+'"hpsum-agentless-management-option" type="checkbox"/></td>' +
															'<td>'+ localizer.getString('hpsum.node.agentlessManagementService') +'</td>' +														
														'</tr>' +
														'<tr>' +
															'<td><input class="useWEBEMcheckbox require-analysis" id="'+idPrepender+'"hpsum-webem-management-option" type="checkbox"/></td>' +
															'<td>'+ localizer.getString('hpsum.node.useWebem') +'</td>' +													
														'</tr>' +																	 
													'</tbody>' +
												'</table>' +
											'</div>' +						
										'</div>' +										
									'</ol>' +
								'</fieldset>' +
						'</ol>' +
					'</fieldset>'
				);
									
				$('#hpsum-os-management-drop-down').bind('change', function(){
					if($('#hpsum-os-management-drop-down').val() == "none")
						$('#osmanagement-tbody').hide();		
					else
						$('#osmanagement-tbody').show();		
				});

				$('.useWEBEMcheckbox').hpToggle({checked: 'Selected', unchecked: 'Select'});
				$('.useAgentlesscheckbox').hpToggle({checked: 'Selected', unchecked: 'Select'});
				$('.useSNMPcheckbox').hpToggle({checked: 'Selected', unchecked: 'Select'});
				$('#hpsum-os-management-drop-down').selectBox({autoWidth: false});
				
				osManagementOptionsPanelAdded = true;
			},
			getSelectedBaseline : function (nodeId)
			{
				var idPrepender = '';
				if(this.element.id != "" && this.element.id != null)
					idPrepender = this.element.id + "_";
				
				var baseline_options={
					newBaseline:"",
					newHotFix:""
				};
				baseline_options.newHotFix = $('#'+idPrepender+'hpsum-gu-node-addpackage').val();
				baseline_options.newBaseline = $('#'+idPrepender+'hpsum-gu-node-baseline').val();
				return baseline_options;
			}
				
		};
		
		// A really lightweight plugin wrapper around the constructor,
		// preventing against multiple instantiations
		$.fn[pluginName] = function ( options ) {
			var instance;
			if ( typeof options === 'string')
			{
				if(options.match(/init/i) ) { 
					return this.each(function () {
						if (!$.data(this, "plugin_" + pluginName)) {
							$.data(this, "plugin_" + pluginName, new Plugin( this, options ));
						}
					});
				}
			}
			var argument,args;
			if (typeof options === 'string'){
				argument = options;
				args = Array.prototype.slice.call( arguments, 1 );
			}
			else{
				argument = options.command;
				args = options.args;
			}
			// call method
			//var args = Array.prototype.slice.call( arguments, 1 );
			this.each(function() {
				instance = $.data( this, "plugin_" + pluginName );
				if ( !instance ) {
					if (window.console) {
						window.console.error( "cannot call methods on hpsumAddNodeDetails prior to initialization; " +
							"attempted to call method '" + argument + "'" );
					}
					return;
				}
				if ( !$.isFunction( instance[argument] ) || argument.charAt(0) === "_" ) {
					if (window.console) {
						window.console.error( "no such method '" + argument + "' for hpsumAddNodeDetails instance" );
					}
					return;
				}
				// apply method
				instance[ argument ].call( instance, args );
			});  
		};
	}(jQuery));
});
	
