define(['hpsum/presenter/node/NodePresenter',
		'hpsum/presenter/baseline/BaselinePresenter',
		'hp/core/EventDispatcher',
		'hp/core/Localizer', 
		'hp/view/DialogView',
		'text!hpsumpages/node/component_dialog.html',   
		'jquery', 
		'hp/lib/jquery.hpStatus',
		'lib/jquery.dataTables',
		'hp/lib/jquery.hpCollapsible',
		'hp/lib/jquery.hpToggle'], 
function(presenter,baselinePresenter, EventDispatcher, localizer,DialogView,componentDialogHtml) {"use strict";
	(function($) {
		// Create the defaults once
  		var pluginName = "hpsumInstallables",
        defaults = {
            nodeItem: null
        };
		function initInstallReviewTable(tableid) {
			var oTab = $(tableid).dataTable({
				oLanguage : {
					sEmptyTable : localizer.getString("hpsum.node.noApplicableComponentsFound"),
                    sSearch: localizer.getString("hpsum.common.search")
				},
				bPaginate : false,
				bProcessing : true,
				bFilter : true,
				bSort : true,
				bAutoWidth : false,
				bInfo : false,
				bRetrieve : true,
				bDestroy : true,
				//aaData: data,
				aoColumns : [
				{mDataProp: 'group_id', "bVisible": false},
				{
					mDataProp : 'selected'
				},
				{
					mDataProp : 'name'
				}, {
						mDataProp : 'status',
					}, {
						mDataProp : 'product_type'
						}, {
						mDataProp : 'product_sub_type'
						}, {
							mDataProp : 'installed_version',
							fnRender: function(oObj){
								var version = oObj.aData.installed_version;
								var device_info = oObj.aData.device_info;
								if((version == '') && (device_info != ''))
									return '<a id="device_info" href="javascript:void(0);">View Devices</a>';
								else
									return version;
							}
							
						}, {
							mDataProp : 'active_version',
							fnRender: function(oObj){
								var version = oObj.aData.active_version;
								var device_info = oObj.aData.device_info;
								if((version == '') && (device_info != ''))
									return '<a id="device_info" href="javascript:void(0);">View Devices</a>';
								else
									return version;
							}
							
						}, {
							mDataProp : 'available_version',
							 fnRender: function (oObj) {
								var version = oObj.aData.available_version;
								return '<a id="revision_history" href="javascript:void(0);">' + version+ '</a>';
							}
						},
						//{mDataProp: 'has_failed_dependencies'},
						{mDataProp: 'baseline_details', "bVisible": false}, 
						{
							mDataProp : 'file_name',
							"bVisible" : false
						}, {
							mDataProp : 'component_id',
							"bVisible" : false
						}, {
							mDataProp : 'failed_deps',
							"bVisible" : false
						},
						{mDataProp: 'group_name', "bVisible": false}, 
						{
							mDataProp : 'device_info',
							"bVisible" : false
				}],
				fnCreatedRow:function(nRow, aData, iDataIndex){
					if(aData.status.match(/ok|selected/i))
								nRow.className += ' hp-selected ' + aData.group_id;
						else{
								if(aData.status.match(/selectable/i))
									nRow.className += ' ' + aData.group_id;
								else
									nRow.className += ' hp-disabled ' + aData.group_id;
							}
				},
				//aaSorting : [],
				fnRowCallback : function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
					//nRow.className += ' ' + aData.group_id;
					return nRow;
				},
				"fnDrawCallback": function ( oSettings ) {
			if ( oSettings.aiDisplay.length == 0 )
			{
				return;
			}
			
			var nTrs = $(tableid + ' tbody tr');
			var iColspan = nTrs[0].getElementsByTagName('td').length;
			var sLastGroup = "";
			for ( var i=0 ; i<nTrs.length ; i++ )
			{
				var iDisplayIndex = oSettings._iDisplayStart + i;
				var sGroup = oSettings.aoData[ oSettings.aiDisplay[iDisplayIndex] ]._aData.group_id;
				var sGroupName = oSettings.aoData[ oSettings.aiDisplay[iDisplayIndex] ]._aData.group_name;
				if(sGroup == ''){
					sLastGroup = sGroup;
					continue;
				}
				if ( sGroup != sLastGroup )
				{
					var nGroup = document.createElement( 'tr' );
					nGroup.className='hp-disabled';
					var nCell = document.createElement( 'td' );
					nCell.colSpan = iColspan;
					nCell.className = "group";
					nCell.innerHTML = '<b>' + sGroupName + '</b>';
					nGroup.appendChild( nCell );
					nTrs[i].parentNode.insertBefore( nGroup, nTrs[i] );
					sLastGroup = sGroup;
				}
			}
			$('.group').css({'background-color': '#dddddd'});
		},
		"aaSortingFixed": [[ 0, 'asc' ]],
		"aaSorting": [[ 1, 'asc' ]],
		"sDom": 'lfr<"giveHeight"t>ip'
			});

			$(tableid + ' tbody tr').first().addClass('hp-selected');
		}
    // The actual plugin constructor
    function Plugin( element, options ) {
        this.element = element;

        // jQuery has an extend method which merges the contents of two or
        // more objects, storing the result in the first object. The first object
        // is generally empty as we don't want to alter the default options for
        // future instances of the plugin
        this.options = $.extend( {}, defaults, options );
		this.dispatcher = new EventDispatcher();
        this._defaults = defaults;
        this._name = pluginName;

        this.init();
    }

    Plugin.prototype = {

        init: function() {
			$(this.element).addClass('hpsumInstallables');
			if(this.options.command =='init')
           		this.calculate(this.element, this.options);

        },
        getComponents:function(el){
        	if(this.options.nodeItem == null)
        		return false;
        	var nodeItem = this.options.nodeItem;
        	var tableid = '#hpsum-otu-installables-' + nodeItem.node_id+ '-table';
        	var currTable= $(tableid).dataTable();
        	var selectedRows = $(tableid + ' tbody tr');
			var selectedComps = [];
			var componentsList = {
				hapi : {
					components : {
						component : []
					}
				}
			};
			//var grouprows = $()
        	for (var tmp = 0; tmp < selectedRows.length; tmp++) {
				var compData = currTable.fnGetData(selectedRows[tmp]._DT_RowIndex);
				if(compData == null)
					continue;
				var bselected = false, bforce = false;

				if (selectedRows[tmp].className.indexOf('hp-selected') != -1)
					bselected = true;
				else
					bselected = false;
				if (bselected && selectedRows[tmp].firstChild.firstChild) 
				{
					var toggle_name = selectedRows[tmp].firstChild.firstChild.id
					if ($('#' + toggle_name)[0].innerHTML.match(localizer.getString("hpsum.oneTouchUpdate.forced"))){
						bforce = true;
					}
				}
				var item = {
					component_name : compData.file_name,
					selected : bselected,
					force : bforce
				};

				componentsList.hapi.components.component.push(item);
			}
        	return componentsList;
        },
        getSelectedComponents:function(id){
        	 if(id == null)
        		return false;
        	var tableid = '#hpsum-otu-installables-' + id+ '-table';
        	var currTable= $(tableid).dataTable();
        	var selectedList= {failed_dependency:0,
        					component:[]};
        	var selectedRows = $(tableid + ' tbody tr');
        	for (var tmp = 0; tmp < selectedRows.length; tmp++) {
				var compData = currTable.fnGetData(selectedRows[tmp]._DT_RowIndex);
				if (selectedRows[tmp].className.indexOf('hp-selected') != -1){
					if(compData){
					selectedList.component.push(compData.file_name);
					if(compData.failed_deps != '')
						selectedList.failed_dependency++;
					}
				}
					
			}
			return selectedList;
        	
        },
        populateInstallSet: function(data,id, nodeItem){
        	var plugin =this;
       		var deployflag = false, analysisflag = false;
			$(id).empty();
			this._defaults.nodeItem =nodeItem;
			$(id).append('<table class="hp-selectable" id="hpsum-otu-installables-' + nodeItem.node_id + '-table"><thead><tr><td></td><td><b>'+
								localizer.getString("hpsum.oneTouchUpdate.selectComponents") + '</b></td><td><b>' + 
								localizer.getString("hpsum.oneTouchUpdate.packageStr") + '</b></td><td><b>' + 
								localizer.getString("hpsum.oneTouchUpdate.statusStr") + '</b></td><td><b>' +
								localizer.getString("hpsum.oneTouchUpdate.reports.type") + '</b></td><td><b>' +
								localizer.getString("hpsum.oneTouchUpdate.family") + '</b></td><td><b>' + 
								localizer.getString("hpsum.oneTouchUpdate.installedVersion") + '</b></td><td><b>' + 
								localizer.getString("hpsum.oneTouchUpdate.activeVersion") + '</b></td><td><b>' + 
								localizer.getString("hpsum.oneTouchUpdate.availableVersion") + '</b></td><td></td><td></td><td></td><td></td></tr></thead></table>');
			initInstallReviewTable('#hpsum-otu-installables-' + nodeItem.node_id + '-table');
			var currtableId = '#hpsum-otu-installables-' + nodeItem.node_id + '-table';
			var currTable = $('#hpsum-otu-installables-' + nodeItem.node_id + '-table').dataTable();
			currTable.fnClearTable();
			var baselineslist = data.hapi.baselines;
			var componentMap = {}, componentAdded = {};
			if (currTable && baselineslist) {
				for (var j = 0; j < baselineslist.baseline.length; j++) {
					var currbaseline = baselineslist.baseline[j];
					if (currbaseline.hasOwnProperty("components")) {
						var comps = currbaseline.components.component;
						for (var k = 0; k < comps.length; k++){
							var comp = comps[k];
							var group_id= comp.product_family_name + comp.product_sub_type; 
							if(componentMap[group_id] == undefined )
								componentMap[group_id] = comp.component_id;
							else
								componentMap[group_id] += comp.component_id;
						}
					}
				}
				for (var j = 0; j < baselineslist.baseline.length; j++) {
					var currbaseline = baselineslist.baseline[j];
					if (currbaseline.hasOwnProperty("components")) {
						var comps = currbaseline.components.component;
						
						var baseline_details= {baseline_id:currbaseline.baseline_id,
							location_id:currbaseline.location_id  };
						//first add all the selected components
						for (var k = 0; k < comps.length; k++) {
							var comp = comps[k];
							if(componentAdded[comp.component_id]!=true)
							{
							var stat = '', forcetoggle = '', comp_id = comp.component_id, comp_name = ' (' + comp_id + ')', selectedtoggle = '', isSelected = '';
							var comp_id_refined = comp_id.replace(/\./g,'_');
							if (comp.is_forcible === true){
								if(comp.is_forced == true)
									forcetoggle = '<input id="toggle-' + comp_id_refined + '-' + nodeItem.node_id + '" type="checkbox" checked/>';
								else
									forcetoggle = '<input id="toggle-' + comp_id_refined + '-' + nodeItem.node_id + '" type="checkbox" />';
							}
							else
								forcetoggle = '';
							if(comp.selected){
								stat = '<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>';
								isSelected = 'selected';
								selectedtoggle = '<input id="selectToggle-' + comp_id_refined + '-' + nodeItem.node_id + '" type="checkbox" checked/>';
							}
							else{
								if(comp.is_selectable == true)
									stat = '<div id="selectable" class="hp-status"><div class="hp-status-value hp-status-disabled"><span class="hp-value">disabled</span></div></div>';
								else
									stat = '<div class="hp-status"><div class="hp-status-value hp-status-disabled"><span class="hp-value">disabled</span></div></div>';
									selectedtoggle = '<input id="selectToggle-' + comp_id_refined + '-' + nodeItem.node_id + '" type="checkbox" />';
							}
							
							if(forcetoggle != '')
								selectedtoggle = forcetoggle;
							
							var failed_deps = '';

							if (comp.has_failed_dependencies === true) {
								stat = '<div id="'+isSelected +'" class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>';
								failed_deps = comp.failed_dependencies.failed_dependency;
								//disable deploy button if failed dependency component is selected
								if(comp.selected)
									deployflag = false;
							}
							var group_id = comp.product_family_name + comp.product_sub_type;
							var group_name = '';
							var componentName  = comp.name + comp_name;
							if(componentMap[group_id] === comp.component_id){
								group_id  = '';
								group_name ='';
							}
							else{
								group_id = componentMap[group_id];
								group_name = comp.name;
								componentName = comp_id;
								
							}
							var compItem = [{
								'group_id': group_id,
								'name' : componentName,
								'status' : stat,
								'product_type' : comp.product_type,
								'product_sub_type' : comp.product_sub_type,
								'installed_version' : comp.installed_version,
								'active_version' : comp.active_version,
								'available_version' : comp.available_version,
								//'has_failed_dependencies': currbaseline.components.component[k].has_failed_dependencies,
								'force' : forcetoggle,
								'baseline_details' : baseline_details,
								'file_name' : comp.file_name,
								'component_id' : comp.component_id,
								'failed_deps' : failed_deps,
								'group_name':group_name,
								'selected' : selectedtoggle,
								'device_info' : (comp.hasOwnProperty('device_info')) ? comp.device_info : ''
							}];
							currTable.fnAddData(compItem);
							if (forcetoggle != "")
								$('#toggle-' + comp_id_refined + '-' + nodeItem.node_id).hpToggle({
									unchecked : localizer.getString("hpsum.oneTouchUpdate.force"),
									checked : localizer.getString("hpsum.oneTouchUpdate.forced")
								});
							if (selectedtoggle != "")
								$('#selectToggle-' + comp_id_refined + '-' + nodeItem.node_id).hpToggle({
									unchecked : localizer.getString("hpsum.oneTouchUpdate.select"),
									checked : localizer.getString("hpsum.oneTouchUpdate.selected")
								});
								
								componentAdded[comp.component_id] = true;
							}
							}
						}
					}
					}
					$(currtableId + " tbody tr").click(function(e) {
						var srcElem;
									//Check if firefox or (chrome and IE)
						if (e.srcElement) {
										srcElem = e.srcElement;
											//Chrome and IE
									} else {
										srcElem = e.target;
										//Firefox
									}
									if(srcElem.id == 'revision_history'){
										var data = currTable.fnGetData(this);
										plugin.showRevisionHistory(data);
										
										return;	
									}
									else if (srcElem.id == 'device_info'){
										var data = currTable.fnGetData(this);
										var componentsList = {
											hapi : {
												components : {
													component : []
												}
											}
										};
										var item = {
											component_id : data.component_id,
											component_log : '',
											failed_deps : data.failed_deps,
											device_info : data.device_info
										};
										componentsList.hapi.components.component.push(item);
										plugin.showComponentDialog(componentsList);
										return;	
									}
									var data = currTable.fnGetData(this);
									var clickedCellIndex = srcElem.cellIndex;
									if (clickedCellIndex === undefined) {
										
										var forceid = data.force.split('"');
										forceid ='#'+ forceid[1];//+'-hpToggle';
										if(srcElem.innerHTML.match(/Selected/i)){
											$(forceid).removeAttr('checked');
											$(forceid).trigger('change');
										} else if(srcElem.innerHTML.match(/Select/i)){
											$(forceid).prop('checked', true);
											$(forceid).trigger('change');
										}
										
										
										analysisflag = false;
										//$(MULTI_ANALYSIS_BTN).attr("disabled", false);
											deployflag = true;
											//$(MULTI_DEPLOY_BTN).attr("disabled", true);
										
										var selectforceid = data.selected.split('"');
										selectforceid ='#'+selectforceid[1];//+'-hpToggle';
										
										if(srcElem.className =='hp-on')
										{
											if(data.force != '')
											$(this).addClass('hp-disabled');
											$(this).removeClass('hp-selected');
											$(selectforceid).removeAttr('checked');
										}
										else {//row highlighting
											if(srcElem.className.match(/hp-status-value/i))
											{
												var data = currTable.fnGetData(this);
												var componentsList = {
													hapi : {
														components : {
														component : []
														}
													}
												};
												var item = {
													component_id : data.component_id,
													component_log : '',
													failed_deps : data.failed_deps,
													device_info : data.device_info,
													component_desc: data.name
												};
												componentsList.hapi.components.component.push(item);
												plugin.showComponentDialog(componentsList);
												return;
											}
											if(srcElem.className.match(/hp-status/i))
											{
											     if ($(this).hasClass('hp-disabled')) 
													return;   
											}
											$(this).removeClass('hp-disabled');
											$(this).addClass('hp-selected');
											
											$(selectforceid).prop('checked', true);
											
											if(data.group_id != ''){
												var group = '.' + data.group_id;
											//var group ='.groupName';
												$(group).each(function(item){
													var rdata = currTable.fnGetData(this);
													if(rdata == data)
														return;
													$(this).removeClass('hp-selected');
													$(this).addClass('hp-disabled');
													if(rdata.force != ''){
														var id = rdata.force.split('"');
														id='#'+id[1];//+'-hpToggle';
                      									$(id).removeAttr('checked');
                      									$(id).trigger('change');
													}
													
												});
											}
										}
										$(selectforceid).trigger('change');
										plugin.setChanged(nodeItem.node_id, true);
										return;
									}
									
										//row is disabled, so only force option can be applied
										//no row selection/deselection supported
									if ($(this).hasClass('hp-disabled')) {
											//var toggleid = '#' + $(data.force)[0].id + '-hp';
											//$(toggleid).hpToggle('uncheck');
										return;
									}
									
									//Select toggle button changes 
									var selectid = data.selected.split('"');
									selectid='#'+selectid[1];//+'-hpToggle';
									if ($(this).hasClass('hp-selected')) {
										if(data.force != '')
										return;
										else {
										$(selectid).removeAttr('checked');
                      					}
									}
									else {
										if(data.force != '')
										return;
										else {
										$(selectid).prop('checked', true);
                      					}
									}
									$(selectid).trigger('change');
									
									//toggle row selection
										if(data.group_id != ''){
											var group = '.' + data.group_id;
											
											$(group).each(function(item){
												var rdata = currTable.fnGetData(this);
												if(rdata == data)
													return;
												$(this).removeClass('hp-selected');
												if(rdata.force != ''){
													var id = rdata.force.split('"');
													id='#'+id[1];//+'-hpToggle';
                      								$(id).removeAttr('checked');
                      								$(id).trigger('change');
												}
													
											});
										}
									$(this).toggleClass('hp-selected');
									plugin.setChanged(nodeItem.node_id, true);
									//	$(MULTI_ANALYSIS_BTN).attr("disabled", false);
									//	$(MULTI_DEPLOY_BTN).attr("disabled", true);
								});
							$(currtableId + " tbody tr").dblclick(function(e) {
									var data = currTable.fnGetData(this);
									var componentsList = {
										hapi : {
											components : {
												component : []
											}
										}
									};
									var item = {
										component_id : data.component_id,
										component_log : '',
										failed_deps : data.failed_deps,
										device_info : data.device_info,
										component_desc: data.name
									};
									componentsList.hapi.components.component.push(item);
									plugin.showComponentDialog(componentsList);
								});
				plugin.setChanged(nodeItem.node_id, false);
		},
		setChanged: function(id, value){
			var componentList = this.getSelectedComponents(id);
			this.options.onSelectionChanged(id,value,componentList);
		},
		showRevisionHistory: function(data){
			//First sent getComponentData
			var item = {baseline_id:data.baseline_details.baseline_id,
						 location_id:data.baseline_details.location_id,
						 component_id:data.component_id,
						 filter: "revision_history"
						 };
			baselinePresenter.getComponentData(item,{
				success:function(data) {
				var componentDialogContents  =$(componentDialogHtml);
            	localizer.localizeDom(componentDialogContents);
            	//show component dialog
            	var dialog = new DialogView({contents: componentDialogContents,
                    ok: function (elem) {
                        return true;
                    },
                    cancel: function () {
                    }
                });
                var component= data.hapi.component_data;
                $('#component_title',componentDialogContents).html(localizer.getString("hpsum.oneTouchUpdate.componentDetailsFor", [component.component_file_name]));
                $('#hpsum-comp-fail-dep',componentDialogContents).hide();
	            $('#hpsum-comp-inst-notes',componentDialogContents).show();
	            $('#hpsum-device-list-div',componentDialogContents).empty();
				$('#hpsum-device-list',componentDialogContents).hide();
				$('#hpsum-component-id',componentDialogContents).html(component.package_name);
				var revision= component.revision_history.revision;
				var htmlContents='';
				for(var i=0; i<revision.length; i++){
					var version = revision[i].version;
					if(revision[i].revision != '')
						version += '('+ revision[i].revision + ')';
					htmlContents+='<div class="hp-collapsible"><label>'+ version+ '</label>';
					var enhancement, fixes;
					enhancement = revision[i].enhancement;
							fixes = revision[i].fixes;
							if(enhancement == '')
								enhancement =  'None';
							if(fixes == '')
								fixes ='None'
							
						
					htmlContents+='<div><b><u>Enhancements</u></b></br>'+enhancement+ '</br>'+
								'<b><u>Fixes</u></b></br>' + fixes+ '</br></div></div>';
				}
				$('#hpsum-component-installation-notes').html(htmlContents);
				$('.hp-collapsible',componentDialogContents).hpCollapsible();
				$('.hp-collapsible',componentDialogContents).hpCollapsible('expand');	
				},
				error:function(){
					
				}
			});
		},
		showComponentDialog:function(data) {
            	var componentDialogContents  =$(componentDialogHtml);
            	localizer.localizeDom(componentDialogContents);
            	//show component dialog
            	var dialog = new DialogView({contents: componentDialogContents,
                    ok: function (elem) {
                        return true;
                    },
                    cancel: function () {
                    }
                });
                
                if(data.hapi.components.component[0].hasOwnProperty('failed_deps'))
                {
                    $('#component_title',componentDialogContents).html(localizer.getString("hpsum.oneTouchUpdate.componentDetails"));
	                if(data.hapi.components.component.length > 0)
	                {
	                	$('#hpsum-comp-fail-dep',componentDialogContents).show();
	                	$('#hpsum-comp-inst-notes',componentDialogContents).hide();
		                $('#hpsum-component-id',componentDialogContents).html(data.hapi.components.component[0].component_id);
				$('#hpsum-component-help-id').html(data.hapi.components.component[0].component_desc);
						
						var id= $('#hpsum-component-failed-dep',componentDialogContents);
		                this.initFailedDependencyTable(id);
		                
		                var oFailedDepTable = $(id).dataTable();
		                
		                if(oFailedDepTable) {
							oFailedDepTable.fnClearTable();
		                	for(var i=0; i < data.hapi.components.component[0].failed_deps.length; i++)
		                	{
		                		var item =  [
		                						{
		                							failed_dependency: data.hapi.components.component[0].failed_deps[i]
				                				}
				                			];
		                		oFailedDepTable.fnAddData(item);
		                	}
		                }
		                
		                //this is for textarea
		                //$('#hpsum-component-failed-dep').val(data.hapi.components.component[0].failed_deps);
		                
						if(data.hapi.components.component[0].hasOwnProperty('device_info') && data.hapi.components.component[0].device_info.hasOwnProperty('devices'))
						{
							$('#hpsum-device-list-div',componentDialogContents).empty();
							
							$('#hpsum-device-list',componentDialogContents).show();
							
							for(var devInd=0; devInd < data.hapi.components.component[0].device_info.devices.device.length; devInd++)
							{
								var device = data.hapi.components.component[0].device_info.devices.device[devInd];
								
								// Use index as table id instead of including device id in case of multiple devices with the same ID
								// Not sure why use device id, save it into attribute so that could find it if need.
								var devid = 'deviceid="' + device.device_id.replace(/\W/g, '-') + '"';
								var headertableid = 'hpsum-devices-header-table-' + devInd;
								$('#hpsum-device-list-div').append('<table id="' + headertableid + '" ' + devid + '><thead><tr><td></td><td></td><td></td></tr></thead></table>');
								
								this.initDevicesHeaderTable('#' + headertableid);
								
								var headerTable = $('#' + headertableid).dataTable();
								
								var item = [{deviceid: device.device_id, 
						                	productid: device.product_id 
				                			}];
						                			
								headerTable.fnAddData(item);
								
								//replace white spaces with - as element id should not have white spaces
								var rowtableid = 'hpsum-devices-rows-table-' + devInd; 
								$('#hpsum-device-list-div',componentDialogContents).append('<table class="hp-selectable" id="' + rowtableid + '" ' + devid + '><thead><tr><td>Type</td><td>Status</td><td>Active Version</td><td>Available Version</td></tr></thead></table>');
								
								this.initDevicesRowTable('#' + rowtableid);
								
								var rowTable = $('#' + rowtableid).dataTable();
								
								for(var fwInd=0; fwInd < device.fw_item.length; fwInd++)
								{
									var fwitem = device.fw_item[fwInd];
									
									var rowitem = [{type: fwitem.type, 
							                	fw_item_status: fwitem.fw_item_status,
							                	active_version: fwitem.active_version,
							                	version: fwitem.version 
					                			}];
							                			
									rowTable.fnAddData(rowitem);
								}
							}
						}
						else
						{
							$('#hpsum-device-list-div',componentDialogContents).empty();
							$('#hpsum-device-list',componentDialogContents).hide();
						}
		            }
		       	}
	            
            },
            initDevicesHeaderTable:function(tableid) {
            	
            	var oTab = $(tableid).dataTable({
					oLanguage: {
								sEmptyTable: localizer.getString("hpsum.node.noItemsFound"),
                    sSearch: localizer.getString("hpsum.common.search")
							   },
				    bPaginate : false,
				    bProcessing : false,
				    bFilter : false,
				    bSort : false,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
				    aoColumns : [
				    	{mDataProp: 'deviceid'},
				    	{mDataProp: 'productid'}
				        ],
				    aaSorting: [],
				    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        return nRow;
				    }
				    });
			 
				$(tableid + ' tbody tr').first().addClass('hp-selected');
			},
			
			//Initialize component device info row table 
            initDevicesRowTable:function(tableid) {
            	
            	var oTab = $(tableid).dataTable({
					oLanguage: {
								sEmptyTable: localizer.getString("hpsum.node.noItemsFound"),
                    sSearch: localizer.getString("hpsum.common.search")
							   },
				    bPaginate : false,
				    bProcessing : false,
				    bFilter : false,
				    bSort : false,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
				    aoColumns : [
				    	{mDataProp: 'type'},
				    	{mDataProp: 'fw_item_status'},
				    	{mDataProp: 'active_version'},
				    	{mDataProp: 'version'}
				        ],
				    aaSorting: [],
				    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        return nRow;
				    }
				    });
			 
				$(tableid + ' tbody tr').first().addClass('hp-selected');
			},
		recalculate:function() {
			if(this.options.nodeItem == undefined){
				window.console.error("recalculate before init is not allowed");
				return;
			}
			this.calculate(this.element,this.options);
			
		},
	
        calculate: function(el, options) {
        	var plugin =this;
           presenter.getbaseline(options.nodeItem, {
						success : function(data) {
							plugin.populateInstallSet(data, el, options.nodeItem);
						},
						error : function(data){ 
							plugin.onPopulateError(el);
						}
					});
        },
        onPopulateError : function(el){
        	el.text("GetUpdatelist failed for this node");
        },
        destroy: function(el){
        		$(this.element).removeClass('hpsumInstallables');
        		$.removeData(this.element, "plugin_" + pluginName);
        },
                    //Initialize component device info row table 
        initFailedDependencyTable:function(tableid) {
            	
            	var oTab = $(tableid).dataTable({
					oLanguage: {
								sEmptyTable: localizer.getString("hpsum.node.noItemsFound"),
                    sSearch: localizer.getString("hpsum.common.search")
							   },
				    bPaginate : false,
				    bProcessing : false,
				    bFilter : false,
				    bSort : false,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
				    aoColumns : [
				    	{mDataProp: 'failed_dependency'}
				        ],
				    aaSorting: [],
				    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        return nRow;
				    }
				    });
			 
			//	$(tableid + ' tbody tr').first().addClass('hp-selected');
			}
       
		
        
    };

    // A really lightweight plugin wrapper around the constructor,
    // preventing against multiple instantiations
    $.fn[pluginName] = function ( options ) {
    	var instance;
    	if ( typeof options === 'string' ) { 
                // call method
                var args = Array.prototype.slice.call( arguments, 1 );
				 this.each(function() {
                    instance = $.data( this, "plugin_" + pluginName );
                    if ( !instance ) {
                        if (window.console) {
                            window.console.error( "cannot call methods on hpInstallables prior to initialization; " +
                                "attempted to call method '" + options + "'" );
                        }
                        return;
                    }
                    if ( !$.isFunction( instance[options] ) || options.charAt(0) === "_" ) {
                        if (window.console) {
                            window.console.error( "no such method '" + options + "' for hpInstallables instance" );
                        }
                        return;
                    }
                    // apply method
                   	instance[ options ].call( instance, args );
                });  
              }
               else{
        return this.each(function () {
            if (!$.data(this, "plugin_" + pluginName)) {
                $.data(this, "plugin_" + pluginName, new Plugin( this, options ));
               }

        });
        }
    };


}(jQuery));
});
	
