// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
/**
 * @type (OneTouchUpdateAdvOptionsView)
 * This is a view class for One Touch Update Advanced options.
 */
define(['hp/core/Router',
    'hp/core/Notifications',
	'hp/core/HelpMenu',
	'hp/services/REST',
    'hp/model/Session',
    'hp/core/Localizer',
	'hpsum/presenter/node/NodePresenter',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'hp/lib/jquery.hpPanels',
    'lib/jquery.selectBox',
    'lib/jquery.dataTables',
    'hp/lib/jquery.hpCollapsible',
    'hp/lib/jquery.hpToggle',
	'hp/lib/jquery.hpSearchCombo'],
function(router, notifications, helpMenu, REST, session, localizer, nodepresenter) { "use strict";

    var OneTouchUpdateAdvOptionsView = (function() {
      
        var OK = '#hpsum-otu-advoptions-ok',
            CANCEL = '#hpsum-otu-advoptions-close',
			ADDBASELINE = '#hpsum-cbl-add-baseline-button',
			REMOVEBASELINE = '#hpsum-cbl-remove-baseline-button',
			PANEL_SELECTOR = '#hpsum-advoptions-panel-selector',
            FIRST_ANCHOR = PANEL_SELECTOR + ' a[href]:first',
            PANELS = '#hpsum-otu-advoptions-panels',
			COLLAPSE = '#hpsum-custom-baseline-collapsible',
			COLLAPSE_SYSTEM = '#hpsum-custom-baseline-collapsible-system',
			COLLAPSE_STORAGE = '#hpsum-custom-baseline-collapsible-storage',
			COLLAPSE_NIC = '#hpsum-custom-baseline-collapsible-nic',
			COLLAPSE_FCHBA = '#hpsum-custom-baseline-collapsible-fchba',
			COLLAPSE_ADVFILTERS = '#hpsum-custom-baseline-collapsible-advfilters',
			COLLAPSE_ARCH = '#hpsum-custom-baseline-collapsible-arch',
			COLLAPSE_DEVTYPE = '#hpsum-custom-baseline-collapsible-devtype',
			COLLAPSE_OSTYPE = '#hpsum-custom-baseline-collapsible-ostype',
			COLLAPSE_SERVER = '#hpsum-custom-baseline-collapsible-server',
			SEARCH_COMBO = '#hpsum-custom-baseline-search',
			DESCR = '#hpsum-custom-baselines-descr',
			VERSION = '#hpsum-custom-baselines-version',
			VERSION1 = '#hpsum-custom-baselines-version1',
			VERSION2 = '#hpsum-custom-baselines-version2',
			CHECKBOX_HEADER = '#chkboxheader',
			CHECKBOX_COMP = '#chkboxcomp',
			DAILYPANEL ='#hpsum-otu-schedule-daily-panel',
			WEEKLYPANEL ='#hpsum-otu-schedule-weekly-panel',
			MONTHLYPANEL ='#hpsum-otu-schedule-monthly-panel',
			DAILYRECUR ='#hpsum-otu-schedule-recur-daily',
			WEEKLYRECUR ='#hpsum-otu-schedule-recur-weekly',
			MONTHLYRECUR ='#hpsum-otu-schedule-recur-monthly',
			DATETIMESECTION ='#hpsum-otu-schedule-datetimepick',
			SCHEDULETOGGLE ='#hpsum-otu-schedule-enable',
			FREQOPTION ="hpsum-otu-schedule-frequency",
            ROUTE_PREFIX = '/guided-update/advoptions',
            REBOOTDELAY = '#hpsum-reboot-delay',
            REBOOTDELAYERR = '#hpsum-reboot-delay-error-label';
            
        /**
         * Constructor
         */
        function OneTouchUpdateAdvOptionsView() {
          
            var addInProgress = false, 
				nodes = [];
          
            function onItemAddSuccess(item) {
                addInProgress = false;
            }

            /**
             * @private
             */
            function onItemAddError(errorMessage) {
                notifications.show(errorMessage, 'error');
                addInProgress = false;
                $(CANCEL).trigger('click');
            }

            /**
             * @private
             * loadNodeAttributes - Call node's getattributes command to get force options, reboot options etc
             */
            function loadNodeAttributes()
            {
	        //Below Code is commented to use Node API instead of Session API.
            	/*
            	REST.getURI("Session/" + session.getToken() + "/getattributes", {
                    			success : function(data) {
                        			ongetAttributesSuccess(data);
                    		 	},
                    			error : function(errorInfo) {
                        			ongetAttributesError(errorInfo);
                    			}
                			});
				*/
				if(nodes.length <= 0)
					return;
				nodepresenter.otheroption(nodes[0],  {
                    			success : function(data) {
                        			ongetAttributesSuccess(data);
                    		 	},
                    			error : function(errorInfo) {
                        			ongetAttributesError(errorInfo);
                    			}
                			});
            }
            
            function ongetAttributesSuccess(data){
				/*
				if(data.hapi.force_options != 'none')
				{
					if(data.hapi.force_options.indexOf('rewrite') >= 0)
						$('#hpsum-otu-advoptions-chkbox-rewrite').attr('checked',true);
					else
						$('#hpsum-otu-advoptions-chkbox-rewrite').attr('checked',false);
						
					if(data.hapi.force_options.indexOf('downgrade') >= 0)
						$('#hpsum-otu-advoptions-chkbox-downgrade').attr('checked',true);
					else
						$('#hpsum-otu-advoptions-chkbox-downgrade').attr('checked',false);
				}	
				
				if(data.hapi.reboot === 'no')
				{
					$('#reboot-options').selectBox('value', 'No'); 
				}
				else if(data.hapi.reboot === 'Always')
				{
					$('#reboot-options').selectBox('value', 'Always'); 
				}
				else if(data.hapi.reboot === 'If Needed')
				{
					$('#reboot-options').selectBox('value', 'If Needed'); 
				}
				
				$(REBOOTDELAY).val(data.hapi.reboot_delay);
				
				$('#reboot-message').val(data.hapi.reboot_message);
				*/
			}
			
			function ongetAttributesError(error){
				
			}

            function validateRebootDelay() {
			var rebootopt = $('#reboot-options option:selected').val();
			var rebootDelayValue = $(REBOOTDELAY).val();
			// TODO: Enforce a time range on the reboot delay?
            // Check to see if it appears to be a number.
			
			if (rebootopt != localizer.getString("hpsum.oneTouchUpdate.never")) {
            if( !isNaN(parseFloat(rebootDelayValue)) && isFinite(rebootDelayValue)){
				$(REBOOTDELAY).removeClass("hp-error");
                $(REBOOTDELAYERR).hide();
			}
			else {
				$(REBOOTDELAY).addClass("hp-error");
                $(REBOOTDELAYERR).text(localizer.getString('hpsum.oneTouchUpdate.advancedOptions.rebootDelayNotANumber'));
                $(REBOOTDELAYERR).show();
				return false;
            }
			}
			
			if(rebootopt == localizer.getString("hpsum.oneTouchUpdate.never") || rebootopt == localizer.getString("hpsum.common.ifNeeded") || rebootopt == localizer.getString("hpsum.common.always"))
			return true;
            }

            function validate() {
                return validateRebootDelay();
            }

            /**
             * @private
             * onOk - Call session's setattributes command to save force options, reboot options etc
             */
            function onOk() {

                if (!validate()) {
                    return false;
                }
            	
            	var bforceopt = false;
            	var forceoptions;
            	if($('#hpsum-otu-advoptions-chkbox-rewrite')[0].checked)
            	{
            		bforceopt = true;
            	}
            		
            	if($('#hpsum-otu-advoptions-chkbox-downgrade')[0].checked){
            		bforceopt = true;
            		
            		forceoptions += 'downgrade';
            	}
            	
            	var rebootopt = $('#reboot-options option:selected').val();
				if(rebootopt == localizer.getString("hpsum.oneTouchUpdate.never")){
					rebootopt = "Never";
				}
				else if(rebootopt == localizer.getString("hpsum.common.ifNeeded")){
					rebootopt = "If needed";
				}
				else if(rebootopt == localizer.getString("hpsum.common.always")){
					rebootopt = "Always";
				}
								
            	var rebootdelay = $(REBOOTDELAY).val();
            	var rebootmsg = $('#reboot-message').val();         	
            	
            	var attributes = {
								 	hapi:
								 	{
												reboot_options :
												{
										    		  delay: rebootdelay,
											          action: rebootopt,
											          message: rebootmsg
												},
												installation_option :
												{
										       		  downgrade: $('#hpsum-otu-advoptions-chkbox-downgrade')[0].checked,
												  rewrite: $('#hpsum-otu-advoptions-chkbox-rewrite')[0].checked,
												  force: bforceopt,
												  software : $('#chkbox-software')[0].checked,
												  firmware : $('#chkbox-firmware')[0].checked
												}
									 }
				  };
			        //Below Code is commented to use Node API instead of Session API.
				/*
				REST.postObject("Session/" + session.getToken() + "/setattributes", 
								attributes,  "", 
            		         {
                    			success : function(data) {
                        			onSetAttributesSuccess(data);
                        			window.bRefreshReview = true;
                    		 	},
                    			error : function(errorInfo) {
                        			onSetAttributesError(errorInfo);
                    			}
                			}, {});
				*/
				var initialGetattr = null;
				nodepresenter.otheroption(nodes[0], {
				   success : function(data) {
				        initialGetattr = data;
						if(nodes.length > 0) {
					//send the setattribute command to engine
					if(initialGetattr.hapi.installation_option.downgrade != attributes.hapi.installation_option.downgrade ||
						initialGetattr.hapi.installation_option.rewrite != attributes.hapi.installation_option.rewrite ||
						initialGetattr.hapi.installation_option.software != attributes.hapi.installation_option.software ||
						initialGetattr.hapi.installation_option.firmware != attributes.hapi.installation_option.firmware ||
						initialGetattr.hapi.reboot_options.action != attributes.hapi.reboot_options.action) {
					
						nodepresenter.setattribute(nodes[0], attributes, {
										success : function(data) {
											onSetAttributesSuccess(data);
											window.bRefreshReview = true;
					$(CANCEL).trigger('click');
										},
										error : function(errorInfo) {
											onSetAttributesError(errorInfo);
										}
									});
								}
					else{
							$(CANCEL).trigger('click');			
						}
				}
				
				return true;
				   },
				     error : function(errorInfo) {				   
				      }
				   });

			}
			
			function onSetAttributesSuccess(data){
				
			}
			
			function onSetAttributesError(error){
				
			}
			
			function changeLocation(location) {
                if (location.length > ROUTE_PREFIX.length) {
                    $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
                } else {
                    $(PANELS).hpStackedPanels('setFirstPanel');
                }
            }
            
			function toggleSchedule(cb)
            {
            	if(cb.target.checked){
            		$(DATETIMESECTION).show();
            		$('input[name="hpsum-otu-schedule-frequency"]').attr('disabled',false);
            		showFrequencyPanels($("input[name='hpsum-otu-schedule-frequency']:checked").val());
            	}
            	else{
            		$(DATETIMESECTION).hide();
            		$('input[name="hpsum-otu-schedule-frequency"]').attr('disabled',true);
            		$(DAILYPANEL).hide();
            		$(WEEKLYPANEL).hide();
    				$(MONTHLYPANEL).hide();
            	}
            }
            
            function showFrequencyPanels(value) {
            	if(value.target)
            		value = value.target.value;
            	if(value == "daily"){
            		$(DAILYPANEL).show();
            		$(WEEKLYPANEL).hide();
    				$(MONTHLYPANEL).hide();
    				// $(PANELS).hpStackedPanels('setFirstPanel');
            	}
            	else if(value == "weekly"){
            		$(DAILYPANEL).hide();
            		$(WEEKLYPANEL).show();
    				$(MONTHLYPANEL).hide();
            	}
            	else if(value == "monthly"){
            		$(DAILYPANEL).hide();
            		$(WEEKLYPANEL).hide();
    				$(MONTHLYPANEL).show();
            	}
            }
			function loadNodes() {
				//get nodes from one touch update wizard page
				nodes = nodepresenter.getNodesForAdvOptions();
			}
          
            /**
             * @public
             */
            this.resume = function () {
                $(REBOOTDELAYERR).hide();
				$('#hpsum-node-delay-err-msg').hide(); 
		loadNodes();
            	loadNodeAttributes();
            	window.bRefreshReview = false;
            };
            
            this.pause = function () {
            };
            
            /**
             * @public
             * Initialization funtion for the object
             * All the controls actions are initialized in this function.
             */
            this.init = function() {
                
                //hide schedule option as it is yet to integrate
                $("#hpsum-otu-advoptions-schedule").hide();
		loadNodes();
                loadNodeAttributes();
                $(OK).live('click', function(ev) {
                    onOk.call(this);
                    ev.preventDefault();
                });
				
				$(PANELS).hpStackedPanels({
                    panelSelector : PANEL_SELECTOR
                });

				$(REBOOTDELAYERR).hide();
				
				$(REBOOTDELAY).change(function(ev, value) { 
                  var delaySec = parseInt($(REBOOTDELAY).val());  
                  if (delaySec < 60 || delaySec > 3600) { 
                    	$('#hpsum-node-delay-err-msg').show();
                    $('#hpsum-node-delay-err-msg').text(localizer.getString("hpsum.oneTouchUpdate.rebootDelayErrMsg"));
						if (delaySec < 60 ) { 
                                       $(REBOOTDELAY).val('60'); 
                                       } 
                                       else if (delaySec > 3600 ) { 
                                        $(REBOOTDELAY).val('3600'); 
                                       }            
                  } 
                  else { 
                  	
                  	$('#hpsum-node-delay-err-msg').hide(); 
                  } 
                });
			    
				
				$(DATETIMESECTION).hide(); 
    			$('input[name="hpsum-otu-schedule-frequency"]').attr('disabled','disabled');
    			$('input[name="hpsum-otu-schedule-frequency"]').click(showFrequencyPanels);
    			$(DAILYPANEL).hide();
    			$(WEEKLYPANEL).hide();
    			$(MONTHLYPANEL).hide();
    			$(SCHEDULETOGGLE).hpToggle({checked: 'On', unchecked: 'Off'});
    			$(SCHEDULETOGGLE).bind('change',toggleSchedule); 
				
				
				router.watch('one-touch-update advoptions section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});
					
                this.resume();
            };
        }

        return OneTouchUpdateAdvOptionsView;
    }());
    
    return new OneTouchUpdateAdvOptionsView();
});
