// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/server/ServerPresenter',
    'hp/core/Router',
    'jquery',
    'hp/lib/jquery.hpStackedPanels'],
function(presenter, router) { "use strict";

    var ServerShowMoreView = (function() {
      
        var PANELS = '#tour-server-more-panels';
        var PANEL_SELECTOR = '#tour-server-panel-selector';
        var ROUTE_PATHS = '(general|connections|bios)';
        var ROUTE_PREFIX = '/server/show/' + ROUTE_PATHS;
      
        /**
         * Constructor
         */
        function ServerShowMoreView() {
        
            function changeLocation(location) {
                $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
            }
            
            function hideDefaults() {
                $('tr.hp-default').hide();
                $('tr.hp-header').hide();
                $('#tour-show-bios-all').removeClass('hp-selected');
                $('#tour-show-bios-modified').addClass('hp-selected');
                /*
                // Hide any headers with all content set to default
                $('tr.hp-header').each(function (index, row) {
                    var peer = $(row).next();
                    while (peer.length > 0 && peer.hasClass('hp-default') &&
                        ! peer.hasClass('hp-header')) {
                        peer = peer.next();
                    }
                    if (peer.length === 0 || peer.hasClass('hp-header')) {
                        $(row).hide();
                    }
                });
                */
            }
            
            function showDefaults() {
                $('tr.hp-default, tr.hp-header').show();
                $('#tour-show-bios-modified').removeClass('hp-selected');
                $('#tour-show-bios-all').addClass('hp-selected');
            }
            
            /**
             * @public
             */
            this.init = function() {
                
                $(PANELS).hpStackedPanels({
                    panelSelector : PANEL_SELECTOR
                });
                
                $('#tour-show-bios-modified').click(hideDefaults);
                $('#tour-show-bios-all').click(showDefaults);
                hideDefaults();
                
                router.watch('server more section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});
            };
        }

        return new ServerShowMoreView();
    }());
    
    return ServerShowMoreView;
});
