// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
/**
 * @type (ServerView)
 * This is a view class for Servers
 * Provides functions for showing master pane and its action.
 */
define(['hpsum/model/node/NodeResource',
	'hp/view/MasterPaneView',
	'hpsum/presenter/node/NodePresenter',
	'hp/core/Localizer',
    'jquery',
	'hp/lib/jquery.hpStatus',
    'hp/lib/jquery.hpUtilizationMeter',
    'hp/lib/jquery.hpSafeClone'],
function(resource, MasterPaneView, presenter, localizer) {"use strict";

    var ServerView = ( function() {
		
		var TYPE = 'server';
		var PAGE = '#hpsum-servers-page';

        /**
         * @constructor
         * @type {ServerView}
         */
        function ServerView() {

			var masterPaneView = new MasterPaneView();
			var template = null;
			var types = [],
				types_existing =[];
			
			function renderer(indexResult) {
               var item = template.hpSafeClone();
                $('.hp-status', item).hpStatus(indexResult.status, indexResult.changing);
                $('.hp-master-item-name', item).html(indexResult.name);
                $('.hpsum-node-type',item).html(localizer.getString('hpsum.common.type') + ':' + indexResult.type);
                $('.hpsum-node-status',item).html(localizer.getString('hpsum.common.statusStr') + ':' +indexResult.node_status);
                return item;
            }
			
			function getItemUrl(oObj){
								// add Filters
                var types = presenter.getAllNodeTypes();
               	var html = '<li data-id="all" class="hp-selected">' + localizer.getString('hpsum.common.all') + '</li>';
                if(types.length > types_existing.length)
                {
                	for(var i = types_existing.length-1; i < types.length; i += 1)
                	{
                		html = html + '<li data-id="' + types[i] + '">' + types[i]  + '</li>';
                		types_existing.push(types[i]);
                	}
                
                $('#types', PAGE).html(html);
				}
				
				return oObj.aData.name;
                //Commented the following lines to avoid opening the node in another tab in the browser
				/*
	    		return '<a href="#/' + TYPE + '/show/r' + oObj.aData.uri + '?f_q=type:servers' +
                                    '">' + oObj.aData.name +
                                    '</a>';
				*/	
			}
            /**
             * @public
             */
            this.init = function() {
				presenter.init();
                
                template = $('#hpsum-node-item-template').detach().show().attr('id', '');
                
             
                presenter.setFilter("type:servers");
                masterPaneView.init({
                    routePrefix: '/' + TYPE,
                    resource: presenter.resource(),
                    page: $(PAGE),
                    multiSelect: true,
                    addLink: presenter.getAddLink(),
                    dataTableOptions:  {
                        aoColumns : [
                            {fnRender: function (oObj) {
                                return '<div>' + oObj.aData.status +
                                    (oObj.aData.changing ? ' *' : '') +
                                    '</div>';
                            }, mDataProp: 'status'},
                            {fnRender: getItemUrl, mDataProp: 'name'} //,
                            //{mDataProp: 'attributes.model'}
                        ],
                        //aaSorting: [[ 1, "asc" ]],
                        fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0) > div', nRow).hpStatus();
                            return nRow;
                        }
                    },
                    gridItemRenderer: renderer
                });
                //
  
            };

            /**
             * @public
             */
            this.pause = function() {
				masterPaneView.pause();
            };

            /**
             * @public
             */
            this.resume = function() {
				masterPaneView.resume();
				presenter.setFilter("type:servers");
            };
        }

        return new ServerView();
    }());

    return ServerView;
});
