// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/node/NodePresenter',
    'hp/core/UrlFragment',
    'hp/core/Router',
	'hp/model/Session',
    'text!hpsumpages/graphics/switch.html',
	'hp/core/Localizer',
    'text!hpPages/core/no_details.html',
    'jquery',
    'hp/lib/jquery.hpGridPanels',
    'hp/lib/jquery.hpStatus',
    'hp/lib/jquery.hpUtilizationMeter',
    'lib/jquery.dateFormat',
    'hp/lib/date'],
function(presenter, urlFragment, router, session, switchGraphic, localizer, noneHtml) { "use strict";

    var SwitchOverviewView = (function() {
      
      	var ROOT = '#hpsum-switch-show-overview';
        var VIEW = '.hp-details-show-section',
        	MODEL ='#hpsum-switch-model',
        	DESCRIPTION ='#hpsum-switch-description',
        	WWN = '#hpsum-switch-wwn',
        	FWVERSION = '#hpsum-switch-fw',
        	BASELINE='#hpsum-switch-bundle',
        	NOASSOC ='#hpsum-switch-noassocdevices',
        	ASSOC ='#hpsum-switch-assocdevices',
        	PARTNER ='#hpsum-switch-partner',
        	PARTNERWFW ='#hpsum-switch-partner-writtenfw',
        	PARTNERAFW ='#hpsum-switch-partner-activefw',
		PARTNERIP ='#hpsum-switch-partnerip',
        	OA ='#hpsum-switch-oa',
        	SPINNER = '#hpsum-node-add-spinner';
        var GRAPHIC_CONTAINER = '.hp-overview-graphic';
        var INSTALL_LOGS = '#hpsum-switch-install-log';
        /**
         * Constructor
         */
        function SwitchOverviewView() {
            var noItem,
            	thisNode = null;
            
            function onItemChange(item) {
            	item = item.hapi;
            	thisNode = item;
                noItem.remove();
        		
        		item.type = item.type.toLowerCase();
        		var uitype = presenter.getUINodeType(item.type);
        		$(ROOT).closest('section').show();
        		
	        	if(!router.location().match(uitype)) {
        		    if(router.location().indexOf("/node") == 0)
        		    	router.go((urlFragment.replaceView(router.location(), 'show/' + item.type + '/overview')));
        		    else {
        		    	$(ROOT).closest('section').hide();
        		      	return;
        		    }
                }
                
                $('a.hp-button' , $(INSTALL_LOGS)).attr('href', '#/' + urlFragment.getPage(router.location()) + '/deploy-results');
                $(INSTALL_LOGS).hide();

        		if(item.node_state.match(/idle/i) && item.node_phase.match(/initialize/i)){
        			$('.hp-grid-panels').css({"display":"none"});
        			 $(SPINNER).show();
        			 presenter.startNodeStatus(item);
        		}
        		else {
        			$(SPINNER).hide();
        			$(NOASSOC).hide();
        			$(ASSOC).hide();
        			$('.hp-grid-panels').css({"display":""});
        			$('.hp-grid-panels').hpGridPanels('reset');     			
        			$(DESCRIPTION).text(item.description);
        			if(item.hasOwnProperty('model_name'))
        				$(MODEL).text(item.model_name);
        			else 
        				$(MODEL).text('');
        			if(item.hasOwnProperty('active_version'))
        				$(FWVERSION).text(item.active_version);
        			else
        				$(FWVERSION).text('');
        			if(item.hasOwnProperty('device_wwn'))
						$(WWN).text(item.device_wwn);
					else
						$(WWN).text('');
					showAssociatedDevices(item);
        			var fwBaseline =presenter.getBaselineOrPkg(item.baselines)
        			if(fwBaseline){
        					var baseline_url = '#/baseline/show/r'+fwBaseline.uri +'/getBaselineData';
        					name = fwBaseline.name;
        					$(BASELINE).html('<a href="'+ baseline_url +'">'+name+ '</a>');
        				}
        			else
        				$(BASELINE).text(localizer.getString('hpsum.node.noBaselineDefined'));  

                    if(item.node_state.match(/installdone/i))
                        $(INSTALL_LOGS).show();

        		}
            }
            
            function showAssociatedDevices(item){
				$(NOASSOC).show();
				$(PARTNER).html('');
				if(item.type == "sas_switch")
				{
					if(item.oa_ip_address)
					{
						$(NOASSOC).hide();
						$(ASSOC).show();
						var assoc_node_url = '#/node/show/r/session/' + session.getToken() + '/node/' + item.assoc_node_id + '/getData';
						if(item.assoc_node_id)
						{
							var assoc_node_url = '#/node/show/r/session/' + session.getToken() +'/node/' + item.assoc_node_id + '/getdata';
							$(OA).html ('<a href="' + assoc_node_url + '">' + item.oa_ip_address+ '</a>');
						}
						else
							$(OA).text(item.oa_ip_address);
					}
					if(item.partner_ip_address)
					{
						if(item.partner_node_id)
						{
							var partner_url = '#/node/show/r/session/' + session.getToken() +'/node/' + item.partener_node_id + '/getdata';
							$(PARTNERIP).html ('<a href="' + partner_url + '">' + item.partner_ip_address+ '</a>');					
						}
						else
						{
							$(PARTNERIP).text(item.partner_ip_address);
						}
						$(PARTNERWFW).text(item.partner_written_version);
						$(PARTNERAFW).text(item.partner_active_version);
					}
				}
				else
				{
					if(item.associated_device === undefined) 
						return;
					if(item.associated_device.length == 0)
						return;
					$(NOASSOC).hide();
					var tablecontents1 = "<table><tr> <td> <u>" + localizer.getString('hpsum.enclosure.deviceType') + "</u> </td> <td> <u>" + localizer.getString('hpsum.common.ipDns') + "</u> </td></tr>";
					for(var i=0; i<item.associated_device.length; i++){
						if(item.associated_device[i].node_id){
							var assoc_node_url = '#/node/show/r/session/' + session.getToken() +'/node/'+ item.associated_device[i].node_id+'/getData';
							tablecontents1 += "<tr><td>" + item.associated_device[i].type +' '+ item.associated_device[i].productName
								+'</td><td>' + '<a href= "' + assoc_node_url + '">' +item.associated_device[i].ip_or_dns+'</a>' + '</td></tr>';
						}
						else{
							tablecontents1 += "<tr><td>" + item.associated_device[i].type +' '+ item.associated_device[i].productName
								+'</td><td>' + item.associated_device[i].ip_or_dns + '</td></tr>';
						}
					}
					tablecontents1 += "</table>";
					$(PARTNER).html(tablecontents1);
				}
            }
            
            function onItemError(error) {
                $(ROOT).append(noItem);
            }

            function onItemError(errorMessage) {
            }
            
            function onResize() {
                var connectivity = $('#tour-switch-connectivity');
                if (connectivity.width() < 700 || connectivity.height() < 300) {
                    $('.hp-overview-graphic .hp-form-section > .hp-switch').show();
                    $('.hp-overview-graphic .hp-form-section > .hp-switch-context').hide();
                } else {
                    $('.hp-overview-graphic .hp-form-section > .hp-switch').hide();
                    $('.hp-overview-graphic .hp-form-section > .hp-switch-context').show();
                }
            }
          
            /**
             * @public
             */
            this.pause = function () {
                //$(window).off('resize', onResize);
                presenter.off("itemChange", onItemChange);
                presenter.off("itemError", onItemError);
            };
            
            this.resume = function () {
                $('.hp-grid-panels').hpGridPanels('reset');
                presenter.on("itemChange", onItemChange);
                presenter.on("itemError", onItemError);
                //$(window).on('resize', onResize);
                //onResize();
            };
            
            this.init = function() {
            	if(!presenter.initDone)
            		presenter.init();
                noItem = $(noneHtml);
                $('.hp-grid-panels').hpGridPanels();
                
                this.resume();
            };
            
        }

        return new SwitchOverviewView();
    }());
    
    return SwitchOverviewView;
});
