//(C) Copyright 2012-2014 Hewlett-Packard Development Company, L.P.
define([], function() {"use strict";
    return {
        menu : "Settings",
        development : {
            title : "Development Settings",
            "short-title" : "Development",
            refresh_interval : "Refresh Interval",
            ms : "milliseconds",
            max_master_items : "Maximum number of items in master pane",
            experimental_features : "Experimental features",
            "routing-log-level" : "Routing log level",
            edit : {
                title : "Edit Development Settings",
                success : "Updated development settings"
            }
        },
        appliance : {
            title : "Appliance",
            overview : {
                hostname: "Host name",
                ipaddr: "Appliance IP address",
                ipaddr2: "Deployment IP address",
                networkInterfaces:"Network Interfaces",
                version: "Version",
                model: "Model",
                datetime: "Date/time",
                snmp: "SNMP trap destinations"
            },
            general: {
                title: "General",
                hostname: "Appliance host name",
                model: "Model number",
                serial: "Serial number",
                version: "Firmware version",
                date: "Firmware date"
            },
            IPv4: {
                title: "IPv4",
                address: {
                    "1node": "IP address",
                    "2node": "Floating IP address"
                },
                address2: {
                    "1node": "Second IP address"
                },
                addrtype: {
                    "1node": "Address assignment",
                    "2node": "Fixed address assignment"
                },
                node1: "Node 1 fixed IP address",
                node2: "Node 2 fixed IP address",
                subnet: "Subnet mask or CIDR",
                gateway: "Gateway address"
            },

            DNS: {
                title: "DNS",
                preferred: "Preferred DNS server",
                alternate: "Alternate DNS server"
            },
            timeandlanguage: {
                title: "Time and Language",
                currentdatetime: "Current date/time",
                timezone: "Timezone",
                ntpserver: "Network time server",
                locale: "Locale",
                ntpnotconfigured:"not configured"
            },
            backup: {
                title: "Backup",
                created: "Created",
                started: "Started",
                failed: "Failed",
                downloaded: "Downloaded",
                filename: "Filename",
                none: "none",
                never: "never",
                progress: "in progress",
                cancelprogress: "stopping backup",
                error : "Error",
                resolution : "Resolution",
                by: "{0} by {1}"
            },
            snmp: {
                title: "SNMP",
                trapdestination: "Trap Destination",
                trapport: "Trap Port",
                communitystring: "Community String",
                addtrapdestination: "Add Trap Destination",
                port: "Port",
                addMsg : "Add destination {0}",
                deleteMsg : "Delete destination {0}",
                error : "Unable to add destination {0}.",
                validateHostAddress: "Enter valid hostname or IP address",
                validatePortNumber: "Enter port between 1 and 65535",
                notificationMessage: "Unable to add trap destination, correct the indicated issues.",
                none: "none",
                retrieveDestinationsfailure: "Fail to retrieve trap destinations.",
                updateMsg : "Update done.",
                publicStr: "public",
                validateCommunityString: "Enter community string.",
                addCSMsgSuccess: "Added community string {0}.",
                globalcommunitystring: "Read community string",
                communitystringnote:"SNMP read community string is applied to all managed server hardware, power devices and enclosures.",
                learnmore:"Learn more...",
                unableToAddTrapDestination:"Unable to add trap destination",
                trapforwarding:"Trap Forwarding",
                notrapdestinations:"No trap destinations",
                specifyanotherdestination:"Please specify another trap destination.",
                unabletoconfiguredestination:"Unable to configure trap destination [",
                isdestinationconfigured:"] because it is already configured."
            },
            IPv6: {
                title: "IPv6",
                address: {
                    "1node": "IP address",
                    "2node": "Floating IP address"
                },
                 address2: {
                    "1node": "Second IP address"
                },
                addrtype: {
                    "1node": "Address assignment",
                    "2node": "Fixed address assignment"
                },
                node1: "Node 1 fixed IP address",
                node2: "Node 2 fixed IP address",
                subnet: "Subnet mask or CIDR",
                gateway: "Gateway address"
            },
            platform : {
                vm : "virtual machine"
            },
            addrType: {
                STATIC: "Manual",
                DHCP: "DHCP",
                UNCONFIGURE: "Off"
            },
            fromDHCP: "from DHCP",
            updateLink : "Update appliance",
            host : {
                name : "Host name",
                ip : "IP address"
            },
            version : "Version",
            hardware : "Hardware",
            applianceVersion : "Appliance version",
            update : {
                title : "Update Appliance",
                upload : "Upload",
                remove : "Remove",
                file : "File",
                cancelUpdate : "Cancel update",
                usersWarning : "<span id='cic-settings-update-usersWarning'>{0} other users</span> are logged into the appliance. Updating the appliance may cause them to lose any work in progress.",
                cancelUpload : "Cancel upload",
                performUpdate : "Perform update",
                releaseNotes : "Release notes",
                currentStatus: "Current status:",
                updateStatus: "{0}% completed",
                progress : "Updating",
                failureMessage : "The appliance update failed. The appliance will restart and revert to its pre-update state.  Please close the browser and log in again after the restart has completed.",
                progressInfo : "The browser will reconnect when the update is complete. You can also close this browser and log in again later if you prefer.",
                progressTime : "{0} minutes remaining",
                progressTimeOneMinute : "{0} minute remaining",
                installUpdate : "Install update",
                uploadInstall : "Upload and install",
                uploadOnly : "Upload only",
                uploadTime : "{0} remaining",
                checktext : "Go to hp.com for latest ",
                check : "updates",
                uploading : "uploading",
                applyWarning : "The update will cause a temporary service interruption, estimated to last {0} minutes.",
                applyWarningOtherUsers : "They will be locked out when the update starts and may lose their work.",
                applyContinue : "Continue with the update?",
                applyUpdate: "Yes, update",
                updateAppliance : "Update appliance",
                applyBoxUsersLoggedIn : "{0} other users are logged in.  " ,
                applyBoxOneUserLoggedIn : "{0} is logged into the appliance. ",
                applianceReboot : "The appliance is about to restart.",
                applianceUpdateFailed : "Unable to update appliance",
                uploadFileStop : "Stop uploading file {0} ?",
                uploadFileStopWarning : "Note: Any data transferred so far will be discarded. ",
                uploadStop : "Stop upload",
                uploadDelete : "Delete {0}",
                uploadFileDeleteWarning : "Are you sure you want to delete {0}?",
                uploadFileFormatWarning : "Invalid file format.",
                uploadFileDiskSpaceWarning : "Not enough space. Ensure that there is enough space to proceed.",
                healthWarning : {
                    MEMORY_ERROR : "Insufficient memory to continue the upload. Only {0} memory available.",
                    MEMORY_WARNING : "Insufficient memory. Only {0} memory available.",
                    CPU_ERROR : "Low on CPU(s) to start the upload. {0} CPU core(s) available.",
                    CPU_WARNING : "Low on CPU(s). {0} CPU core(s) available.",
                    DISK_ERROR : "Not enough space to continue the upload. Only {0} space available.",
                    DISK_WARNING : "Not enough space. Only {0} space available."
                },
                uploadStopButton : "Yes, stop upload",
                uploadDeleteButton : "Yes, delete",
                uploadWarningConditions  : "Error/Warning Conditions",
                eulaNotification : "An end user license agreement will be shown after the upload is complete",
                uploadingNotification : "Uploading",
                uploadedNotification : "Update",
                acceptEULA : "View EULA",
                installEULANotification : "To install the updates, you must agree to the EULA terms to proceed installing the update.",
                usersLoggedInAnd : " and ",
                uploadValidating : "validating",
                updateMessage : "This file is ready to be installed. It may take some time to install. After the installation, the appliance will reboot automatically if required.",
                continueUpdate : "Continue",
                startUpdate : "Update"
            }
        },
        network : {
            panel: {
                hostname: "General",
                nics: "Networks",
                ipv4: "IPv4",
                dns: "DNS",
                ipv6: "IPv6",
                timeandlanguage: "Time and Language",
                errors: "Errors"
            },
            "short-title" : "Network",
            dhcpWarning : "DHCP is not supported for assigning appliance IP addresses unless DHCP reservations are used. " ,
            dualStackWarning : "When configuring IPv6, ensure the DNS servers specified manually or supplied by the DHCP server support both IPv4 and IPv6 name resolution. ",
            datetimeWarning : "Changing the current date and time of the appliance sessions might expire/affect all the logged-in users and current jobs that are running in the appliance, so a reboot of the appliance is mandatory after applying the change." ,
            datetimeRebootWarning : "The appliance will reboot on manual date time setting.",
            timezoneWarning : "Time zone changes will be reflected after restarting the appliance." ,
            localeWarning : "Locale changes will be reflected only after rebooting the appliance." ,
            dhcpDisallowed : "DHCP configuration is not allowed",
            gatewayWarning : "Specify a gateway address if the appliance needs to be accessed from a different subnet." ,
            collapsibleWarning : "If you have entered any data for this network interface, keep this row expanded untill you press OK. If the row is collapsed before pressing OK, data you have entered will not be saved." ,
            deploymentIPWarning : "Insight Control server provisioning does not recommend ever changing the deployment IP address, even when changing between shared and independent modes. Always keep the deployment IP address the same and modify the appliance IP as required.",
            dialog : {
                action : "Applying network settings.",
                certwarn : "Accept certificates if the browser prompts you to.",
                redirect : "Browser will be redirecting to the new settings shortly.",
                browserwarn :"Some browser security settings can interfere with the handling of errors. If the appliance becomes unreachable, consult the printed appliance documentation for recovery actions.",
                altairftswarn : "Once settings are applied, there will be a short delay followed by an appliance reboot. The entire process will take about fifteen minutes. Please do not attempt to use the appliance until after the reboot completes, even if the main menu appears.",
                altaireditappliancewarn : "If you switched between shared and independent modes, your appliance will automatically shut down to allow you to reconfigure the network settings of the appliance. While your appliance is down, reconfigure the network connections to match your new settings and power the appliance back on to complete the reconfiguration. "
            },
            error : {
                get : {
                    msg:  "Unable to retrieve network settings.",
                    res : "Consult the printed appliance documentation for recovery actions."
                },
                set : {
                    timeout : {
                        msg : "Unable to automatically reconnect with the appliance.",
                        res : "Using the appliance's console, check the Activity screen for possible causes and use the Settings screen to determine the appliance's current IP address.",
                        resDhcp : "The network configuration has been changed from static to DHCP. The appliance is not reachable via the hostname. Verify that the hostname or IP address is reachable, open a new browser and connect to the new hostname or IP address."
                    },
                    ftsinprogress : {
                        msg : "Another appliance network configuration is in progress."
                    },
                    unknown : {
                        msg : "Errors Occurred. Unable to apply all the network settings correctly.",
                        res : "Restart the appliance. If the network settings are not applied after restarting the appliance, contact HP support."
                    }
                }
            },
            fields : {
              alias: "Shared with appliance interface",
              independent: "Independent",
                addrselector: {
                    full: "Address assignment",
                    short: "Address"
                },
                ipv6switch : "IPv6",
                ipv6state : {
                    on : "ON",
                    off : "OFF"
                },
                certificatechain: "Certificate chain (optional)",
                rabbitmqlistner: "RabbitMQ listens on this NIC.",
                postgresqllistner: "PostgreSQL listens on this NIC.",
                certificates: "Certificates",
                importrabbitmq: "RabbitMQ", 
                importpostgresql: "PostgreSQL",
                catrootcertificate: "CA root certificate",
                messaging: "Messaging",
                database: "Database",
                servercertificate: "Server certificate",
                privatekey: "Private Key",
                cacertificate: "CA Certificate",
                webserver: "Web Server",
                webservercertificates: "Web Server Certificates",
                services: " Services",
                listnermessage  : "Enable services to listen on this NIC.",
                restartwarn : "There will be a temporary service interruption while importing the certificate.",
                privatekeywarn: "Provide a valid RSA key.",
                certificate: "Certificate",
                compliantcert: "Provide X.509 compliant certificate.",
                
                dns1 : {
                    full : "Preferred DNS server",
                    short : "Preferred"
                },
                dns2 : {
                    full : "Alternate DNS server",
                    short : "Alternate"
                },
                manualdatetime : {
                    full : "Manual",
                    synchronizeWithHost : "Synchronize with VM host"
                },
                syncwithserver : {
                    full : "Synchronize with time server"
                },
                ntpserver : {
                    full : "Network time servers",
                    recommended : "Recommended"
                },
                currentdatetime : {
                    full : "Current date and time"
                },
                currentdatetimelabel : {
                    full : "Current date and time"
                },
                timezone : {
                    full : "Time zone"
                },
                locale : {
                    full : "Default language / locale"
                },
                gateway : {
                    both : "Gateways",
                    full : "Gateway address",
                    short : "Gateway"
                },
                hostname : {
                    full : "Appliance host name",
                    short : "Name"
                },
                ipaddr : {
                    short : "IP address",
                    applianceip : "Appliance IP",
                    fromDHCP : "from DHCP",
                    node1 : {
                        full : "Node 1 fixed IP address",
                        short : "Node 1"
                    },
                    node2 : {
                        full : "Node 2 fixed IP address",
                        short : "Node 2"
                    },
                    "one-node" : {
                        both : "IP addresses",
                        full : "IP address",
                        short : "IP address"
                    },
                    "two-node" : {
                        both : "Floating IP addresses",
                        full : "Appliance floating IP address",
                        short : "Floating IP address"
                    }
                },
                ipaddr2 : {
                    short : "Second IP address",
                    deploymentip : "Deployment IP",
                    node1 : {
                        full : "Node 1 Second fixed IP address"
                    },
                    node2 : {
                        full : "Node 2 Second fixed IP address"
                    }
                },
                iptype : {
                    ipv4 : "IPv4 configuration",
                    ipv6 : "IPv6 configuration",
                    "one-node" : " ",
                    short : "Configuration",
                    "two-node" : {
                        fixed : "Fixed IP address assignment",
                        floating : "Floating IP address assignment"
                    }
                },
                proxy : {
                    short : "Web proxy"
                },
                slaac : "SLAAC IP address",
                usage : "Usage",
                appliance : "Appliance",
                deployment : "Deployment",
                management : "Management",
                subnet : {
                    both : "Subnets",
                    full : "Subnet mask or CIDR",
                    short : "Subnet"
                }
            },
            headings : {
                appliance : "Appliance",
                dns : "DNS",
                ha : "High Availability",
                ipv6 : "IPv6"
            },
            iptype : {
                dhcp : "DHCP",
                manual : "Manual",
                off : "Off",
                unassign : "Unassign",
                dhcpv6 : "DHCPv6"
            },
            notify : {
                sourceName : "Appliance Network",
                set : {
                    parameterError : "Invalid Parameters. Correct any errors before proceeding.",
                    verify : "Verifying network settings...",
                    start : "Applying network settings. Please restart the appliance if the date and time of the appliance was changed manually.",
                    success : "Configuration saved.",
                    error : "Unable to apply settings.",
                    warning :"Warnings encountered during validation.",
                    warning_resolution:"Click OK to proceed anyway.",
                    multi_nic_fts_error:"Primary NIC and deployment NIC must be setup during First Time Appliance Setup."
                }
            },
            "slaac-ip-address" : "SLAAC IP address",
            title : "Appliance Networking",
            "dns-info" : "DNS",
            validator : {
                dns : {
                    ipv4_only : "Enter a valid IPv4 address of a DNS server.",
                    ipv4_ipv6 : "Enter a valid IPv4 or IPv6 address of a DNS server."
                },
                "gateway-ipv4" : "Enter a valid IPv4 gateway address.",
                "gateway-ipv6" : "Enter a valid IPv6 gateway address.",
                hostname : {
                    fqdn_optional : "Enter a valid hostname or fully qualified domain name.",
                    fqdn_required : "Enter a valid, fully qualified domain name."
                },
                ntpserver : {
                    ipv4 : "Enter a valid IPv4 address for NTP server.",
                    ipv4_v6 : "Enter a valid IPv4/v6 address for NTP server.",
                    ipv4_dns : "Enter a valid IPv4 address or hostname for NTP server.",
                    ntp_fqdn_required : "Enter a valid IP address or hostname for NTP server.",
                    set_date_time_manually : "Set date/time manually"
                },
                currentdatetime : {
                    datetime_required : "Select a valid Date and time using the date picker.",
                    datetime_format_resolution : "Ensure that the date/time is formatted as yyyy-mm-dd hh:mm:ss."
               },
                timezone : {
                     timezone_required : "Select a valid Timezone."
                },
                locale : {
                    locale_required : "Select a valid locale."

               },
               usage : "Enter a valid network interface name.",
                ipv4 : "Enter a valid IPv4 address.",
                ipv6 : "Enter a valid IPv6 address.",
                "mask-ipv4" : "Enter a valid IPv4 network mask, or a CIDR bit count between 0 and 32.",
                "mask-ipv6" : "Enter a valid IPv6 network mask, or a CIDR bit count between 0 and 128."
            },
            edit : {
              title : "Edit Appliance"
            }
        },
        authn : {
            title : "Authentication",
            "short-title" : "Authentication",
            allow_local : "Allow local login",
            default_provider : "Default directory",
            providers : "Providers",
            get_failed : "Failed to retrieve one or more authentication settings.",
            providers_not_set : "not set",
            enabled : "Enabled",
            disabled : "Disabled",
            local : "Local",
            default_directory : " (default)",
            failed_get_global_settings : "Failed to retrieve global settings.",
            failed_set_default_provider : "Failed to set the default provider.",
            refresh_and_verify_provider : "Refresh the page and verify that the provider you are looking for exists.",
            auth_settings_error : "Authentication settings error:",
            failed_get_provider_info : "Failed to get the  provider info",
            plus_more : "plus {0} more",
            enable_local_login : "Enabled",
            explain_login_provider : "To disable Local login you must log in using another authentication service.",
            edit : {
              title : "Edit Authentication",
              success : "Updated authentication settings",
              add_authn_service : "Add directory",
              service_name : "Directory name",
              remove : "Remove",
              verify : "Verify Authentication",
              protocol : "Protocol",
              baseDN : "Base DN",
              directory_servers : "Directory servers",
              add_server : "Add server",
              host_name : "Host name",
              default_dir_error : "Local login is not allowed. Choose an option other than LOCAL for default directory.",
              default_dir_delete_error : "Cannot remove default directory. Change the default directory and try again.",
              default_dir_delete_error2 : "Cannot delete a directory and have the same set as default directory!",
              directory_server_required_error : "At least one directory server is required.",
              baseDN_required_error : "All three values are required.",
              host_name_error : "Provide a host name.",
              save_failure : "The Add operation could not be completed because one or more required entries are either missing or invalid. Enter the missing data and try again.",
              failure_resolution : "Fix the errors and try again.",
              delete_directory_errormessage : "A user belonging to a directory cannot delete or edit it",
              directory_server_duplicate_error : "Directory service names cannot be duplicated.",
              default_dir_change_common_msg : "Changing the default directory can allow users unauthorized access to OpenStack resources.",
              default_dir_change_warning_msg : "Ensure that the original and new directories do not use the same user name to identify different individuals.",
              default_dir_change_confirm_msg : "Do you want to change the default directory?",
              default_dir_update_yes : "Yes,change",
              default_dir_change_title : "Change Default Directory",
              search_ctx_update_warning_msg : "Ensure that the original and new search context do not use the same user name to identify different individuals.",
              search_ctx_update_common_msg : "Changing the search context can allow users unauthorized access to OpenStack resources.",
              search_ctx_update_confirm_msg : "Do you want to change the search context?",
              search_ctx_update_title : "Change Search Context"
             },
            addDirectory : {
                title : "Add Directory",
                directory_name : "Directory",
                directory_type : "Directory type",
                search_context : "Search context",
                search_context_uid : "Search context (UID)",
                search_context_org : "Search context (Organization)",
                search_context_top : "Search context (Top Level Domain)",
                credentials_title : "Credentials",
                credentials_text : "(used to verify server connection and will not be saved)",
                username : "User name",
                password : "Password",
                directory_servers : "Directory servers",
                add_directory_server : "Add directory server",
                success_notification : "Update Directories",
                add_success : "Add directory {0}",
                remove_server_success : "Removed {0}",
                invalid_naming_attribute : "Incorrect value. Enter CN or UID depending upon AD/LDAP server configuration.",
                max_search_context : "At most {0} search context can be specified.",
                help_example : "Example",
                help_field1 : "Field1",
                help_field2 : "Field2",
                help_field3 : "Field3",
                certificate_placeholder : "Paste key here",
                disable_multirdn : "Incorrect value. '+' is not allowed."
            },
            addServer : {
                title : "Add Directory Server",
                host_name : "IP address or host name",
                ssl_port : "Directory server port",
                certificate : "Directory server certificate",
                success : "Change : Directory servers to {0}",
                table_column_server : "Server",
                table_column_certificate : "Certificate",
                certificate_state_yes : "Yes",
                duplicate_host : "Duplicate host name or IP address. Specify a different directory server.",
                invalid_host : "Invalid host name or IP address.",
                invalid_port : "Invalid port number - has to be a numeric value.",
                invalid_port_range : "Invalid port number range. (Range: 0 to 65535.) ",
                invalid_certificate : "The certificate entered does not appear to be X.509 certificate. Enter valid AD/LDAP server certificate."
            }
        },
        overview : {
            title : "Settings"
        },
        auditlogs : {
            download : "Download audit logs"
        },
        edit : {
            title : "Edit Settings",
            saved : "Settings have been saved."
                },
        supportdump : {
            title : "Create support dump",
            error_creating_dump : "Error creating dump",
            error_creating_dump_message : "Support dump creation failed. Try again.",
            error_downloading_dump : "Error downloading dump",
            error_downloading_dump_message : "Support dump download failed. It is likely that a new support dump request has been initiated.",
            createtitle : "Create support dump",
            create_button : "Yes, create",
            creating_dump : "Create support dump",
            create_dump : "Creating a support dump may take a few minutes after which the file download will begin automatically. Meanwhile, you can continue to use the UI normally. ",
            dump_created : "Successfully created dump",
            encryption_label :"Enable support dump encryption",
            create_prompt : "Do you want to create a support dump now?"

        },
        factoryReset: {
            title: "Factory Reset",
            factoryResetAction: "Factory Reset",  // menu name in Action menu
            warning: "Reset to factory defaults is a disruptive action that will erase all data, logs and settings on the appliance.",
            fullResetWarning: "If the network settings change as a result of the factory reset, the browser could lose connectivity to the appliance. If this occurs, open a new browser to connect to the appliance's new address, or alternatively use the kiosk interface on the appliance console.",
            preserveNetworkCheckbox: "Preserve appliance network settings",
            startFailure: "Factory Reset failed to start.",
            confirmationWarning: "Before you reset to factory deaults, make sure you have read and understood the warning message.",
            confirmationCheckbox: "I have read and understood all the implications.",
            confirmationCheckboxRequired: "Required",
            confirmationPrompt: "Continue factory reset?",
            confirmOk: "Yes, factory reset",
            ok: "OK"
        },
        shutdown: {
            title:"Shutdown Appliance",
            shutdownAction: "Shut down",
            warning:"Shutdown will cause all users to be disconnected and all ongoing tasks to be interrupted.",
            start_prompt : "Continue shutdown?",
            ok: "Yes, shut down." ,
            errorMsg : "Unable to perform shutdown."
        },
        restart: {
            title:"Restart Appliance",
            shutdownAction: "Restart",
            warning:"Restart will cause all users to be disconnected and all ongoing tasks to be interrupted.",
            start_prompt : "Continue restart?",
            ok: "Yes, restart." ,
            errorMsg : "Unable to perform restart."
        },
        restore: {
            kiloBytes: "KB",
            megaBytes: "MB",
            gigaBytes: "GB",
            title: "Restore from Backup",
            uploadingTitle : "Uploading",
            restorePendingTitle : "Restore",
            restoreAction : "Restore from backup",
            backupFileTitle : "Backup file",
            useUploadedFile : "Select a backup file",
            useStagedFile : "Restore from a backup file",
            uploadAndRestore : "Upload and restore",
            uploadOnly : "Upload only",
            aFileIsRequired : "A file is required.",
            uploadFileFormatWarning : "Invalid file format.",
            uploadInProgress : "Upload in progress.",
            uploadHMSRemaining: "{0}h {1}m {2}s remaining",
            uploadMSRemaining: "{0}m {1}s remaining",
            uploadStop : "Stop upload",
            uploadStopWarning : "Stop upload will discard any data transfered so far. Once the upload is complete, you will be able to restore from the uploaded file.",
            backupIsReady : "This backup is ready.",
            noBackupStaged : "No file has been uploaded yet.",
            restoreFromBackup : "Restore",
            restoreFromBackupConfirmationWarning : "Before you begin the restore process, make sure you understand all the implications.",
            restoreFromBackupConfirmationCheckbox : "I have read and understood all the implications.",
            restoreFromBackupConfirmationRequired : "Required",
            restoreFromBackupConfirmationPrompt : "Continue to restore from backup?",
            yesRestoreFromBackup : "Yes, restore",
            fileNameLabel : "File",
            createdDateLabel: "Created",
            versionLabel : "Version",
            sizeLabel : "Size",
            sizeData : "{0} {1}",
            uploading : "Uploading file",
            stopUpload : "Stop upload",
            uploadStopped : "Upload stopped",
            closeUpload : "Close",
            uploaded : "File uploaded",
            validating : "Validating file - this may take a while",
            validated : "File validated",
            stopRestore: "Cancel restore",
            restoreCanceled : "Restore canceled",
            uploadProgressUnknowable : "Uploading and validating file - this may take a while",
            backupTooBigErrMsg : "Backup is too large to upload.",
            backupTooBigResolutionMsg : "Select a backup smaller than {0} GB.",
            restoreWarningSummary: "Restoring from backup is a disruptive behavior.",
            restoreWarningDetails: "Any users using the appliance will be logged out and their work will be lost.",
            restoreStarted : "Restoring from backup ...",
            uploadOverwritten : "Another backup operation removed the uploaded backup.",
            retryUpload : "Retry the backup upload.",
            uploadFailed : "The backup upload failed to complete.",
            retryOrSelectAlternate : "Retry or select an alternate backup.",
            backupIsCompatible : "This file is compatible.",
            uploadActivity : "Upload ",
            uploadError : "Upload error",
            validationFailure : 'Validation failure',
            restoreModeStartError : 'Restore could not be started',
            restoreActivity : 'Restore '
        },
        backup: {
            backupAction : "Create backup",
            backupDownloadAction: "Download backup",
            backupDownloadLinkLabel: "Download most recent backup",
            unableToStartBackup: "Unable to start backup.",
            backupDidNotComplete: "The backup did not complete.",
            errorGettingBackupProgress: "Unable to get backup progress information.",
            unableToDownloadBackup: "Unable to download backup.",
            uploadedBackup: "Cannot download an uploaded backup.",
            noBackup: "No backup exists.",
            backupInProgress: "A backup is already in progress.",
            waitForBackupToComplete: "Wait until the backup completes, and then retry the operation.",
            createBackupAndRetry: "Create a backup, and then retry the operation.",
            errorCancellingBackup: "Unable to stop backup.",
            backupCreateDetails: "Backup started by {0}.",
            backupDownloadSummary: "Download backup",
            backupDownloadDetails: "Backup {0} download requested by {1}.",
            completedDetails: "Backup completed and ready to download.\n\nBackup {0} was created by {1}.",
            canceledDetails: "Stopped backup.",
            backupSourceName: "Appliance",
            backupStopLinkLabel: "Stop backup",
            backupStopDialogTitle: "Stop backup",
            backupStopButtonLabel: "Yes, stop backup",
            backupStopConfirmMessage: "Continue to stop backup?"
        },
        security : {
          title : "Security",
          overview : {
            cert_title : "Certificate",
            common_name : "Cert common name (CN)",
            valid_until : "Valid until",
            expires_in : "(expires in {0} days)",
            expires_message : "Appliance certificate expires in {0} days.",
            expires_detail_message : "Certificate expires on {0}, {1} days from now.",
            expires_resolution : "Import a new certificate using {0} or {1}.",
            auth_title : "Authentication",
            local_login : "Local login",
            default_directory : "Default directory",
            directories : "Directories",
            add_directory : "Add directory"
            },
            publickey : {
                title : "Key",
                download_location_msg : "The latest HP public key is available from {0}.",
                uploaded : "Uploaded HP Public Key",
                display_content : "Display Content",
                paste_message : "Paste Key Here",
                key_message : "This key is used to validate the authenticity of all patches and updates."
            },
            firmwarebundle : {
                optiontext : "Update firmware using ",
                http : "HTTP - Faster",
                https: "HTTPS - More secure",
                displayText: "This setting controls the protocol used for the iLO virtual media mount used when updating firmware on server hardware. <a href=\"doc#/cic/enclosure/add/learnmore\" target=\"hphelp\">Learn more...</a>"
            },
            edit_security_title: "Edit Security",
            panel: {
                authentication : "Authentication",
                hp_public_key : "HP Public Key",
                firmware_bundle : "Firmware Bundle"
            },
            more :{
                directories : "Directories",
            authn :{
              active_directory : "Active Directory",
              open_ldap : "OpenLDAP",
                directory_type : "Directory type",
                naming_attribute: "Naming attribute",
                search_context : "Search context",
                directory_servers : "Directory servers",
                no_directories : "No directories"
             }
            },
            edit_authn : {
              edit_directory_title : "Edit Directory",
              edit_directoryserver_title : "Edit Directory Server",
              delete_title : "Delete {0}",
              delete_message : "Are you sure you want to delete {0}? Continue with delete?",
              delete_yes :"Yes, delete"
            }
        },
        certificate : {
            title : "Certificate Settings",
            csr_attributes : "Certificate Signing Request Attributes",
            unstr_name : "Unstructured name",
            selfsigned : {
              create_action_title : "Create self-signed certificate",
              create_title : "Create Self-Signed Certificate",
              required_information : "Required Information",
              optional_information : "Optional Information",
              create_success : "Self-signed certificate created.",
              create_error : "Unable to create self-signed certificate.",
              create_action : "Create",
              get_action : "Retrieve",
              source_object : "Self signed certificate",
              get_error : "Unable to retrieve current self-signed certificate.",
              update_button : "Yes, update",
              cancel_button : "Cancel",
              dialog : {
              title : "Update Certificate",
                update : "Applying update...",
                certwarn : "You may need to accept browser certificates warnings when the browser refreshes.",
                restartwarn : "Warning: Updates to the certificate will require the appliance web server to be restarted. There will be a temporary service interruption estimated to last 30 seconds.",
                reconnectmsg :"You will automatically be reconnected when the system is available again.",
                continue_update : "Continue with the update?",
                usersLoggedIn : "{0} other users are logged in",
                oneUserLoggedIn : "1 other user is logged in",
                remaining : "{0} seconds remaining"
              },
              error : {
                timeout : {
                  msg : "The appliance is no longer reachable after restarting the web server.",
                  res : "Verify connectivity between this browser and the appliance's network address. Consult the printed appliance documentation for other recovery actions."
                },
                unknown : {
                    msg : "Unable to create self-signed certificate.",
                    res : "Restart the appliance. If unable to create a self-signed certificate after restarting the appliance, contact HP support."
                },
                support_dump_link : "Create a support dump",
                support_dump_link_message : "If the issue persists, {0} and contact your authorized support representative for assistance."
              }
            },
            country : "Country (C)",
            state : "State or province (ST)",
            locality : "City or locality (L)",
            org : "Organization name (O)",
            cn : "Common name (CN)",
            ou : "Organizational unit",
            alt_name : "Alternative name",
            contact : "Contact person",
            email : "Email address",
            surname : "Surname",
            given_name : "Given name",
            initials : "Initials",
            dn : "DN qualifier",
            explain_comma_list : "Enter a comma separated list of alternate names (such as hostname, IP address).  The CN is a required alternative name and will be added automatically if not supplied here.",
            hostname_regen_cert_warn    : "Changing the hostname requires generating a new SSL certificate for secure communications with your browser. ",
            hostname_regen_cert_warn_csr    : "Changing the hostname requires generating a new SSL certificate for secure communications with your browser. This also requires generating another CSR and getting a new signed SSL certificate and importing it to the appliance.",
            ipaddress_regen_cert_warn    : "Changing the IP address requires generating a new SSL certificate for secure communications with your browser. ",
            ipaddress_regen_cert_warn_csr    : "Changing the IP address requires generating a new SSL certificate for secure communications with your browser. This also requires generating another CSR and getting a new signed SSL certificate and importing it to the appliance.",
            hostname_cn_mistmatch    : "Host name and common name of the certificate are different. This requires generating a new SSL certificate for secure communications with your browser. ",
            hostname_cn_mistmatch_csr    : "Host name and common name of the certificate are different. This requires generating a new SSL certificate for secure communications with your browser. This also requires generating another CSR and getting a new signed SSL certificate and importing it to the appliance.",
            validator : {
              host_or_ip_required : "Specify valid hostnames or IP addresses.",
              max_length : "Enter no more than {0} characters.",
              max_length_no_cn : "The CN is automatically added to this field, but doing so will exceed the max size limit of {0}. Allow enough space to account for the CN.",
              matchpasswd : "Passwords must match.",
              passwdvalidation : "Password should not contain any of < > ; , \" ' & \\ / | + : = and space."

            },
            more_title : "Certificate",
            required_information : "Required Information",
            optional_information : "Optional Information",
            common_name : "Cert common name (CN)",
            issued_by : "Issued by",
            valid_from : "Valid from",
            valid_until : "Valid until",
            serial_number : "Serial number",
            version : "Version",
            md5_fingerprint : "MD5 fingerprint",
            sha1_fingerprint : "SHA1 fingerprint",
            cert_sign_req_attr : "Certificate Signing Request Attributes",
            unstructured_name : "Unstructured name",
            csr : {
              create_action_title : "Create certificate signing request",
              create_title : "Create Certificate Signing Request",
              create_action : "Create",
              source_object : "Certificate Signing Request",
              required_information : "Required Information",
              optional_information : "Optional Information",
              create_success : "Certificate signing request created.",
              create_error : "Unable to create certificate signing request.",
              get_error : "Unable to retrieve current certificate.",
              ok_button : "OK",
                cancel_button : "Cancel",
                challenge_password : "Challenge password",
                confirm_password : "Confirm password",
                dialog : {
                  base64_save : "The following base64 encoded data may be used to request a certificate from a certificate server. Copy the data below and use it to make a certificate request. Once you receive your certificate, import it using the \"Actions->Import certificate\" menu item in the Settings page."
                },
                error : {
                  support_dump_link : "Create a support dump",
                  support_dump_link_message : "If the issue persists, {0} and contact your authorized support representative for assistance."
                }
            },
            signedimport : {
              import_success : "Appliance certificate Imported.",
              import_action_title : "Import certificate",
              import_title : "Import Certificate",
              import_action: "Import",
              import_paste : "Paste a certificate to import it into the appliance.",
              certificate : "Certificate",
              dialog : {
                  importing : "Importing certificate...",
                  certwarn : "You may need to accept browser certificates warnings when the browser refreshes.",
                  restartwarn : "Warning:  Importing a new certificate will require the appliance web server to be restarted. There will be a temporary service interruption estimated to last 30 seconds.",
                  reconnectmsg :"You will automatically be reconnected when the system is available again.",
                  usersLoggedIn : "{0} other users are logged in",
                  oneUserLoggedIn : "1 other user is logged in",
                  remaining : "{0} seconds remaining"
              },
              error : {
                unknown : {
                  msg : "Unable to import signed certificate.",
                  res : "Restart the appliance. If unable to import a signed certificate after restarting the appliance, contact HP support."
                }
              }
            },
            truststore : {
                self_signed_warn : "The security certificate is not trusted because it is self signed.",
                issue_untrusted_warn : "The security certificate is issued by an entity that is not trusted.",
                invalid_warn : "The security certificate presented is not in validity period.",
                hostname_not_found_warn : "The security certificate from this website was issued for a different website's address.",
                connection_untrusted_warn : "This connection is untrusted.",
                issued_to : "Issued to",
                issued_by : "Issued by",
                valid_from : "Valid from",
                to : "to",
                retrieve_cert_error : "Unable to retrieve certificate.",
                retrieve_cert_resolution : "Resolution : Try registering again.",
                header : "Trust Certificate",
                variableheader : "Trust Certificate {0}",
                certificate_information : "Certificate",
                details : "Details",
                trust_confirm : "Continue to trust certificate?",
                trust_confirm_multiple : "Continue to trust certificates?",
                ca_info : "Certificate authority",
                not_auth : "You are not authorized to perform this action",
                not_auth_resol : "Check your credentials and try registering again.",
                version : "Version",
                serial_number : "Serial number",
                common_name : "Subject ( CN, O, L, S, C)",
                issuer : "Issuer",
                alternative_name : "Subject alternative names",
                sha1_fingerprint : "SHA1 fingerprint",
                md5_fingerprint : "MD5 fingerprint",
                signature_algorithm : "Signature algorithm",
                public_key : "Public key",
                revoked_msg : "The security certificate has been revoked",
                revoked_resol : "Verify that the host address is correct and try registering again",
                close : "Close",
                ok_trust : "Yes, trust certificate",
                cancel_trust : "No, do not trust",
                upload_ca_cert : "Upload the CA certificate of the host and proceed with registration.",
                invalid_chain : "The security certificate is not trusted because the certificate chain is invalid.",
                invalid_chain_resol : "Correct the certificate chain in the host and try registering again",
                ca_certificate : "CA Certificate",
                ca_cert_header : "Add CA Certificate",
                ca_cert_upload_error : "Unable to add certificate",
                verifying : "Verifying...",
                ca_cert_upload_error_detail : "Certificate is not valid. Provide a valid certificate.",
                upload_ca_reason : "The security certificate of {0} is not trusted because the issuer is unknown.",
                required : "Required"
            }
        },
        supportaccess : {
            service_unavailable : "Unable to get support access.",
            error : "Unable to edit support access.",
            update : "Update",
            source_object : "Services Access",
            success : "Successfully updated Services Access.",
            failure : "Failed to update Services Access."
        },
        eula : {
            config : {
                appliance_name : "Virtual Appliance",
                end_user_title : "License",
                eula_title : "End-User license agreement",
                agree_button : "Agree",
                disagree_button : "Disagree",
                yesdisagree_button : "Yes, disagree",
                confirmation_dialog_advice : "If you disagree with the terms of the End-User License agreement, you cannot proceed.",
                end_user_support_title : "Support",
                application_support : "Application Support",
                warning : "warning",
                written_offer : "Written offer",
                enabled : "Enabled",
                disabled : "Disabled",
                support : "Support",
                license : "Licenses",
                support_access_enabled : "Authorized services access",
                edit_appliance_support_access : "Edit services access",
                agree_disagree_message : "If you agree with the licensing terms, click Agree. Otherwise, click Disagree.",
                content_directory: "/ui-js/pages/fs/license",
                upgrade_content_directory: "/ui-js/pages/upgrade",
                eula_content_file : "eula_content.html",
                support_access_file : "support_access_and_written_offer.html"
            }
        },
        license : {
            config : {
                add_license : "Add license",
                add_license_title : "Add License",
                license_key: "License Key",
                licensing_portal : "HP licensing portal",
                verifying_license : "Verifying license key...",
                successMsg : "Add license",
                error : {
                      msg : "Unable to add license: "
                  }
            },
            summary : {
                add : "Add",
                no_licenses : "No licenses",
                license : "Licenses",
                licensed : "Licensed Servers",
                licensed_instance_required : "Instances without {0} license",
                compliance : "Usage",
                license_required : "{0} {1} required",
                licensed_total_nodes : "{0} {1} licensed",
                available_license : "{0} {1} available",
                peak_usage : "{0} peak usage",
                total_license : "{0} total licenses",
                type : {
                    node : "node",
                    node_plural : "nodes",
                    instance : "instance",
                    instance_plural : "instances",
                    vm : "vm",
                    vm_plural : "vms",
                    server : "server",
                    server_plural : "servers",
                    license : "license",
                    license_plural : "licenses"
                }
            },
            notification :{
                title : "More licenses required",
                details : "Add more {0} licenses to be in compliance.",
                license_ok : "All servers are licensed"
            }
        }

    };
});
