//(C) Copyright 2012-2014 Hewlett-Packard Development Company, L.P.
define([], function() {"use strict";
    return {
        menu : "Configuracion",
        "development" : {
            "title" : "Configuracin para el desarrollo",
            "short-title" : "Desarrollo",
            "refresh_interval" : "Intervalo de actualizacion",
            "ms" : "milisegundos",
            "max_master_items" : "Numero maximo de elementos en el panel principal",
            "experimental_features" : "Caracteristicas experimentales",
            "routing-log-level" : "Registro de enrutamiento",
            "edit" : {
                "title" : "Editar la configuracin de desarrollo",
                "success" : "Actualizado entornos de desarrollo"
            }
        },
        "appliance" : {
            "title" : "[ES] Appliance",
            overview : {
                hostname: "[ES] Host name",
                ipaddr: "[ES] Appliance IP address",
                ipaddr2: "[ES] Deployment IP address",
                networkInterfaces:"[ES] Network Interfaces",
                version: "[ES] Version",
                model: "[ES] Model",
                datetime: "[ES] Date/time",
                snmp: "Destinos de capturas SNMP"
            },
            general: {
                title: "[ES] General",
                hostname: "[ES] Appliance host name",
                model: "[ES] Model number",
                serial: "[ES] Serial number",
                version: "[ES] Firmware version",
                date: "[ES] Firmware date"
            },
            IPv4: {
                title: "[ES] IPv4",
                address: {
                    "1node": "[ES] IP address",
                    "2node": "[ES] Floating IP address"
                },
                 address2: {
                    "1node": "[ES] Second IP address"
                },
                addrtype: {
                    "1node": "[ES] Address assignment",
                    "2node": "[ES] Fixed address assignment"
                },
                node1: "[ES] Node 1 fixed IP address",
                node2: "[ES] Node 2 fixed IP address",
                subnet: "[ES] Subnet mask or CIDR",
                gateway: "[ES] Gateway address"
            },
            DNS: {
                title: "[ES] DNS",
                preferred: "[ES] Preferred DNS server",
                alternate: "[ES] Alternate DNS server"
            },
            timeandlanguage: {
                title: "[ES] Time and Language",
                currentdatetime: "[ES] Current date/time",
                timezone: "[ES] Timezone",
                ntpserver: "[ES] Network time server",
                locale: "[ES] Locale",
                ntpnotconfigured:"[ES] not configured"
            },
            backup: {
                title: "[ES] Backup",
                created: "[ES] Created",
                started: "[ES] Started",
                failed: "[ES] Failed",
                downloaded: "[ES] Downloaded",
                filename: "[ES] Filename",
                none: "[ES] none",
                never: "[ES] never",
                progress: "[ES] in progress",
                cancelprogress: "[ES] stopping backup",
                error : "[ES] Error",
                resolution : "[ES] Resolution",
                by: "[ES] {0} by {1}"
            },
            snmp: {
                title: "SNMP",
                trapdestination: "Destino de trampa",
                trapport: "Trampa Puerto",
                communitystring: "cadena de comunidad",
                addtrapdestination: "A\u00F1adir destino de captura",
                port: "puerto",
                addMsg : "Adici\u00F3n de destino {0}",
                deleteMsg : "Eliminaci\u00F3n de destino {0}",
                error : "No se puede agregar destino {0}.",
                validateHostAddress: "Introduzca la direcci\u00F3n de host o direcci\u00F3n IP v\u00E1lida",
                validatePortNumber: "Ingrese puerto entre 1 y 65535",
                notificationMessage: "No se puede agregar destino de captura, corregir los problemas indicados.",
                none: "ninguno",
                retrieveDestinationsfailure: "Error al recuperar los destinos de las capturas.",
                updateMsg : "Actualizar hecho.",
                publicStr : "p\u00FAblico",
                validateCommunityString: "Introduzca cadena de comunidad.",
                addCSMsgSuccess: "Agregar cadena de comunidad {} con \u00E9xito.",
                globalcommunitystring: "Leer cadena de comunidad",
                communitystringnote:"Cadena de comunidad SNMP de lectura se aplica a todos los servidores gestionados hardware, dispositivos de potencia y recintos.",
                learnmore:"Aprenda m\U00E1s...",
                unableToAddTrapDestination:"No se puede agregar destino de captura",
                trapforwarding:"Desv\u00EDo de Trampa",
                notrapdestinations:"No hay destinos de las capturas",
                specifyanotherdestination:"Por favor especificar otro destino de captura.",
                unabletoconfiguredestination:"No se puede configurar destino de capturas [",
                isdestinationconfigured:"] debido a que ya est\u00E1 configurado."
            },
            IPv6: {
                title: "[ES] IPv6",
                address: {
                    "1node": "[ES] IP address",
                    "2node": "[ES] Floating IP address"
                },
                 address2: {
                    "1node": "[ES] Second IP address"
                },
                addrtype: {
                    "1node": "[ES] Address assignment",
                    "2node": "[ES] Fixed address assignment"
                },
                node1: "[ES] Node 1 fixed IP address",
                node2: "[ES] Node 2 fixed IP address",
                subnet: "[ES] Subnet mask or CIDR",
                gateway: "[ES] Gateway address"
            },
            platform : {
                vm : "[ES] virtual machine"
            },
            addrType: {
                STATIC: "[ES] Manual",
                DHCP: "[ES] DHCP",
                UNCONFIGURE: "[ES] Off"
            },
            fromDHCP: "[ES] from DHCP",
            "updateLink" : "[ES] Update appliance",
            "host" : {
                "name" : "[ES] Host name",
                "ip" : "[ES] IP address"
            },
            "version" : "[ES] Version",
            "hardware" : "[ES] Hardware",
            "applianceVersion" : "[ES] Appliance version",
            "update" : {
                "title" : "[ES] Update Appliance",
                "upload" : "[ES]Upload",
                "remove" : "[ES] Remove",
                "file" : "[ES]File",
                "cancelUpdate" : "[ES]Cancel update",
                "usersWarning" : "[ES]<span id='cic-settings-update-usersWarning'>{0} other users</span> are logged " +
                                 "into the appliance.</br>" +
                                 "Updating the appliance may cause them to lose any work in progress.",
                "cancelUpload" : "[ES] Cancel upload",
                "performUpdate" : "[ES] Perform update",
                "releaseNotes" : "[ES] Release notes",
                "currentStatus": "[ES] Current status:",
                "updateStatus": "[ES] {0}% completed:",
                "progress" : "[ES] Updating",
                "failureMessage" : "[ES] The appliance update failed.  The appliance will restart and revert to its pre-update state.  Please close the browser and log in again after the restart has completed.",
                "progressInfo" : "[ES] The browser will reconnect when the update is complete." +
                "</br>You can also close this browser and log in again later if you prefer.",
                "progressTime" : "[ES] {0} minutes remaining",
                "progressTimeOneMinute" : "[ES]{0} minute remaining",
                "installUpdate" : "[ES] Install update",
                "uploadInstall" : "[ES] Upload and install",
                "uploadOnly" : "[ES] Upload only",
                "uploadTime" : "[ES]{0} remaining",
                "checktext" : "[ES] Go to hp.com for latest",
                "check" : "[ES] updates",
                "uploading" : "[ES] uploading",
                "applyWarning" : "[ES]The update will cause a temporary service interruption, " +
                                 "estimated to last {0} minutes.",
                "applyWarningOtherUsers" : "[ES]They will be locked out when the update " +
                                           "starts and may lose their work.",
                "applyContinue" : "[ES] Continue with the update?",
                "applyUpdate": "[ES] Yes, update",
                "updateAppliance" : "[ES]Update appliance",
                "applyBoxUsersLoggedIn" : "[ES]{0} other users are logged in.  ",
                "applyBoxOneUserLoggedIn" : "[ES]{0} is logged into the appliance. ",
                "applianceReboot" : "[ES] The appliance is about to restart.",
                "applianceUpdateFailed" : "[ES]Unable to update appliance",
                "uploadFileStop" : "[ES] Stop uploading file {0} ?",
                "uploadFileStopWarning" : "[ES] Note: Any data transferred so far will be discarded. ",
                "uploadStop" : "[ES]Stop upload",
                "uploadDelete" : "[ES]Delete {0}",
                "uploadFileDeleteWarning" : "[ES]Are you sure you want to delete {0}?",
                "uploadFileFormatWarning" : "[ES]Invalid file format.",
                "uploadFileDiskSpaceWarning" : "[ES]Not enough space. Ensure that there is enough space to proceed.",
                "healthWarning" : {
                    "MEMORY_ERROR" : "[ES]Insufficient memory to continue the upload. Only {0} memory available.",
                    "MEMORY_WARNING" : "[ES]Insufficient memory. Only {0} memory available.",
                    "CPU_ERROR" : "[ES]Low on CPU(s) to start the upload. {0} CPU core(s) available.",
                    "CPU_WARNING" : "[ES]Low on CPU(s). {0} CPU core(s) available.",
                    "DISK_ERROR" : "[ES]Not enough space to continue the upload. Only {0} space available.",
                    "DISK_WARNING" : "[ES]Not enough space. Only {0} space available."
                },
                "uploadStopButton" : "[ES]Yes, stop upload",
                "uploadDeleteButton" : "[ES]Yes, delete",
                "uploadWarningConditions"  : "[ES]Error/Warning Conditions",
                "eulaNotification" : "[ES]An end user license agreement will be shown after the upload is complete",
                "uploadingNotification" : "[ES]Uploading",
                "uploadedNotification" : "[ES]Update",
                "acceptEULA" : "[ES]View EULA",
                "installEULANotification" : "[ES]To install the updates, you must agree to the EULA terms to proceed installing the update.",
                "usersLoggedInAnd" : "[ES] and ",
                "uploadValidating" : "[ES]validating",
                "updateMessage" : "[ES]This file is ready to be installed. It may take some time to install. After the installation, the appliance will reboot automatically if required.",
                "continueUpdate" : "[ES]Continue",
                "startUpdate" : "[ES]Update"
            }
        },
        "network" : {
             panel: {
                hostname: "General",
                nics: "[ES] Networks",
                ipv4: "IPv4",
                dns: "DNS",
                ipv6: "IPv6",
                timeandlanguage: "[ES] Time and Language",
                errors: "[ES] Errors"
            },
            "short-title" : "Red",
            "dhcpWarning" : "[ES]DHCP is not supported for assigning appliance IP addresses unless DHCP reservations" +
                          " are used. ",
            "dualStackWarning" : "[ES]When configuring IPv6, ensure the DNS servers specified manually or supplied by the" +
            					" DHCP server support both IPv4 and IPv6 name resolution. ",
            "datetimeWarning" : "[ES] Changing the current date and time of the appliance sessions might expire/affect all the logged-in users and current jobs that are running in the appliance, so a reboot of the appliance is mandatory after applying the change." ,
            "datetimeRebootWarning" : "[ES] The appliance will reboot on manual date time setting.",
            "timezoneWarning" : "[ES] Time zone changes will be reflected after restarting the appliance." ,
            "localeWarning" : "[ES] Locale changes will be reflected only after rebooting the appliance." ,
            "dhcpDisallowed" : "[ES] DHCP configuration is not allowed",
            "gatewayWarning" : "[ES] Specify gateway address if the appliance needs to be accessed from a different subnet" ,
            "collapsibleWarning" : "[ES] If you have entered any data for this network interface, keep this row expanded untill you press OK. If the row is collapsed before pressing OK, data you have entered will not be saved.",
            "deploymentIPWarning" : "[ES] Insight Control server provisioning does not recommend ever changing the deployment IP address, even when changing between shared and independent modes. Always keep the deployment IP address the same and modify the applaince IP as required.",
            "dialog" : {
                "action" : "[ES] Applying network settings.",
                "certwarn" : "[ES] Accept certificates if the browser prompts you to.",
                "redirect" : "[ES] Browser will be redirecting to the new settings shortly.",
                "browserwarn" :"[ES] Some browser security settings can interfere with the handling of errors." +
                             " If the appliance becomes unreachable, consult the printed appliance documentation " +
                             "for recovery actions.",
                "altairftswarn" : "[ES] Once settings are applied, there will be a short delay followed by an appliance reboot. The entire process will take about fifteen minutes. Please do not attempt to use the appliance until after the reboot completes, even if the main menu appears.",
                "altaireditappliancewarn" : "[ES] If you switched between shared and independent modes, your appliance will automatically shut down to allow you to reconfigure the network settings of the appliance. While your appliance is down, reconfigure the network connections to match your new settings and power the appliance back on to complete the reconfiguration. "
            },
            "error" : {
                "get" : {
                    "msg":  "[ES] Unable to retrieve network settings.",
                    "res" : "Consult the printed appliance documentation for recovery actions."
                },
                "set" : {
                    "timeout" : {
                        "msg" : "[ES] Unable to automatically reconnect with the appliance.",
                        "res" : "[ES] Using the appliance's console, check the Activity screen for "+
                                "possible causes and use the Settings screen to determine "+
                                "the appliance's current IP address.",
                        "resDhcp" : "[ES] The network configuration has been changed from static to DHCP. " +
                                    "The appliance is not reachable via the hostname." +
                                    "Verify that the hostname or IP address is reachable , open a new browser " +
                                    "and connect to the new hostname or IP address."
                    },
                    "ftsinprogress" : {
                        "msg" : "Another appliance network configuration is in progress."
                    },
                    "unknown" : {
                        "msg" : "[ES] Errors Occurred. Unable to apply all  network settings correctly.",
                        "res" : "[ES] Restart the appliance. If the network settings are not applied after restarting " +
                                 " the appliance, contact HP support."
                    }
                }
            },
            "fields" : {
              alias: "[ES] Shared with appliance interface",
              independent: "[ES] Independent",
                addrselector: {
                    full: "[ES] Address assignment",
                    short: "[ES] Address"
                },
                ipv6switch : "[ES] IPv6",
                ipv6state : {
                    on : "[ES] ON",
                    off : "[ES] OFF"
                },
                
                certificatechain: "[ES] Certificate chain (optional)",
                rabbitmqlistner: "[ES] RabbitMQ listens on this NIC.",
                postgresqllistner: "[ES] PostgreSQL listens on this NIC.",
                certificates: "[ES] Certificates",
                importrabbitmq: "[ES] RabbitMQ", 
                importpostgresql: "[ES] PostgreSQL",
                catrootcertificate: "[ES] CA root certificate",
                messaging: "[ES] Messaging",
                database: "[ES] Database",
                servercertificate: "[ES] Server certificate",
                privatekey: "[ES] Private Key",
                cacertificate: "[ES] CA Certificate",
                webserver: "[ES] Web Server",
                webservercertificates: "[ES] Web Server Certificates",
                services: "[ES]  Services",
                listnermessage  : "[ES] Enable services to listen on this NIC.",
                restartwarn : "[ES] There will be a temporary service interruption while importing the certificate.",
                privatekeywarn: "[ES] Provide a valid RSA key.",
                certificate: "[ES] Certificate",
                compliantcert: "[ES] Provide X.509 compliant certificate.",
                "dns1" : {
                    "full" : "[ES] Preferred DNS server",
                    "short" : "[ES] Preferred"
                },
                "dns2" : {
                    "full" : "[ES] Alternate DNS server",
                    "short" : "[ES] Alternate"
                },
                "manualdatetime" : {
                    full : "[ES] Manual",
                    synchronizeWithHost : "[ES] Synchronize with VM host"
                },
                "syncwithserver" : {
                    full : "[ES] Synchronize with time server"
                },
                "ntpserver" : {
                    full : "[ES] Network time servers",
                    recommended : "[ES] Recommended"
                },
                "currentdatetime" : {
                    full : "[ES] Current date and time"
                },
                "currentdatetimelabel" : {
                    full : "[ES] Current date and time"
                },
                "timezone" : {
                    full : "[ES] Time zone"
                },
                "locale" : {
                    full : "[ES] Default language / locale"
                },
                "gateway" : {
                    "both" : "[ES] Gateways",
                    "full" : "[ES] Gateway address",
                    "short" : "[ES] Gateway"
                },
                "hostname" : {
                    "full" : "[ES] Appliance host name",
                    "short" : "[ES] Name"
                },
                "ipaddr" : {
                    "short" : "[ES] IP address",
                    applianceip : "[ES] Appliance IP",
                    fromDHCP : "from DHCP",
                    "node1" : {
                        "full" : "[ES] Node 1 fixed IP address",
                        "short" : "[ES] Node 1"
                    },
                    "node2" : {
                        "full" : "[ES] Node 2 fixed IP address",
                        "short" : "[ES] Node 2"
                    },
                    "one-node" : {
                        "both" : "[ES] IP addresses",
                        "full" : "[ES] Appliance IP address",
                        "short" : "[ES] IP address"
                    },
                    "two-node" : {
                        "both" : "[ES] Floating IP addresses",
                        "full" : "[ES] Appliance floating IP address",
                        "short" : "[ES] Floating IP address"
                    }
                },

                "ipaddr2" : {
                    "short" : "[ES] Second IP address",
                    deploymentip : "[ES] Deployment IP",
                    "node1" : {
                        "full" : "[ES] Node 1 Second fixed IP address"
                    },
                    "node2" : {
                        "full" : "[ES] Node 2 Second fixed IP address"
                    }
                },

                "iptype" : {
                    "ipv4" : "[ES] IPv4 configuration",
                    "ipv6" : "[ES] IPv6 configuration",
                    "one-node" : " ",
                    "short" : "[ES] Configuration",
                    "two-node" : {
                        "fixed" : "[ES] Fixed IP address assignment",
                        "floating" : "[ES] Floating IP address assignment"
                    }
                },
                "proxy" : {
                    "short" : "[ES] Web proxy"
                },
                "slaac" : "[ES] SLAAC IP address",
                "usage" : "[ES] Usage",
                "appliance" : "[ES] Appliance",
                "deployment" : "[ES] Deployment",
                "management" : "[ES] Management",
                "subnet" : {
                    "both" : "[ES] Subnets",
                    "full" : "[ES] Subnet mask or CIDR",
                    "short" : "[ES] Subnet"
                }
            },
            "headings" : {
                "appliance" : "[ES] Appliance",
                "dns" : "[ES] DNS",
                "ha" : "[ES] High Availability",
                "ipv6" : "[ES] IPv6"
            },
            "iptype" : {
                "dhcp" : "[ES] DHCP",
                "manual" : "[ES] Manual",
                "off" : "[ES] Off",
                "unassign" : "[ES] Unassign",
                "dhcpv6" : "[ES] DHCPv6"
            },
            notify : {
                sourceName : "[ES]Appliance Network",
                set : {
                    parameterError : "[ES] Invalid Parameters. Correct errors before proceeding",
                    verify : "[ES] Verifying network settings...",
                    start : "[ES] Applying network settings. Please restart the appliance if the date and time or locale of the appliance was changed manually.",
                    success : "[ES] Configuration saved.",
                    error : "[ES] Unable to apply settings.",
                    warning :"[ES] Warnings encountered during validation.",
                    warning_resolution:"[ES] Click OK to proceed anyway.",
                    multi_nic_fts_error:"[ES] Primary NIC and deployment NIC must be setup during First Time Appliance Setup."
                }
            },

            "slaac-ip-address" : "[ES] SLAAC IP address",
            "title" : "[ES] Appliance Networking",
            "dns-info" : "DNS",
            "validator" : {
                "dns" : {
                    "ipv4_only" : "[ES] Enter a valid IPv4 address of a DNS server.",
                    "ipv4_ipv6" : "[ES] Enter a valid IPv4 or IPv6 address of a DNS server."
                },
                "gateway-ipv4" : "[ES] Enter a valid IPv4 gateway address.",
                "gateway-ipv6" : "[ES] Enter a valid IPv6 gateway address.",
                "hostname" : {
                    "fqdn_optional" : "[ES] Enter a valid hostname or fully qualified domain name.",
                    "fqdn_required" : "[ES] Enter a valid, fully qualified domain name."
                },
                "ntpserver" : {
                    "ipv4" : "[ES] Enter a valid IPv4 address for NTP server.",
                    "ipv4_v6" : "[ES] Enter a valid IPv4/v6 address for NTP server.",
                    "ipv4_dns" : "[ES] Enter a valid IPv4 address or hostname for NTP server.",
                    "ntp_fqdn_required" : "[ES] Enter a valid IP address or hostname for NTP server.",
                    "set_date_time_manually" : "[ES] Set date/time manually"
                },
                "currentdatetime" : {
                    "datetime_required" : "[ES] Select a valid Date time using the date picker.",
                    "datetime_format_resolution" : "[ES] Ensure that the date/time is formatted as yyyy-mm-dd hh:mm:ss."
                },
                "timezone" : {
                    "timezone_required" : "[ES] Select a valid Timezone."
                 },
                 "locale" : {
                     "locale_required" : "[ES] Select a valid locale."

                },
                "usage" : "[ES]Enter a valid network interface name.",
                "ipv4" : "[ES] Enter a valid IPv4 address.",
                "ipv6" : "[ES] Enter a valid IPv6 address.",
                "mask-ipv4" : "[ES] Enter a valid IPv4 network mask, or a CIDR bit count between 0 and 32.",
                "mask-ipv6" : "[ES] Enter a valid IPv6 network mask, or a CIDR bit count between 0 and 128."
            },
            "edit" : {
              "title" : "Edit Appliance"
            }
        },
        "authn" : {
            "title" : "Configuracin de la autenticaci\u00F3n",
            "short-title" : "Autenticacin",
            "allow_local" : "Permitir inicio de sesin local",
            "default_provider" : "Por defecto del proveedor",
            "providers" : "Proveedores",
            "get_failed" : "No se puedo recuperar uno o ms valores de autenticaci\u00F3n.",
            "providers_not_set" : "No se establece",
            "enabled" : "Activado",
            "disabled" : "Discapacitado",
            "local" : "Local",
            "default_directory" : " (defecto)",
            "failed_get_global_settings" : "No se puedo recuperar la configuracin global.",
            "failed_set_default_provider" : "No se peudo establecer el proveedor predeterminado.",
            "refresh_and_verify_provider" : "Actualizar la pgina y verificar que el proveedor que busca existe.",
            "auth_settings_error" : "Configuraci\u00F3n de autenticacin de error:",
            "failed_get_provider_info" : "[ES]Failed to get the  provider info",
            "plus_more" : "adems de {0} ms",
            "explain_login_provider" : "Para deshabilitar el inicio de sesi\u00F3n local debe iniciar " +
                                       "sesi\u00F3n en el uso de otro servicio de autenticaci\u00F3n.",
            "enable_local_login" : "Activado",
            "edit" : {
              "title" : "editar autenticacin",
              "success" : "Actualizado configuraci\u00F3n de autenticaci\u00F3n",
              "service_name": "Nombre del directorio",
              "remove": "Apartamiento",
              "verify" : "Verificar la autenticaci\u00F3n",
              "add_authn_service" : "A\u00F1adir el directorio",
              "protocol" : "Protocolo",
              "baseDN" : "Base DN",
              "directory_servers" : "Servidores de directorio",
              "add_server" : "A\u00F1adir servidor de",
              "host_name" : "Nombre de host",
              "default_dir_error" : "Inicio de sesion local no esta permitido. Por favor, " +
                  "elija una opcion que no sea LOCAL para el directorio por defecto.",
              "default_dir_delete_error" : "No se puede eliminar el directorio por defecto. " +
                  "Cambie el directorio por defecto y vuelva a intentarlo.",
              "default_dir_delete_error2" : "No se puede eliminar un directorio y tienen el " +
                  "mismo conjunto como directorio por defecto",
              "directory_server_required_error" : "Al menos un servidor de directorio se requiere.",
              "baseDN_required_error" : "Los tres valores son necesarios.",
              "host_name_error" : "Por favor, proporcione un nombre de host.",
              "save_failure" : "No se pudo completar la operaci\uFFFDn de guardar porque una o m\uFFFDs " +
                  "entradas necesarias son falta o no es v\uFFFDlido. Introduzca los datos que faltan y vuelva a intentarlo.",
              "failure_resolution" : "Por favor, corrija los errores y vuelva a intentarlo.",
              "delete_directory_errormessage" : "[ES]A user belonging to a directory cannot delete or edit it",
              "directory_server_duplicate_error" : "Los nombres de directorio de servicios no puede ser duplicado",
              "default_dir_change_common_msg" : "Changing the default directory can allow users unauthorized access to OpenStack resources.",
              "default_dir_change_warning_msg" : "Ensure that the original and new directories do not use the same user name to identify different individuals.",
              "default_dir_change_confirm_msg" : "Do you want to change the default directory?",
              "default_dir_update_yes" : "Yes,change",
              "default_dir_change_title" : "Change Default Directory",
              "search_ctx_update_warning_msg" : "Ensure that the original and new search context do not use the same user name to identify different individuals.",
              "search_ctx_update_common_msg" : "Changing the search context can allow users unauthorized access to OpenStack resources.",
              "search_ctx_update_confirm_msg" : "Do you want to change the search context?",
              "search_ctx_update_title" : "Change Search Context"
            },
            addDirectory : {
                title : "A\u00f1adir directorio",
                directory_name : "directorio",
                directory_type : "Tipo de directorio",
                search_context : "Buscar contexto",
                search_context_uid : "Buscar contexto (UID)",
                search_context_org : "Buscar contexto (organizaci\u00f3n)",
                search_context_top : "Buscar contexto (dominio de nivel superior)",
                credentials_title : "Credenciales " ,
                credentials_text :"(utilizado para verificar la conexi\u00f3n del servidor y no se guardar\u00e1)",
                username : "Nombre del consumidor",
                password : "contrase\u00f1a",
                directory_servers : "Los servidores de directorio",
                add_directory_server : "Add directory server",
                success_notification : "Actualizar los Directorios",
                add_success : "A\u00f1adir directorio { 0}",
                remove_server_success : "Quitado {0}",
                invalid_naming_attribute : "Valor incorrecto. " +
                    "Ingrese CN o UID dependiendo de AD / configuraci\u00f3n del servidor LDAP.",
                max_search_context : "A lo sumo {0} contexto de búsqueda se puede especificar.",
                help_example : "Example",
                help_field1 : "Field1",
                help_field2 : "Field2",
                help_field3 : "Field3",
                certificate_placeholder : "Paste key here",
                disable_multirdn : "Incorrect value. '+' is not allowed."
            },
            addServer : {
                title : "Add Directory Server",
                host_name : "Direcci\u00f3n IP o nombre de host",
                ssl_port : "Directory server port",
                certificate : "Certificado del servidor de directorio",
                success : "Cambio : servidores de directorio a { 0}",
                table_column_server : "servidor",
                table_column_certificate : "certificado",
                certificate_state_yes : "s\u00ed",
                duplicate_host : "Duplicar el nombre de host o la direcci\u00f3n IP. " +
                    "Especifique un servidor de directorio.",
                invalid_host : "Nombre de host no v\u00e1lido o una direcci\u00f3n IP.",
                invalid_port : "N\u00famero de puerto no v\u00e1lido - tiene que ser un valor num\u00e9rico.",
                invalid_port_range : "Invalid rango de n\u00fameros de puerto. (Gama: 0 a 65535)",
                invalid_certificate : "El certificado escribi\u00f3 no parece ser certificado X.509. " +
                    "Ingrese AD v\u00e1lido / certificado del servidor LDAP."
            }
        },
        "overview" : {
            "title" : "Configuraci\u00F3n"
        },
        "auditlogs" : {
            download : "Download audit logs"
        },
        "edit" : {
            "title" : "Editar la configuraci\u00F3n",
            "saved" : "La configuraci\u00F3n se ha guardado."
        },
        "supportdump" : {
          "title" : "[ES]Create support dump",
          "error_creating_dump" : "[ES]Error creating dump",
          "error_creating_dump_message" : "[ES]Support dump creation failed. Try again.",
          "error_downloading_dump" : "[ES]Error downloading dump",
          "error_downloading_dump_message" : "[ES]Support dump download failed. It is likely that a new support dump request has been initiated.",
          "createtitle" : "[ES]Create support dump",
          "create_button" : "[ES]Yes, create",
          "creating_dump" : "[ES]Create support dump",
          "create_dump" : "[ES]Creating a support dump may take a few minutes after which the file download " +
                          "will begin automatically. Meanwhile, you can continue to use the UI normally. ",
          "dump_created" : "[ES]Successfully created dump",
          encryption_label :"[ES]Enable support dump encryption",
          "create_prompt" : "[ES]Do you want to create a support dump now?"
        },
        "security" : {
          title : "[ES]Security",
          overview : {
            cert_title : "[ES]Certificate",
            common_name : "[ES]Cert common name (CN)",
            valid_until : "[ES]Valid until",
            expires_in : "[ES](expires in {0} days)",
            expires_message : "ES]Appliance certificate expires in {0} days.",
            expires_detail_message : "[ES]Certificate expires on {0}, {1} days from now.",
            expires_resolution : "[ES]Import a new certificate using {0} or {1}.",
             auth_title :"autenticaci\u00f3n",
             local_login : "Inicio de sesi\u00f3n local",
             default_directory :"directorio predeterminado",
             directories : "Directorios",
             add_directory : "A\u00f1adir directorio"
            },
            publickey : {
                title : "[ES]Key",
                download_location_msg : "[ES]The latest HP public key is available from {0}",
                uploaded : "[ES]Uploaded HP Public Key",
                display_content : "[ES]Display Content",
                paste_message : "[ES]Paste Key Here",
                key_message : "[ES]This key is used to validate the authenticity of all patches" +
                              " and updates"
            },
            firmwarebundle : {
                optiontext : "[ES]Update firmware using ",
                http : "[ES]HTTP - Faster",
                https: "[ES]HTTPS - More secure",
                displayText: "[ES]This setting controls the protocol used for the iLO virtual media "+
                "mount used when updating firmware on server hardware. <a href=\"doc#/cic/enclosure/add/learnmore\" target=\"hphelp\">Learn more...</a>"
            },
            edit_security_title: "[ES]Edit Security",
            panel: {
                authentication : "[ES]Authentication",
                hp_public_key : "[ES]HP Public Key",
                firmware_bundle : "[ES]Firmware Bundle"
            },
            more :{
                directories : "Directorios",
                authn :{
                active_directory : "[ES]Active Directory",
                open_ldap : "[ES]OpenLDAP",
                directory_type : "Directorio de tipo",
                naming_attribute: "Nombrar atributo",
                search_context : "B\u00fasqueda contexto",
                directory_servers : "servidores de directorio",
                no_directories : "No hay directorios"
                }
            },
            edit_authn : {
              edit_directory_title : "[ES]Edit Directory",
              edit_directoryserver_title : "[ES]Edit Directory Server",
              delete_title : "[ES]Delete {0}",
              delete_message : "[ES]Are you sure you want to delete {0}?"+
                                "<br/><br/>Continue with delete?",
              delete_yes :"[ES]Yes, delete"
            }
        },
        "certificate" : {
            title : "[ES]Certificate Settings",
            csr_attributes : "[ES]Certificate Signing Request Attributes",
            unstr_name : "[ES]Unstructured name",
            selfsigned : {
              create_action_title : "[ES]Create self-signed certificate",
              create_title : "[ES]Create Self-Signed Certificate",
              required_information : "[ES]Required Information",
              optional_information : "[ES]Optional Information",
              create_success : "[ES]Self-signed certificate created",
              create_error : "[ES]Unable to create self-signed certificate.",
              create_action : "Create",
              get_action : "Retrieve",
              source_object : "Self signed certificate",
              get_error : "[ES]Unable to retrieve current self-signed certificate.",
              update_button : "[ES]Yes, update",
              cancel_button : "[ES]Cancel",
              dialog : {
                title : "[ES]Update Certificate",
                update : "[ES]Applying update...",
                certwarn : "[ES]You may need to accept browser certificates warnings when the browser refreshes.",
                restartwarn : "[ES]Warning:  Updates to the certificate will require the appliance web server to be " +
                            "restarted.  There will be a temporary service interruption estimated to last 30 seconds.",
                reconnectmsg :"[ES]You will automatically be reconnected when the system is available again.",
                continue_update : "[ES]Continue with the update?",
                usersLoggedIn : "[ES]{0} other users are logged in",
                oneUserLoggedIn : "[ES]1 other user is logged in",
                remaining : "[ES]{0} seconds remaining"
              },
              error : {
                  timeout : {
                      msg : "[ES]The appliance is no longer reachable after restarting the web server.",
                      res : "[ES]Verify connectivity between this browser and the appliance's network address." +
                             "  Consult the printed appliance documentation for other recovery actions."
                  },
                  unknown : {
                      msg : "[ES]Unable to create self-signed certificate.",
                      res : "[ES]Restart the appliance. If unable to create a self-signed certificate after restarting " +
                            " the appliance, contact HP support."
                  },
                  support_dump_link : "[ES]create a support dump",
                  support_dump_link_message : "[ES]If the issue persists, {0} and contact your authorized support " +
                               "representative for assistance."
              }
            },
            country : "[ES]Country (C)",
            state : "[ES]State or province (ST)",
            locality : "[ES]City or locality (L)",
            org : "[ES]Organization name (O)",
            cn : "[ES]Common name (CN)",
            ou : "[ES]Organizational unit",
            alt_name : "[ES]Alternative name",
            contact : "[ES]Contact person",
            email : "[ES]Email address",
            surname : "[ES]Surname",
            given_name : "[ES]Given name",
            initials : "[ES]Initials",
            dn : "[ES]DN qualifier",
            explain_comma_list : "[ES]Enter a comma separated list of alternate names (e.g. hostname, IP address).  " +
                                 "The CN is a required alternative name and will be added automatically if not supplied here.",

            hostname_regen_cert_warn    : "Changing the hostname requires generating a new SSL certificate " +
                                 "for secure communications with your browser. ",

            hostname_regen_cert_warn_csr    : "Changing the hostname requires generating a new SSL certificate " +
                                 "for secure communications with your browser. " +
                                 "This also requires generating another CSR and getting a new signed SSL certificate and importing it to the appliance.",

            ipaddress_regen_cert_warn    : "Changing the IP address requires generating a new SSL certificate " +
                                 "for secure communications with your browser. ",

            ipaddress_regen_cert_warn_csr    : "Changing the IP address requires generating a new SSL certificate " +
                                 "for secure communications with your browser. " +
                                 "This also requires generating another CSR and getting a new signed SSL certificate and importing it to the appliance.",

            hostname_cn_mistmatch    : "Host name and common name of the certificate are different. This requires generating a new SSL certificate " +
                                 "for secure communications with your browser. ",

            hostname_cn_mistmatch_csr    : "Host name and common name of the certificate are different. This requires generating a new SSL certificate " +
                                 "for secure communications with your browser. " +
                                 "This also requires generating another CSR and getting a new signed SSL certificate and importing it to the appliance.",

            validator : {
              host_or_ip_required : "[ES]Specify valid hostnames or IP addresses.",
              max_length : "[ES]Enter no more than {0} characters",
              max_length_no_cn : "[ES]The CN is automatically added to this field, but doing so will exceed the " +
                                 "max size limit of {0}. Allow enough space to account for the CN.",
              matchpasswd : "[ES]Passwords must match.",
              passwdvalidation : "[ES]Password should not contain any of < > ; , \" ' & \\ / | + : = and space."
            },
            more_title : "[ES]Certificate",
            required_information : "[ES]Required Information",
            optional_information : "[ES]Optional Information",
            common_name : "[ES]Cert common name (CN)",
            issued_by : "[ES]Issued by",
            valid_from : "[ES]Valid from",
            valid_until : "[ES]Valid until",
            serial_number : "[ES]Serial number",
            version : "[ES]Version",
            md5_fingerprint : "[ES]MD5 fingerprint",
            sha1_fingerprint : "[ES]SHA1 fingerprint",
            cert_sign_req_attr : "[ES]Certificate Signing Request Attributes",
            unstructured_name : "[ES]Unstructured name",
            csr : {
              create_action_title : "[ES]Create certificate signing request",
              create_title : "[ES]Create Certificate Signing Request",
              create_action : "Create",
              source_object : "Certificate Signing Request",
              required_information : "[ES]Required Information",
              optional_information : "[ES]Optional Information",
              create_success : "[ES]Certificate signing request created",
              create_error : "[ES]Unable to create certificate signing request.",
              get_error : "[ES]Unable to retrieve current certificate.",
              ok_button : "[ES]OK",
                cancel_button : "[ES]Cancel",
                challenge_password : "[ES]Challenge password",
                confirm_password : "[ES]Confirm password",
                dialog : {
                  base64_save : "[ES]The following base64 encoded data may be used to request a certificate from a " +
                              "certificate server. Copy the data below and use it to make a certificate request. " +
                              "Once you receive your certificate, import it using the \"Actions->Import certificate\" " +
                              "menu item in the Settings page."
                },
                error : {
                  support_dump_link : "[ES]create a support dump",
                  support_dump_link_message : "[ES]If the issue persists, {0} and contact your authorized support " +
                          "representative for assistance."
                }
            },
            signedimport : {
                import_success : "[ES]Appliance certificate Imported.",
                import_action_title : "[ES]Import certificate",
                import_title : "[ES]Import Certificate",
                import_action: "Import",
                import_paste : "[ES]Paste a certificate to import it into the appliance",
                certificate : "[ES]Certificate",
                dialog : {
                    importing : "[ES]Importing certificate...",
                    certwarn : "[ES]You may need to accept browser certificates warnings when the browser refreshes.",
                    restartwarn : "[ES]Warning:  Importing a new certificate will require the appliance web server to be " +
                                "restarted. There will be a temporary service interruption estimated to last 30 seconds.",
                    reconnectmsg :"[ES]You will automatically be reconnected when the system is available again.",
                    usersLoggedIn : "[ES]{0} other users are logged in",
                    oneUserLoggedIn : "[ES]1 other user is logged in",
                    remaining : "[ES]{0} seconds remaining"
                },
                error : {
                  unknown : {
                    msg : "[ES]Unable to import signed certificate.",
                    res : "[ES]Restart the appliance. If unable to import a signed certificate after restarting " +
                          " the appliance, contact HP support."
                  }
                }
              },
              truststore : {
            	  self_signed_warn : "The security certificate is not trusted because it is self signed.",
                  issue_untrusted_warn : "The security certificate is issued by an entity that is not trusted.",
                  invalid_warn : "The security certificate presented is not in validity period.",
                  hostname_not_found_warn : "The security certificate from this website was issued for a different website's address.",
                  connection_untrusted_warn : "This connection is untrusted.",
                  issued_to : "Issued to",
                  issued_by : "Issued by",
                  valid_from : "Valid from",
                  to : "to",
                  retrieve_cert_error : "Unable to retrieve certificate.",
                  retrieve_cert_resolution : "Resolution : Try registering again.",
                  header : "Trust Certificate",
                  variableheader : "Trust Certificate {0}",
                  certificate_information : "Certificate",
                  details : "Details",
                  trust_confirm : "Continue to trust certificate?",
                  trust_confirm_multiple : "Continue to trust certificates?",
                  ca_info : "Certificate authority",
                  not_auth : "You are not authorized to perform this action",
                  not_auth_resol : "Check your credentials and try registering again.",
                  version : "Version",
                  serial_number : "Serial number",
                  common_name : "Subject ( CN, O, L, S, C)",
                  issuer : "Issuer",
                  alternative_name : "Subject alternative names",
                  sha1_fingerprint : "SHA1 fingerprint",
                  md5_fingerprint : "MD5 fingerprint",
                  signature_algorithm : "Signature algorithm",
                  public_key : "Public key",
                  revoked_msg : "The security certificate has been revoked",
                  revoked_resol : "Verify that the host address is correct and try registering again",
                  close : "Close",
                  ok_trust : "Yes, trust certificate",
                  cancel_trust : "No, do not trust",
                  upload_ca_cert : "Upload the CA certificate of the host and proceed with registration.",
                  invalid_chain : "The security certificate is not trusted because the certificate chain is invalid.",
                  invalid_chain_resol : "Correct the certificate chain in the host and try registering again",
                  ca_certificate : "CA Certificate",
                  ca_cert_header : "Add CA Certificate",
                  ca_cert_upload_error : "Unable to add certificate",
                  verifying : "Verifying...",
                  ca_cert_upload_error_detail : "Certificate is not valid. Provide a valid certificate.",
                  upload_ca_reason : "The security certificate of {0} is not trusted because the issuer is unknown.",
                  required : "Required"
              }
        },
        restore: {
            kiloBytes: "KB",     // TODO: Translate
            megaBytes: "MB",     // TODO: Translate
            gigaBytes: "GB",     // TODO: Translate
            title: "Restore from Backup",     // TODO: Translate
            uploadingTitle : "Uploading",     // TODO: Translate
            restorePendingTitle : "Restore",     // TODO: Translate
            restoreAction : "Restore from backup",     // TODO: Translate
            backupFileTitle : "Backup file",     // TODO: Translate
            useUploadedFile : "Select a backup file",     // TODO: Translate
            useStagedFile : "Restore from a backup file",     // TODO: Translate
            uploadAndRestore : "Upload and restore",     // TODO: Translate
            uploadOnly : "Upload only",     // TODO: Translate
            aFileIsRequired : "A file is required.",     // TODO: Translate
            uploadFileFormatWarning : "Invalid file format.",     // TODO: Translate
            uploadInProgress : "Upload in progress.",     // TODO: Translate
            uploadHMSRemaining: "{0}h {1}m {2}s remaining",     // TODO: Translate
            uploadMSRemaining: "{0}m {1}s remaining",     // TODO: Translate
            uploadStop : "Stop upload",     // TODO: Translate
            uploadStopWarning : "Stop upload will discard any data transfered so far. Once the upload is complete, you will be able to restore from the uploaded file.",     // TODO: Translate
            backupIsReady : "This backup is ready.",     // TODO: Translate
            noBackupStaged : "No file has been uploaded yet.",     // TODO: Translate
            restoreFromBackup : "Restore",     // TODO: Translate
            restoreFromBackupConfirmationWarning : "Before you begin the restore process, make sure you understand all the implications.",     // TODO: Translate
            restoreFromBackupConfirmationCheckbox : "I have read and understood all the implications.",     // TODO: Translate
            restoreFromBackupConfirmationRequired : "Required",     // TODO: Translate
            restoreFromBackupConfirmationPrompt : "Continue to restore from backup?",     // TODO: Translate
            yesRestoreFromBackup : "Yes, restore",     // TODO: Translate
            fileNameLabel : "File",     // TODO: Translate
            createdDateLabel: "Created",     // TODO: Translate
            versionLabel : "Version",     // TODO: Translate
            sizeLabel : "Size",     // TODO: Translate
            sizeData : "{0} {1}",     // TODO: Translate
            uploading : "Uploading file",     // TODO: Translate
            stopUpload : "Stop upload",     // TODO: Translate
            uploadStopped : "Upload stopped",     // TODO: Translate
            closeUpload : "Close",     // TODO: Translate
            uploaded : "File uploaded",     // TODO: Translate
            validating : "Validating file - this may take a while",     // TODO: Translate
            validated : "File validated",     // TODO: Translate
            stopRestore: "Cancel restore",     // TODO: Translate
            restoreCanceled : "Restore canceled",     // TODO: Translate
            uploadProgressUnknowable : "Uploading and validating file - this may take a while",     // TODO: Translate
            backupTooBigErrMsg : "Backup is too large to upload.",     // TODO: Translate
            backupTooBigResolutionMsg : "Select a backup smaller than {0} GB.",     // TODO: Translate
            restoreWarningSummary: "Restoring from backup is a disruptive behavior.",     // TODO: Translate
            restoreWarningDetails: "Any users using the appliance will be logged out and their work will be lost.",     // TODO: Translate
            restoreStarted : "Restoring from backup ...",     // TODO: Translate
            uploadOverwritten : "Another backup operation removed the uploaded backup.",     // TODO: Translate
            retryUpload : "Retry the backup upload.",     // TODO: Translate
            uploadFailed : "The backup upload failed to complete.",     // TODO: Translate
            retryOrSelectAlternate : "Retry or select an alternate backup.",     // TODO: Translate
            backupIsCompatible : "This file is compatible.",     // TODO: Translate
            uploadActivity : "Upload ",     // TODO: Translate
            uploadError : "Upload error",     // TODO: Translate
            validationFailure : 'Validation failure',     // TODO: Translate
            restoreModeStartError : 'Restore could not be started',     // TODO: Translate
            restoreActivity : 'Restore '     // TODO: Translate
        },
        backup: {
            backupAction : "[ES]Create backup",
            backupDownloadAction: "[ES]Download backup",
            backupDownloadLinkLabel: "[ES] Download most recent backup",
            unableToStartBackup: "[ES]Unable to start backup.",
            backupDidNotComplete: "[ES]The backup did not complete.",
            errorGettingBackupProgress: "[ES]Unable to get backup progress information.",
            unableToDownloadBackup: "[ES]Unable to download backup.",
            uploadedBackup: "[ES]Cannot download an uploaded backup.",
            noBackup: "[ES]No backup exists.",
            backupInProgress : "[ES]A backup is already in progress.",
            waitForBackupToComplete: "[ES]Wait until the backup completes, and then retry the operation.",
            createBackupAndRetry: "[ES]Create a backup, and then retry the operation.",
            errorCancellingBackup: "[ES]Unable to stop backup.",
            backupCreateDetails: "[ES]Backup started by {0}.",
            backupDownloadSummary: "[ES]Download backup",
            backupDownloadDetails: "[ES]Backup {0} download requested by {1}.",
            completedDetails: "[ES]Backup completed and ready to download.\n\nBackup {0} was created by {1}.",
            canceledDetails: "[ES]Stopped backup.",
            backupSourceName: "[ES]Appliance",
            backupStopDialogTitle: "[ES]Stop backup",
            backupStopLinkLabel: "[ES]Stop backup",
            backupStopButtonLabel: "[ES]Yes, stop backup",
            backupStopConfirmMessage: "[ES]Continue to stop backup?"
        },
        "factoryReset": {
            "title": "[ES]Factory Reset",
            "factoryResetAction" : "[ES]Factory Reset",
            "warning": "[ES]Reset to factory defaults is a disruptive action that will erase all data, logs and settings on the appliance.",
            "fullResetWarning": "[ES]If the network settings change as a result of the factory reset, the browser could lose connectivity to the appliance. If this occurs, open a new browser to connect to the appliance's new address, or alternatively use the kiosk interface on the appliance console. ",
            "preserveNetworkCheckbox": "[ES]Preserve appliance network settings",
            "startFailure": "[ES]Factory Reset failed to start.",
            "confirmationWarning":"[ES]Before you reset to factory deaults, make sure you have read and understood the warning message.",
            "confirmationCheckbox": "[ES]I have read and understood all the implications.",
            "confirmationCheckboxRequired": "[ES]Required",
            "confirmationPrompt": "[ES]Continue factory reset?",
            "confirmOk": "[ES]Yes, factory reset",
            "ok": "[ES]OK"

        },
        shutdown: {
            title:"[ES]Shutdown Appliance",
            shutdownAction: "[ES]Shut down",
            warning:"[ES]Shutdown will cause all users to be disconnected and all ongoing tasks to be interrupted.",
            start_prompt : "[ES]Continue shutdown ?",
            ok: "[ES]Yes, shut down" ,
            errorMsg : "[ES]Unable to perform shutdown"
        },
        restart: {
            title:"[ES]Restart Appliance",
            shutdownAction: "[ES]Restart",
            warning:"[ES]Restart will cause all users to be disconnected and all ongoing tasks to be interrupted.",
            start_prompt : "[ES]Continue restart ?",
            ok: "[ES]Yes, restart" ,
            errorMsg : "[ES]Unable to perform restart"
        },
        supportaccess : {
            service_unavailable : "Unable to get support access.",
            error : "[ES]Unable to edit support access.",
            update : "Update",
            source_object : "Services Access",
            success : "Successfully updated Services Access.",
            failure : "Failed to update Services Access."
        },
        eula : {
            config : {
                appliance_name : "[ES]Virtual Appliance",
                end_user_title : "[ES]License",
                eula_title : "[ES]End-User license agreement",
                agree_button : "[ES]Agree",
                disagree_button : "[ES]Disagree",
                yesdisagree_button : "[ES]Yes, disagree",
                confirmation_dialog_advice : "[ES]If you disagree with the terms of the End-User License agreement, you cannot proceed.",
                end_user_support_title : "[ES]Support",
                application_support : "[ES]Application Support",
                warning : "[ES]warning",
                written_offer : "[ES]Written offer",
                enabled : "[ES]Enabled",
                disabled : "[ES]Disabled",
                support : "[ES]Support",
                license : "[ES]Licenses",
                support_access_enabled : "[ES]Authorized services access",
                edit_appliance_support_access : "[ES]Edit services access",
                agree_disagree_message : "[ES]If you agree with the licensing terms, click Agree. Otherwise, click Disagree.",
                content_directory: "/ui-js/pages/fs/license",
                upgrade_content_directory: "/ui-js/pages/upgrade",
                eula_content_file : "eula_content_es.html",
                support_access_file : "support_access_and_written_offer_es.html"
            }
        },
        license : {
            config : {
                add_license : "Add license",
                add_license_title : "Add License",
                license_key: "License Key",
                licensing_portal : "HP licensing portal",
                verifying_license : "Verifying license key...",
                successMsg : "Add license",
                error : {
                      msg : "Unable to add license: "
                  }
            },
            summary : {
                add : "Add",
                no_licenses : "No licenses",
                license : "Licenses",
                licensed : "[ES]Licensed Servers",
                licensed_instance_required : "Instances without {0} license",
                compliance : "Usage",
                license_required : "{0} {1} required",
                licensed_total_nodes : "{0} {1} licensed",
                available_license : "{0} {1} available",
                peak_usage : "{0} peak usage",
                total_license : "{0} total licenses",
                type : {
                    node : "node",
                    node_plural : "nodes",
                    instance : "instance",
                    instance_plural : "instances",
                    vm : "vm",
                    vm_plural : "vms",
                    server : "server",
                    server_plural : "servers",
                    license : "license",
                    license_plural : "licenses"
                }
            },
            notification :{
                title : "More licenses required",
                details : "Add more {0} licenses to be in compliance.",
                license_ok : "All servers are licensed"
            }
        }

    };
});
