//(C) Copyright 2012-2014 Hewlett-Packard Development Company, L.P.
define([], function() {"use strict";
    return {
        menu : "設定",
        development : {
            title : "開発設定",
            "short-title" : "開発",
            refresh_interval : "再描画間隔",
            ms : "ミリ秒",
            max_master_items : "マスターペイン項目の最大数",
            experimental_features : "実験的な機能",
            "routing-log-level" : "ログレベルのルーティング",
            edit : {
                title : "開発設定を編集",
                success : "開発設定がアップデートされました"
            }
        },
        appliance : {
            title : "アプライアンス",
            overview : {
                hostname: "ホスト名",
                ipaddr: "アプライアンスIPアドレス",
                ipaddr2: "展開IPアドレス",
                networkInterfaces:"ネットワークインターフェイス",
                version: "バージョン",
                model: "モデル",
                datetime: "日付/時刻",
                snmp: "SNMPトラップ宛先"
            },
            general: {
                title: "全般",
                hostname: "アプライアンスホスト名",
                model: "モデル番号",
                serial: "シリアル番号",
                version: "ファームウェアバージョン",
                date: "ファームウェア日付"
            },
            IPv4: {
                title: "IPv4",
                address: {
                    "1node": "IPアドレス",
                    "2node": "浮動型IPアドレス"
                },
                address2: {
                    "1node": "2番目のIPアドレス"
                },
                addrtype: {
                    "1node": "アドレス割当て",
                    "2node": "静的アドレス割当て"
                },
                node1: "ノード1静的IPアドレス",
                node2: "ノード2静的IPアドレス",
                subnet: "サブネットマスクまたはCIDR",
                gateway: "ゲートウェイアドレス"
            },

            DNS: {
                title: "DNS",
                preferred: "優先DNSサーバー",
                alternate: "代替DNSサーバー"
            },
            timeandlanguage: {
                title: "時刻および言語",
                currentdatetime: "現在の日付/時刻",
                timezone: "タイムゾーン",
                ntpserver: "ネットワークタイムサーバー",
                locale: "ロケール",
                ntpnotconfigured:"構成されていません"
            },
            backup: {
                title: "バックアップ",
                created: "作成",
                started: "開始",
                failed: "失敗",
                downloaded: "ダウンロード",
                filename: "ファイル名",
                none: "なし",
                never: "never",
                progress: "進行中",
                cancelprogress: "バックアップを停止しています",
                error : "エラー",
                resolution : "解決策",
                by: "{0} / {1}"
            },
            snmp: {
                title: "SNMP",
                trapdestination: "トラップ宛先",
                trapport: "トラップポート",
                communitystring: "コミュニティ文字列",
                addtrapdestination: "トラップ宛先を追加",
                port: "ポート",
                addMsg : "宛先の追加{0}",
                deleteMsg : "宛先の削除{0}",
                error : "宛先を追加できませんでした{0}。",
                validateHostAddress: "有効なホスト名またはIPアドレスを入力してください",
                validatePortNumber: "1から65535までのポート番号を入力してください",
                notificationMessage: "トラップ宛先を追加できません、示された問題を修正してください。",
                none: "なし",
                retrieveDestinationsfailure: "トラップ宛先を収集できませんでした。",
                updateMsg : "アップデート完了",
                publicStr: "public",
                validateCommunityString: "コミュニティ文字列を入力してください。",
                addCSMsgSuccess: "コミュニティ文字列{0}が追加されました。",
                globalcommunitystring: "読み取りコミュニティ文字列",
                communitystringnote:"SNMP読み取りコミュニティ文字列は、すべての管理サーバーハードウェア、電力デバイスおよびエンクロージャーに適用されます。",
                learnmore:"さらに詳しく...",
                unableToAddTrapDestination:"トラップ送信先を追加できません",
                trapforwarding:"トラップ転送",
                notrapdestinations:"トラップ送信先がありません",
                specifyanotherdestination:"他のトラップ送信先を指定してください。",
                unabletoconfiguredestination:"トラップ送信先を構成できません [",
                isdestinationconfigured:"] すでに構成済みです。"
            },
            IPv6: {
                title: "IPv6",
                address: {
                    "1node": "IPアドレス",
                    "2node": "浮動型IPアドレス"
                },
                 address2: {
                    "1node": "2番目のIPアドレス"
                },
                addrtype: {
                    "1node": "アドレス割当て",
                    "2node": "静的アドレス割当て"
                },
                node1: "ノード1静的IPアドレス",
                node2: "ノード2静的IPアドレス",
                subnet: "サブネットマスクまたはCIDR",
                gateway: "ゲートウェイアドレス"
            },
            platform : {
                vm : "仮想マシン"
            },
            addrType: {
                STATIC: "手動",
                DHCP: "DHCP",
                UNCONFIGURE: "オフ"
            },
            fromDHCP: "DHCPから",
            updateLink : "アプライアンスのアップデート",
            host : {
                name : "ホスト名",
                ip : "IPアドレス"
            },
            version : "バージョン",     //TODO need localize         
            hardware : "ハードウェア",
            applianceVersion : "アプライアンスバージョン",
            update : {
                title : "アプライアンスのアップデート",
                upload : "アップロード",
                remove : "削除",
                file : "ファイル",
                cancelUpdate : "アップデートのキャンセル",
                usersWarning : "<span id='cic-settings-update-usersWarning'>{0} 他のユーザー</span>が、このアプライアンスにログインします。アプライアンスのアップデートは、他のユーザーの進行中の作業を失うことになります。",
                cancelUpload : "アップロードのキャンセル",
                performUpdate : "アップデートの実行",
                releaseNotes : "リリースノート",
                currentStatus: "現在のステータス:",
                updateStatus: "{0}% 完了",
                progress : "アップデート中",
                failureMessage : "アプライアンスのアップデートは失敗しました。アプライアンスは再起動され、アップデート前の状態に戻されます。ブラウザーを閉じて再起動が完了した後、ふたたびログインしてください。",
                progressInfo : "ブラウザーはアップデートが完了した時に再接続されます。このブラウザーを閉じ、必要ならば、後でログインしてください。",
                progressTime : "{0}分残り",
                progressTimeOneMinute : "{0}分残り",
                installUpdate : "インストールアップデート",
                uploadInstall : "アップロードおよびインストール",
                uploadOnly : "アップロードのみ",
                uploadTime : "{0} 残り",
                checktext : "最新のアップデートを入手するにはhp.comに",
                check : "アクセス",
                uploading : "アップデート中",
                applyWarning : "このアップデートは一時的なサービスの中断を起こします、予想される残り時間は{0}分です。",
                applyWarningOtherUsers : "アップデートが開始されると、これらは、ロックアウトされ、作業内容は失われます。",
                applyContinue : "アップデートを続行しますか?",
                applyUpdate: "アップデートします",
                updateAppliance : "アプライアンスのアップデート",
                applyBoxUsersLoggedIn : "{0} 他のユーザーがログイン中。  " ,
                applyBoxOneUserLoggedIn : "{0} がこのアプライアンスにログインします。",
                applianceReboot : "アプライアンスが再起動しようとしています。",
                applianceUpdateFailed : "アプライアンスをアップデートできません",
                uploadFileStop : "ファイル {0} のアップロードを停止しますか?",
                uploadFileStopWarning : "注意: これまでに転送されたデータは破棄されます。",
                uploadStop : "アップロードを停止",
                uploadDelete : "{0}を削除",
                uploadFileDeleteWarning : "{0}を削除してよろしいですか?",
                uploadFileFormatWarning : "無効なファイル形式です。",
                uploadFileDiskSpaceWarning : "十分な容量がありません。続行するための十分な容量があることを確認してください。",
                healthWarning : {
                    MEMORY_ERROR : "アップロードするための十分なメモリがありません。{0}メモリのみが利用可能です。",
                    MEMORY_WARNING : "メモリが足りません。{0}メモリのみが利用可能です。",
                    CPU_ERROR : "アップロードを開始するには、CPUが低速です。{0}CPUコアが利用可能です。",
                    CPU_WARNING : "CPUが低速です。{0}CPUコアが利用可能です。",
                    DISK_ERROR : "アップロードを続行するための十分な容量がありません。{0} 空き容量のみが利用可能です。",
                    DISK_WARNING : "十分な容量がありません。{0} 空き容量のみが利用可能です。"
                },
                uploadStopButton : "アップロードを停止します",
                uploadDeleteButton : "削除します",
                uploadWarningConditions  : "エラー/警告の状態",
                eulaNotification : "エンドユーザーライセンス許諾書はアップロードが完了した後に表示されます",
                uploadingNotification : "アップロード中",
                uploadedNotification : "アップデート",
                acceptEULA : "EULAを参照",
                installEULANotification : "アップデートをインストールするには、EULAを承諾しなければなりません。",
                usersLoggedInAnd : "および",
                uploadValidating : "検証中",
                updateMessage : "このファイルはインストールされる準備ができています。インストールには時間がかかるかもしれません。インストールした後、アプライアンスは必要に応じて自動的に再起動します。",
                continueUpdate : "続行",
                startUpdate : "アップデート"
             }
        },
        network : {
            panel: {
                hostname: "全般",
                nics: "ネットワーク",
                ipv4: "IPv4",
                dns: "DNS",
                ipv6: "IPv6",
                timeandlanguage: "時刻および言語",
                errors: "エラー"
            },
            "short-title" : "ネットワーク",
            dhcpWarning : "DHCPは、DHCP予約を使用していない限り、アプライアンスのIPアドレスを割り当てるためにサポートされていません。" ,
            dualStackWarning : "IPv6を設定する時には、DNSサーバーがIPv4とIPv6両方の名前解決をサポートするDHCPサーバーによってされているか、手動で指定済みであるかを確認してください。",
            datetimeWarning : "アプライアンスセッションの現在の日付と時刻を変更すると、ログインしているすべてのユーザーと、アプライアンス内で動作している、現在のジョブに失効/影響を与えることがあります、したがって変更を適用した後は、アプライアンスの再起動が必須です。" ,              
            datetimeRebootWarning : "アプライアンスは手動の日付と時刻の設定によって再起動します。",
            timezoneWarning : "タイムゾーンの変更は、アプライアンスの再起動後に反映されます。" ,
            localeWarning : "ロケールの変更は、アプライアンスの再起動後にのみ反映されます。" ,
            dhcpDisallowed : "DHCPの構成は許可されていません",
            gatewayWarning : "アプライアンスに別のサブネットからアクセスする必要がある場合、ゲートウェイアドレスを指定してください。" ,
            collapsibleWarning : "このネットワークインタフェースに任意のデータを入力した場合、OKを押すまでこの行を拡大してください。行がOKを押す前に折りたたまれている場合は、入力したデータは保存されません。" ,
            deploymentIPWarning : "Insight Controlサーバープロビジョニングは、共有から独立モードに変更した時でも、展開用のIPアドレスを変更することは推奨しません。展開用のIPアドレスは同じにしておいて、管理IPは必要に応じて変更してください。",
            dialog : {
                action : "ネットワークの設定を適用中です。",
                certwarn : "ブラウザーから証明書の指示がでたら、証明書を受け入れてください。",
                redirect : "ブラウザーは、まもなく新しい設定にリダイレクトされます。",
                browserwarn :"いくつかのブラウザーのセキュリティ設定では、エラーの処理の妨げになることがあります。アプライアンスがアクセス不能になった場合は、リカバリアクションのために印刷されたアプライアンスのマニュアルを参照してください。",
                altairftswarn : "設定が一旦適用されると、アプライアンスの再起動によって短い遅延が発生します。全体のプロセスは15分程度になります。再起動が完了するまではメインメニューが表示されても、アプライアンスを使用しないでください。",
                altaireditappliancewarn : "共有から独立モードにスイッチした場合、アプライアンスはネットワークの設定を再構成を許可するために、自動的にシャットダウンします。アプライアンスがダウンしている間、ネットワークの設定を新しい設定に一致させるために再構成し、再構成を完了するためにアプライアンスを再度立ち上げてください。"
            },
            error : {
                get : {
                    msg:  "ネットワーク設定の収集ができません。",
                    res : "リカバリのアクションのために、印刷されたアプライアンスのドキュメントを参考にしてください。"
                },
                set : {
                    timeout : {
                        msg : "アプライアンスに自動で再接続できません。",
                        res : "アプライアンスのコンソールを使用して、考えられる原因のためにアクティビティ画面を確認し、アプライアンスの現在のIPアドレスを特定するために設定画面を使用してください。",
                        resDhcp : "ネットワーク構成は、静的からDHCPに変更されました。このアプライアンスは、ホスト名から到達できません。ホスト名またはIPアドレスが到達可能であることを検証し、新しくブラウザーを開いて新しいホスト名またはIPアドレスに接続してください。"
                    },
                    ftsinprogress : {
                        msg : "別のアプライアンスのネットワーク構成が進行中です。"
                    },
                    unknown : {
                        msg : "エラーが発生しました。すべてのネットワーク設定を正しく適用できません。",
                        res : "アプライアンスを再起動してください。アプライアンスを再起動した後も、ネットワークの設定が適用されていない場合には、HPサポートに連絡してください。"
                    }
                }
            },
            fields : {
              alias: "管理インターフェイスと共有",
              independent: "独立",
                addrselector: {
                    full: "アドレス割当て",
                    short: "アドレス"
                },
                ipv6switch : "IPv6",
                ipv6state : {
                    on : "オン",
                    off : "オフ"
                },
                certificatechain: "証明書チェーン（オプション）",
                rabbitmqlistner: "RabbitMQは、このNICでリスンします。",
                postgresqllistner: "PostgreSQLは、このNICでリスンします。",
                certificates: "証明書",
                importrabbitmq: "RabbitMQ", 
                importpostgresql: "PostgreSQL",
                catrootcertificate: "CAルート証明書",
                messaging: "メッセージング",
                database: "データベース",
                servercertificate: "サーバー証明書",
                privatekey: "秘密キー",
                cacertificate: "CA証明書",
                webserver: " Webサーバー",
                webservercertificates: " Webサーバー証明書",
                services: " サービス",
                listnermessage  : "このNICでリスンするためにサービスを有効にします。",
                restartwarn : "証明書のインポート中に、一時的なサービスの中断が発生します。",
                privatekeywarn: "Provide a valid RSA key.",
                certificate: "証明書",
                compliantcert: "X.509準拠の証明書を提供してください。",
                dns1 : {
                    full : "優先DNSサーバー",
                    short : "優先"
                },
                dns2 : {
                    full : "代替DNSサーバー",
                    short : "代替"
                },
                manualdatetime : {
                    full : "手動",
                    synchronizeWithHost : "VMホストと同期"
                },
                syncwithserver : {
                    full : "タイムサーバーに同期"
                },
                ntpserver : {
                    full : "ネットワークタイムサーバー",
                    recommended : "推奨"
                },
                currentdatetime : {
                    full : "現在の日付および時刻"
                },
                currentdatetimelabel : {
                    full : "現在の日付および時刻"
                },
                timezone : {
                    full : "タイムゾーン"
                },
                locale : {
                    full : "デフォルトの言語 / ロケール"
                },
                gateway : {
                    both : "ゲートウェイ",
                    full : "ゲートウェイアドレス",
                    short : "ゲートウェイ"
                },
                hostname : {
                    full : "アプライアンスホスト名",
                    short : "名前"
                },
                ipaddr : {
                    short : "IPアドレス",
                    applianceip : "アプライアンスIP",
                    fromDHCP : "DHCPから",
                    node1 : {
                        full : "ノード1静的IPアドレス",
                        short : "ノード1"
                    },
                    node2 : {
                        full : "ノード2静的IPアドレス",
                        short : "ノード2"
                    },
                    "one-node" : {
                        both : "IPアドレス",
                        full : "IPアドレス",
                        short : "IPアドレス"
                    },
                    "two-node" : {
                        both : "浮動型IPアドレス",
                        full : "アプライアンスの浮動型IPアドレス",
                        short : "浮動型IPアドレス"
                    }
                },
                ipaddr2 : {
                    short : "2番目のIPアドレス",
                    deploymentip : "展開IP",
                    node1 : {
                        full : "ノード1の2番目の静的IPアドレス"
                    },
                    node2 : {
                        full : "ノード2の2番目の静的IPアドレス"
                    }
                },
                iptype : {
                    ipv4 : "IPv4構成",
                    ipv6 : "IPv6構成",
                    "one-node" : " ",
                    short : "構成",
                    "two-node" : {
                        fixed : "静的IPアドレス割当て",
                        floating : "浮動型IPアドレス割当て"
                    }
                },
                proxy : {
                    short : "Webプロキシ"
                },
                slaac : "SLAAC IPアドレス",
                usage : "使用方法",
                appliance : "アプライアンス",
                deployment : "展開",
                management : "マネジメント",
                subnet : {
                    both : "サブネット",
                    full : "サブネットマスクまたはCIDR",
                    short : "サブネット"
                }
            },
            headings : {
                appliance : "アプライアンス",
                dns : "DNS",
                ha : "高可用性",
                ipv6 : "IPv6"
            },
            iptype : {
                dhcp : "DHCP",
                manual : "手動",
                off : "オフ",
                unassign : "未割当て",
                dhcpv6 : "DHCPv6"
            },
            notify : {
                sourceName : "アプライアンスネットワーク",
                set : {
                    parameterError : "無効なパラメーターです。続行する前に、エラーを修正してください。",
                    verify : "ネットワーク設定を検証中です...",
                    start : "ネットワーク設定を適用中です。アプライアンスの日付と時刻を手動で変更している場合、アプライアンスを再起動してください。",
                    success : "構成が保存されました。",
                    error : "設定を適用できません。",
                    warning :"検証中に警告が発生しました。",
                    warning_resolution:"そのまま続行するには、OKをクリックしてください。" ,
                    multi_nic_fts_error:"プライマリNICおよび展開NICはファーストタイムアプライアンスセットアップ中にセットアップしなければなりません。"
                }
            },
            "slaac-ip-address" : "SLAAC IPアドレス",
            title : "アプライアンスネットワーク",
            "dns-info" : "DNS",
            validator : {
                dns : {
                    ipv4_only : "DNSサーバーの有効なIPv4アドレスを入力してください。",
                    ipv4_ipv6 : "DNSサーバーの有効なIPv4またはIPv6アドレスを入力してください。"
                },
                "gateway-ipv4" : "有効なIPv4ゲートウェイアドレスを入力してください。",
                "gateway-ipv6" : "有効なIPv6ゲートウェイアドレスを入力してください。",
                hostname : {
                    fqdn_optional : "有効なホスト名または、完全修飾ドメイン名を入力してください。",
                    fqdn_required : "有効な完全修飾ドメイン名を入力してください。"
                },
                ntpserver : {
                    ipv4 : "NTPサーバーのために有効なIPv4アドレスを入力してください。",
                    ipv4_v6 : "NTPサーバーのために有効なIPv4/v6アドレスを入力してください。",
                    ipv4_dns : "NTPサーバーのために、有効なIPv4またはホスト名を入力してください。",
                    ntp_fqdn_required : "NTPサーバーの有効な完全修飾ドメイン名を入力してください。",
                    set_date_time_manually : "日付/時刻を手動で設定してください"
                },
                currentdatetime : {
                    datetime_required : "date pickerを使用して、有効な日付と時刻を選択してください。",
                    datetime_format_resolution : "日付/時刻の形式がyyyy-mm-dd hh:mm:ssになっていることを確認してください。"
               },
                timezone : {
                     timezone_required : "有効なタイムゾーンを選択してください。"
                },
                locale : {
                    locale_required : "有効なロケールを選択してください。"

               },
               usage : "有効なネットワークインターフェイス名を入力してください。",
                ipv4 : "有効なIPv4アドレスを入力してください。",
                ipv6 : "有効なIPv6アドレスを入力してください。",
                "mask-ipv4" : "有効なIPv4ネットワークマスクまたは、0から32までのCIDRビットカウントを入力してください。",
                "mask-ipv6" : "有効なIPv6ネットワークマスクまたは、0から128までのCIDRビットカウントを入力してください。"
            },
            edit : {
              title : "アプライアンスの編集"
            }
        },
        authn : {
            title : "認証",
            "short-title" : "認証",
            allow_local : "ローカルログインを許可",
            default_provider : "デフォルトディレクトリ",
            providers : "プロバイダー",
            get_failed : "1つ以上の認証設定を取得できませんでした。",
            providers_not_set : "未セット",
            enabled : "有効",
            disabled : "無効",
            local : "ローカル",
            default_directory : " (デフォルト)",
            failed_get_global_settings : "グローバル設定の取得に失敗しました。",
            failed_set_default_provider : "デフォルトのプロバイダの設定に失敗しました。",
            refresh_and_verify_provider : "ページをリフレッシュして、探しているプロバイダーが存在することを確認してください。",
            auth_settings_error : "認証設定エラー:",
            failed_get_provider_info : "プロバイダー情報の取得に失敗しました",
            plus_more : "プラス {0} more",
            enable_local_login : "有効",
            explain_login_provider : "ローカルログインを無効にするには、別の認証サービスを使用してログインする必要があります。",
            edit : {
              title : "認証の編集",
              success : "アップデートされた認証設定",
              add_authn_service : "ディレクトリの追加",
              service_name : "ディレクトリ名",
              remove : "削除",
              verify : "認証の検証",
              protocol : "プロトコル",
              baseDN : "ベースDN",
              directory_servers : "ディレクトリサーバー",
              add_server : "サーバーの追加",
              host_name : "ホスト名",
              default_dir_error : "ローカルログインは許可されていません。デフォルトのディレクトリのためのLOCAL以外のオプションを選択してください。",
              default_dir_delete_error : "デフォルトのディレクトリを削除することはできません。デフォルトのディレクトリを変更して再試行してください。",
              default_dir_delete_error2 : "ディレクトリを削除し、デフォルトのディレクトリと同じセットにすることはできません！",
              directory_server_required_error : "少なくとも1つのディレクトリサーバーが必要です。",
              baseDN_required_error : "すべての3つの値が必要になります。",
              host_name_error : "ホスト名を指定してください。",
              save_failure : "1つ以上の必要なエントリが存在しないか、または無効であるため、追加操作を完了できませんでした。欠落したデータを入力し、再試行してください。",
              failure_resolution : "エラーを修正して再試行してください。",
              delete_directory_errormessage : "ディレクトリに属しているユーザーは、それを削除したり、編集することはできません",
              directory_server_duplicate_error : "ディレクトリサービス名が重複することはできません。",
              default_dir_change_common_msg : "デフォルトのディレクトリを変更すると、ユーザーにOpenStackリソースへの未許可のアクセスを許す可能性があります。",
              default_dir_change_warning_msg : "オリジナルと新しいディレクトリが異なる個人を識別するために、同じユーザー名を使用していないことを確認してください。",
              default_dir_change_confirm_msg : "デフォルトディレクトリを変更しますか?",
              default_dir_update_yes : "はい、変更します",
              default_dir_change_title : "デフォルトディレクトリの変更",
              search_ctx_update_warning_msg : "オリジナルと新しい検索コンテキストが異なる個人を識別するために、同じユーザー名を使用していないことを確認してください。",
              search_ctx_update_common_msg : "検索コンテキストを変更すると、ユーザーにOpenStackリソースへの未許可のアクセスを許す可能性があります。",
              search_ctx_update_confirm_msg : "検索コンテキストを変更しますか?",
              search_ctx_update_title : "検索コンテキストの変更"
            },
            addDirectory : {
                title : "ディレクトリの追加",
                directory_name : "ディレクトリ",
                directory_type : "ディレクトリの種類",
                search_context : "検索コンテキスト",
                search_context_uid : "検索コンテキスト (UID)",
                search_context_org : "検索コンテキスト (組織)",
                search_context_top : "検索コンテキスト (最上位ドメイン)",
                credentials_title : "認証情報",
                credentials_text : "(サーバー接続を検証するために使用され、保存されることはありません)",
                username : "ユーザー名",
                password : "パスワード",
                directory_servers : "ディレクトリサーバー",
                add_directory_server : "ディレクトリサーバーの追加",
                success_notification : "ディレクトリのアップデート",
                add_success : "ディレクトリ{0}の追加",
                remove_server_success : "{0}を削除しました",
                invalid_naming_attribute : "無効な値です。CNを入力するか、AD/LDAPサーバの設定に応じて、UIDを入力してください。",
                max_search_context : "最大で{0}つの検索コンテキストを指定することが可能です。",
                help_example : "例",
                help_field1 : "フィールド1",
                help_field2 : "フィールド2",
                help_field3 : "フィールド3",
                certificate_placeholder : "ここにキーを貼り付けます",
                disable_multirdn : "不正な値です。'+' は許可されません。"
            },
            addServer : {
                title : "ディレクトリサーバーの追加",
                host_name : "IPアドレスまたはホスト名",
                ssl_port : "ディレクトリサーバーポート",
                certificate : "ディレクトリサーバー証明書",
                success : "変更 : ディレクトリサーバーを{0}に",
                table_column_server : "サーバー",
                table_column_certificate : "証明書",
                certificate_state_yes : "はい",
                duplicate_host : "ホスト名またはIPアドレスが重複しています。異なったディレクトリサーバーを指定してください。",
                invalid_host : "無効なホスト名またはIPアドレスです。",
                invalid_port : "無効なポート番号 - 数値でなければなりません。",
                invalid_port_range : "無効なポート番号の範囲です。(範囲: 0 から 65535。) ",
                invalid_certificate : "入力した証明書は、X.509証明書であることが表示されません。有効なAD/LDAPサーバーの証明を入力してください。"
            }
        },
        overview : {
            title : "設定"
        },
        auditlogs : {
            download : "監査ログのダウンロード"
        },
        edit : {
            title : "設定の編集",
            saved : "設定は保存されました。"
                },
        supportdump : {
            title : "サポートダンプの作成",
            error_creating_dump : "dump作成中のエラー",
            error_creating_dump_message : "サポートダンプの作成に失敗しました。もう一度試してください。",
            error_downloading_dump : "dumpのダウンロード中のエラー",
            error_downloading_dump_message : "サポートダンプのダウンロードに失敗しました。これは新しいサポートダンプのリクエストが開始されたためのようです。",
            createtitle : "サポートダンプの作成",
            create_button : "作成します",
            creating_dump : "サポートダンプの作成",
            create_dump : "サポートダンプを作成すると、ファイルのダウンロードが自動的に開始された後、数分かかることがあります。一方で、UIを通常通り使用し続けることができます。",
            dump_created : "dumpの作成が成功しました",
            encryption_label :"サポートダンプの暗号化を有効",
            create_prompt : "今からサポートダンプを作成しますか?"

        },
        factoryReset: {
            title: "工場出荷時設定へのリセット",
            factoryResetAction : "工場出荷時設定へのリセット",
            warning: "工場出荷時設定へのリセットは、すべてのデータ、ログおよびアプライアンスの設定を消去する破壊的なアクションです。",
            fullResetWarning: "ネットワーク設定を工場出荷時設定へのリセットで変更した場合、ブラウザーは、アプライアンスへの接続を失う可能性があります。この問題が発生した場合、アプライアンスの新しいアドレスに接続するために新しいブラウザーを開く、あるいはアプライアンスのコンソール上のkioskインターフェイスを使用します。",
            preserveNetworkCheckbox: "アプライアンスのネットワーク設定を保存します",
            startFailure: "工場出荷時設定へのリセットの開始に失敗しました。",
            confirmationWarning: "工場出荷時設定へリセットする前に、警告メッセージを確実に参照し、理解してください。",
            confirmationCheckbox: "すべての内容について参照し、理解しました。",
            confirmationCheckboxRequired: "必須",
            confirmationPrompt: "工場出荷時設定へのリセットを続行しますか?",
            confirmOk: "はい、続行します",
            ok: "OK"
        },
        shutdown: {
            title:"アプライアンスのシャットダウン",
            shutdownAction: "シャットダウン",
            warning:"シャットダウンすると、すべてのユーザーは切断され、作業中のすべてのタスクは中断されます。",
            start_prompt : "シャットダウンを続行しますか?",            
            ok: "シャットダウンします。" ,
            errorMsg : "シャットダウンを実行できません。"
        },
        restart: {
            title:"アプライアンスの再起動",
            shutdownAction: "再起動",
            warning:"再起動すると、すべてのユーザーは切断され、作業中のすべてのタスクは中断されます。",
            start_prompt : "再起動を続行しますか?",
            ok: "再起動します。" ,
            errorMsg : "再起動を実行できません。"
        },
        restore: {
            kiloBytes: "KB",     // TODO: Translate
            megaBytes: "MB",     // TODO: Translate
            gigaBytes: "GB",     // TODO: Translate
            title: "バックアップからのリストア",
            uploadingTitle : "アップロード中",     // TODO: Translate
            restorePendingTitle : "リストア",     // TODO: Translate
            restoreAction : "バックアップからのリストア",
            backupFileTitle : "バックアップファイル",
            useUploadedFile : "ファイルを選択",     // TODO: Translate
            useStagedFile : "ファイルからリストア",     // TODO: Translate
            uploadAndRestore : "アップロードおよびリストア",     // TODO: Translate
            uploadOnly : "アップロードのみ",     // TODO: Translate
            aFileIsRequired : "ファイルが必要です。",     // TODO: Translate
            uploadFileFormatWarning : "無効なファイルフォーマットです。",     // TODO: Translate
            uploadInProgress : "アップロードが進行中です。",     // TODO: Translate
            uploadHMSRemaining: "残り {0}時間 {1}分 {2}秒",     // TODO: Translate
            uploadMSRemaining: "残り {0}分 {1}秒",     // TODO: Translate
            uploadStop : "アップロードを停止",     // TODO: Translate
            uploadStopWarning : "アップロードを停止すると、これまでに転送されたデータを破棄します。アップロードが完了すると、アップロードされたファイルからリストアすることができます。",     // TODO: Translate
            backupIsReady : "このバックアップは、準備ができています。",     // TODO: Translate
            noBackupStaged : "どのファイルもまだアップロードされていません。",     // TODO: Translate
            restoreFromBackup : "リストア",
            restoreFromBackupConfirmationWarning : "リストアプロセスを開始する前に、すべての予想される結果について理解しておいてください。",     // TODO: Translate
            restoreFromBackupConfirmationCheckbox : "私はすべての予想される結果を理解しました。",     // TODO: Translate
            restoreFromBackupConfirmationRequired : "必須",     // TODO: Translate
            restoreFromBackupConfirmationPrompt : "バックアップからのリストアを続行しますか?",     // TODO: Translate
            yesRestoreFromBackup : "はい、続行します",     // TODO: Translate
            fileNameLabel : "ファイル",     // TODO: Translate
            createdDateLabel: "作成",     // TODO: Translate
            versionLabel : "バージョン",     // TODO: Translate
            sizeLabel : "サイズ",     // TODO: Translate
            sizeData : "{0} {1}",     // TODO: Translate
            uploading : "ファイルをアップロード中",
            stopUpload : "アップロードを停止",     // TODO: Translate
            uploadStopped : "アップロードが停止されました",     // TODO: Translate
            closeUpload : "閉じる",     // TODO: Translate
            uploaded : "ファイルがアップロードされました",
            validating : "ファイルの検証中 - しばらく時間がかかります",
            validated : "ファイルが検証されました",     // TODO: Translate
            stopRestore: "リストアをキャンセル",     // TODO: Translate
            restoreCanceled : "リストアがキャンセルされました",     // TODO: Translate
            uploadProgressUnknowable : "ファイルのアップロードおよび検証中 - しばらく時間がかかります",     // TODO: Translate
            backupTooBigErrMsg : "バックアップは、アップロードには大きすぎます。",
            backupTooBigResolutionMsg : "{0}GBバイトより小さいサイズのバックアップを選択してください。",
            restoreWarningSummary: "バックアップからのリストアは、破壊的な動作です。",     // TODO: Translate
            restoreWarningDetails: "アプライアンスを使用しているあらゆるユーザーがログアウトされ、それらの作業が失われます。",     // TODO: Translate
            restoreStarted : "バックアップからのリストア中 ...",
            uploadOverwritten : "他のバックアップ操作はアップロードされたバックアップを削除しました。",
            retryUpload : "バックアップのアップロードを再試行してください。",
            uploadFailed : "バックアップのアップロードの完了に失敗しました。",
            retryOrSelectAlternate : "再試行するか、別のバックアップを選択してください。",     // TODO: Translate
            backupIsCompatible : "このファイルは互換性があります。",
            uploadActivity : "アップロード ",     // TODO: Translate
            uploadError : "アップロードエラー",     // TODO: Translate
            validationFailure : '検証エラー',     // TODO: Translate
            restoreModeStartError : 'リストアを開始できませんでした',     // TODO: Translate
            restoreActivity : 'リストア'     // TODO: Translate
        },
        backup: {
            backupAction : "バックアップの作成",
            backupDownloadAction: "バックアップのダウンロード",
            backupDownloadLinkLabel: "最新のバックアップのダウンロード",
            unableToStartBackup: "バックアップを開始できません。",
            backupDidNotComplete: "このバックアップは完了しませんでした。",
            errorGettingBackupProgress: "バックアップの進行情報を取得できません。",
            unableToDownloadBackup: "バックアップをダウンロードできません。",
            uploadedBackup: "アップロードされたバックアップをダウンロードできません。",
            noBackup: "存在するバックアップがありません。",
            backupInProgress: "バックアップはすでに進行中です。",
            waitForBackupToComplete: "バックアップが完了するまで待ってから、この操作をやり直してください。",
            createBackupAndRetry: "バックアップを作成して、この操作をやり直してください。",
            errorCancellingBackup: "バックアップを停止することができません。",
            backupCreateDetails: "バックアップは{0}によって開始されました。",
            backupDownloadSummary: "バックアップのダウンロード",
            backupDownloadDetails: "バックアップ{0}のダウンロードは、{1}によってリクエストされました。",
            completedDetails: "バックアップは完了し、ダウンロードの準備ができました。\n\nバックアップ{0}は{1}によって作成されました。",
            canceledDetails: "バックアップ {0}はキャンセルされました。",
            backupSourceName: "アプライアンス",
            backupStopLinkLabel: "バックアップの停止",
            backupStopDialogTitle: "バックアップの停止",
            backupStopButtonLabel: "バックアップを停止します",
            backupStopConfirmMessage: "バックアップの停止を続行しますか?"
        },
        security : {
          title : "セキュリティ",
          overview : {
            cert_title : "証明書",
            common_name : "認証情報共通名(CN)",
            valid_until : "有効期限",
            expires_in : "({0}日で失効)",
            expires_message : "アプライアンスの証明書は{0}日で失効します。",
            expires_detail_message : "証明書は{0}に失効します、今から{1}日です。",
            expires_resolution : "新しい証明書を{0}または{1}を使用して インポートしてください。",
            auth_title : "認証",
            local_login : "ローカルログイン",
            default_directory : "デフォルトディレクトリ",
            directories : "ディレクトリ",
            add_directory : "ディレクトリの追加"
            },
            publickey : {
                title : "キー",
                download_location_msg : "最新のHP公開キーは、{0}から利用可能です。",
                uploaded : "アップロードされたHP公開キー",
                display_content : "コンテンツを表示",
                paste_message : "キーをここに貼り付けてください",
                key_message : "このキーは、すべてのパッチとアップデートの信頼性を検証するために使用されます。"
            },
            firmwarebundle : {
                optiontext : "ファームウェアのアップデート 使用:",
                http : "HTTP - 高速",
                https: "HTTPS - よりセキュア",
                displayText: "この設定は、サーバーハードウェア上のファームウェアを更新するときに使用するiLOの仮想メディアのマウントに使用されるプロトコルを制御します。<a href=\"doc#/cic/s_enc-add-error\" target=\"hphelp\">よく詳しくは...</a>"
            },
            edit_security_title: "セキュリティの編集",
            panel: {
                authentication : "認証",
                hp_public_key : "HP公開キー",
                firmware_bundle : "ファームウェアバンドル"
            },
            more :{
                directories : "ディレクトリ",
            authn :{
              active_directory : "Active Directory",
              open_ldap : "OpenLDAP",
                directory_type : "ディレクトリの種類",
                naming_attribute: "ネーミングの属性",
                search_context : "検索コンテキスト",
                directory_servers : "ディレクトリサーバー",
                no_directories : "ディレクトリなし"
             }
            },
            edit_authn : {
              edit_directory_title : "ディレクトリの編集",
              edit_directoryserver_title : "ディレクトリサーバーの編集",
              delete_title : "{0}を削除",
              delete_message : "{0}を削除してよろしいでしょうか? 削除して続行しますか?",
              delete_yes :"削除します"
            }
        },
        certificate : {
            title : "証明書の設定",
            csr_attributes : "リクエスト属性証明書署名",
            unstr_name : "非構造化名",
            selfsigned : {
              create_action_title : "自己署名の証明書の作成",
              create_title : "自己署名の証明書の作成",
              required_information : "必要な情報",
              optional_information : "オプション情報",
              create_success : "自己署名の証明書が作成されました。",
              create_error : "自己署名の証明書を作成できません。",
              create_action : "作成",
              get_action : "収集",
              source_object : "自己署名証明書",
              get_error : "現在の自己署名の証明書を取得できません。",
              update_button : "アップデートします",
              cancel_button : "キャンセル",
              dialog : {
              title : "証明書のアップデート",  
                update : "アップデートを適用中...",
                certwarn : "ブラウザーをリフレッシュした時に、ブラウザーの証明書の警告を受け入れる必要があるかもしれません。",
                restartwarn : "警告：証明書のアップデートは、アプライアンスのWebサーバーを再起動する必要があります。サービスの一時的な中断が30秒ほど発生します。",
                reconnectmsg :"システムが再び利用可能になった時に、自動的に再接続されます。",
                continue_update : "アップデートを続行しますか?",
                usersLoggedIn : "{0}他のユーザーがログイン中です",
                oneUserLoggedIn : "1 他のユーザーがログイン中です",
                remaining : "残り{0}秒"
              },
              error : {
                timeout : {
                  msg : "このアプライアンスは、Webサーバーが再起動した後には、到達不可能です。",
                  res : "このブラウザーとアプライアンスのネットワークアドレスの接続を検証してください。他の回復アクションのための印刷されたアプライアンスのマニュアルを参照してください。"
                },
                unknown : {
                    msg : "自己署名の証明書の作成ができません。",
                    res : "アプライアンスを再起動してください。アプライアンスを再起動した後、自己署名の証明書が作成できない場合には、HPサポートに連絡してください。"
                },
                support_dump_link : "サポートダンプの作成",
                support_dump_link_message : "問題が解決しない場合は、{0}および支援のために認定されたサポート担当者にお問い合わせください。"
              }
            },
            country : "国 (C)",
            state : "州または県 (ST)",
            locality : "都市または地域 (L)",
            org : "組織名 (O)",
            cn : "共通名 (CN)",
            ou : "組織ユニット",
            alt_name : "代替名",
            contact : "コンタクト先",
            email : "Emailアドレス",
            surname : "姓",
            given_name : "名",
            initials : "イニシャル",
            dn : "DN有資格者",
            explain_comma_list : "代替名のコンマ区切りのリスト（例えばホスト名、IPアドレスなど）を入力します。CNは必要な代替名で、ここで提供されていない場合、自動的に追加されます。",
            hostname_regen_cert_warn    : "ホスト名を変更すると、ブラウザーとの安全な通信のための新しいSSL証明書を生成する必要があります。",
            hostname_regen_cert_warn_csr    : "ホスト名を変更すると、ブラウザーとの安全な通信のための新しいSSL証明書を生成する必要があります。これはまた別のCSRを生成し、新しい署名付きSSL証明書を取得し、アプライアンスにインポートする必要があります。",
            ipaddress_regen_cert_warn    : "IPアドレスを変更すると、ブラウザーとの安全な通信のための新しいSSL証明書を生成する必要があります。",
            ipaddress_regen_cert_warn_csr    : "IPアドレスを変更すると、ブラウザーとの安全な通信のための新しいSSL証明書を生成する必要があります。これはまた別のCSRを生成し、新しい署名付きSSL証明書を取得し、アプライアンスにインポートする必要があります。",
            hostname_cn_mistmatch    : "ホスト名および証明書の共通名が異なっています。 これは、ブラウザとの安全な通信のための新しいSSL証明書を生成する必要があります。",
            hostname_cn_mistmatch_csr    : "ホスト名および証明書の共通名が異なっています。 これは、ブラウザとの安全な通信のための新しいSSL証明書を生成する必要があります。これはまた別のCSRを生成し、新しい署名付きSSL証明書を取得し、アプライアンスにインポートする必要があります。",
            validator : {
              host_or_ip_required : "有効なホスト名またはIPアドレスを指定してください。",
              max_length : "{0}文字以上を入力してください。",
              max_length_no_cn : "CNは、自動的にこのフィールドに追加されますが、そのようにすると{0}の最大サイズの制限を超えてしまいます。CNを考慮して十分なスペースを確保してください。",
              matchpasswd : "パスワードは一致していなければなりません。",
              passwdvalidation : "パスワードは、< > ; , \" ' & \\ / | + : = およびスペースを含んではいけません。"

            },
            more_title : "証明書",
            required_information : "要求された情報",
            optional_information : "オプション情報",
            common_name : "Cert共通名 (CN)",
            issued_by : "発行元",
            valid_from : "発効日",
            valid_until : "有効期限",
            serial_number : "シリアル番号",
            version : "バージョン",
            md5_fingerprint : "MD5指紋",
            sha1_fingerprint : "SHA1指紋",
            cert_sign_req_attr : "リクエスト属性証明書署名",
            unstructured_name : "非構造化名",
            csr : {
              create_action_title : "証明書の署名リクエストの作成",
              create_title : "証明書の署名リクエストの作成",
              create_action : "作成",
              source_object : "証明書署名要求",
              required_information : "要求された情報",
              optional_information : "オプション情報",
              create_success : "証明書の署名リクエストが作成されました。",
              create_error : "証明書の署名リクエストが作成できません。",
              get_error : "現在の証明書を取得できません。",
              ok_button : "OK",
                cancel_button : "キャンセル",
                challenge_password : "パスワードの変更",
                confirm_password : "パスワードの確認",
                dialog : {
                  base64_save : "以下のBase64でエンコードされたデータは認証サーバの証明書を要求するために使用することができます。下のデータをコピーして、証明書要求を作成し、それを使用してください。この証明書を受け取る設定ページ内で\"アクション - >インポート証明書\"メニュー項目を使用して、それをインポートしてください。"
                },
                error : {
                  support_dump_link : "サポートダンプの作成",
                  support_dump_link_message : "この問題が続くようでしたら、{0}および支援のために認定されたサポート担当者にお問い合わせください。"
                }
            },
            signedimport : {
              import_success : "アプライアンスの証明書がインポートされました。",
              import_action_title : "証明書のインポート",
              import_title : "証明書のインポート",
              import_action: "インポート",
              import_paste : "アプライアンス内でインポートする証明書を貼り付けてください。",
              certificate : "証明書",
              dialog : {
                  importing : "証明書のインポート中...",
                  certwarn : "ブラウザーから証明書の指示がでたら、証明書を受け入れてください。",
                  restartwarn : "警告：証明書のアップデートは、アプライアンスのWebサーバーを再起動する必要があります。サービスの一時的な中断が30秒ほど発生します。",
                  reconnectmsg :"システムが再び利用可能になった時に、自動的に再接続されます。",
                  usersLoggedIn : "{0}他のユーザーがログイン中です",
                  oneUserLoggedIn : "1 他のユーザーがログイン中です",
                  remaining : "残り{0}秒"
              },
              error : {
                unknown : {
                  msg : "署名された証明書をインポートできません。",
                  res : "アプライアンスを再起動してください。アプライアンスを再起動した後、署名された証明書をインポートできない場合には、HPサポートに連絡してください。"
                }
              }
            },
            truststore : {
                self_signed_warn : "自己署名のため、セキュリティ証明書は信頼されていません。",
                issue_untrusted_warn : "セキュリティ証明書は信頼されていないエンティティにより発行されています。",
                invalid_warn : "示されたセキュリティ証明書は、有効期間内ではありません。",
                hostname_not_found_warn : "このウェブサイトのセキュリティ証明書は、別のWebサイトのアドレスのために発行されました。",
                connection_untrusted_warn : "この接続は信頼できません。",
                issued_to : "発行先",
                issued_by : "発行元",
                valid_from : "有効期間-開始",
                to : "終了",
                retrieve_cert_error : "証明書を取得できません。",
                retrieve_cert_resolution : "解決策：もう一度登録してください。",
                header : "信頼証明書",
                variableheader : "信頼証明書 {0}",
                certificate_information : "証明書",
                details : "詳細",
                trust_confirm : "証明書を信頼し続けますか?",
                trust_confirm_multiple : "証明書を信頼し続けますか?",
                ca_info : "認証局",
                not_auth : "このアクションを実行する権限がありません",
                not_auth_resol : "証明書を確認して、もう一度登録してください。",
                version : "バージョン",
                serial_number : "シリアル番号",
                common_name : "サブジェクト ( CN, O, L, S, C)",
                issuer : "発行者",
                alternative_name : "サブジェクトの別名",
                sha1_fingerprint : "SHA1指紋",
                md5_fingerprint : "MD5指紋",
                signature_algorithm : "署名アルゴリズム",
                public_key : "公開キー",
                revoked_msg : "セキュリティ証明書は取り消されました。",
                revoked_resol : "ホストアドレスが正しいことを確認して、もう一度登録してください。",
                close : "閉じる",
                ok_trust : "はい、信頼します",
                cancel_trust : "いいえ、信頼しません",
                upload_ca_cert : "ホストのCA証明書をアップロードし、登録を続行します。",
                invalid_chain : "証明書チェーンが無効なため、セキュリティ証明書は信頼されません。",
                invalid_chain_resol : "ホストの証明書チェーンを修正して、もう一度登録してください",
                ca_certificate : "CA証明書",
                ca_cert_header : "CA証明書を追加",
                ca_cert_upload_error : "証明書を追加できません",
                verifying : "検証中...",
                ca_cert_upload_error_detail : "証明書が有効ではありません。有効な証明書を提供してください。",
                upload_ca_reason : "発行者が不明なため、{0}のセキュリティ証明書は信頼されません。",
                required : "必須"
            }
        },
        supportaccess : {
            service_unavailable : "サポートアクセスを取得できません。",
            error : "サポートアクセスを編集することができません。",
            update : "アップデート",
            source_object : "サービスアクセス",
            success : "サービスアクセスのアップデートが成功しました。",
            failure : "サービスアクセスのアップデートに失敗しました。"
        },
        eula : {
            config : {
                appliance_name : "仮想アプライアンス",
                end_user_title : "ライセンス",
                eula_title : "エンドユーザー使用許諾契約書",
                agree_button : "同意",
                disagree_button : "拒否",
                yesdisagree_button : "拒否します",
                confirmation_dialog_advice : "エンドユーザー使用許諾契約書に同意されない場合には、先には進めません。",
                end_user_support_title : "サポート",
                application_support : "アプリケーションサポート",
                warning : "警告",
                written_offer : "書面による申込み",
                enabled : "有効",
                disabled : "無効",
                support : "サポート",
                license : "ライセンス",
                support_access_enabled : "サービスアクセス認証",
                edit_appliance_support_access : "サービスアクセスの編集",
                agree_disagree_message : "ライセンス条項に同意する場合は同意をクリックしてください、そうでない場合には拒否をクリックしてください。",
                content_directory: "/ui-js/pages/fs/license",
                upgrade_content_directory: "/ui-js/pages/upgrade",
                eula_content_file : "eula_content_ja.html",
                support_access_file : "support_access_and_written_offer_ja.html"
            }
        },
        license : {
            config : {
                add_license : "ライセンスの追加",
                add_license_title : "ライセンスの追加",
                license_key: "ライセンスキー",
                licensing_portal : "HPライセンスポータル",
                verifying_license : "ライセンスキーの検証中...",
                successMsg : "ライセンスの追加",
                error : {
                      msg : "ライセンスの追加ができません : "
                  }
            },
            summary : {
                add : "追加",
                no_licenses : "ライセンスなし",
                license : "ライセンス",
                licensed : "ライセンスサーバー",
                licensed_instance_required : "{0} ライセンスなしのインスタンス",
                compliance : "使用",
                license_required : "{0} {1}が必要",
                licensed_total_nodes : "{0} {1}がライセンスされています",
                available_license : "{0} {1}が利用可能",
                peak_usage : "{0} ピーク使用",
                total_license : "{0} 合計ライセンス",
                type : {
                    node : "ノード",
                    node_plural : "ノード",
                    instance : "インスタンス",
                    instance_plural : "インスタンス",
                    vm : "VM",
                    vm_plural : "VM",
                    server : "サーバー",
                    server_plural : "サーバー",
                    license : "ライセンス",
                    license_plural : "ライセンス"
                }
            },
            notification :{
                title : "さらにライセンスが必要です",
                details : "許諾するにはさらに {0} ライセンス以上追加してください。",
                license_ok : "すべてのサーバーはライセンスされています"
            }
        }

    };
});
